/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.CrossProduct;
import nom.bdezonia.zorbage.algorithm.DotProduct;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.PerpDotProduct;
import nom.bdezonia.zorbage.algorithm.RModuleAdd;
import nom.bdezonia.zorbage.algorithm.RModuleAssign;
import nom.bdezonia.zorbage.algorithm.RModuleConjugate;
import nom.bdezonia.zorbage.algorithm.RModuleDefaultNorm;
import nom.bdezonia.zorbage.algorithm.RModuleDirectProduct;
import nom.bdezonia.zorbage.algorithm.RModuleEqual;
import nom.bdezonia.zorbage.algorithm.RModuleNegate;
import nom.bdezonia.zorbage.algorithm.RModuleRound;
import nom.bdezonia.zorbage.algorithm.RModuleScale;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByDouble;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByRational;
import nom.bdezonia.zorbage.algorithm.RModuleSubtract;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Products;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.VectorSpace;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32Algebra;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32MatrixMember;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32VectorMember;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat32Vector
implements VectorSpace<ComplexFloat32Vector, ComplexFloat32VectorMember, ComplexFloat32Algebra, ComplexFloat32Member>,
Constructible1dLong<ComplexFloat32VectorMember>,
Norm<ComplexFloat32VectorMember, Float32Member>,
Products<ComplexFloat32VectorMember, ComplexFloat32Member, ComplexFloat32MatrixMember>,
DirectProduct<ComplexFloat32VectorMember, ComplexFloat32MatrixMember>,
Rounding<Float32Member, ComplexFloat32VectorMember>,
Infinite<ComplexFloat32VectorMember>,
NaN<ComplexFloat32VectorMember>,
ScaleByHighPrec<ComplexFloat32VectorMember>,
ScaleByRational<ComplexFloat32VectorMember>,
ScaleByDouble<ComplexFloat32VectorMember>,
Tolerance<Float32Member, ComplexFloat32VectorMember> {
    private final Procedure1<ComplexFloat32VectorMember> ZER = new Procedure1<ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember> NEG = new Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b) {
            RModuleNegate.compute(G.CFLT, a, b);
        }
    };
    private final Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> ADD = new Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c) {
            RModuleAdd.compute(G.CFLT, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> SUB = new Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c) {
            RModuleSubtract.compute(G.CFLT, a, b, c);
        }
    };
    private final Function2<Boolean, ComplexFloat32VectorMember, ComplexFloat32VectorMember> EQ = new Function2<Boolean, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public Boolean call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b) {
            return RModuleEqual.compute(G.CFLT, a, b);
        }
    };
    private final Function2<Boolean, ComplexFloat32VectorMember, ComplexFloat32VectorMember> NEQ = new Function2<Boolean, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public Boolean call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b) {
            return ComplexFloat32Vector.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember> ASSIGN = new Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember from, ComplexFloat32VectorMember to) {
            RModuleAssign.compute(G.CFLT, from, to);
        }
    };
    private final Procedure2<ComplexFloat32VectorMember, Float32Member> NORM = new Procedure2<ComplexFloat32VectorMember, Float32Member>(){

        @Override
        public void call(ComplexFloat32VectorMember a, Float32Member b) {
            RModuleDefaultNorm.compute(G.CFLT, G.FLT, a, b);
        }
    };
    private final Procedure3<ComplexFloat32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember> SCALE = new Procedure3<ComplexFloat32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32Member scalar, ComplexFloat32VectorMember a, ComplexFloat32VectorMember b) {
            RModuleScale.compute(G.CFLT, scalar, a, b);
        }
    };
    private final Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> CROSS = new Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c) {
            CrossProduct.compute(G.CFLT_VEC, G.CFLT, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member> DOT = new Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b, ComplexFloat32Member c) {
            DotProduct.compute(G.CFLT_VEC, G.CFLT, G.FLT, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member> PERP = new Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b, ComplexFloat32Member c) {
            PerpDotProduct.compute(G.CFLT_VEC, G.CFLT, a, b, c);
        }
    };
    private final Procedure4<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> VTRIPLE = new Procedure4<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c, ComplexFloat32VectorMember d) {
            ComplexFloat32VectorMember b_cross_c = new ComplexFloat32VectorMember(new float[6]);
            ComplexFloat32Vector.this.crossProduct().call(b, c, b_cross_c);
            ComplexFloat32Vector.this.crossProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure4<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member> STRIPLE = new Procedure4<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c, ComplexFloat32Member d) {
            ComplexFloat32VectorMember b_cross_c = new ComplexFloat32VectorMember(new float[6]);
            ComplexFloat32Vector.this.crossProduct().call(b, c, b_cross_c);
            ComplexFloat32Vector.this.dotProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember> CONJ = new Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a, ComplexFloat32VectorMember b) {
            RModuleConjugate.compute(G.CFLT, a, b);
        }
    };
    private final Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32MatrixMember> VDP = new Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32VectorMember in1, ComplexFloat32VectorMember in2, ComplexFloat32MatrixMember out) {
            ComplexFloat32Vector.this.directProduct().call(in1, in2, out);
        }
    };
    private final Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32MatrixMember> DP = new Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32MatrixMember>(){

        @Override
        public void call(ComplexFloat32VectorMember in1, ComplexFloat32VectorMember in2, ComplexFloat32MatrixMember out) {
            RModuleDirectProduct.compute(G.CFLT, in1, in2, out);
        }
    };
    private final Function1<Boolean, ComplexFloat32VectorMember> ISNAN = new Function1<Boolean, ComplexFloat32VectorMember>(){

        @Override
        public Boolean call(ComplexFloat32VectorMember a) {
            return SequenceIsNan.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat32VectorMember> NAN = new Procedure1<ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a) {
            FillNaN.compute(G.CFLT, a);
        }
    };
    private final Function1<Boolean, ComplexFloat32VectorMember> ISINF = new Function1<Boolean, ComplexFloat32VectorMember>(){

        @Override
        public Boolean call(ComplexFloat32VectorMember a) {
            return SequenceIsInf.compute(G.CFLT, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat32VectorMember> INF = new Procedure1<ComplexFloat32VectorMember>(){

        @Override
        public void call(ComplexFloat32VectorMember a) {
            FillInfinite.compute(G.CFLT, a);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember> ROUND = new Procedure4<Round.Mode, Float32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, ComplexFloat32VectorMember a, ComplexFloat32VectorMember b) {
            RModuleRound.compute(G.CFLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat32VectorMember> ISZERO = new Function1<Boolean, ComplexFloat32VectorMember>(){

        @Override
        public Boolean call(ComplexFloat32VectorMember a) {
            return SequenceIsZero.compute(G.CFLT, a.rawData());
        }
    };
    private Procedure3<HighPrecisionMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c) {
            RModuleScaleByHighPrec.compute(G.CFLT, a, b, c);
        }
    };
    private Procedure3<RationalMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> SBR = new Procedure3<RationalMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(RationalMember a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c) {
            RModuleScaleByRational.compute(G.CFLT, a, b, c);
        }
    };
    private Procedure3<Double, ComplexFloat32VectorMember, ComplexFloat32VectorMember> SBD = new Procedure3<Double, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public void call(Double a, ComplexFloat32VectorMember b, ComplexFloat32VectorMember c) {
            RModuleScaleByDouble.compute(G.CFLT, a, b, c);
        }
    };
    private final Function3<Boolean, Float32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember> WITHIN = new Function3<Boolean, Float32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember>(){

        @Override
        public Boolean call(Float32Member tol, ComplexFloat32VectorMember a, ComplexFloat32VectorMember b) {
            return SequencesSimilar.compute(G.CFLT, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure1<ComplexFloat32VectorMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexFloat32VectorMember, ComplexFloat32VectorMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat32VectorMember, ComplexFloat32VectorMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public ComplexFloat32VectorMember construct() {
        return new ComplexFloat32VectorMember();
    }

    @Override
    public ComplexFloat32VectorMember construct(ComplexFloat32VectorMember other) {
        return new ComplexFloat32VectorMember(other);
    }

    @Override
    public ComplexFloat32VectorMember construct(String s) {
        return new ComplexFloat32VectorMember(s);
    }

    @Override
    public ComplexFloat32VectorMember construct(StorageConstruction s, long d1) {
        return new ComplexFloat32VectorMember(s, d1);
    }

    @Override
    public Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<ComplexFloat32VectorMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure3<ComplexFloat32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> crossProduct() {
        return this.CROSS;
    }

    @Override
    public Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member> dotProduct() {
        return this.DOT;
    }

    @Override
    public Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member> perpDotProduct() {
        return this.PERP;
    }

    @Override
    public Procedure4<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> vectorTripleProduct() {
        return this.VTRIPLE;
    }

    @Override
    public Procedure4<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32Member> scalarTripleProduct() {
        return this.STRIPLE;
    }

    @Override
    public Procedure2<ComplexFloat32VectorMember, ComplexFloat32VectorMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32MatrixMember> vectorDirectProduct() {
        return this.VDP;
    }

    @Override
    public Procedure3<ComplexFloat32VectorMember, ComplexFloat32VectorMember, ComplexFloat32MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Function1<Boolean, ComplexFloat32VectorMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat32VectorMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat32VectorMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat32VectorMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat32VectorMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat32VectorMember, ComplexFloat32VectorMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat32VectorMember, ComplexFloat32VectorMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float32Member, ComplexFloat32VectorMember, ComplexFloat32VectorMember> within() {
        return this.WITHIN;
    }
}

