/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.octonion;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.OctonionNumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OctonionConstants;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float32.complex.ComplexFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.octonion.OctonionFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class OctonionFloat32Algebra
implements SkewField<OctonionFloat32Algebra, OctonionFloat32Member>,
Conjugate<OctonionFloat32Member>,
Norm<OctonionFloat32Member, Float32Member>,
Infinite<OctonionFloat32Member>,
NaN<OctonionFloat32Member>,
Rounding<Float32Member, OctonionFloat32Member>,
RealConstants<OctonionFloat32Member>,
ImaginaryConstants<OctonionFloat32Member>,
QuaternionConstants<OctonionFloat32Member>,
OctonionConstants<OctonionFloat32Member>,
Random<OctonionFloat32Member>,
Exponential<OctonionFloat32Member>,
Trigonometric<OctonionFloat32Member>,
Hyperbolic<OctonionFloat32Member>,
Power<OctonionFloat32Member>,
Roots<OctonionFloat32Member>,
RealUnreal<OctonionFloat32Member, Float32Member>,
Scale<OctonionFloat32Member, OctonionFloat32Member>,
ScaleByHighPrec<OctonionFloat32Member>,
ScaleByRational<OctonionFloat32Member>,
ScaleByDouble<OctonionFloat32Member>,
ScaleComponents<OctonionFloat32Member, Float32Member>,
Tolerance<Float32Member, OctonionFloat32Member> {
    private static final OctonionFloat32Member ZERO = new OctonionFloat32Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member ONE_THIRD = new OctonionFloat32Member(0.33333334f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member ONE_HALF = new OctonionFloat32Member(0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member ONE = new OctonionFloat32Member(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member TWO = new OctonionFloat32Member(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member E = new OctonionFloat32Member((float)Math.E, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member PI = new OctonionFloat32Member((float)Math.PI, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member GAMMA = new OctonionFloat32Member(0.5772157f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member PHI = new OctonionFloat32Member(1.618034f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member I = new OctonionFloat32Member(0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member J = new OctonionFloat32Member(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member K = new OctonionFloat32Member(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member L = new OctonionFloat32Member(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member I0 = new OctonionFloat32Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private static final OctonionFloat32Member J0 = new OctonionFloat32Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    private static final OctonionFloat32Member K0 = new OctonionFloat32Member(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    private final Procedure1<OctonionFloat32Member> UNITY = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> MUL = new Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b, OctonionFloat32Member c) {
            OctonionFloat32Member tmp = new OctonionFloat32Member(ZERO);
            tmp.setR(a.r() * b.r());
            tmp.setI(a.r() * b.i());
            tmp.setJ(a.r() * b.j());
            tmp.setK(a.r() * b.k());
            tmp.setL(a.r() * b.l());
            tmp.setI0(a.r() * b.i0());
            tmp.setJ0(a.r() * b.j0());
            tmp.setK0(a.r() * b.k0());
            tmp.setI(tmp.i() + a.i() * b.r());
            tmp.setR(tmp.r() - a.i() * b.i());
            tmp.setK(tmp.k() + a.i() * b.j());
            tmp.setJ(tmp.j() - a.i() * b.k());
            tmp.setI0(tmp.i0() + a.i() * b.l());
            tmp.setL(tmp.l() - a.i() * b.i0());
            tmp.setK0(tmp.k0() - a.i() * b.j0());
            tmp.setJ0(tmp.j0() + a.i() * b.k0());
            tmp.setJ(tmp.j() + a.j() * b.r());
            tmp.setK(tmp.k() - a.j() * b.i());
            tmp.setR(tmp.r() - a.j() * b.j());
            tmp.setI(tmp.i() + a.j() * b.k());
            tmp.setJ0(tmp.j0() + a.j() * b.l());
            tmp.setK0(tmp.k0() + a.j() * b.i0());
            tmp.setL(tmp.l() - a.j() * b.j0());
            tmp.setI0(tmp.i0() - a.j() * b.k0());
            tmp.setK(tmp.k() + a.k() * b.r());
            tmp.setJ(tmp.j() + a.k() * b.i());
            tmp.setI(tmp.i() - a.k() * b.j());
            tmp.setR(tmp.r() - a.k() * b.k());
            tmp.setK0(tmp.k0() + a.k() * b.l());
            tmp.setJ0(tmp.j0() - a.k() * b.i0());
            tmp.setI0(tmp.i0() + a.k() * b.j0());
            tmp.setL(tmp.l() - a.k() * b.k0());
            tmp.setL(tmp.l() + a.l() * b.r());
            tmp.setI0(tmp.i0() - a.l() * b.i());
            tmp.setJ0(tmp.j0() - a.l() * b.j());
            tmp.setK0(tmp.k0() - a.l() * b.k());
            tmp.setR(tmp.r() - a.l() * b.l());
            tmp.setI(tmp.i() + a.l() * b.i0());
            tmp.setJ(tmp.j() + a.l() * b.j0());
            tmp.setK(tmp.k() + a.l() * b.k0());
            tmp.setI0(tmp.i0() + a.i0() * b.r());
            tmp.setL(tmp.l() + a.i0() * b.i());
            tmp.setK0(tmp.k0() - a.i0() * b.j());
            tmp.setJ0(tmp.j0() + a.i0() * b.k());
            tmp.setI(tmp.i() - a.i0() * b.l());
            tmp.setR(tmp.r() - a.i0() * b.i0());
            tmp.setK(tmp.k() - a.i0() * b.j0());
            tmp.setJ(tmp.j() + a.i0() * b.k0());
            tmp.setJ0(tmp.j0() + a.j0() * b.r());
            tmp.setK0(tmp.k0() + a.j0() * b.i());
            tmp.setL(tmp.l() + a.j0() * b.j());
            tmp.setI0(tmp.i0() - a.j0() * b.k());
            tmp.setJ(tmp.j() - a.j0() * b.l());
            tmp.setK(tmp.k() + a.j0() * b.i0());
            tmp.setR(tmp.r() - a.j0() * b.j0());
            tmp.setI(tmp.i() - a.j0() * b.k0());
            tmp.setK0(tmp.k0() + a.k0() * b.r());
            tmp.setJ0(tmp.j0() - a.k0() * b.i());
            tmp.setI0(tmp.i0() + a.k0() * b.j());
            tmp.setL(tmp.l() + a.k0() * b.k());
            tmp.setK(tmp.k() - a.k0() * b.l());
            tmp.setJ(tmp.j() - a.k0() * b.i0());
            tmp.setI(tmp.i() + a.k0() * b.j0());
            tmp.setR(tmp.r() - a.k0() * b.k0());
            OctonionFloat32Algebra.this.assign().call(tmp, c);
        }
    };
    private final Procedure3<Integer, OctonionFloat32Member, OctonionFloat32Member> POWER = new Procedure3<Integer, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(Integer power, OctonionFloat32Member a, OctonionFloat32Member b) {
            PowerAny.compute(G.OFLT, power, a, b);
        }
    };
    private final Procedure1<OctonionFloat32Member> ZER = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> NEG = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Algebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> ADD = new Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b, OctonionFloat32Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
            c.setJ(a.j() + b.j());
            c.setK(a.k() + b.k());
            c.setL(a.l() + b.l());
            c.setI0(a.i0() + b.i0());
            c.setJ0(a.j0() + b.j0());
            c.setK0(a.k0() + b.k0());
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> SUB = new Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b, OctonionFloat32Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
            c.setJ(a.j() - b.j());
            c.setK(a.k() - b.k());
            c.setL(a.l() - b.l());
            c.setI0(a.i0() - b.i0());
            c.setJ0(a.j0() - b.j0());
            c.setK0(a.k0() - b.k0());
        }
    };
    private Function2<Boolean, OctonionFloat32Member, OctonionFloat32Member> EQ = new Function2<Boolean, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public Boolean call(OctonionFloat32Member a, OctonionFloat32Member b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k() && a.l() == b.l() && a.i0() == b.i0() && a.j0() == b.j0() && a.k0() == b.k0();
        }
    };
    private Function2<Boolean, OctonionFloat32Member, OctonionFloat32Member> NEQ = new Function2<Boolean, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public Boolean call(OctonionFloat32Member a, OctonionFloat32Member b) {
            return OctonionFloat32Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<OctonionFloat32Member, OctonionFloat32Member> ASSIGN = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member from, OctonionFloat32Member to) {
            to.set(from);
        }
    };
    private Procedure2<OctonionFloat32Member, OctonionFloat32Member> INV = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            double norm2 = OctonionFloat32Algebra.this.norm2(a);
            OctonionFloat32Algebra.this.conjugate().call(a, b);
            b.setR((float)((double)b.r() / norm2));
            b.setI((float)((double)b.i() / norm2));
            b.setJ((float)((double)b.j() / norm2));
            b.setK((float)((double)b.k() / norm2));
            b.setL((float)((double)b.l() / norm2));
            b.setI0((float)((double)b.i0() / norm2));
            b.setJ0((float)((double)b.j0() / norm2));
            b.setK0((float)((double)b.k0() / norm2));
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> DIVIDE = new Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b, OctonionFloat32Member c) {
            OctonionFloat32Member tmp = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.invert().call(b, tmp);
            OctonionFloat32Algebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, OctonionFloat32Member, OctonionFloat32Member> ROUND = new Procedure4<Round.Mode, Float32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, OctonionFloat32Member a, OctonionFloat32Member b) {
            Float32Member tmp = new Float32Member();
            tmp.setV(a.r());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setI(tmp.v());
            tmp.setV(a.j());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setJ(tmp.v());
            tmp.setV(a.k());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setK(tmp.v());
            tmp.setV(a.l());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setL(tmp.v());
            tmp.setV(a.i0());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setI0(tmp.v());
            tmp.setV(a.j0());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setJ0(tmp.v());
            tmp.setV(a.k0());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setK0(tmp.v());
        }
    };
    private Function1<Boolean, OctonionFloat32Member> ISNAN = new Function1<Boolean, OctonionFloat32Member>(){

        @Override
        public Boolean call(OctonionFloat32Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i()) || Double.isNaN(a.j()) || Double.isNaN(a.k()) || Double.isNaN(a.l()) || Double.isNaN(a.i0()) || Double.isNaN(a.j0()) || Double.isNaN(a.k0());
        }
    };
    private final Procedure1<OctonionFloat32Member> NAN = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            a.setR(Float.NaN);
            a.setI(Float.NaN);
            a.setJ(Float.NaN);
            a.setK(Float.NaN);
            a.setL(Float.NaN);
            a.setI0(Float.NaN);
            a.setJ0(Float.NaN);
            a.setK0(Float.NaN);
        }
    };
    private Function1<Boolean, OctonionFloat32Member> ISINF = new Function1<Boolean, OctonionFloat32Member>(){

        @Override
        public Boolean call(OctonionFloat32Member a) {
            return OctonionFloat32Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()) || Double.isInfinite(a.j()) || Double.isInfinite(a.k()) || Double.isInfinite(a.l()) || Double.isInfinite(a.i0()) || Double.isInfinite(a.j0()) || Double.isInfinite(a.k0()));
        }
    };
    private final Procedure1<OctonionFloat32Member> INF = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            a.setR(Float.POSITIVE_INFINITY);
            a.setI(Float.POSITIVE_INFINITY);
            a.setJ(Float.POSITIVE_INFINITY);
            a.setK(Float.POSITIVE_INFINITY);
            a.setL(Float.POSITIVE_INFINITY);
            a.setI0(Float.POSITIVE_INFINITY);
            a.setJ0(Float.POSITIVE_INFINITY);
            a.setK0(Float.POSITIVE_INFINITY);
        }
    };
    private final Procedure2<OctonionFloat32Member, Float32Member> NORM = new Procedure2<OctonionFloat32Member, Float32Member>(){

        @Override
        public void call(OctonionFloat32Member a, Float32Member b) {
            b.setV((float)OctonionFloat32Algebra.this.norm(a));
        }
    };
    private Procedure2<OctonionFloat32Member, OctonionFloat32Member> CONJ = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            b.setR(a.r());
            b.setI(-a.i());
            b.setJ(-a.j());
            b.setK(-a.k());
            b.setL(-a.l());
            b.setI0(-a.i0());
            b.setJ0(-a.j0());
            b.setK0(-a.k0());
        }
    };
    private final Procedure1<OctonionFloat32Member> PI_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> E_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> GAMMA_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> PHI_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> I_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> J_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> K_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(K, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> L_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(L, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> I0_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(I0, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> J0_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(J0, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> K0_ = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            OctonionFloat32Algebra.this.assign().call(K0, a);
        }
    };
    private final Procedure1<OctonionFloat32Member> RAND = new Procedure1<OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextFloat());
            a.setI(rng.nextFloat());
            a.setJ(rng.nextFloat());
            a.setK(rng.nextFloat());
            a.setL(rng.nextFloat());
            a.setI0(rng.nextFloat());
            a.setJ0(rng.nextFloat());
            a.setK0(rng.nextFloat());
        }
    };
    private final Procedure2<OctonionFloat32Member, Float32Member> REAL = new Procedure2<OctonionFloat32Member, Float32Member>(){

        @Override
        public void call(OctonionFloat32Member a, Float32Member b) {
            b.setV(a.r());
        }
    };
    private Procedure2<OctonionFloat32Member, OctonionFloat32Member> UNREAL = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Algebra.this.assign().call(a, b);
            b.setR(0.0f);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> SINH = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Member negA = new OctonionFloat32Member();
            OctonionFloat32Member sum = new OctonionFloat32Member();
            OctonionFloat32Member tmp1 = new OctonionFloat32Member();
            OctonionFloat32Member tmp2 = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.negate().call(a, negA);
            OctonionFloat32Algebra.this.exp().call(a, tmp1);
            OctonionFloat32Algebra.this.exp().call(negA, tmp2);
            OctonionFloat32Algebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionFloat32Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private Procedure2<OctonionFloat32Member, OctonionFloat32Member> COSH = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Member negA = new OctonionFloat32Member();
            OctonionFloat32Member sum = new OctonionFloat32Member();
            OctonionFloat32Member tmp1 = new OctonionFloat32Member();
            OctonionFloat32Member tmp2 = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.negate().call(a, negA);
            OctonionFloat32Algebra.this.exp().call(a, tmp1);
            OctonionFloat32Algebra.this.exp().call(negA, tmp2);
            OctonionFloat32Algebra.this.add().call(tmp1, tmp2, sum);
            OctonionFloat32Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> SINHANDCOSH = new Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member s, OctonionFloat32Member c) {
            OctonionFloat32Member negA = new OctonionFloat32Member();
            OctonionFloat32Member sum = new OctonionFloat32Member();
            OctonionFloat32Member tmp1 = new OctonionFloat32Member();
            OctonionFloat32Member tmp2 = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.negate().call(a, negA);
            OctonionFloat32Algebra.this.exp().call(a, tmp1);
            OctonionFloat32Algebra.this.exp().call(negA, tmp2);
            OctonionFloat32Algebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionFloat32Algebra.this.divide().call(sum, TWO, s);
            OctonionFloat32Algebra.this.add().call(tmp1, tmp2, sum);
            OctonionFloat32Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> TANH = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Member s = new OctonionFloat32Member();
            OctonionFloat32Member c = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.sinhAndCosh().call(a, s, c);
            OctonionFloat32Algebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> SIN = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            OctonionFloat32Member tmp = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.unreal().call(a, tmp);
            OctonionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            b.setR((float)(sin * cosh));
            b.setI((float)(ws * (double)a.i()));
            b.setJ((float)(ws * (double)a.j()));
            b.setK((float)(ws * (double)a.k()));
            b.setL((float)(ws * (double)a.l()));
            b.setI0((float)(ws * (double)a.i0()));
            b.setJ0((float)(ws * (double)a.j0()));
            b.setK0((float)(ws * (double)a.k0()));
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> COS = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            OctonionFloat32Member tmp = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.unreal().call(a, tmp);
            OctonionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double wc = -sin * sinhc_pi;
            b.setR((float)(cos * cosh));
            b.setI((float)(wc * (double)a.i()));
            b.setJ((float)(wc * (double)a.j()));
            b.setK((float)(wc * (double)a.k()));
            b.setL((float)(wc * (double)a.l()));
            b.setI0((float)(wc * (double)a.i0()));
            b.setJ0((float)(wc * (double)a.j0()));
            b.setK0((float)(wc * (double)a.k0()));
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> SINANDCOS = new Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member s, OctonionFloat32Member c) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            OctonionFloat32Member tmp = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.unreal().call(a, tmp);
            OctonionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            double wc = -sin * sinhc_pi;
            s.setR((float)(sin * cosh));
            s.setI((float)(ws * (double)a.i()));
            s.setJ((float)(ws * (double)a.j()));
            s.setK((float)(ws * (double)a.k()));
            s.setL((float)(ws * (double)a.l()));
            s.setI0((float)(ws * (double)a.i0()));
            s.setJ0((float)(ws * (double)a.j0()));
            s.setK0((float)(ws * (double)a.k0()));
            c.setR((float)(cos * cosh));
            c.setI((float)(wc * (double)a.i()));
            c.setJ((float)(wc * (double)a.j()));
            c.setK((float)(wc * (double)a.k()));
            c.setL((float)(wc * (double)a.l()));
            c.setI0((float)(wc * (double)a.i0()));
            c.setJ0((float)(wc * (double)a.j0()));
            c.setK0((float)(wc * (double)a.k0()));
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> TAN = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Member sin = new OctonionFloat32Member();
            OctonionFloat32Member cos = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.sinAndCos().call(a, sin, cos);
            OctonionFloat32Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> EXP = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            OctonionFloat32Member tmp = new OctonionFloat32Member();
            double u = FastMath.exp((double)a.r());
            OctonionFloat32Algebra.this.unreal().call(a, tmp);
            OctonionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinc().call(z, z2);
            double w = z2.v();
            b.setR((float)(u * FastMath.cos((double)z.v())));
            b.setI((float)(u * w * (double)a.i()));
            b.setJ((float)(u * w * (double)a.j()));
            b.setK((float)(u * w * (double)a.k()));
            b.setL((float)(u * w * (double)a.l()));
            b.setI0((float)(u * w * (double)a.i0()));
            b.setJ0((float)(u * w * (double)a.j0()));
            b.setK0((float)(u * w * (double)a.k0()));
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> LOG = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Member unreal = new OctonionFloat32Member();
            ComplexFloat32Member tmp = new ComplexFloat32Member();
            Float32Member norm = new Float32Member();
            OctonionFloat32Algebra.this.assign().call(a, b);
            OctonionFloat32Algebra.this.unreal().call(a, unreal);
            OctonionFloat32Algebra.this.norm().call(unreal, norm);
            tmp.setR(a.r());
            tmp.setI(norm.v());
            G.CFLT.log().call(tmp, tmp);
            double factor = (double)norm.v() == 0.0 ? (double)tmp.i() : (double)(tmp.i() / norm.v());
            OctonionFloat32Algebra.this.multiplier(tmp.r(), factor, b);
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> POW = new Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b, OctonionFloat32Member c) {
            OctonionFloat32Member logA = new OctonionFloat32Member();
            OctonionFloat32Member bLogA = new OctonionFloat32Member();
            OctonionFloat32Algebra.this.log().call(a, logA);
            OctonionFloat32Algebra.this.multiply().call(b, logA, bLogA);
            OctonionFloat32Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> SINCH = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            Sinch.compute(G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> SINCHPI = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            Sinchpi.compute(G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> SINC = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            Sinc.compute(G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> SINCPI = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            Sincpi.compute(G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> SQRT = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<OctonionFloat32Member, OctonionFloat32Member> CBRT = new Procedure2<OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32Member b) {
            OctonionFloat32Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, OctonionFloat32Member> ISZERO = new Function1<Boolean, OctonionFloat32Member>(){

        @Override
        public Boolean call(OctonionFloat32Member a) {
            return a.r() == 0.0f && a.i() == 0.0f && a.j() == 0.0f && a.k() == 0.0f && a.l() == 0.0f && a.i0() == 0.0f && a.j0() == 0.0f && a.k0() == 0.0f;
        }
    };
    private final Procedure3<HighPrecisionMember, OctonionFloat32Member, OctonionFloat32Member> SBHP = new Procedure3<HighPrecisionMember, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(HighPrecisionMember a, OctonionFloat32Member b, OctonionFloat32Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j()));
            c.setJ(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k()));
            c.setK(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.l()));
            c.setL(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i0()));
            c.setI0(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j0()));
            c.setJ0(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k0()));
            c.setK0(tmp.floatValue());
        }
    };
    private final Procedure3<RationalMember, OctonionFloat32Member, OctonionFloat32Member> SBR = new Procedure3<RationalMember, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(RationalMember a, OctonionFloat32Member b, OctonionFloat32Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.j());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.k());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.l());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setL(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.i0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI0(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.j0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ0(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.k0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK0(tmp.floatValue());
        }
    };
    private final Procedure3<Double, OctonionFloat32Member, OctonionFloat32Member> SBD = new Procedure3<Double, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(Double a, OctonionFloat32Member b, OctonionFloat32Member c) {
            c.setR((float)(a * (double)b.r()));
            c.setI((float)(a * (double)b.i()));
            c.setJ((float)(a * (double)b.j()));
            c.setK((float)(a * (double)b.k()));
            c.setL((float)(a * (double)b.l()));
            c.setI0((float)(a * (double)b.i0()));
            c.setJ0((float)(a * (double)b.j0()));
            c.setK0((float)(a * (double)b.k0()));
        }
    };
    private final Procedure3<Float32Member, OctonionFloat32Member, OctonionFloat32Member> SC = new Procedure3<Float32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public void call(Float32Member a, OctonionFloat32Member b, OctonionFloat32Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
            c.setJ(a.v() * b.j());
            c.setK(a.v() * b.k());
            c.setL(a.v() * b.l());
            c.setI0(a.v() * b.i0());
            c.setJ0(a.v() * b.j0());
            c.setK0(a.v() * b.k0());
        }
    };
    private final Function3<Boolean, Float32Member, OctonionFloat32Member, OctonionFloat32Member> WITHIN = new Function3<Boolean, Float32Member, OctonionFloat32Member, OctonionFloat32Member>(){

        @Override
        public Boolean call(Float32Member tol, OctonionFloat32Member a, OctonionFloat32Member b) {
            return OctonionNumberWithin.compute(G.FLT, tol, a, b);
        }
    };

    @Override
    public Procedure1<OctonionFloat32Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, OctonionFloat32Member, OctonionFloat32Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<OctonionFloat32Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, OctonionFloat32Member, OctonionFloat32Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, OctonionFloat32Member, OctonionFloat32Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public OctonionFloat32Member construct() {
        return new OctonionFloat32Member();
    }

    @Override
    public OctonionFloat32Member construct(OctonionFloat32Member other) {
        return new OctonionFloat32Member(other);
    }

    @Override
    public OctonionFloat32Member construct(String s) {
        return new OctonionFloat32Member(s);
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, OctonionFloat32Member, OctonionFloat32Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, OctonionFloat32Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<OctonionFloat32Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, OctonionFloat32Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<OctonionFloat32Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<OctonionFloat32Member, Float32Member> norm() {
        return this.NORM;
    }

    private double norm(OctonionFloat32Member a) {
        double max = Math.max(Math.abs(a.r()), Math.abs(a.i()));
        max = Math.max(max, (double)Math.abs(a.j()));
        max = Math.max(max, (double)Math.abs(a.k()));
        max = Math.max(max, (double)Math.abs(a.l()));
        max = Math.max(max, (double)Math.abs(a.i0()));
        max = Math.max(max, (double)Math.abs(a.j0()));
        if ((max = Math.max(max, (double)Math.abs(a.k0()))) == 0.0) {
            return 0.0;
        }
        double sum = (double)a.r() / max * ((double)a.r() / max);
        sum += (double)a.i() / max * ((double)a.i() / max);
        sum += (double)a.j() / max * ((double)a.j() / max);
        sum += (double)a.k() / max * ((double)a.k() / max);
        sum += (double)a.l() / max * ((double)a.l() / max);
        sum += (double)a.i0() / max * ((double)a.i0() / max);
        sum += (double)a.j0() / max * ((double)a.j0() / max);
        return max * Math.sqrt(sum += (double)a.k0() / max * ((double)a.k0() / max));
    }

    private double norm2(OctonionFloat32Member a) {
        double norm = this.norm(a);
        return norm * norm;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure1<OctonionFloat32Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> I() {
        return this.I_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> J() {
        return this.J_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> K() {
        return this.K_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> L() {
        return this.L_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> I0() {
        return this.I0_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> J0() {
        return this.J0_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> K0() {
        return this.K0_;
    }

    @Override
    public Procedure1<OctonionFloat32Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<OctonionFloat32Member, Float32Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> tan() {
        return this.TAN;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> log() {
        return this.LOG;
    }

    private void multiplier(double r, double factor, OctonionFloat32Member result) {
        if (Double.isNaN(factor) || Double.isInfinite(factor)) {
            if (result.i() == 0.0f && result.j() == 0.0f && result.k() == 0.0f) {
                result.setR((float)r);
                result.setI((float)((double)result.i() * factor));
                result.setJ((float)((double)result.j() * factor));
                result.setK((float)((double)result.k() * factor));
                result.setL((float)((double)result.l() * factor));
                result.setI0((float)((double)result.i0() * factor));
                result.setJ0((float)((double)result.j0() * factor));
                result.setK0((float)((double)result.k0() * factor));
            } else {
                double signum = Math.signum(factor);
                result.setR((float)r);
                if (result.i() == 0.0f) {
                    result.setI((float)(signum * (double)result.i()));
                } else {
                    result.setI((float)(factor * (double)result.i()));
                }
                if (result.j() == 0.0f) {
                    result.setJ((float)(signum * (double)result.j()));
                } else {
                    result.setJ((float)(factor * (double)result.j()));
                }
                if (result.k() == 0.0f) {
                    result.setK((float)(signum * (double)result.k()));
                } else {
                    result.setK((float)(factor * (double)result.k()));
                }
                if (result.l() == 0.0f) {
                    result.setL((float)(signum * (double)result.l()));
                } else {
                    result.setL((float)(factor * (double)result.l()));
                }
                if (result.i0() == 0.0f) {
                    result.setI0((float)(signum * (double)result.i0()));
                } else {
                    result.setI0((float)(factor * (double)result.i0()));
                }
                if (result.j0() == 0.0f) {
                    result.setJ0((float)(signum * (double)result.j0()));
                } else {
                    result.setJ0((float)(factor * (double)result.j0()));
                }
                if (result.k0() == 0.0f) {
                    result.setK0((float)(signum * (double)result.k0()));
                } else {
                    result.setK0((float)(factor * (double)result.k0()));
                }
            }
        } else {
            result.setR((float)r);
            result.setI((float)((double)result.i() * factor));
            result.setJ((float)((double)result.j() * factor));
            result.setK((float)((double)result.k() * factor));
            result.setL((float)((double)result.l() * factor));
            result.setI0((float)((double)result.i0() * factor));
            result.setJ0((float)((double)result.j0() * factor));
            result.setK0((float)((double)result.k0() * factor));
        }
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<OctonionFloat32Member, OctonionFloat32Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, OctonionFloat32Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32Member, OctonionFloat32Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, OctonionFloat32Member, OctonionFloat32Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, OctonionFloat32Member, OctonionFloat32Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, OctonionFloat32Member, OctonionFloat32Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float32Member, OctonionFloat32Member, OctonionFloat32Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float32Member, OctonionFloat32Member, OctonionFloat32Member> within() {
        return this.WITHIN;
    }
}

