/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.octonion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.octonion.OctonionFloat32Algebra;
import nom.bdezonia.zorbage.type.data.float32.octonion.OctonionFloat32MatrixMember;
import nom.bdezonia.zorbage.type.data.float32.octonion.OctonionFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class OctonionFloat32Matrix
implements RingWithUnity<OctonionFloat32Matrix, OctonionFloat32MatrixMember>,
MatrixRing<OctonionFloat32Matrix, OctonionFloat32MatrixMember, OctonionFloat32Algebra, OctonionFloat32Member>,
Constructible2dLong<OctonionFloat32MatrixMember>,
Rounding<Float32Member, OctonionFloat32MatrixMember>,
Norm<OctonionFloat32MatrixMember, Float32Member>,
DirectProduct<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>,
Exponential<OctonionFloat32MatrixMember>,
Trigonometric<OctonionFloat32MatrixMember>,
Hyperbolic<OctonionFloat32MatrixMember>,
RealConstants<OctonionFloat32MatrixMember>,
Infinite<OctonionFloat32MatrixMember>,
NaN<OctonionFloat32MatrixMember>,
ScaleByHighPrec<OctonionFloat32MatrixMember>,
ScaleByRational<OctonionFloat32MatrixMember>,
ScaleByDouble<OctonionFloat32MatrixMember>,
Tolerance<Float32Member, OctonionFloat32MatrixMember> {
    private final Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> MUL = new Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            MatrixMultiply.compute(G.OFLT, a, b, c);
        }
    };
    private final Procedure3<Integer, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> POWER = new Procedure3<Integer, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(Integer power, OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            MatrixPower.compute(power, G.OFLT, G.OFLT_RMOD, G.OFLT_MAT, a, b);
        }
    };
    private Procedure1<OctonionFloat32MatrixMember> ZER = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> NEG = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            MatrixNegate.compute(G.OFLT, a, b);
        }
    };
    private final Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> ADD = new Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            MatrixAddition.compute(G.OFLT, a, b, c);
        }
    };
    private final Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SUB = new Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            MatrixSubtraction.compute(G.OFLT, a, b, c);
        }
    };
    private final Function2<Boolean, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> EQ = new Function2<Boolean, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            return MatrixEqual.compute(G.OFLT, a, b);
        }
    };
    private final Function2<Boolean, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> NEQ = new Function2<Boolean, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            return OctonionFloat32Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> ASSIGN = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember from, OctonionFloat32MatrixMember to) {
            MatrixAssign.compute(G.OFLT, from, to);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, Float32Member> NORM = new Procedure2<OctonionFloat32MatrixMember, Float32Member>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, Float32Member b) {
            MatrixSpectralNorm.compute(G.OFLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> ROUND = new Procedure4<Round.Mode, Float32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            MatrixRound.compute(G.OFLT, mode, delta, a, b);
        }
    };
    private Function1<Boolean, OctonionFloat32MatrixMember> ISNAN = new Function1<Boolean, OctonionFloat32MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat32MatrixMember a) {
            return SequenceIsNan.compute(G.OFLT, a.rawData());
        }
    };
    private final Procedure1<OctonionFloat32MatrixMember> NAN = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            FillNaN.compute(G.OFLT, a);
        }
    };
    private Function1<Boolean, OctonionFloat32MatrixMember> ISINF = new Function1<Boolean, OctonionFloat32MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat32MatrixMember a) {
            return SequenceIsInf.compute(G.OFLT, a.rawData());
        }
    };
    private final Procedure1<OctonionFloat32MatrixMember> INF = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            FillInfinite.compute(G.OFLT, a);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> CONJ = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            MatrixConjugate.compute(G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> TRANSP = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            MatrixTranspose.compute(G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> CONJTRANSP = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            OctonionFloat32MatrixMember tmp = new OctonionFloat32MatrixMember();
            OctonionFloat32Matrix.this.conjugate().call(a, tmp);
            OctonionFloat32Matrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32Member> DET = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32Member>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32Member b) {
            MatrixDeterminant.compute(G.OFLT_MAT, G.OFLT, a, b);
        }
    };
    private final Procedure1<OctonionFloat32MatrixMember> UNITY = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            MatrixUnity.compute(G.OFLT, a);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> INVERT = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            MatrixInvert.compute(G.OFLT, G.OFLT_RMOD, G.OFLT_MAT, a, b);
        }
    };
    private final Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> DIVIDE = new Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            OctonionFloat32MatrixMember invB = OctonionFloat32Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            OctonionFloat32Matrix.this.invert().call(b, invB);
            OctonionFloat32Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> DP = new Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember in1, OctonionFloat32MatrixMember in2, OctonionFloat32MatrixMember out) {
            MatrixDirectProduct.compute(G.OFLT, in1, in2, out);
        }
    };
    private final Procedure3<OctonionFloat32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SCALE = new Procedure3<OctonionFloat32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32Member a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            MatrixScale.compute(G.OFLT, a, b, c);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SINH = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.OFLT_MAT, G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> COSH = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.OFLT_MAT, G.OFLT, a, b);
        }
    };
    private final Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SINHANDCOSH = new Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember s, OctonionFloat32MatrixMember c) {
            OctonionFloat32Matrix.this.sinh().call(a, s);
            OctonionFloat32Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> TANH = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            OctonionFloat32MatrixMember s = G.OFLT_MAT.construct();
            OctonionFloat32MatrixMember c = G.OFLT_MAT.construct();
            OctonionFloat32Matrix.this.sinhAndCosh().call(a, s, c);
            OctonionFloat32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SINCH = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            Sinch.compute(G.OFLT_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SINCHPI = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            Sinchpi.compute(G.OFLT_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SIN = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            TaylorEstimateSin.compute(18, G.OFLT_MAT, G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> COS = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            TaylorEstimateCos.compute(18, G.OFLT_MAT, G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> TAN = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            OctonionFloat32MatrixMember s = G.OFLT_MAT.construct();
            OctonionFloat32MatrixMember c = G.OFLT_MAT.construct();
            OctonionFloat32Matrix.this.sinAndCos().call(a, s, c);
            OctonionFloat32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SINANDCOS = new Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember s, OctonionFloat32MatrixMember c) {
            OctonionFloat32Matrix.this.sin().call(a, s);
            OctonionFloat32Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SINC = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            Sinc.compute(G.OFLT_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SINCPI = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            Sincpi.compute(G.OFLT_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> EXP = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            TaylorEstimateExp.compute(35, G.OFLT_MAT, G.OFLT, a, b);
        }
    };
    private final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> LOG = new Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            TaylorEstimateLog.compute(8, G.OFLT_MAT, G.OFLT, a, b);
        }
    };
    private final Function1<Boolean, OctonionFloat32MatrixMember> ISZERO = new Function1<Boolean, OctonionFloat32MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat32MatrixMember a) {
            return SequenceIsZero.compute(G.OFLT, a.rawData());
        }
    };
    private final Procedure1<OctonionFloat32MatrixMember> PI = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            OctonionFloat32Member pi = G.OFLT.construct();
            G.OFLT.PI().call(pi);
            MatrixConstantDiagonal.compute(G.OFLT, pi, a);
        }
    };
    private final Procedure1<OctonionFloat32MatrixMember> E = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            OctonionFloat32Member e = G.OFLT.construct();
            G.OFLT.E().call(e);
            MatrixConstantDiagonal.compute(G.OFLT, e, a);
        }
    };
    private final Procedure1<OctonionFloat32MatrixMember> PHI = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            OctonionFloat32Member phi = G.OFLT.construct();
            G.OFLT.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.OFLT, phi, a);
        }
    };
    private final Procedure1<OctonionFloat32MatrixMember> GAMMA = new Procedure1<OctonionFloat32MatrixMember>(){

        @Override
        public void call(OctonionFloat32MatrixMember a) {
            OctonionFloat32Member gamma = G.OFLT.construct();
            G.OFLT.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.OFLT, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SBHP = new Procedure3<HighPrecisionMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.OFLT, a, b, c);
        }
    };
    private Procedure3<RationalMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SBR = new Procedure3<RationalMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(RationalMember a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            MatrixScaleByRational.compute(G.OFLT, a, b, c);
        }
    };
    private Procedure3<Double, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> SBD = new Procedure3<Double, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public void call(Double a, OctonionFloat32MatrixMember b, OctonionFloat32MatrixMember c) {
            MatrixScaleByDouble.compute(G.OFLT, a, b, c);
        }
    };
    private final Function3<Boolean, Float32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> WITHIN = new Function3<Boolean, Float32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember>(){

        @Override
        public Boolean call(Float32Member tol, OctonionFloat32MatrixMember a, OctonionFloat32MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.OFLT, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public OctonionFloat32MatrixMember construct() {
        return new OctonionFloat32MatrixMember();
    }

    @Override
    public OctonionFloat32MatrixMember construct(OctonionFloat32MatrixMember other) {
        return new OctonionFloat32MatrixMember(other);
    }

    @Override
    public OctonionFloat32MatrixMember construct(String s) {
        return new OctonionFloat32MatrixMember(s);
    }

    @Override
    public OctonionFloat32MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new OctonionFloat32MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, OctonionFloat32MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, OctonionFloat32MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public final Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> invert() {
        return this.INVERT;
    }

    @Override
    public Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<OctonionFloat32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, OctonionFloat32MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<OctonionFloat32MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float32Member, OctonionFloat32MatrixMember, OctonionFloat32MatrixMember> within() {
        return this.WITHIN;
    }
}

