/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.quaternion;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.QuaternionNumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float32.quaternion.QuaternionFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat32Algebra
implements SkewField<QuaternionFloat32Algebra, QuaternionFloat32Member>,
RealConstants<QuaternionFloat32Member>,
ImaginaryConstants<QuaternionFloat32Member>,
QuaternionConstants<QuaternionFloat32Member>,
Norm<QuaternionFloat32Member, Float32Member>,
Conjugate<QuaternionFloat32Member>,
Infinite<QuaternionFloat32Member>,
NaN<QuaternionFloat32Member>,
Rounding<Float32Member, QuaternionFloat32Member>,
Random<QuaternionFloat32Member>,
Exponential<QuaternionFloat32Member>,
Trigonometric<QuaternionFloat32Member>,
Hyperbolic<QuaternionFloat32Member>,
Power<QuaternionFloat32Member>,
Roots<QuaternionFloat32Member>,
RealUnreal<QuaternionFloat32Member, Float32Member>,
Scale<QuaternionFloat32Member, QuaternionFloat32Member>,
ScaleByHighPrec<QuaternionFloat32Member>,
ScaleByRational<QuaternionFloat32Member>,
ScaleByDouble<QuaternionFloat32Member>,
ScaleComponents<QuaternionFloat32Member, Float32Member>,
Tolerance<Float32Member, QuaternionFloat32Member> {
    private static final QuaternionFloat32Member ZERO = new QuaternionFloat32Member(0.0f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member ONE_THIRD = new QuaternionFloat32Member(0.33333334f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member ONE_HALF = new QuaternionFloat32Member(0.5f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member ONE = new QuaternionFloat32Member(1.0f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member TWO = new QuaternionFloat32Member(2.0f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member E = new QuaternionFloat32Member((float)Math.E, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member PI = new QuaternionFloat32Member((float)Math.PI, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member GAMMA = new QuaternionFloat32Member(0.5772157f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member PHI = new QuaternionFloat32Member(1.618034f, 0.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member I = new QuaternionFloat32Member(0.0f, 1.0f, 0.0f, 0.0f);
    private static final QuaternionFloat32Member J = new QuaternionFloat32Member(0.0f, 0.0f, 1.0f, 0.0f);
    private static final QuaternionFloat32Member K = new QuaternionFloat32Member(0.0f, 0.0f, 0.0f, 1.0f);
    private final Procedure1<QuaternionFloat32Member> UNITY = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> MUL = new Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            double r = a.r() * b.r() - a.i() * b.i() - a.j() * b.j() - a.k() * b.k();
            double i = a.r() * b.i() + a.i() * b.r() + a.j() * b.k() - a.k() * b.j();
            double j = a.r() * b.j() - a.i() * b.k() + a.j() * b.r() + a.k() * b.i();
            double k = a.r() * b.k() + a.i() * b.j() - a.j() * b.i() + a.k() * b.r();
            c.setR((float)r);
            c.setI((float)i);
            c.setJ((float)j);
            c.setK((float)k);
        }
    };
    private final Procedure3<Integer, QuaternionFloat32Member, QuaternionFloat32Member> POWER = new Procedure3<Integer, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(Integer power, QuaternionFloat32Member a, QuaternionFloat32Member b) {
            PowerAny.compute(G.QFLT, power, a, b);
        }
    };
    private final Procedure1<QuaternionFloat32Member> ZER = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> NEG = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Algebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> ADD = new Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
            c.setJ(a.j() + b.j());
            c.setK(a.k() + b.k());
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> SUB = new Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
            c.setJ(a.j() - b.j());
            c.setK(a.k() - b.k());
        }
    };
    private final Function2<Boolean, QuaternionFloat32Member, QuaternionFloat32Member> EQ = new Function2<Boolean, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public Boolean call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k();
        }
    };
    private final Function2<Boolean, QuaternionFloat32Member, QuaternionFloat32Member> NEQ = new Function2<Boolean, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public Boolean call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            return QuaternionFloat32Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> ASSIGN = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member from, QuaternionFloat32Member to) {
            to.set(from);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> INV = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Member c = new QuaternionFloat32Member();
            QuaternionFloat32Member scale = new QuaternionFloat32Member();
            Float32Member nval = new Float32Member();
            QuaternionFloat32Algebra.this.norm().call(a, nval);
            scale.setR((float)(1.0 / (double)(nval.v() * nval.v())));
            QuaternionFloat32Algebra.this.conjugate().call(a, c);
            QuaternionFloat32Algebra.this.multiply().call(scale, c, b);
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> DIVIDE = new Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            QuaternionFloat32Member tmp = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.invert().call(b, tmp);
            QuaternionFloat32Algebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> CONJ = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            b.setR(a.r());
            b.setI(-a.i());
            b.setJ(-a.j());
            b.setK(-a.k());
        }
    };
    private final Procedure2<QuaternionFloat32Member, Float32Member> NORM = new Procedure2<QuaternionFloat32Member, Float32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, Float32Member b) {
            double max = Math.max(Math.abs(a.r()), Math.abs(a.i()));
            max = Math.max(max, (double)Math.abs(a.j()));
            if ((max = Math.max(max, (double)Math.abs(a.k()))) == 0.0) {
                b.setV(0.0f);
            } else {
                double sum = (double)a.r() / max * ((double)a.r() / max);
                sum += (double)a.i() / max * ((double)a.i() / max);
                sum += (double)a.j() / max * ((double)a.j() / max);
                b.setV((float)(max * Math.sqrt(sum += (double)a.k() / max * ((double)a.k() / max))));
            }
        }
    };
    private final Procedure1<QuaternionFloat32Member> PI_ = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<QuaternionFloat32Member> E_ = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<QuaternionFloat32Member> GAMMA_ = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<QuaternionFloat32Member> PHI_ = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<QuaternionFloat32Member> I_ = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<QuaternionFloat32Member> J_ = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<QuaternionFloat32Member> K_ = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            QuaternionFloat32Algebra.this.assign().call(K, a);
        }
    };
    private Procedure4<Round.Mode, Float32Member, QuaternionFloat32Member, QuaternionFloat32Member> ROUND = new Procedure4<Round.Mode, Float32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Float32Member tmp = new Float32Member();
            tmp.setV(a.r());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setI(tmp.v());
            tmp.setV(a.j());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setJ(tmp.v());
            tmp.setV(a.k());
            Round.compute(G.FLT, mode, delta, tmp, tmp);
            b.setK(tmp.v());
        }
    };
    private Function1<Boolean, QuaternionFloat32Member> ISNAN = new Function1<Boolean, QuaternionFloat32Member>(){

        @Override
        public Boolean call(QuaternionFloat32Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i()) || Double.isNaN(a.j()) || Double.isNaN(a.k());
        }
    };
    private final Procedure1<QuaternionFloat32Member> NAN = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            a.setR(Float.NaN);
            a.setI(Float.NaN);
            a.setJ(Float.NaN);
            a.setK(Float.NaN);
        }
    };
    private Function1<Boolean, QuaternionFloat32Member> ISINF = new Function1<Boolean, QuaternionFloat32Member>(){

        @Override
        public Boolean call(QuaternionFloat32Member a) {
            return QuaternionFloat32Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()) || Double.isInfinite(a.j()) || Double.isInfinite(a.k()));
        }
    };
    private final Procedure1<QuaternionFloat32Member> INF = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            a.setR(Float.POSITIVE_INFINITY);
            a.setI(Float.POSITIVE_INFINITY);
            a.setJ(Float.POSITIVE_INFINITY);
            a.setK(Float.POSITIVE_INFINITY);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> EXP = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            QuaternionFloat32Member tmp = new QuaternionFloat32Member();
            double u = FastMath.exp((double)a.r());
            QuaternionFloat32Algebra.this.unreal().call(a, tmp);
            QuaternionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinc().call(z, z2);
            double w = z2.v();
            b.setR((float)(u * FastMath.cos((double)z.v())));
            b.setI((float)(u * w * (double)a.i()));
            b.setJ((float)(u * w * (double)a.j()));
            b.setK((float)(u * w * (double)a.k()));
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> LOG = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Float32Member norm = new Float32Member();
            Float32Member term = new Float32Member();
            Float32Member v1 = new Float32Member();
            Float32Member v2 = new Float32Member();
            Float32Member v3 = new Float32Member();
            QuaternionFloat32Algebra.this.norm().call(a, norm);
            Float32Member multiplier = new Float32Member(a.r() / norm.v());
            v1.setV(a.i() * multiplier.v());
            v2.setV(a.j() * multiplier.v());
            v3.setV(a.k() * multiplier.v());
            G.FLT.acos().call(multiplier, term);
            b.setR((float)Math.log(norm.v()));
            b.setI(v1.v() * term.v());
            b.setJ(v2.v() * term.v());
            b.setK(v3.v() * term.v());
        }
    };
    private final Procedure1<QuaternionFloat32Member> RAND = new Procedure1<QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextFloat());
            a.setI(rng.nextFloat());
            a.setJ(rng.nextFloat());
            a.setK(rng.nextFloat());
        }
    };
    private final Procedure2<QuaternionFloat32Member, Float32Member> REAL = new Procedure2<QuaternionFloat32Member, Float32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, Float32Member b) {
            b.setV(a.r());
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> UNREAL = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Algebra.this.assign().call(a, b);
            b.setR(0.0f);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> SINH = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Member negA = new QuaternionFloat32Member();
            QuaternionFloat32Member sum = new QuaternionFloat32Member();
            QuaternionFloat32Member tmp1 = new QuaternionFloat32Member();
            QuaternionFloat32Member tmp2 = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.negate().call(a, negA);
            QuaternionFloat32Algebra.this.exp().call(a, tmp1);
            QuaternionFloat32Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat32Algebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionFloat32Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> COSH = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Member negA = new QuaternionFloat32Member();
            QuaternionFloat32Member sum = new QuaternionFloat32Member();
            QuaternionFloat32Member tmp1 = new QuaternionFloat32Member();
            QuaternionFloat32Member tmp2 = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.negate().call(a, negA);
            QuaternionFloat32Algebra.this.exp().call(a, tmp1);
            QuaternionFloat32Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat32Algebra.this.add().call(tmp1, tmp2, sum);
            QuaternionFloat32Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> SINHANDCOSH = new Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member s, QuaternionFloat32Member c) {
            QuaternionFloat32Member negA = new QuaternionFloat32Member();
            QuaternionFloat32Member sum = new QuaternionFloat32Member();
            QuaternionFloat32Member tmp1 = new QuaternionFloat32Member();
            QuaternionFloat32Member tmp2 = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.negate().call(a, negA);
            QuaternionFloat32Algebra.this.exp().call(a, tmp1);
            QuaternionFloat32Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat32Algebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionFloat32Algebra.this.divide().call(sum, TWO, s);
            QuaternionFloat32Algebra.this.add().call(tmp1, tmp2, sum);
            QuaternionFloat32Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> TANH = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Member s = new QuaternionFloat32Member();
            QuaternionFloat32Member c = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.sinhAndCosh().call(a, s, c);
            QuaternionFloat32Algebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> SIN = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            QuaternionFloat32Member tmp = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.unreal().call(a, tmp);
            QuaternionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            b.setR((float)(sin * cosh));
            b.setI((float)(ws * (double)a.i()));
            b.setJ((float)(ws * (double)a.j()));
            b.setK((float)(ws * (double)a.k()));
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> COS = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            QuaternionFloat32Member tmp = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.unreal().call(a, tmp);
            QuaternionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double wc = -sin * sinhc_pi;
            b.setR((float)(cos * cosh));
            b.setI((float)(wc * (double)a.i()));
            b.setJ((float)(wc * (double)a.j()));
            b.setK((float)(wc * (double)a.k()));
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> SINANDCOS = new Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member s, QuaternionFloat32Member c) {
            Float32Member z = new Float32Member();
            Float32Member z2 = new Float32Member();
            QuaternionFloat32Member tmp = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.unreal().call(a, tmp);
            QuaternionFloat32Algebra.this.norm().call(tmp, z);
            G.FLT.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            double wc = -sin * sinhc_pi;
            s.setR((float)(sin * cosh));
            s.setI((float)ws * a.i());
            s.setJ((float)ws * a.j());
            s.setK((float)ws * a.k());
            c.setR((float)(cos * cosh));
            c.setI((float)wc * a.i());
            c.setJ((float)wc * a.j());
            c.setK((float)wc * a.k());
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> TAN = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Member sin = new QuaternionFloat32Member();
            QuaternionFloat32Member cos = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.sinAndCos().call(a, sin, cos);
            QuaternionFloat32Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> POW = new Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            QuaternionFloat32Member logA = new QuaternionFloat32Member();
            QuaternionFloat32Member bLogA = new QuaternionFloat32Member();
            QuaternionFloat32Algebra.this.log().call(a, logA);
            QuaternionFloat32Algebra.this.multiply().call(b, logA, bLogA);
            QuaternionFloat32Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> SINCH = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Sinch.compute(G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> SINCHPI = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Sinchpi.compute(G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> SINC = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Sinc.compute(G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> SINCPI = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            Sincpi.compute(G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> SQRT = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> CBRT = new Procedure2<QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32Member b) {
            QuaternionFloat32Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat32Member> ISZERO = new Function1<Boolean, QuaternionFloat32Member>(){

        @Override
        public Boolean call(QuaternionFloat32Member a) {
            return a.r() == 0.0f && a.i() == 0.0f && a.j() == 0.0f && a.k() == 0.0f;
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionFloat32Member, QuaternionFloat32Member> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j()));
            c.setJ(tmp.floatValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k()));
            c.setK(tmp.floatValue());
        }
    };
    private final Procedure3<RationalMember, QuaternionFloat32Member, QuaternionFloat32Member> SBR = new Procedure3<RationalMember, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(RationalMember a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.j());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp.floatValue());
            tmp = BigDecimal.valueOf(b.k());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp.floatValue());
        }
    };
    private final Procedure3<Double, QuaternionFloat32Member, QuaternionFloat32Member> SBD = new Procedure3<Double, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(Double a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            c.setR((float)(a * (double)b.r()));
            c.setI((float)(a * (double)b.i()));
            c.setJ((float)(a * (double)b.j()));
            c.setK((float)(a * (double)b.k()));
        }
    };
    private final Procedure3<Float32Member, QuaternionFloat32Member, QuaternionFloat32Member> SC = new Procedure3<Float32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public void call(Float32Member a, QuaternionFloat32Member b, QuaternionFloat32Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
            c.setJ(a.v() * b.j());
            c.setK(a.v() * b.k());
        }
    };
    private final Function3<Boolean, Float32Member, QuaternionFloat32Member, QuaternionFloat32Member> WITHIN = new Function3<Boolean, Float32Member, QuaternionFloat32Member, QuaternionFloat32Member>(){

        @Override
        public Boolean call(Float32Member tol, QuaternionFloat32Member a, QuaternionFloat32Member b) {
            return QuaternionNumberWithin.compute(G.FLT, tol, a, b);
        }
    };

    @Override
    public Procedure1<QuaternionFloat32Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat32Member, QuaternionFloat32Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, QuaternionFloat32Member, QuaternionFloat32Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat32Member, QuaternionFloat32Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public QuaternionFloat32Member construct() {
        return new QuaternionFloat32Member();
    }

    @Override
    public QuaternionFloat32Member construct(QuaternionFloat32Member other) {
        return new QuaternionFloat32Member(other);
    }

    @Override
    public QuaternionFloat32Member construct(String s) {
        return new QuaternionFloat32Member(s);
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> I() {
        return this.I_;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> J() {
        return this.J_;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> K() {
        return this.K_;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, QuaternionFloat32Member, QuaternionFloat32Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> log() {
        return this.LOG;
    }

    @Override
    public Procedure1<QuaternionFloat32Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, Float32Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<QuaternionFloat32Member, QuaternionFloat32Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32Member, QuaternionFloat32Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat32Member, QuaternionFloat32Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat32Member, QuaternionFloat32Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat32Member, QuaternionFloat32Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float32Member, QuaternionFloat32Member, QuaternionFloat32Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float32Member, QuaternionFloat32Member, QuaternionFloat32Member> within() {
        return this.WITHIN;
    }
}

