/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.quaternion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorLikeProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.quaternion.QuaternionFloat32Algebra;
import nom.bdezonia.zorbage.type.data.float32.quaternion.QuaternionFloat32CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float32.quaternion.QuaternionFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat32CartesianTensorProduct
implements TensorLikeProduct<QuaternionFloat32CartesianTensorProduct, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32Algebra, QuaternionFloat32Member>,
ConstructibleNdLong<QuaternionFloat32CartesianTensorProductMember>,
Norm<QuaternionFloat32CartesianTensorProductMember, Float32Member>,
Scale<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32Member>,
Rounding<Float32Member, QuaternionFloat32CartesianTensorProductMember>,
Infinite<QuaternionFloat32CartesianTensorProductMember>,
NaN<QuaternionFloat32CartesianTensorProductMember>,
ScaleByHighPrec<QuaternionFloat32CartesianTensorProductMember>,
ScaleByRational<QuaternionFloat32CartesianTensorProductMember>,
ScaleByDouble<QuaternionFloat32CartesianTensorProductMember>,
Tolerance<Float32Member, QuaternionFloat32CartesianTensorProductMember> {
    private final Function2<Boolean, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> EQ = new Function2<Boolean, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QFLT, G.FLT.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> NEQ = new Function2<Boolean, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            return QuaternionFloat32CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> ASSIGN = new Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember from, QuaternionFloat32CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.QFLT, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<QuaternionFloat32CartesianTensorProductMember> ZER = new Procedure1<QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> NEG = new Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QFLT, G.QFLT.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> ADDEL = new Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b, QuaternionFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QFLT, G.QFLT.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> SUBEL = new Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b, QuaternionFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QFLT, G.QFLT.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<QuaternionFloat32CartesianTensorProductMember, Float32Member> NORM = new Procedure2<QuaternionFloat32CartesianTensorProductMember, Float32Member>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, Float32Member b) {
            TensorNorm.compute(G.QFLT, G.FLT, a.rawData(), b);
        }
    };
    private final Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> CONJ = new Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QFLT, G.QFLT.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> SCALE = new Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32Member scalar, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.QFLT, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> ADDSCALAR = new Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32Member scalar, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.QFLT, scalar, G.QFLT.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> SUBSCALAR = new Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32Member scalar, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            QuaternionFloat32Member tmp = G.QFLT.construct();
            G.QFLT.negate().call(scalar, tmp);
            QuaternionFloat32CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> MULEL = new Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b, QuaternionFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QFLT, G.QFLT.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> DIVIDEEL = new Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b, QuaternionFloat32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QFLT, G.QFLT.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> MUL = new Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b, QuaternionFloat32CartesianTensorProductMember c) {
            QuaternionFloat32CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorContract.compute(G.QFLT, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> SEMI = new Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.QFLT_TEN, G.QFLT, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> COMMA = new Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.QFLT_TEN, G.QFLT, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> POWER = new Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorPower.compute(G.QFLT_TEN, power, a, b);
        }
    };
    private final Procedure1<QuaternionFloat32CartesianTensorProductMember> UNITY = new Procedure1<QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember result) {
            TensorUnity.compute(G.QFLT_TEN, G.QFLT, result);
        }
    };
    private final Function1<Boolean, QuaternionFloat32CartesianTensorProductMember> ISNAN = new Function1<Boolean, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat32CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.QFLT, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat32CartesianTensorProductMember> NAN = new Procedure1<QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a) {
            FillNaN.compute(G.QFLT, a);
        }
    };
    private final Function1<Boolean, QuaternionFloat32CartesianTensorProductMember> ISINF = new Function1<Boolean, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat32CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.QFLT, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat32CartesianTensorProductMember> INF = new Procedure1<QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a) {
            FillInfinite.compute(G.QFLT, a);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorRound.compute(G.QFLT_TEN, G.QFLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat32CartesianTensorProductMember> ISZERO = new Function1<Boolean, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat32CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.QFLT, a.rawData());
        }
    };
    private final Procedure3<RationalMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> SBR = new Procedure3<RationalMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.QFLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> SBD = new Procedure3<Double, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.QFLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.QFLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32Member tol, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QFLT, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> MULBYSCALAR = new Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32Member factor, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            QuaternionFloat32CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32Member factor, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            QuaternionFloat32Member invFactor = G.QFLT.construct();
            G.QFLT.invert().call(factor, invFactor);
            QuaternionFloat32CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> RAISE = new Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> LOWER = new Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            QuaternionFloat32CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b, QuaternionFloat32CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            QuaternionFloat32CartesianTensorProductMember tmp = QuaternionFloat32CartesianTensorProduct.this.construct();
            QuaternionFloat32CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            QuaternionFloat32CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> OUTER = new Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat32CartesianTensorProductMember a, QuaternionFloat32CartesianTensorProductMember b, QuaternionFloat32CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.QFLT_TEN, G.QFLT, a, b, c);
        }
    };

    @Override
    public QuaternionFloat32CartesianTensorProductMember construct() {
        return new QuaternionFloat32CartesianTensorProductMember();
    }

    @Override
    public QuaternionFloat32CartesianTensorProductMember construct(QuaternionFloat32CartesianTensorProductMember other) {
        return new QuaternionFloat32CartesianTensorProductMember(other);
    }

    @Override
    public QuaternionFloat32CartesianTensorProductMember construct(String s) {
        return new QuaternionFloat32CartesianTensorProductMember(s);
    }

    @Override
    public QuaternionFloat32CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new QuaternionFloat32CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<QuaternionFloat32CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<QuaternionFloat32CartesianTensorProductMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat32CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat32CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat32CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember, QuaternionFloat32CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

