/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.quaternion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.quaternion.QuaternionFloat32Algebra;
import nom.bdezonia.zorbage.type.data.float32.quaternion.QuaternionFloat32MatrixMember;
import nom.bdezonia.zorbage.type.data.float32.quaternion.QuaternionFloat32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat32Matrix
implements RingWithUnity<QuaternionFloat32Matrix, QuaternionFloat32MatrixMember>,
MatrixRing<QuaternionFloat32Matrix, QuaternionFloat32MatrixMember, QuaternionFloat32Algebra, QuaternionFloat32Member>,
Constructible2dLong<QuaternionFloat32MatrixMember>,
Rounding<Float32Member, QuaternionFloat32MatrixMember>,
Norm<QuaternionFloat32MatrixMember, Float32Member>,
DirectProduct<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>,
Exponential<QuaternionFloat32MatrixMember>,
Trigonometric<QuaternionFloat32MatrixMember>,
Hyperbolic<QuaternionFloat32MatrixMember>,
RealConstants<QuaternionFloat32MatrixMember>,
Infinite<QuaternionFloat32MatrixMember>,
NaN<QuaternionFloat32MatrixMember>,
ScaleByHighPrec<QuaternionFloat32MatrixMember>,
ScaleByRational<QuaternionFloat32MatrixMember>,
ScaleByDouble<QuaternionFloat32MatrixMember>,
Tolerance<Float32Member, QuaternionFloat32MatrixMember> {
    private final Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> MUL = new Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            MatrixMultiply.compute(G.QFLT, a, b, c);
        }
    };
    private final Procedure3<Integer, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> POWER = new Procedure3<Integer, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(Integer power, QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            MatrixPower.compute(power, G.QFLT, G.QFLT_RMOD, G.QFLT_MAT, a, b);
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> ZER = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> NEG = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            MatrixNegate.compute(G.QFLT, a, b);
        }
    };
    private final Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> ADD = new Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            MatrixAddition.compute(G.QFLT, a, b, c);
        }
    };
    private final Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SUB = new Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            MatrixSubtraction.compute(G.QFLT, a, b, c);
        }
    };
    private final Function2<Boolean, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> EQ = new Function2<Boolean, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            return MatrixEqual.compute(G.QFLT, a, b);
        }
    };
    private final Function2<Boolean, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> NEQ = new Function2<Boolean, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            return QuaternionFloat32Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> ASSIGN = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember from, QuaternionFloat32MatrixMember to) {
            MatrixAssign.compute(G.QFLT, from, to);
        }
    };
    private Procedure2<QuaternionFloat32MatrixMember, Float32Member> NORM = new Procedure2<QuaternionFloat32MatrixMember, Float32Member>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, Float32Member b) {
            MatrixSpectralNorm.compute(G.QFLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> ROUND = new Procedure4<Round.Mode, Float32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            MatrixRound.compute(G.QFLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat32MatrixMember> ISNAN = new Function1<Boolean, QuaternionFloat32MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat32MatrixMember a) {
            return SequenceIsNan.compute(G.QFLT, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> NAN = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            FillNaN.compute(G.QFLT, a);
        }
    };
    private final Function1<Boolean, QuaternionFloat32MatrixMember> ISINF = new Function1<Boolean, QuaternionFloat32MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat32MatrixMember a) {
            return SequenceIsInf.compute(G.QFLT, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> INF = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            FillInfinite.compute(G.QFLT, a);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> CONJ = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            MatrixConjugate.compute(G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> TRANSP = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            MatrixTranspose.compute(G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> CONJTRANSP = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            QuaternionFloat32MatrixMember tmp = new QuaternionFloat32MatrixMember();
            QuaternionFloat32Matrix.this.conjugate().call(a, tmp);
            QuaternionFloat32Matrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32Member> DET = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32Member>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32Member b) {
            MatrixDeterminant.compute(G.QFLT_MAT, G.QFLT, a, b);
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> UNITY = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            MatrixUnity.compute(G.QFLT, a);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> INV = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            MatrixInvert.compute(G.QFLT, G.QFLT_RMOD, G.QFLT_MAT, a, b);
        }
    };
    private final Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> DIVIDE = new Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            QuaternionFloat32MatrixMember invB = QuaternionFloat32Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            QuaternionFloat32Matrix.this.invert().call(b, invB);
            QuaternionFloat32Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> DP = new Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember in1, QuaternionFloat32MatrixMember in2, QuaternionFloat32MatrixMember out) {
            MatrixDirectProduct.compute(G.QFLT, in1, in2, out);
        }
    };
    private final Procedure3<QuaternionFloat32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SCALE = new Procedure3<QuaternionFloat32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32Member a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            MatrixScale.compute(G.QFLT, a, b, c);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SINH = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.QFLT_MAT, G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> COSH = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.QFLT_MAT, G.QFLT, a, b);
        }
    };
    private final Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SINHANDCOSH = new Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember s, QuaternionFloat32MatrixMember c) {
            QuaternionFloat32Matrix.this.sinh().call(a, s);
            QuaternionFloat32Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> TANH = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            QuaternionFloat32MatrixMember s = G.QFLT_MAT.construct();
            QuaternionFloat32MatrixMember c = G.QFLT_MAT.construct();
            QuaternionFloat32Matrix.this.sinhAndCosh().call(a, s, c);
            QuaternionFloat32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SINCH = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            Sinch.compute(G.QFLT_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SINCHPI = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            Sinchpi.compute(G.QFLT_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SIN = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            TaylorEstimateSin.compute(18, G.QFLT_MAT, G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> COS = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            TaylorEstimateCos.compute(18, G.QFLT_MAT, G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> TAN = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            QuaternionFloat32MatrixMember s = G.QFLT_MAT.construct();
            QuaternionFloat32MatrixMember c = G.QFLT_MAT.construct();
            QuaternionFloat32Matrix.this.sinAndCos().call(a, s, c);
            QuaternionFloat32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SINANDCOS = new Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember s, QuaternionFloat32MatrixMember c) {
            QuaternionFloat32Matrix.this.sin().call(a, s);
            QuaternionFloat32Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SINC = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            Sinc.compute(G.QFLT_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SINCPI = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            Sincpi.compute(G.QFLT_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> EXP = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            TaylorEstimateExp.compute(35, G.QFLT_MAT, G.QFLT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> LOG = new Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            TaylorEstimateLog.compute(8, G.QFLT_MAT, G.QFLT, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat32MatrixMember> ISZERO = new Function1<Boolean, QuaternionFloat32MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat32MatrixMember a) {
            return SequenceIsZero.compute(G.QFLT, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> PI = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            QuaternionFloat32Member pi = G.QFLT.construct();
            G.QFLT.PI().call(pi);
            MatrixConstantDiagonal.compute(G.QFLT, pi, a);
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> E = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            QuaternionFloat32Member e = G.QFLT.construct();
            G.QFLT.E().call(e);
            MatrixConstantDiagonal.compute(G.QFLT, e, a);
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> PHI = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            QuaternionFloat32Member phi = G.QFLT.construct();
            G.QFLT.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.QFLT, phi, a);
        }
    };
    private final Procedure1<QuaternionFloat32MatrixMember> GAMMA = new Procedure1<QuaternionFloat32MatrixMember>(){

        @Override
        public void call(QuaternionFloat32MatrixMember a) {
            QuaternionFloat32Member gamma = G.QFLT.construct();
            G.QFLT.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.QFLT, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.QFLT, a, b, c);
        }
    };
    private Procedure3<RationalMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SBR = new Procedure3<RationalMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(RationalMember a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            MatrixScaleByRational.compute(G.QFLT, a, b, c);
        }
    };
    private Procedure3<Double, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> SBD = new Procedure3<Double, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public void call(Double a, QuaternionFloat32MatrixMember b, QuaternionFloat32MatrixMember c) {
            MatrixScaleByDouble.compute(G.QFLT, a, b, c);
        }
    };
    private final Function3<Boolean, Float32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> WITHIN = new Function3<Boolean, Float32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember>(){

        @Override
        public Boolean call(Float32Member tol, QuaternionFloat32MatrixMember a, QuaternionFloat32MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.QFLT, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public QuaternionFloat32MatrixMember construct() {
        return new QuaternionFloat32MatrixMember();
    }

    @Override
    public QuaternionFloat32MatrixMember construct(QuaternionFloat32MatrixMember other) {
        return new QuaternionFloat32MatrixMember(other);
    }

    @Override
    public QuaternionFloat32MatrixMember construct(String s) {
        return new QuaternionFloat32MatrixMember(s);
    }

    @Override
    public QuaternionFloat32MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new QuaternionFloat32MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<QuaternionFloat32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, QuaternionFloat32MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<QuaternionFloat32MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float32Member, QuaternionFloat32MatrixMember, QuaternionFloat32MatrixMember> within() {
        return this.WITHIN;
    }
}

