/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.real;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;
import nom.bdezonia.zorbage.type.algebra.InverseTrigonometric;
import nom.bdezonia.zorbage.type.algebra.MiscFloat;
import nom.bdezonia.zorbage.type.algebra.ModularDivision;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OrderedField;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.PredSucc;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float32Algebra
implements OrderedField<Float32Algebra, Float32Member>,
Bounded<Float32Member>,
Norm<Float32Member, Float32Member>,
RealConstants<Float32Member>,
Exponential<Float32Member>,
Trigonometric<Float32Member>,
InverseTrigonometric<Float32Member>,
Hyperbolic<Float32Member>,
InverseHyperbolic<Float32Member>,
Infinite<Float32Member>,
NaN<Float32Member>,
Roots<Float32Member>,
Power<Float32Member>,
Rounding<Float32Member, Float32Member>,
Random<Float32Member>,
RealUnreal<Float32Member, Float32Member>,
PredSucc<Float32Member>,
MiscFloat<Float32Member>,
ModularDivision<Float32Member>,
Conjugate<Float32Member>,
Scale<Float32Member, Float32Member>,
ScaleByHighPrec<Float32Member>,
ScaleByRational<Float32Member>,
ScaleByDouble<Float32Member>,
ScaleComponents<Float32Member, Float32Member>,
Tolerance<Float32Member, Float32Member> {
    private static final Float32Member PI = new Float32Member((float)Math.PI);
    private static final Float32Member E = new Float32Member((float)Math.E);
    private static final Float32Member GAMMA = new Float32Member(0.5772157f);
    private static final Float32Member PHI = new Float32Member(1.618034f);
    private final Function2<Boolean, Float32Member, Float32Member> EQ = new Function2<Boolean, Float32Member, Float32Member>(){

        @Override
        public Boolean call(Float32Member a, Float32Member b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, Float32Member, Float32Member> NEQ = new Function2<Boolean, Float32Member, Float32Member>(){

        @Override
        public Boolean call(Float32Member a, Float32Member b) {
            return a.v() != b.v();
        }
    };
    private final Procedure2<Float32Member, Float32Member> ASSIGN = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member from, Float32Member to) {
            to.set(from);
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> ADD = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV(a.v() + b.v());
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> SUB = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV(a.v() - b.v());
        }
    };
    private final Procedure1<Float32Member> ZER = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float32Member, Float32Member> NEG = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(-a.v());
        }
    };
    private final Procedure1<Float32Member> UNITY = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            a.setV(1.0f);
        }
    };
    private final Procedure2<Float32Member, Float32Member> INV = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(1.0f / a.v());
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> DIVIDE = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV(a.v() / b.v());
        }
    };
    private final Function2<Boolean, Float32Member, Float32Member> LESS = new Function2<Boolean, Float32Member, Float32Member>(){

        @Override
        public Boolean call(Float32Member a, Float32Member b) {
            return a.v() < b.v();
        }
    };
    private final Function2<Boolean, Float32Member, Float32Member> LE = new Function2<Boolean, Float32Member, Float32Member>(){

        @Override
        public Boolean call(Float32Member a, Float32Member b) {
            return a.v() <= b.v();
        }
    };
    private final Function2<Boolean, Float32Member, Float32Member> GREAT = new Function2<Boolean, Float32Member, Float32Member>(){

        @Override
        public Boolean call(Float32Member a, Float32Member b) {
            return a.v() > b.v();
        }
    };
    private final Function2<Boolean, Float32Member, Float32Member> GE = new Function2<Boolean, Float32Member, Float32Member>(){

        @Override
        public Boolean call(Float32Member a, Float32Member b) {
            return a.v() >= b.v();
        }
    };
    private Function2<Integer, Float32Member, Float32Member> CMP = new Function2<Integer, Float32Member, Float32Member>(){

        @Override
        public Integer call(Float32Member a, Float32Member b) {
            if (a.v() < b.v()) {
                return -1;
            }
            if (a.v() > b.v()) {
                return 1;
            }
            return 0;
        }
    };
    private Function1<Integer, Float32Member> SIG = new Function1<Integer, Float32Member>(){

        @Override
        public Integer call(Float32Member a) {
            if (a.v() < 0.0f) {
                return -1;
            }
            if (a.v() > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure1<Float32Member> MAXBOUND = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            a.setV(Float.MAX_VALUE);
        }
    };
    private final Procedure1<Float32Member> MINBOUND = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            a.setV(-3.4028235E38f);
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> MUL = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<Integer, Float32Member, Float32Member> POWER = new Procedure3<Integer, Float32Member, Float32Member>(){

        @Override
        public void call(Integer power, Float32Member a, Float32Member b) {
            if (power == 0 && a.v() == 0.0f) {
                b.setV(Float.NaN);
            } else {
                b.setV((float)FastMath.pow((double)a.v(), (double)power.intValue()));
            }
        }
    };
    private final Procedure2<Float32Member, Float32Member> ABS = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(Math.abs(a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> NORM = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Float32Algebra.this.abs().call(a, b);
        }
    };
    private final Procedure1<Float32Member> PI_ = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            Float32Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<Float32Member> E_ = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            Float32Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<Float32Member> GAMMA_ = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            Float32Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<Float32Member> PHI_ = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            Float32Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure2<Float32Member, Float32Member> EXP = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.exp((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> EXPM1 = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.expm1((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> LOG = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.log(a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> LOG1P = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.log1p(a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> COS = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.cos((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> SIN = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.sin((double)a.v()));
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> SINANDCOS = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member s, Float32Member c) {
            Float32Algebra.this.sin().call(a, s);
            Float32Algebra.this.cos().call(a, c);
        }
    };
    private final Procedure2<Float32Member, Float32Member> TAN = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.tan((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> CSC = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)(1.0 / FastMath.sin((double)a.v())));
        }
    };
    private final Procedure2<Float32Member, Float32Member> SEC = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)(1.0 / FastMath.cos((double)a.v())));
        }
    };
    private final Procedure2<Float32Member, Float32Member> COT = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)(1.0 / FastMath.tan((double)a.v())));
        }
    };
    private final Procedure2<Float32Member, Float32Member> COSH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.cosh((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> SINH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.sinh((double)a.v()));
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> SINHANDCOSH = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member s, Float32Member c) {
            Float32Algebra.this.sinh().call(a, s);
            Float32Algebra.this.cosh().call(a, c);
        }
    };
    private final Procedure2<Float32Member, Float32Member> TANH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.tanh((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> CSCH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)(1.0 / FastMath.sinh((double)a.v())));
        }
    };
    private final Procedure2<Float32Member, Float32Member> SECH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)(1.0 / FastMath.cosh((double)a.v())));
        }
    };
    private final Procedure2<Float32Member, Float32Member> COTH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)(1.0 / FastMath.tanh((double)a.v())));
        }
    };
    private final Procedure2<Float32Member, Float32Member> ACOS = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.acos((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> ASIN = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.asin((double)a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> ATAN = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.atan((double)a.v()));
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> ATAN2 = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV((float)FastMath.atan2((double)a.v(), (double)b.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> ACSC = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Float32Member tmp = new Float32Member(1.0f / a.v());
            Float32Algebra.this.asin().call(tmp, b);
        }
    };
    private final Procedure2<Float32Member, Float32Member> ASEC = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Float32Member tmp = new Float32Member(1.0f / a.v());
            Float32Algebra.this.acos().call(tmp, b);
        }
    };
    private final Procedure2<Float32Member, Float32Member> ACOT = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Float32Member tmp = new Float32Member(1.0f / a.v());
            Float32Algebra.this.atan().call(tmp, b);
        }
    };
    private Procedure2<Float32Member, Float32Member> ACOSH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.log((double)a.v() + Math.sqrt(a.v() * a.v() - 1.0f)));
        }
    };
    private Procedure2<Float32Member, Float32Member> ASINH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.log((double)a.v() + Math.sqrt(a.v() * a.v() + 1.0f)));
        }
    };
    private Procedure2<Float32Member, Float32Member> ATANH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)(0.5 * (-Math.log(1.0f - a.v()) + Math.log(1.0f + a.v()))));
        }
    };
    private final Procedure2<Float32Member, Float32Member> ACSCH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Float32Member tmp = new Float32Member(1.0f / a.v());
            Float32Algebra.this.asinh().call(tmp, b);
        }
    };
    private final Procedure2<Float32Member, Float32Member> ASECH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Float32Member tmp = new Float32Member(1.0f / a.v());
            Float32Algebra.this.acosh().call(tmp, b);
        }
    };
    private final Procedure2<Float32Member, Float32Member> ACOTH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Float32Member tmp = new Float32Member(1.0f / a.v());
            Float32Algebra.this.atanh().call(tmp, b);
        }
    };
    private final Function1<Boolean, Float32Member> ISNAN = new Function1<Boolean, Float32Member>(){

        @Override
        public Boolean call(Float32Member a) {
            return Float.isNaN(a.v());
        }
    };
    private final Procedure1<Float32Member> NAN = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            a.setV(Float.NaN);
        }
    };
    private final Function1<Boolean, Float32Member> ISINF = new Function1<Boolean, Float32Member>(){

        @Override
        public Boolean call(Float32Member a) {
            return Float.isInfinite(a.v());
        }
    };
    private final Procedure1<Float32Member> INF = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            a.setV(Float.POSITIVE_INFINITY);
        }
    };
    private final Procedure1<Float32Member> NINF = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            a.setV(Float.NEGATIVE_INFINITY);
        }
    };
    private final Procedure2<Float32Member, Float32Member> SQRT = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.sqrt(a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> CBRT = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)FastMath.cbrt((double)a.v()));
        }
    };
    private final Procedure4<Round.Mode, Float32Member, Float32Member, Float32Member> ROUND = new Procedure4<Round.Mode, Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, Float32Member a, Float32Member b) {
            Round.compute(G.FLT, mode, delta, a, b);
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> MIN = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            Min.compute(G.FLT, a, b, c);
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> MAX = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            Max.compute(G.FLT, a, b, c);
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> POW = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            if (a.v() == 0.0f && b.v() == 0.0f) {
                c.setV(Float.NaN);
            } else {
                c.setV((float)FastMath.pow((double)a.v(), (double)b.v()));
            }
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> IEEE = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV((float)Math.IEEEremainder(a.v(), b.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> LOG10 = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.log10(a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> TODEG = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.toDegrees(a.v()));
        }
    };
    private final Procedure2<Float32Member, Float32Member> TORAD = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV((float)Math.toRadians(a.v()));
        }
    };
    private final Procedure1<Float32Member> RAND = new Procedure1<Float32Member>(){

        @Override
        public void call(Float32Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextFloat());
        }
    };
    private final Procedure2<Float32Member, Float32Member> REAL = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(a.v());
        }
    };
    private final Procedure2<Float32Member, Float32Member> UNREAL = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(0.0f);
        }
    };
    private final Procedure2<Float32Member, Float32Member> PRED = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(Math.nextAfter(a.v(), Double.NEGATIVE_INFINITY));
        }
    };
    private final Procedure2<Float32Member, Float32Member> SUCC = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(Math.nextUp(a.v()));
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> CPS = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV(Math.copySign(a.v(), b.v()));
        }
    };
    private final Function1<Integer, Float32Member> GEXP = new Function1<Integer, Float32Member>(){

        @Override
        public Integer call(Float32Member a) {
            return Math.getExponent(a.v());
        }
    };
    private final Procedure3<Integer, Float32Member, Float32Member> SCALB = new Procedure3<Integer, Float32Member, Float32Member>(){

        @Override
        public void call(Integer scaleFactor, Float32Member a, Float32Member b) {
            b.setV(Math.scalb(a.v(), (int)scaleFactor));
        }
    };
    private final Procedure2<Float32Member, Float32Member> ULP = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            b.setV(Math.ulp(a.v()));
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> DIV = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member d) {
            double v = a.v() / b.v();
            v = v > 0.0 ? Math.floor(v) : Math.ceil(v);
            d.setV((float)v);
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> MOD = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member m) {
            m.setV(a.v() % b.v());
        }
    };
    private final Procedure4<Float32Member, Float32Member, Float32Member, Float32Member> DIVMOD = new Procedure4<Float32Member, Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member d, Float32Member m) {
            Float32Algebra.this.div().call(a, b, d);
            Float32Algebra.this.mod().call(a, b, m);
        }
    };
    private Procedure2<Float32Member, Float32Member> SINCH = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Sinch.compute(G.FLT, a, b);
        }
    };
    private Procedure2<Float32Member, Float32Member> SINCHPI = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Sinchpi.compute(G.FLT, a, b);
        }
    };
    private Procedure2<Float32Member, Float32Member> SINC = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Sinc.compute(G.FLT, a, b);
        }
    };
    private Procedure2<Float32Member, Float32Member> SINCPI = new Procedure2<Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b) {
            Sincpi.compute(G.FLT, a, b);
        }
    };
    private final Function1<Boolean, Float32Member> ISZERO = new Function1<Boolean, Float32Member>(){

        @Override
        public Boolean call(Float32Member a) {
            return a.v() == 0.0f;
        }
    };
    private final Procedure3<HighPrecisionMember, Float32Member, Float32Member> SBHP = new Procedure3<HighPrecisionMember, Float32Member, Float32Member>(){

        @Override
        public void call(HighPrecisionMember a, Float32Member b, Float32Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.v()));
            c.setV(tmp.floatValue());
        }
    };
    private final Procedure3<RationalMember, Float32Member, Float32Member> SBR = new Procedure3<RationalMember, Float32Member, Float32Member>(){

        @Override
        public void call(RationalMember a, Float32Member b, Float32Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.v());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setV(tmp.floatValue());
        }
    };
    private final Procedure3<Double, Float32Member, Float32Member> SBD = new Procedure3<Double, Float32Member, Float32Member>(){

        @Override
        public void call(Double a, Float32Member b, Float32Member c) {
            c.setV((float)(a * (double)b.v()));
        }
    };
    private final Procedure3<Float32Member, Float32Member, Float32Member> SC = new Procedure3<Float32Member, Float32Member, Float32Member>(){

        @Override
        public void call(Float32Member a, Float32Member b, Float32Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Function3<Boolean, Float32Member, Float32Member, Float32Member> WITHIN = new Function3<Boolean, Float32Member, Float32Member, Float32Member>(){

        @Override
        public Boolean call(Float32Member tol, Float32Member a, Float32Member b) {
            return NumberWithin.compute(G.FLT, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, Float32Member, Float32Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float32Member, Float32Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Float32Member construct() {
        return new Float32Member();
    }

    @Override
    public Float32Member construct(Float32Member other) {
        return new Float32Member(other);
    }

    @Override
    public Float32Member construct(String s) {
        return new Float32Member(s);
    }

    @Override
    public Procedure2<Float32Member, Float32Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<Float32Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure1<Float32Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Function2<Boolean, Float32Member, Float32Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, Float32Member, Float32Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, Float32Member, Float32Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, Float32Member, Float32Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<Integer, Float32Member, Float32Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<Integer, Float32Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure1<Float32Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<Float32Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, Float32Member, Float32Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<Float32Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<Float32Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<Float32Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<Float32Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> exp() {
        return this.EXP;
    }

    public Procedure2<Float32Member, Float32Member> expm1() {
        return this.EXPM1;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> log() {
        return this.LOG;
    }

    public Procedure2<Float32Member, Float32Member> log1p() {
        return this.LOG1P;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> tan() {
        return this.TAN;
    }

    public Procedure2<Float32Member, Float32Member> csc() {
        return this.CSC;
    }

    public Procedure2<Float32Member, Float32Member> sec() {
        return this.SEC;
    }

    public Procedure2<Float32Member, Float32Member> cot() {
        return this.COT;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> tanh() {
        return this.TANH;
    }

    public Procedure2<Float32Member, Float32Member> csch() {
        return this.CSCH;
    }

    public Procedure2<Float32Member, Float32Member> sech() {
        return this.SECH;
    }

    public Procedure2<Float32Member, Float32Member> coth() {
        return this.COTH;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> acos() {
        return this.ACOS;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> asin() {
        return this.ASIN;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> atan() {
        return this.ATAN;
    }

    public Procedure3<Float32Member, Float32Member, Float32Member> atan2() {
        return this.ATAN2;
    }

    public Procedure2<Float32Member, Float32Member> acsc() {
        return this.ACSC;
    }

    public Procedure2<Float32Member, Float32Member> asec() {
        return this.ASEC;
    }

    public Procedure2<Float32Member, Float32Member> acot() {
        return this.ACOT;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> acosh() {
        return this.ACOSH;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> asinh() {
        return this.ASINH;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> atanh() {
        return this.ATANH;
    }

    public Procedure2<Float32Member, Float32Member> acsch() {
        return this.ACSCH;
    }

    public Procedure2<Float32Member, Float32Member> asech() {
        return this.ASECH;
    }

    public Procedure2<Float32Member, Float32Member> acoth() {
        return this.ACOTH;
    }

    @Override
    public Function1<Boolean, Float32Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float32Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float32Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float32Member> infinite() {
        return this.INF;
    }

    public Procedure1<Float32Member> negInfinite() {
        return this.NINF;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, Float32Member, Float32Member> round() {
        return this.ROUND;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> pow() {
        return this.POW;
    }

    public Procedure3<Float32Member, Float32Member, Float32Member> IEEEremainder() {
        return this.IEEE;
    }

    public Procedure2<Float32Member, Float32Member> log10() {
        return this.LOG10;
    }

    public Procedure2<Float32Member, Float32Member> toDegrees() {
        return this.TODEG;
    }

    public Procedure2<Float32Member, Float32Member> toRadians() {
        return this.TORAD;
    }

    @Override
    public Procedure1<Float32Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> copySign() {
        return this.CPS;
    }

    @Override
    public Function1<Integer, Float32Member> getExponent() {
        return this.GEXP;
    }

    @Override
    public Procedure3<Integer, Float32Member, Float32Member> scalb() {
        return this.SCALB;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> ulp() {
        return this.ULP;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<Float32Member, Float32Member, Float32Member, Float32Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<Float32Member, Float32Member> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, Float32Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float32Member, Float32Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float32Member, Float32Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float32Member, Float32Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float32Member, Float32Member, Float32Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float32Member, Float32Member, Float32Member> within() {
        return this.WITHIN;
    }
}

