/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Algebra;
import nom.bdezonia.zorbage.type.data.float32.real.Float32CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float32CartesianTensorProduct
implements TensorProduct<Float32CartesianTensorProduct, Float32CartesianTensorProductMember, Float32Algebra, Float32Member>,
ConstructibleNdLong<Float32CartesianTensorProductMember>,
Norm<Float32CartesianTensorProductMember, Float32Member>,
Scale<Float32CartesianTensorProductMember, Float32Member>,
Rounding<Float32Member, Float32CartesianTensorProductMember>,
Infinite<Float32CartesianTensorProductMember>,
NaN<Float32CartesianTensorProductMember>,
ScaleByHighPrec<Float32CartesianTensorProductMember>,
ScaleByRational<Float32CartesianTensorProductMember>,
ScaleByDouble<Float32CartesianTensorProductMember>,
Tolerance<Float32Member, Float32CartesianTensorProductMember> {
    private final Function2<Boolean, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> EQ = new Function2<Boolean, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.FLT, G.FLT.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> NEQ = new Function2<Boolean, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            return Float32CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> ASSIGN = new Procedure2<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember from, Float32CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.FLT, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<Float32CartesianTensorProductMember> ZER = new Procedure1<Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> NEG = new Procedure2<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.FLT, G.FLT.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> ADDEL = new Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b, Float32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.FLT, G.FLT.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> SUBEL = new Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b, Float32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.FLT, G.FLT.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<Float32CartesianTensorProductMember, Float32Member> NORM = new Procedure2<Float32CartesianTensorProductMember, Float32Member>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32Member b) {
            TensorNorm.compute(G.FLT, G.FLT, a.rawData(), b);
        }
    };
    private final Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> SCALE = new Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32Member scalar, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.FLT, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> ADDSCALAR = new Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32Member scalar, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.FLT, scalar, G.FLT.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> SUBSCALAR = new Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32Member scalar, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            Float32Member tmp = G.FLT.construct();
            G.FLT.negate().call(scalar, tmp);
            Float32CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> MULEL = new Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b, Float32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.FLT, G.FLT.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> DIVIDEEL = new Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b, Float32CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.FLT, G.FLT.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> MUL = new Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b, Float32CartesianTensorProductMember c) {
            Float32CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorContract.compute(G.FLT, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> SEMI = new Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.FLT_TEN, G.FLT, index, a, b);
        }
    };
    private final Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> COMMA = new Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.FLT_TEN, G.FLT, index, a, b);
        }
    };
    private final Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> POWER = new Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorPower.compute(G.FLT_TEN, power, a, b);
        }
    };
    private final Procedure1<Float32CartesianTensorProductMember> UNITY = new Procedure1<Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember result) {
            TensorUnity.compute(G.FLT_TEN, G.FLT, result);
        }
    };
    private final Function1<Boolean, Float32CartesianTensorProductMember> ISNAN = new Function1<Boolean, Float32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure1<Float32CartesianTensorProductMember> NAN = new Procedure1<Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a) {
            FillNaN.compute(G.FLT, a);
        }
    };
    private final Function1<Boolean, Float32CartesianTensorProductMember> ISINF = new Function1<Boolean, Float32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure1<Float32CartesianTensorProductMember> INF = new Procedure1<Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a) {
            FillInfinite.compute(G.FLT, a);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorRound.compute(G.FLT_TEN, G.FLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float32CartesianTensorProductMember> ISZERO = new Function1<Boolean, Float32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure3<RationalMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> SBR = new Procedure3<RationalMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.FLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> SBD = new Procedure3<Double, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.FLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.FLT, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float32Member tol, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.FLT, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> MULBYSCALAR = new Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32Member factor, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            Float32CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32Member factor, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            Float32Member invFactor = G.FLT.construct();
            G.FLT.invert().call(factor, invFactor);
            Float32CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> RAISE = new Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> LOWER = new Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            Float32CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b, Float32CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            Float32CartesianTensorProductMember tmp = Float32CartesianTensorProduct.this.construct();
            Float32CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            Float32CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> OUTER = new Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember>(){

        @Override
        public void call(Float32CartesianTensorProductMember a, Float32CartesianTensorProductMember b, Float32CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.FLT_TEN, G.FLT, a, b, c);
        }
    };

    @Override
    public Float32CartesianTensorProductMember construct() {
        return new Float32CartesianTensorProductMember();
    }

    @Override
    public Float32CartesianTensorProductMember construct(Float32CartesianTensorProductMember other) {
        return new Float32CartesianTensorProductMember(other);
    }

    @Override
    public Float32CartesianTensorProductMember construct(String s) {
        return new Float32CartesianTensorProductMember(s);
    }

    @Override
    public Float32CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new Float32CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<Float32CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<Float32CartesianTensorProductMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<Float32CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, Float32CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float32CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float32CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float32CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float32CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<Float32Member, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<Float32CartesianTensorProductMember, Float32CartesianTensorProductMember, Float32CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

