/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Algebra;
import nom.bdezonia.zorbage.type.data.float32.real.Float32MatrixMember;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float32Matrix
implements RingWithUnity<Float32Matrix, Float32MatrixMember>,
MatrixRing<Float32Matrix, Float32MatrixMember, Float32Algebra, Float32Member>,
Constructible2dLong<Float32MatrixMember>,
Rounding<Float32Member, Float32MatrixMember>,
Norm<Float32MatrixMember, Float32Member>,
DirectProduct<Float32MatrixMember, Float32MatrixMember>,
Exponential<Float32MatrixMember>,
Trigonometric<Float32MatrixMember>,
Hyperbolic<Float32MatrixMember>,
RealConstants<Float32MatrixMember>,
Infinite<Float32MatrixMember>,
NaN<Float32MatrixMember>,
ScaleByHighPrec<Float32MatrixMember>,
ScaleByRational<Float32MatrixMember>,
ScaleByDouble<Float32MatrixMember>,
Tolerance<Float32Member, Float32MatrixMember> {
    private final Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> MUL = new Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b, Float32MatrixMember c) {
            MatrixMultiply.compute(G.FLT, a, b, c);
        }
    };
    private final Procedure3<Integer, Float32MatrixMember, Float32MatrixMember> POWER = new Procedure3<Integer, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Integer power, Float32MatrixMember a, Float32MatrixMember b) {
            MatrixPower.compute(power, G.FLT, G.FLT_VEC, G.FLT_MAT, a, b);
        }
    };
    private final Procedure1<Float32MatrixMember> ZER = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> NEG = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            MatrixNegate.compute(G.FLT, a, b);
        }
    };
    private final Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> ADD = new Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b, Float32MatrixMember c) {
            MatrixAddition.compute(G.FLT, a, b, c);
        }
    };
    private final Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> SUB = new Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b, Float32MatrixMember c) {
            MatrixSubtraction.compute(G.FLT, a, b, c);
        }
    };
    private final Function2<Boolean, Float32MatrixMember, Float32MatrixMember> EQ = new Function2<Boolean, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public Boolean call(Float32MatrixMember a, Float32MatrixMember b) {
            return MatrixEqual.compute(G.FLT, a, b);
        }
    };
    private final Function2<Boolean, Float32MatrixMember, Float32MatrixMember> NEQ = new Function2<Boolean, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public Boolean call(Float32MatrixMember a, Float32MatrixMember b) {
            return Float32Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> ASSIGN = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember from, Float32MatrixMember to) {
            MatrixAssign.compute(G.FLT, from, to);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32Member> NORM = new Procedure2<Float32MatrixMember, Float32Member>(){

        @Override
        public void call(Float32MatrixMember a, Float32Member b) {
            MatrixSpectralNorm.compute(G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, Float32MatrixMember, Float32MatrixMember> ROUND = new Procedure4<Round.Mode, Float32Member, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, Float32MatrixMember a, Float32MatrixMember b) {
            MatrixRound.compute(G.FLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float32MatrixMember> ISNAN = new Function1<Boolean, Float32MatrixMember>(){

        @Override
        public Boolean call(Float32MatrixMember a) {
            return SequenceIsNan.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure1<Float32MatrixMember> NAN = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            FillNaN.compute(G.FLT, a);
        }
    };
    private final Function1<Boolean, Float32MatrixMember> ISINF = new Function1<Boolean, Float32MatrixMember>(){

        @Override
        public Boolean call(Float32MatrixMember a) {
            return SequenceIsInf.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure1<Float32MatrixMember> INF = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            FillInfinite.compute(G.FLT, a);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> TRANSP = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            MatrixTranspose.compute(G.FLT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> CONJTRANSP = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            Float32Matrix.this.transpose().call(a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32Member> DET = new Procedure2<Float32MatrixMember, Float32Member>(){

        @Override
        public void call(Float32MatrixMember a, Float32Member b) {
            MatrixDeterminant.compute(G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure1<Float32MatrixMember> UNITY = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            MatrixUnity.compute(G.FLT, a);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> INV = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            MatrixInvert.compute(G.FLT, G.FLT_VEC, G.FLT_MAT, a, b);
        }
    };
    private final Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> DIVIDE = new Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b, Float32MatrixMember c) {
            Float32MatrixMember invB = Float32Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            Float32Matrix.this.invert().call(b, invB);
            Float32Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> DP = new Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember in1, Float32MatrixMember in2, Float32MatrixMember out) {
            MatrixDirectProduct.compute(G.FLT, in1, in2, out);
        }
    };
    private final Procedure3<Float32Member, Float32MatrixMember, Float32MatrixMember> SCALE = new Procedure3<Float32Member, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32Member a, Float32MatrixMember b, Float32MatrixMember c) {
            MatrixScale.compute(G.FLT, a, b, c);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> SINH = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> COSH = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> SINHANDCOSH = new Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember s, Float32MatrixMember c) {
            Float32Matrix.this.sinh().call(a, s);
            Float32Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> TANH = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            Float32MatrixMember s = G.FLT_MAT.construct();
            Float32MatrixMember c = G.FLT_MAT.construct();
            Float32Matrix.this.sinhAndCosh().call(a, s, c);
            Float32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> SINCH = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            Sinch.compute(G.FLT_MAT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> SINCHPI = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            Sinchpi.compute(G.FLT_MAT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> SIN = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            TaylorEstimateSin.compute(18, G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> COS = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            TaylorEstimateCos.compute(18, G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> TAN = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            Float32MatrixMember s = G.FLT_MAT.construct();
            Float32MatrixMember c = G.FLT_MAT.construct();
            Float32Matrix.this.sinAndCos().call(a, s, c);
            Float32Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> SINANDCOS = new Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember s, Float32MatrixMember c) {
            Float32Matrix.this.sin().call(a, s);
            Float32Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> SINC = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            Sinc.compute(G.FLT_MAT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> SINCPI = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            Sincpi.compute(G.FLT_MAT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> EXP = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            TaylorEstimateExp.compute(35, G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Procedure2<Float32MatrixMember, Float32MatrixMember> LOG = new Procedure2<Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a, Float32MatrixMember b) {
            TaylorEstimateLog.compute(8, G.FLT_MAT, G.FLT, a, b);
        }
    };
    private final Function1<Boolean, Float32MatrixMember> ISZERO = new Function1<Boolean, Float32MatrixMember>(){

        @Override
        public Boolean call(Float32MatrixMember a) {
            return SequenceIsZero.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure1<Float32MatrixMember> PI = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            Float32Member pi = G.FLT.construct();
            G.FLT.PI().call(pi);
            MatrixConstantDiagonal.compute(G.FLT, pi, a);
        }
    };
    private final Procedure1<Float32MatrixMember> E = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            Float32Member e = G.FLT.construct();
            G.FLT.E().call(e);
            MatrixConstantDiagonal.compute(G.FLT, e, a);
        }
    };
    private final Procedure1<Float32MatrixMember> PHI = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            Float32Member phi = G.FLT.construct();
            G.FLT.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.FLT, phi, a);
        }
    };
    private final Procedure1<Float32MatrixMember> GAMMA = new Procedure1<Float32MatrixMember>(){

        @Override
        public void call(Float32MatrixMember a) {
            Float32Member gamma = G.FLT.construct();
            G.FLT.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.FLT, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, Float32MatrixMember, Float32MatrixMember> SBHP = new Procedure3<HighPrecisionMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, Float32MatrixMember b, Float32MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.FLT, a, b, c);
        }
    };
    private Procedure3<RationalMember, Float32MatrixMember, Float32MatrixMember> SBR = new Procedure3<RationalMember, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(RationalMember a, Float32MatrixMember b, Float32MatrixMember c) {
            MatrixScaleByRational.compute(G.FLT, a, b, c);
        }
    };
    private Procedure3<Double, Float32MatrixMember, Float32MatrixMember> SBD = new Procedure3<Double, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public void call(Double a, Float32MatrixMember b, Float32MatrixMember c) {
            MatrixScaleByDouble.compute(G.FLT, a, b, c);
        }
    };
    private final Function3<Boolean, Float32Member, Float32MatrixMember, Float32MatrixMember> WITHIN = new Function3<Boolean, Float32Member, Float32MatrixMember, Float32MatrixMember>(){

        @Override
        public Boolean call(Float32Member tol, Float32MatrixMember a, Float32MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.FLT, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, Float32MatrixMember, Float32MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<Float32MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, Float32MatrixMember, Float32MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float32MatrixMember, Float32MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Float32MatrixMember construct() {
        return new Float32MatrixMember();
    }

    @Override
    public Float32MatrixMember construct(Float32MatrixMember other) {
        return new Float32MatrixMember(other);
    }

    @Override
    public Float32MatrixMember construct(String s) {
        return new Float32MatrixMember(s);
    }

    @Override
    public Float32MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new Float32MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, Float32MatrixMember, Float32MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float32MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float32MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float32MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float32MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<Float32MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<Float32Member, Float32MatrixMember, Float32MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<Float32MatrixMember, Float32MatrixMember, Float32MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<Float32MatrixMember, Float32MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, Float32MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<Float32MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<Float32MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<Float32MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<Float32MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float32MatrixMember, Float32MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float32MatrixMember, Float32MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float32MatrixMember, Float32MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float32Member, Float32MatrixMember, Float32MatrixMember> within() {
        return this.WITHIN;
    }
}

