/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.CrossProduct;
import nom.bdezonia.zorbage.algorithm.DotProduct;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.PerpDotProduct;
import nom.bdezonia.zorbage.algorithm.RModuleAdd;
import nom.bdezonia.zorbage.algorithm.RModuleAssign;
import nom.bdezonia.zorbage.algorithm.RModuleDefaultNorm;
import nom.bdezonia.zorbage.algorithm.RModuleDirectProduct;
import nom.bdezonia.zorbage.algorithm.RModuleEqual;
import nom.bdezonia.zorbage.algorithm.RModuleNegate;
import nom.bdezonia.zorbage.algorithm.RModuleRound;
import nom.bdezonia.zorbage.algorithm.RModuleScale;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByDouble;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByRational;
import nom.bdezonia.zorbage.algorithm.RModuleSubtract;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Products;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.VectorSpace;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Algebra;
import nom.bdezonia.zorbage.type.data.float32.real.Float32MatrixMember;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.float32.real.Float32VectorMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float32Vector
implements VectorSpace<Float32Vector, Float32VectorMember, Float32Algebra, Float32Member>,
Constructible1dLong<Float32VectorMember>,
Norm<Float32VectorMember, Float32Member>,
Products<Float32VectorMember, Float32Member, Float32MatrixMember>,
DirectProduct<Float32VectorMember, Float32MatrixMember>,
Rounding<Float32Member, Float32VectorMember>,
Infinite<Float32VectorMember>,
NaN<Float32VectorMember>,
ScaleByHighPrec<Float32VectorMember>,
ScaleByRational<Float32VectorMember>,
ScaleByDouble<Float32VectorMember>,
Tolerance<Float32Member, Float32VectorMember> {
    private final Procedure1<Float32VectorMember> ZER = new Procedure1<Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float32VectorMember, Float32VectorMember> NEG = new Procedure2<Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b) {
            RModuleNegate.compute(G.FLT, a, b);
        }
    };
    private final Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember> ADD = new Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b, Float32VectorMember c) {
            RModuleAdd.compute(G.FLT, a, b, c);
        }
    };
    private final Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember> SUB = new Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b, Float32VectorMember c) {
            RModuleSubtract.compute(G.FLT, a, b, c);
        }
    };
    private final Function2<Boolean, Float32VectorMember, Float32VectorMember> EQ = new Function2<Boolean, Float32VectorMember, Float32VectorMember>(){

        @Override
        public Boolean call(Float32VectorMember a, Float32VectorMember b) {
            return RModuleEqual.compute(G.FLT, a, b);
        }
    };
    private final Function2<Boolean, Float32VectorMember, Float32VectorMember> NEQ = new Function2<Boolean, Float32VectorMember, Float32VectorMember>(){

        @Override
        public Boolean call(Float32VectorMember a, Float32VectorMember b) {
            return Float32Vector.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float32VectorMember, Float32VectorMember> ASSIGN = new Procedure2<Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember from, Float32VectorMember to) {
            RModuleAssign.compute(G.FLT, from, to);
        }
    };
    private Procedure2<Float32VectorMember, Float32Member> NORM = new Procedure2<Float32VectorMember, Float32Member>(){

        @Override
        public void call(Float32VectorMember a, Float32Member b) {
            RModuleDefaultNorm.compute(G.FLT, G.FLT, a, b);
        }
    };
    private final Procedure3<Float32Member, Float32VectorMember, Float32VectorMember> SCALE = new Procedure3<Float32Member, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Float32Member scalar, Float32VectorMember a, Float32VectorMember b) {
            RModuleScale.compute(G.FLT, scalar, a, b);
        }
    };
    private final Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember> CROSS = new Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b, Float32VectorMember c) {
            CrossProduct.compute(G.FLT_VEC, G.FLT, a, b, c);
        }
    };
    private final Procedure3<Float32VectorMember, Float32VectorMember, Float32Member> DOT = new Procedure3<Float32VectorMember, Float32VectorMember, Float32Member>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b, Float32Member c) {
            DotProduct.compute(G.FLT_VEC, G.FLT, G.FLT, a, b, c);
        }
    };
    private final Procedure3<Float32VectorMember, Float32VectorMember, Float32Member> PERP = new Procedure3<Float32VectorMember, Float32VectorMember, Float32Member>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b, Float32Member c) {
            PerpDotProduct.compute(G.FLT_VEC, G.FLT, a, b, c);
        }
    };
    private final Procedure4<Float32VectorMember, Float32VectorMember, Float32VectorMember, Float32VectorMember> VTRIPLE = new Procedure4<Float32VectorMember, Float32VectorMember, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b, Float32VectorMember c, Float32VectorMember d) {
            Float32VectorMember b_cross_c = new Float32VectorMember(new float[3]);
            Float32Vector.this.crossProduct().call(b, c, b_cross_c);
            Float32Vector.this.crossProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure4<Float32VectorMember, Float32VectorMember, Float32VectorMember, Float32Member> STRIPLE = new Procedure4<Float32VectorMember, Float32VectorMember, Float32VectorMember, Float32Member>(){

        @Override
        public void call(Float32VectorMember a, Float32VectorMember b, Float32VectorMember c, Float32Member d) {
            Float32VectorMember b_cross_c = new Float32VectorMember(new float[3]);
            Float32Vector.this.crossProduct().call(b, c, b_cross_c);
            Float32Vector.this.dotProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure3<Float32VectorMember, Float32VectorMember, Float32MatrixMember> VDP = new Procedure3<Float32VectorMember, Float32VectorMember, Float32MatrixMember>(){

        @Override
        public void call(Float32VectorMember in1, Float32VectorMember in2, Float32MatrixMember out) {
            Float32Vector.this.directProduct().call(in1, in2, out);
        }
    };
    private final Procedure3<Float32VectorMember, Float32VectorMember, Float32MatrixMember> DP = new Procedure3<Float32VectorMember, Float32VectorMember, Float32MatrixMember>(){

        @Override
        public void call(Float32VectorMember in1, Float32VectorMember in2, Float32MatrixMember out) {
            RModuleDirectProduct.compute(G.FLT, in1, in2, out);
        }
    };
    private final Function1<Boolean, Float32VectorMember> ISNAN = new Function1<Boolean, Float32VectorMember>(){

        @Override
        public Boolean call(Float32VectorMember a) {
            return SequenceIsNan.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure1<Float32VectorMember> NAN = new Procedure1<Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a) {
            FillNaN.compute(G.FLT, a);
        }
    };
    private final Function1<Boolean, Float32VectorMember> ISINF = new Function1<Boolean, Float32VectorMember>(){

        @Override
        public Boolean call(Float32VectorMember a) {
            return SequenceIsInf.compute(G.FLT, a.rawData());
        }
    };
    private final Procedure1<Float32VectorMember> INF = new Procedure1<Float32VectorMember>(){

        @Override
        public void call(Float32VectorMember a) {
            FillInfinite.compute(G.FLT, a);
        }
    };
    private final Procedure4<Round.Mode, Float32Member, Float32VectorMember, Float32VectorMember> ROUND = new Procedure4<Round.Mode, Float32Member, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Round.Mode mode, Float32Member delta, Float32VectorMember a, Float32VectorMember b) {
            RModuleRound.compute(G.FLT, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float32VectorMember> ISZERO = new Function1<Boolean, Float32VectorMember>(){

        @Override
        public Boolean call(Float32VectorMember a) {
            return SequenceIsZero.compute(G.FLT, a.rawData());
        }
    };
    private Procedure3<HighPrecisionMember, Float32VectorMember, Float32VectorMember> SBHP = new Procedure3<HighPrecisionMember, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(HighPrecisionMember a, Float32VectorMember b, Float32VectorMember c) {
            RModuleScaleByHighPrec.compute(G.FLT, a, b, c);
        }
    };
    private Procedure3<RationalMember, Float32VectorMember, Float32VectorMember> SBR = new Procedure3<RationalMember, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(RationalMember a, Float32VectorMember b, Float32VectorMember c) {
            RModuleScaleByRational.compute(G.FLT, a, b, c);
        }
    };
    private Procedure3<Double, Float32VectorMember, Float32VectorMember> SBD = new Procedure3<Double, Float32VectorMember, Float32VectorMember>(){

        @Override
        public void call(Double a, Float32VectorMember b, Float32VectorMember c) {
            RModuleScaleByDouble.compute(G.FLT, a, b, c);
        }
    };
    private final Function3<Boolean, Float32Member, Float32VectorMember, Float32VectorMember> WITHIN = new Function3<Boolean, Float32Member, Float32VectorMember, Float32VectorMember>(){

        @Override
        public Boolean call(Float32Member tol, Float32VectorMember a, Float32VectorMember b) {
            return SequencesSimilar.compute(G.FLT, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure1<Float32VectorMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float32VectorMember, Float32VectorMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, Float32VectorMember, Float32VectorMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float32VectorMember, Float32VectorMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Float32VectorMember construct() {
        return new Float32VectorMember();
    }

    @Override
    public Float32VectorMember construct(Float32VectorMember other) {
        return new Float32VectorMember(other);
    }

    @Override
    public Float32VectorMember construct(String s) {
        return new Float32VectorMember(s);
    }

    @Override
    public Float32VectorMember construct(StorageConstruction s, long d1) {
        return new Float32VectorMember(s, d1);
    }

    @Override
    public Procedure2<Float32VectorMember, Float32VectorMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<Float32VectorMember, Float32Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure3<Float32Member, Float32VectorMember, Float32VectorMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<Float32VectorMember, Float32VectorMember, Float32VectorMember> crossProduct() {
        return this.CROSS;
    }

    @Override
    public Procedure3<Float32VectorMember, Float32VectorMember, Float32Member> dotProduct() {
        return this.DOT;
    }

    @Override
    public Procedure3<Float32VectorMember, Float32VectorMember, Float32Member> perpDotProduct() {
        return this.PERP;
    }

    @Override
    public Procedure4<Float32VectorMember, Float32VectorMember, Float32VectorMember, Float32VectorMember> vectorTripleProduct() {
        return this.VTRIPLE;
    }

    @Override
    public Procedure4<Float32VectorMember, Float32VectorMember, Float32VectorMember, Float32Member> scalarTripleProduct() {
        return this.STRIPLE;
    }

    @Override
    public Procedure2<Float32VectorMember, Float32VectorMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float32VectorMember, Float32VectorMember, Float32MatrixMember> vectorDirectProduct() {
        return this.VDP;
    }

    @Override
    public Procedure3<Float32VectorMember, Float32VectorMember, Float32MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Function1<Boolean, Float32VectorMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float32VectorMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float32VectorMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float32VectorMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float32Member, Float32VectorMember, Float32VectorMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float32VectorMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float32VectorMember, Float32VectorMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float32VectorMember, Float32VectorMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float32VectorMember, Float32VectorMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float32Member, Float32VectorMember, Float32VectorMember> within() {
        return this.WITHIN;
    }
}

