/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float32.real;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.RModuleReshape;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float32.real.Float32Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class Float32VectorMember
implements RModuleMember<Float32Member>,
Gettable<Float32VectorMember>,
Settable<Float32VectorMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<Float32Member> {
    private static final Float32Member ZERO = new Float32Member(0.0f);
    private IndexedDataSource<Float32Member> storage;
    private StorageConstruction s;
    private static ThreadLocal<Float32Member> tmpFloat = new ThreadLocal<Float32Member>(){

        @Override
        protected Float32Member initialValue() {
            return new Float32Member();
        }
    };

    public Float32VectorMember() {
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, 0L, new Float32Member());
    }

    public Float32VectorMember(float[] vals) {
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, vals.length, new Float32Member());
        Float32Member value = new Float32Member();
        for (int i = 0; i < vals.length; ++i) {
            value.setV(vals[i]);
            this.storage.set(i, value);
        }
    }

    public Float32VectorMember(Float32VectorMember other) {
        this.set(other);
    }

    public Float32VectorMember(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        BigList<OctonionRepresentation> data = rep.firstVectorValues();
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, data.size(), new Float32Member());
        Float32Member tmp = new Float32Member();
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            OctonionRepresentation val = data.get(i);
            tmp.setV(val.r().floatValue());
            this.storage.set(i, tmp);
        }
    }

    public Float32VectorMember(StorageConstruction s, long d1) {
        this.s = s;
        this.alloc(d1);
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public void v(long i, Float32Member v) {
        this.storage.get(i, v);
    }

    @Override
    public void setV(long i, Float32Member v) {
        this.storage.set(i, v);
    }

    @Override
    public void set(Float32VectorMember other) {
        if (this == other) {
            return;
        }
        this.storage = (IndexedDataSource)other.storage.duplicate();
        this.s = other.s;
    }

    @Override
    public void get(Float32VectorMember other) {
        if (this == other) {
            return;
        }
        other.storage = (IndexedDataSource)this.storage.duplicate();
        other.s = this.s;
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        Float32Member value = new Float32Member();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(this.length());
        for (long i = 0L; i < this.length(); ++i) {
            this.storage.get(i, value);
            BigDecimal r = BigDecimal.valueOf(value.v());
            OctonionRepresentation o = new OctonionRepresentation(r);
            values.set(i, o);
        }
        rep.setRModule(this.length(), values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        Float32Member value = new Float32Member();
        BigList<OctonionRepresentation> rmod = rep.getRModule();
        long rmodSize = rmod.size();
        this.init(rmodSize);
        for (long i = 0L; i < rmodSize; ++i) {
            OctonionRepresentation o = rmod.get(i);
            value.setV(o.r().floatValue());
            this.storage.set(i, value);
        }
    }

    @Override
    public long length() {
        return this.storage.size();
    }

    public String toString() {
        Float32Member tmp = new Float32Member();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            if (i != 0L) {
                builder.append(',');
            }
            this.v(i, tmp);
            builder.append(tmp.toString());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean alloc(long size) {
        if (this.storage == null || this.storage.size() != size) {
            this.storage = Storage.allocate(this.s, size, new Float32Member());
            return true;
        }
        return false;
    }

    @Override
    public void init(long size) {
        if (!this.alloc(size)) {
            for (long i = 0L; i < size; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public void reshape(long len) {
        RModuleReshape.compute(G.FLT_VEC, G.FLT, len, this);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d == 0) {
            return this.storage.size();
        }
        return 1L;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.FLOAT;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV(v);
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV((float)v);
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV(v.floatValue());
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        long i = index.get(0);
        Float32Member tmp = tmpFloat.get();
        tmp.setV(v.floatValue());
        this.setV(i, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV(v);
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV((float)v);
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV(v.floatValue());
            this.setV(i, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long i = index.get(0);
            Float32Member tmp = tmpFloat.get();
            tmp.setV(v.floatValue());
            this.setV(i, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return (byte)tmp.v();
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return (short)tmp.v();
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return (int)tmp.v();
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return (long)tmp.v();
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return tmp.v();
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return tmp.v();
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return BigDecimal.valueOf(tmp.v()).toBigInteger();
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float32Member tmp = tmpFloat.get();
            this.v(index.get(0), tmp);
            return BigDecimal.valueOf(tmp.v());
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return (byte)tmp.v();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return (short)tmp.v();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return (int)tmp.v();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return (long)tmp.v();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return tmp.v();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return tmp.v();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return BigDecimal.valueOf(tmp.v()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.storage.size()) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        Float32Member tmp = tmpFloat.get();
        this.v(index.get(0), tmp);
        return BigDecimal.valueOf(tmp.v());
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<Float32Member> rawData() {
        return this.storage;
    }
}

