/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.complex;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.ComplexNumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Field;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;
import nom.bdezonia.zorbage.type.algebra.InverseTrigonometric;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat64Algebra
implements Field<ComplexFloat64Algebra, ComplexFloat64Member>,
Norm<ComplexFloat64Member, Float64Member>,
RealConstants<ComplexFloat64Member>,
ImaginaryConstants<ComplexFloat64Member>,
Exponential<ComplexFloat64Member>,
Trigonometric<ComplexFloat64Member>,
InverseTrigonometric<ComplexFloat64Member>,
Hyperbolic<ComplexFloat64Member>,
InverseHyperbolic<ComplexFloat64Member>,
Roots<ComplexFloat64Member>,
Power<ComplexFloat64Member>,
Rounding<Float64Member, ComplexFloat64Member>,
Infinite<ComplexFloat64Member>,
NaN<ComplexFloat64Member>,
Conjugate<ComplexFloat64Member>,
Random<ComplexFloat64Member>,
RealUnreal<ComplexFloat64Member, Float64Member>,
Scale<ComplexFloat64Member, ComplexFloat64Member>,
ScaleByHighPrec<ComplexFloat64Member>,
ScaleByRational<ComplexFloat64Member>,
ScaleByDouble<ComplexFloat64Member>,
ScaleComponents<ComplexFloat64Member, Float64Member>,
Tolerance<Float64Member, ComplexFloat64Member> {
    private static final ComplexFloat64Member ONE = new ComplexFloat64Member(1.0, 0.0);
    private static final ComplexFloat64Member TWO = new ComplexFloat64Member(2.0, 0.0);
    private static final ComplexFloat64Member MINUS_ONE = new ComplexFloat64Member(-1.0, 0.0);
    private static final ComplexFloat64Member PI = new ComplexFloat64Member(Math.PI, 0.0);
    private static final ComplexFloat64Member E = new ComplexFloat64Member(Math.E, 0.0);
    private static final ComplexFloat64Member GAMMA = new ComplexFloat64Member(0.5772156649015329, 0.0);
    private static final ComplexFloat64Member PHI = new ComplexFloat64Member(1.618033988749895, 0.0);
    private static final ComplexFloat64Member ONE_HALF = new ComplexFloat64Member(0.5, 0.0);
    private static final ComplexFloat64Member ONE_THIRD = new ComplexFloat64Member(0.3333333333333333, 0.0);
    private static final ComplexFloat64Member I = new ComplexFloat64Member(0.0, 1.0);
    private static final ComplexFloat64Member I_OVER_TWO = new ComplexFloat64Member(0.0, 0.5);
    private static final ComplexFloat64Member TWO_I = new ComplexFloat64Member(0.0, 2.0);
    private static final ComplexFloat64Member MINUS_I = new ComplexFloat64Member(0.0, -1.0);
    private static final ComplexFloat64Member MINUS_I_OVER_TWO = new ComplexFloat64Member(0.0, -0.5);
    private static final ComplexFloat64Member NaN_ = new ComplexFloat64Member(Double.NaN, Double.NaN);
    private final Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> MUL = new Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b, ComplexFloat64Member c) {
            double r = a.r() * b.r() - a.i() * b.i();
            double i = a.i() * b.r() + a.r() * b.i();
            c.setR(r);
            c.setI(i);
        }
    };
    private final Procedure3<Integer, ComplexFloat64Member, ComplexFloat64Member> POWER = new Procedure3<Integer, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(Integer power, ComplexFloat64Member a, ComplexFloat64Member b) {
            if (power == 0 && ComplexFloat64Algebra.this.isZero().call(a).booleanValue()) {
                ComplexFloat64Algebra.this.assign().call(NaN_, b);
                return;
            }
            double rToTheN = FastMath.pow((double)FastMath.hypot((double)a.r(), (double)a.i()), (double)power.intValue());
            double nTheta = (double)power.intValue() * ComplexFloat64Algebra.this.getArgument(a);
            b.setR(rToTheN * FastMath.cos((double)nTheta));
            b.setI(rToTheN * FastMath.sin((double)nTheta));
        }
    };
    private final Procedure1<ComplexFloat64Member> ZER = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> NEG = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            b.setR(-a.r());
            b.setI(-a.i());
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> ADD = new Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b, ComplexFloat64Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> SUB = new Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b, ComplexFloat64Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
        }
    };
    private final Function2<Boolean, ComplexFloat64Member, ComplexFloat64Member> EQ = new Function2<Boolean, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public Boolean call(ComplexFloat64Member a, ComplexFloat64Member b) {
            return a.r() == b.r() && a.i() == b.i();
        }
    };
    private final Function2<Boolean, ComplexFloat64Member, ComplexFloat64Member> NEQ = new Function2<Boolean, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public Boolean call(ComplexFloat64Member a, ComplexFloat64Member b) {
            return a.r() != b.r() || a.i() != b.i();
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ASSIGN = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member from, ComplexFloat64Member to) {
            to.set(from);
        }
    };
    private final Procedure1<ComplexFloat64Member> UNITY = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            ComplexFloat64Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> INV = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Algebra.this.divide().call(ONE, a, b);
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> DIVIDE = new Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b, ComplexFloat64Member c) {
            double mod2 = b.r() * b.r() + b.i() * b.i();
            double r = (a.r() * b.r() + a.i() * b.i()) / mod2;
            double i = (a.i() * b.r() - a.r() * b.i()) / mod2;
            c.setR(r);
            c.setI(i);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> CONJ = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            b.setR(a.r());
            b.setI(-a.i());
        }
    };
    private final Procedure2<ComplexFloat64Member, Float64Member> NORM = new Procedure2<ComplexFloat64Member, Float64Member>(){

        @Override
        public void call(ComplexFloat64Member a, Float64Member b) {
            b.setV(FastMath.hypot((double)a.r(), (double)a.i()));
        }
    };
    private final Procedure1<ComplexFloat64Member> PI_ = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            ComplexFloat64Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<ComplexFloat64Member> E_ = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            ComplexFloat64Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<ComplexFloat64Member> GAMMA_ = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            ComplexFloat64Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<ComplexFloat64Member> PHI_ = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            ComplexFloat64Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<ComplexFloat64Member> I_ = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            ComplexFloat64Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ASIN = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member ia = new ComplexFloat64Member();
            ComplexFloat64Member aSquared = new ComplexFloat64Member();
            ComplexFloat64Member miniSum = new ComplexFloat64Member();
            ComplexFloat64Member root = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Member logSum = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(I, a, ia);
            ComplexFloat64Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat64Algebra.this.subtract().call(ONE, aSquared, miniSum);
            ComplexFloat64Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat64Algebra.this.add().call(ia, root, sum);
            ComplexFloat64Algebra.this.log().call(sum, logSum);
            ComplexFloat64Algebra.this.multiply().call(MINUS_I, logSum, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ACOS = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member aSquared = new ComplexFloat64Member();
            ComplexFloat64Member miniSum = new ComplexFloat64Member();
            ComplexFloat64Member root = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Member logSum = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat64Algebra.this.subtract().call(aSquared, ONE, miniSum);
            ComplexFloat64Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat64Algebra.this.add().call(a, root, sum);
            ComplexFloat64Algebra.this.log().call(sum, logSum);
            ComplexFloat64Algebra.this.multiply().call(MINUS_I, logSum, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ATAN = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member ia = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Member diff = new ComplexFloat64Member();
            ComplexFloat64Member quotient = new ComplexFloat64Member();
            ComplexFloat64Member log = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(I, a, ia);
            ComplexFloat64Algebra.this.add().call(ONE, ia, sum);
            ComplexFloat64Algebra.this.subtract().call(ONE, ia, diff);
            ComplexFloat64Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat64Algebra.this.log().call(quotient, log);
            ComplexFloat64Algebra.this.multiply().call(MINUS_I_OVER_TWO, log, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ACSC = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member recipA = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.invert().call(a, recipA);
            ComplexFloat64Algebra.this.asin().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ASEC = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member recipA = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.invert().call(a, recipA);
            ComplexFloat64Algebra.this.acos().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ACOT = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member ia = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Member diff = new ComplexFloat64Member();
            ComplexFloat64Member quotient = new ComplexFloat64Member();
            ComplexFloat64Member log = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(I, a, ia);
            ComplexFloat64Algebra.this.add().call(ia, ONE, sum);
            ComplexFloat64Algebra.this.subtract().call(ia, ONE, diff);
            ComplexFloat64Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat64Algebra.this.log().call(quotient, log);
            ComplexFloat64Algebra.this.multiply().call(I_OVER_TWO, log, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ASINH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member aSquared = new ComplexFloat64Member();
            ComplexFloat64Member miniSum = new ComplexFloat64Member();
            ComplexFloat64Member root = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat64Algebra.this.add().call(aSquared, ONE, miniSum);
            ComplexFloat64Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat64Algebra.this.add().call(a, root, sum);
            ComplexFloat64Algebra.this.log().call(sum, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ACOSH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member aSquared = new ComplexFloat64Member();
            ComplexFloat64Member miniSum = new ComplexFloat64Member();
            ComplexFloat64Member root = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(a, a, aSquared);
            ComplexFloat64Algebra.this.subtract().call(aSquared, ONE, miniSum);
            ComplexFloat64Algebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexFloat64Algebra.this.add().call(a, root, sum);
            ComplexFloat64Algebra.this.log().call(sum, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ATANH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Member diff = new ComplexFloat64Member();
            ComplexFloat64Member quotient = new ComplexFloat64Member();
            ComplexFloat64Member log = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.add().call(ONE, a, sum);
            ComplexFloat64Algebra.this.subtract().call(ONE, a, diff);
            ComplexFloat64Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat64Algebra.this.log().call(quotient, log);
            ComplexFloat64Algebra.this.multiply().call(ONE_HALF, log, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ACSCH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member recipA = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.invert().call(a, recipA);
            ComplexFloat64Algebra.this.asinh().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ASECH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member recipA = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.invert().call(a, recipA);
            ComplexFloat64Algebra.this.acosh().call(recipA, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> ACOTH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Member diff = new ComplexFloat64Member();
            ComplexFloat64Member quotient = new ComplexFloat64Member();
            ComplexFloat64Member log = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.add().call(a, ONE, sum);
            ComplexFloat64Algebra.this.subtract().call(a, ONE, diff);
            ComplexFloat64Algebra.this.divide().call(sum, diff, quotient);
            ComplexFloat64Algebra.this.log().call(quotient, log);
            ComplexFloat64Algebra.this.multiply().call(ONE_HALF, log, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SIN = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member IA = new ComplexFloat64Member();
            ComplexFloat64Member minusIA = new ComplexFloat64Member();
            ComplexFloat64Member expIA = new ComplexFloat64Member();
            ComplexFloat64Member expMinusIA = new ComplexFloat64Member();
            ComplexFloat64Member diff = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(a, I, IA);
            ComplexFloat64Algebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexFloat64Algebra.this.exp().call(IA, expIA);
            ComplexFloat64Algebra.this.exp().call(minusIA, expMinusIA);
            ComplexFloat64Algebra.this.subtract().call(expIA, expMinusIA, diff);
            ComplexFloat64Algebra.this.divide().call(diff, TWO_I, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> COS = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member IA = new ComplexFloat64Member();
            ComplexFloat64Member minusIA = new ComplexFloat64Member();
            ComplexFloat64Member expIA = new ComplexFloat64Member();
            ComplexFloat64Member expMinusIA = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(a, I, IA);
            ComplexFloat64Algebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexFloat64Algebra.this.exp().call(IA, expIA);
            ComplexFloat64Algebra.this.exp().call(minusIA, expMinusIA);
            ComplexFloat64Algebra.this.add().call(expIA, expMinusIA, sum);
            ComplexFloat64Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> SINCOS = new Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member s, ComplexFloat64Member c) {
            ComplexFloat64Member IA = new ComplexFloat64Member();
            ComplexFloat64Member minusIA = new ComplexFloat64Member();
            ComplexFloat64Member expIA = new ComplexFloat64Member();
            ComplexFloat64Member expMinusIA = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Member diff = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.multiply().call(a, I, IA);
            ComplexFloat64Algebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexFloat64Algebra.this.exp().call(IA, expIA);
            ComplexFloat64Algebra.this.exp().call(minusIA, expMinusIA);
            ComplexFloat64Algebra.this.subtract().call(expIA, expMinusIA, diff);
            ComplexFloat64Algebra.this.divide().call(diff, TWO_I, s);
            ComplexFloat64Algebra.this.add().call(expIA, expMinusIA, sum);
            ComplexFloat64Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> TAN = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member sin = new ComplexFloat64Member();
            ComplexFloat64Member cos = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.sinAndCos().call(a, sin, cos);
            ComplexFloat64Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> CSC = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member sin = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.sin().call(a, sin);
            ComplexFloat64Algebra.this.invert().call(sin, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SEC = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member cos = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.cos().call(a, cos);
            ComplexFloat64Algebra.this.invert().call(cos, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> COT = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member tan = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.tan().call(a, tan);
            ComplexFloat64Algebra.this.invert().call(tan, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SINH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member expA = new ComplexFloat64Member();
            ComplexFloat64Member minusA = new ComplexFloat64Member();
            ComplexFloat64Member expMinusA = new ComplexFloat64Member();
            ComplexFloat64Member diff = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.exp().call(a, expA);
            ComplexFloat64Algebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexFloat64Algebra.this.exp().call(minusA, expMinusA);
            ComplexFloat64Algebra.this.subtract().call(expA, expMinusA, diff);
            ComplexFloat64Algebra.this.divide().call(diff, TWO, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> COSH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member expA = new ComplexFloat64Member();
            ComplexFloat64Member minusA = new ComplexFloat64Member();
            ComplexFloat64Member expMinusA = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.exp().call(a, expA);
            ComplexFloat64Algebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexFloat64Algebra.this.exp().call(minusA, expMinusA);
            ComplexFloat64Algebra.this.add().call(expA, expMinusA, sum);
            ComplexFloat64Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> SINHCOSH = new Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member s, ComplexFloat64Member c) {
            ComplexFloat64Member expA = new ComplexFloat64Member();
            ComplexFloat64Member minusA = new ComplexFloat64Member();
            ComplexFloat64Member expMinusA = new ComplexFloat64Member();
            ComplexFloat64Member sum = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.exp().call(a, expA);
            ComplexFloat64Algebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexFloat64Algebra.this.exp().call(minusA, expMinusA);
            ComplexFloat64Algebra.this.subtract().call(expA, expMinusA, sum);
            ComplexFloat64Algebra.this.divide().call(sum, TWO, s);
            ComplexFloat64Algebra.this.add().call(expA, expMinusA, sum);
            ComplexFloat64Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> TANH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member sinh = new ComplexFloat64Member();
            ComplexFloat64Member cosh = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.sinhAndCosh().call(a, sinh, cosh);
            ComplexFloat64Algebra.this.divide().call(sinh, cosh, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> CSCH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member sinh = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.sinh().call(a, sinh);
            ComplexFloat64Algebra.this.invert().call(sinh, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SECH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member cosh = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.cosh().call(a, cosh);
            ComplexFloat64Algebra.this.invert().call(cosh, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> COTH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member tanh = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.tanh().call(a, tanh);
            ComplexFloat64Algebra.this.invert().call(tanh, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> EXP = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            double constant = FastMath.exp((double)a.r());
            b.setR(constant * FastMath.cos((double)a.i()));
            b.setI(constant * FastMath.sin((double)a.i()));
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> EXPM1 = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member tmp = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.exp().call(a, tmp);
            ComplexFloat64Algebra.this.subtract().call(tmp, ONE, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> LOG = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            double modulus = FastMath.hypot((double)a.r(), (double)a.i());
            double argument = ComplexFloat64Algebra.this.getArgument(a);
            b.setR(Math.log(modulus));
            b.setI(ComplexFloat64Algebra.this.getPrincipalArgument(argument));
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> LOG1P = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Member tmp = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.add().call(a, ONE, tmp);
            ComplexFloat64Algebra.this.log().call(tmp, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SQRT = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> CBRT = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            ComplexFloat64Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, ComplexFloat64Member, ComplexFloat64Member> ROUND = new Procedure4<Round.Mode, Float64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, ComplexFloat64Member a, ComplexFloat64Member b) {
            Float64Member tmp = new Float64Member();
            tmp.setV(a.r());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setI(tmp.v());
        }
    };
    private final Function1<Boolean, ComplexFloat64Member> ISNAN = new Function1<Boolean, ComplexFloat64Member>(){

        @Override
        public Boolean call(ComplexFloat64Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i());
        }
    };
    private final Procedure1<ComplexFloat64Member> NAN = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            a.setR(Double.NaN);
            a.setI(Double.NaN);
        }
    };
    private final Function1<Boolean, ComplexFloat64Member> ISINF = new Function1<Boolean, ComplexFloat64Member>(){

        @Override
        public Boolean call(ComplexFloat64Member a) {
            return ComplexFloat64Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()));
        }
    };
    private final Procedure1<ComplexFloat64Member> INF = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            a.setR(Double.POSITIVE_INFINITY);
            a.setI(Double.POSITIVE_INFINITY);
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> POW = new Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b, ComplexFloat64Member c) {
            ComplexFloat64Member logA = new ComplexFloat64Member();
            ComplexFloat64Member bLogA = new ComplexFloat64Member();
            ComplexFloat64Algebra.this.log().call(a, logA);
            ComplexFloat64Algebra.this.multiply().call(b, logA, bLogA);
            ComplexFloat64Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure1<ComplexFloat64Member> RAND = new Procedure1<ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextDouble());
            a.setI(rng.nextDouble());
        }
    };
    private Procedure2<ComplexFloat64Member, Float64Member> REAL = new Procedure2<ComplexFloat64Member, Float64Member>(){

        @Override
        public void call(ComplexFloat64Member a, Float64Member b) {
            b.setV(a.r());
        }
    };
    private Procedure2<ComplexFloat64Member, ComplexFloat64Member> UNREAL = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            b.setR(0.0);
            b.setI(a.i());
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SINCH = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            Sinch.compute(G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SINCHPI = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            Sinchpi.compute(G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SINC = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            Sinc.compute(G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64Member, ComplexFloat64Member> SINCPI = new Procedure2<ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64Member b) {
            Sincpi.compute(G.CDBL, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat64Member> ISZERO = new Function1<Boolean, ComplexFloat64Member>(){

        @Override
        public Boolean call(ComplexFloat64Member a) {
            return a.r() == 0.0 && a.i() == 0.0;
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexFloat64Member, ComplexFloat64Member> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(HighPrecisionMember a, ComplexFloat64Member b, ComplexFloat64Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.doubleValue());
        }
    };
    private final Procedure3<RationalMember, ComplexFloat64Member, ComplexFloat64Member> SBR = new Procedure3<RationalMember, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(RationalMember a, ComplexFloat64Member b, ComplexFloat64Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.doubleValue());
        }
    };
    private final Procedure3<Double, ComplexFloat64Member, ComplexFloat64Member> SBD = new Procedure3<Double, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(Double a, ComplexFloat64Member b, ComplexFloat64Member c) {
            c.setR(a * b.r());
            c.setI(a * b.i());
        }
    };
    private final Procedure3<Float64Member, ComplexFloat64Member, ComplexFloat64Member> SC = new Procedure3<Float64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public void call(Float64Member a, ComplexFloat64Member b, ComplexFloat64Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
        }
    };
    private final Function3<Boolean, Float64Member, ComplexFloat64Member, ComplexFloat64Member> WITHIN = new Function3<Boolean, Float64Member, ComplexFloat64Member, ComplexFloat64Member>(){

        @Override
        public Boolean call(Float64Member tol, ComplexFloat64Member a, ComplexFloat64Member b) {
            return ComplexNumberWithin.compute(G.DBL, tol, a, b);
        }
    };

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, ComplexFloat64Member, ComplexFloat64Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexFloat64Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexFloat64Member, ComplexFloat64Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat64Member, ComplexFloat64Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public ComplexFloat64Member construct() {
        return new ComplexFloat64Member();
    }

    @Override
    public ComplexFloat64Member construct(ComplexFloat64Member other) {
        return new ComplexFloat64Member(other);
    }

    @Override
    public ComplexFloat64Member construct(String s) {
        return new ComplexFloat64Member(s);
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<ComplexFloat64Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<ComplexFloat64Member, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<ComplexFloat64Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<ComplexFloat64Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<ComplexFloat64Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<ComplexFloat64Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<ComplexFloat64Member> I() {
        return this.I_;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> asin() {
        return this.ASIN;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> acos() {
        return this.ACOS;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> atan() {
        return this.ATAN;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> acsc() {
        return this.ACSC;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> asec() {
        return this.ASEC;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> acot() {
        return this.ACOT;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> asinh() {
        return this.ASINH;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> acosh() {
        return this.ACOSH;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> atanh() {
        return this.ATANH;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> acsch() {
        return this.ACSCH;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> asech() {
        return this.ASECH;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> acoth() {
        return this.ACOTH;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> sinAndCos() {
        return this.SINCOS;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> tan() {
        return this.TAN;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> csc() {
        return this.CSC;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sec() {
        return this.SEC;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> cot() {
        return this.COT;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> sinhAndCosh() {
        return this.SINHCOSH;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> tanh() {
        return this.TANH;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> csch() {
        return this.CSCH;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sech() {
        return this.SECH;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> coth() {
        return this.COTH;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> exp() {
        return this.EXP;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> expm1() {
        return this.EXPM1;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> log() {
        return this.LOG;
    }

    private double getArgument(ComplexFloat64Member a) {
        double x = a.r();
        double y = a.i();
        double theta = x == 0.0 ? (y > 0.0 ? 1.5707963267948966 : (y < 0.0 ? -1.5707963267948966 : Double.NaN)) : (y == 0.0 ? (x > 0.0 ? 0.0 : Math.PI) : FastMath.atan2((double)y, (double)x));
        return theta;
    }

    private double getPrincipalArgument(double angle) {
        double arg;
        for (arg = angle; arg <= -Math.PI; arg += Math.PI * 2) {
        }
        while (arg > Math.PI) {
            arg -= Math.PI * 2;
        }
        return arg;
    }

    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> log1p() {
        return this.LOG1P;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, ComplexFloat64Member, ComplexFloat64Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat64Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat64Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat64Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat64Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure1<ComplexFloat64Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<ComplexFloat64Member, Float64Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<ComplexFloat64Member, ComplexFloat64Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Function1<Boolean, ComplexFloat64Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64Member, ComplexFloat64Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat64Member, ComplexFloat64Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat64Member, ComplexFloat64Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat64Member, ComplexFloat64Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float64Member, ComplexFloat64Member, ComplexFloat64Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float64Member, ComplexFloat64Member, ComplexFloat64Member> within() {
        return this.WITHIN;
    }
}

