/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Algebra;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat64CartesianTensorProduct
implements TensorProduct<ComplexFloat64CartesianTensorProduct, ComplexFloat64CartesianTensorProductMember, ComplexFloat64Algebra, ComplexFloat64Member>,
ConstructibleNdLong<ComplexFloat64CartesianTensorProductMember>,
Norm<ComplexFloat64CartesianTensorProductMember, Float64Member>,
Scale<ComplexFloat64CartesianTensorProductMember, ComplexFloat64Member>,
Rounding<Float64Member, ComplexFloat64CartesianTensorProductMember>,
Infinite<ComplexFloat64CartesianTensorProductMember>,
NaN<ComplexFloat64CartesianTensorProductMember>,
ScaleByHighPrec<ComplexFloat64CartesianTensorProductMember>,
ScaleByRational<ComplexFloat64CartesianTensorProductMember>,
ScaleByDouble<ComplexFloat64CartesianTensorProductMember>,
Tolerance<Float64Member, ComplexFloat64CartesianTensorProductMember> {
    private final Function2<Boolean, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> EQ = new Function2<Boolean, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CDBL, G.DBL.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> NEQ = new Function2<Boolean, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            return ComplexFloat64CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> ASSIGN = new Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember from, ComplexFloat64CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.CDBL, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<ComplexFloat64CartesianTensorProductMember> ZER = new Procedure1<ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> NEG = new Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CDBL, G.CDBL.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> ADDEL = new Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b, ComplexFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CDBL, G.CDBL.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> SUBEL = new Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b, ComplexFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CDBL, G.CDBL.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<ComplexFloat64CartesianTensorProductMember, Float64Member> NORM = new Procedure2<ComplexFloat64CartesianTensorProductMember, Float64Member>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, Float64Member b) {
            TensorNorm.compute(G.CDBL, G.DBL, a.rawData(), b);
        }
    };
    private final Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> CONJ = new Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CDBL, G.CDBL.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> SCALE = new Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64Member scalar, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.CDBL, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> ADDSCALAR = new Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64Member scalar, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.CDBL, scalar, G.CDBL.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> SUBSCALAR = new Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64Member scalar, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            ComplexFloat64Member tmp = G.CDBL.construct();
            G.CDBL.negate().call(scalar, tmp);
            ComplexFloat64CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> MULEL = new Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b, ComplexFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CDBL, G.CDBL.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> DIVIDEEL = new Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b, ComplexFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CDBL, G.CDBL.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> MUL = new Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b, ComplexFloat64CartesianTensorProductMember c) {
            ComplexFloat64CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorContract.compute(G.CDBL, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> SEMI = new Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.CDBL_TEN, G.CDBL, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> COMMA = new Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.CDBL_TEN, G.CDBL, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> POWER = new Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorPower.compute(G.CDBL_TEN, power, a, b);
        }
    };
    private final Procedure1<ComplexFloat64CartesianTensorProductMember> UNITY = new Procedure1<ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember result) {
            TensorUnity.compute(G.CDBL_TEN, G.CDBL, result);
        }
    };
    private final Function1<Boolean, ComplexFloat64CartesianTensorProductMember> ISNAN = new Function1<Boolean, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat64CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat64CartesianTensorProductMember> NAN = new Procedure1<ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a) {
            FillNaN.compute(G.CDBL, a);
        }
    };
    private final Function1<Boolean, ComplexFloat64CartesianTensorProductMember> ISINF = new Function1<Boolean, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat64CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat64CartesianTensorProductMember> INF = new Procedure1<ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a) {
            FillInfinite.compute(G.CDBL, a);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorRound.compute(G.CDBL_TEN, G.CDBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat64CartesianTensorProductMember> ISZERO = new Function1<Boolean, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexFloat64CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure3<RationalMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> SBR = new Procedure3<RationalMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.CDBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> SBD = new Procedure3<Double, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.CDBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.CDBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64Member tol, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CDBL, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> MULBYSCALAR = new Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64Member factor, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            ComplexFloat64CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64Member factor, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            ComplexFloat64Member invFactor = G.CDBL.construct();
            G.CDBL.invert().call(factor, invFactor);
            ComplexFloat64CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> RAISE = new Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> LOWER = new Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            ComplexFloat64CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b, ComplexFloat64CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            ComplexFloat64CartesianTensorProductMember tmp = ComplexFloat64CartesianTensorProduct.this.construct();
            ComplexFloat64CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            ComplexFloat64CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> OUTER = new Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember>(){

        @Override
        public void call(ComplexFloat64CartesianTensorProductMember a, ComplexFloat64CartesianTensorProductMember b, ComplexFloat64CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.CDBL_TEN, G.CDBL, a, b, c);
        }
    };

    @Override
    public ComplexFloat64CartesianTensorProductMember construct() {
        return new ComplexFloat64CartesianTensorProductMember();
    }

    @Override
    public ComplexFloat64CartesianTensorProductMember construct(ComplexFloat64CartesianTensorProductMember other) {
        return new ComplexFloat64CartesianTensorProductMember(other);
    }

    @Override
    public ComplexFloat64CartesianTensorProductMember construct(String s) {
        return new ComplexFloat64CartesianTensorProductMember(s);
    }

    @Override
    public ComplexFloat64CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new ComplexFloat64CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<ComplexFloat64CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<ComplexFloat64CartesianTensorProductMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexFloat64CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, ComplexFloat64CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat64CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat64CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat64CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat64CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember, ComplexFloat64CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

