/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Algebra;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64MatrixMember;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat64Matrix
implements RingWithUnity<ComplexFloat64Matrix, ComplexFloat64MatrixMember>,
MatrixRing<ComplexFloat64Matrix, ComplexFloat64MatrixMember, ComplexFloat64Algebra, ComplexFloat64Member>,
Constructible2dLong<ComplexFloat64MatrixMember>,
Rounding<Float64Member, ComplexFloat64MatrixMember>,
Norm<ComplexFloat64MatrixMember, Float64Member>,
DirectProduct<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>,
Exponential<ComplexFloat64MatrixMember>,
Trigonometric<ComplexFloat64MatrixMember>,
Hyperbolic<ComplexFloat64MatrixMember>,
RealConstants<ComplexFloat64MatrixMember>,
Infinite<ComplexFloat64MatrixMember>,
NaN<ComplexFloat64MatrixMember>,
ScaleByHighPrec<ComplexFloat64MatrixMember>,
ScaleByRational<ComplexFloat64MatrixMember>,
ScaleByDouble<ComplexFloat64MatrixMember>,
Tolerance<Float64Member, ComplexFloat64MatrixMember> {
    private final Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> MUL = new Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            MatrixMultiply.compute(G.CDBL, a, b, c);
        }
    };
    private final Procedure3<Integer, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> POWER = new Procedure3<Integer, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(Integer power, ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            MatrixPower.compute(power, G.CDBL, G.CDBL_VEC, G.CDBL_MAT, a, b);
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> ZER = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> NEG = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            MatrixNegate.compute(G.CDBL, a, b);
        }
    };
    private final Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> ADD = new Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            MatrixAddition.compute(G.CDBL, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SUB = new Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            MatrixSubtraction.compute(G.CDBL, a, b, c);
        }
    };
    private final Function2<Boolean, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> EQ = new Function2<Boolean, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            return MatrixEqual.compute(G.CDBL, a, b);
        }
    };
    private final Function2<Boolean, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> NEQ = new Function2<Boolean, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            return ComplexFloat64Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> ASSIGN = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember from, ComplexFloat64MatrixMember to) {
            MatrixAssign.compute(G.CDBL, from, to);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, Float64Member> NORM = new Procedure2<ComplexFloat64MatrixMember, Float64Member>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, Float64Member b) {
            MatrixSpectralNorm.compute(G.CDBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> ROUND = new Procedure4<Round.Mode, Float64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            MatrixRound.compute(G.CDBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat64MatrixMember> ISNAN = new Function1<Boolean, ComplexFloat64MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat64MatrixMember a) {
            return SequenceIsNan.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> NAN = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            FillNaN.compute(G.CDBL, a);
        }
    };
    private final Function1<Boolean, ComplexFloat64MatrixMember> ISINF = new Function1<Boolean, ComplexFloat64MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat64MatrixMember a) {
            return SequenceIsInf.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> INF = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            FillInfinite.compute(G.CDBL, a);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> CONJ = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            MatrixConjugate.compute(G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> TRANSP = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            MatrixTranspose.compute(G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> CONJTRANSP = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            ComplexFloat64MatrixMember tmp = new ComplexFloat64MatrixMember();
            ComplexFloat64Matrix.this.conjugate().call(a, tmp);
            ComplexFloat64Matrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64Member> DET = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64Member b) {
            MatrixDeterminant.compute(G.CDBL_MAT, G.CDBL, a, b);
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> UNITY = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            MatrixUnity.compute(G.CDBL, a);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> INV = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            MatrixInvert.compute(G.CDBL, G.CDBL_VEC, G.CDBL_MAT, a, b);
        }
    };
    private final Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> DIVIDE = new Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            ComplexFloat64MatrixMember invB = ComplexFloat64Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            ComplexFloat64Matrix.this.invert().call(b, invB);
            ComplexFloat64Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> DP = new Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember in1, ComplexFloat64MatrixMember in2, ComplexFloat64MatrixMember out) {
            MatrixDirectProduct.compute(G.CDBL, in1, in2, out);
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SCALE = new Procedure3<ComplexFloat64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64Member a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            MatrixScale.compute(G.CDBL, a, b, c);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SINH = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.CDBL_MAT, G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> COSH = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.CDBL_MAT, G.CDBL, a, b);
        }
    };
    private final Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SINHANDCOSH = new Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember s, ComplexFloat64MatrixMember c) {
            ComplexFloat64Matrix.this.sinh().call(a, s);
            ComplexFloat64Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> TANH = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            ComplexFloat64MatrixMember s = ComplexFloat64Matrix.this.construct();
            ComplexFloat64MatrixMember c = ComplexFloat64Matrix.this.construct();
            ComplexFloat64Matrix.this.sinhAndCosh().call(a, s, c);
            ComplexFloat64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SINCH = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            Sinch.compute(G.CDBL_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SINCHPI = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            Sinchpi.compute(G.CDBL_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SIN = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            TaylorEstimateSin.compute(18, G.CDBL_MAT, G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> COS = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            TaylorEstimateCos.compute(18, G.CDBL_MAT, G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> TAN = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            ComplexFloat64MatrixMember s = ComplexFloat64Matrix.this.construct();
            ComplexFloat64MatrixMember c = ComplexFloat64Matrix.this.construct();
            ComplexFloat64Matrix.this.sinAndCos().call(a, s, c);
            ComplexFloat64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SINANDCOS = new Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember s, ComplexFloat64MatrixMember c) {
            ComplexFloat64Matrix.this.sin().call(a, s);
            ComplexFloat64Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SINC = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            Sinc.compute(G.CDBL_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SINCPI = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            Sincpi.compute(G.CDBL_MAT, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> EXP = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            TaylorEstimateExp.compute(35, G.CDBL_MAT, G.CDBL, a, b);
        }
    };
    private final Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> LOG = new Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            TaylorEstimateLog.compute(8, G.CDBL_MAT, G.CDBL, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat64MatrixMember> ISZERO = new Function1<Boolean, ComplexFloat64MatrixMember>(){

        @Override
        public Boolean call(ComplexFloat64MatrixMember a) {
            return SequenceIsZero.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> PI = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            ComplexFloat64Member pi = G.CDBL.construct();
            G.CDBL.PI().call(pi);
            MatrixConstantDiagonal.compute(G.CDBL, pi, a);
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> E = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            ComplexFloat64Member e = G.CDBL.construct();
            G.CDBL.E().call(e);
            MatrixConstantDiagonal.compute(G.CDBL, e, a);
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> PHI = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            ComplexFloat64Member phi = G.CDBL.construct();
            G.CDBL.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.CDBL, phi, a);
        }
    };
    private final Procedure1<ComplexFloat64MatrixMember> GAMMA = new Procedure1<ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64MatrixMember a) {
            ComplexFloat64Member gamma = G.CDBL.construct();
            G.CDBL.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.CDBL, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.CDBL, a, b, c);
        }
    };
    private Procedure3<RationalMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SBR = new Procedure3<RationalMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(RationalMember a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            MatrixScaleByRational.compute(G.CDBL, a, b, c);
        }
    };
    private Procedure3<Double, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> SBD = new Procedure3<Double, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(Double a, ComplexFloat64MatrixMember b, ComplexFloat64MatrixMember c) {
            MatrixScaleByDouble.compute(G.CDBL, a, b, c);
        }
    };
    private final Function3<Boolean, Float64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> WITHIN = new Function3<Boolean, Float64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember>(){

        @Override
        public Boolean call(Float64Member tol, ComplexFloat64MatrixMember a, ComplexFloat64MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.CDBL, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public ComplexFloat64MatrixMember construct() {
        return new ComplexFloat64MatrixMember();
    }

    @Override
    public ComplexFloat64MatrixMember construct(ComplexFloat64MatrixMember other) {
        return new ComplexFloat64MatrixMember(other);
    }

    @Override
    public ComplexFloat64MatrixMember construct(String s) {
        return new ComplexFloat64MatrixMember(s);
    }

    @Override
    public ComplexFloat64MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new ComplexFloat64MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat64MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat64MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, ComplexFloat64MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<ComplexFloat64MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float64Member, ComplexFloat64MatrixMember, ComplexFloat64MatrixMember> within() {
        return this.WITHIN;
    }
}

