/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.CrossProduct;
import nom.bdezonia.zorbage.algorithm.DotProduct;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.PerpDotProduct;
import nom.bdezonia.zorbage.algorithm.RModuleAdd;
import nom.bdezonia.zorbage.algorithm.RModuleAssign;
import nom.bdezonia.zorbage.algorithm.RModuleConjugate;
import nom.bdezonia.zorbage.algorithm.RModuleDefaultNorm;
import nom.bdezonia.zorbage.algorithm.RModuleDirectProduct;
import nom.bdezonia.zorbage.algorithm.RModuleEqual;
import nom.bdezonia.zorbage.algorithm.RModuleNegate;
import nom.bdezonia.zorbage.algorithm.RModuleRound;
import nom.bdezonia.zorbage.algorithm.RModuleScale;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByDouble;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByRational;
import nom.bdezonia.zorbage.algorithm.RModuleSubtract;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Products;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.VectorSpace;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Algebra;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64MatrixMember;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64VectorMember;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexFloat64Vector
implements VectorSpace<ComplexFloat64Vector, ComplexFloat64VectorMember, ComplexFloat64Algebra, ComplexFloat64Member>,
Constructible1dLong<ComplexFloat64VectorMember>,
Norm<ComplexFloat64VectorMember, Float64Member>,
Products<ComplexFloat64VectorMember, ComplexFloat64Member, ComplexFloat64MatrixMember>,
DirectProduct<ComplexFloat64VectorMember, ComplexFloat64MatrixMember>,
Rounding<Float64Member, ComplexFloat64VectorMember>,
Infinite<ComplexFloat64VectorMember>,
NaN<ComplexFloat64VectorMember>,
ScaleByHighPrec<ComplexFloat64VectorMember>,
ScaleByRational<ComplexFloat64VectorMember>,
ScaleByDouble<ComplexFloat64VectorMember>,
Tolerance<Float64Member, ComplexFloat64VectorMember> {
    private final Procedure1<ComplexFloat64VectorMember> ZER = new Procedure1<ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember> NEG = new Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b) {
            RModuleNegate.compute(G.CDBL, a, b);
        }
    };
    private final Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> ADD = new Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c) {
            RModuleAdd.compute(G.CDBL, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> SUB = new Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c) {
            RModuleSubtract.compute(G.CDBL, a, b, c);
        }
    };
    private final Function2<Boolean, ComplexFloat64VectorMember, ComplexFloat64VectorMember> EQ = new Function2<Boolean, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public Boolean call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b) {
            return RModuleEqual.compute(G.CDBL, a, b);
        }
    };
    private final Function2<Boolean, ComplexFloat64VectorMember, ComplexFloat64VectorMember> NEQ = new Function2<Boolean, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public Boolean call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b) {
            return ComplexFloat64Vector.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember> ASSIGN = new Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember from, ComplexFloat64VectorMember to) {
            RModuleAssign.compute(G.CDBL, from, to);
        }
    };
    private final Procedure2<ComplexFloat64VectorMember, Float64Member> NORM = new Procedure2<ComplexFloat64VectorMember, Float64Member>(){

        @Override
        public void call(ComplexFloat64VectorMember a, Float64Member b) {
            RModuleDefaultNorm.compute(G.CDBL, G.DBL, a, b);
        }
    };
    private final Procedure3<ComplexFloat64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember> SCALE = new Procedure3<ComplexFloat64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64Member scalar, ComplexFloat64VectorMember a, ComplexFloat64VectorMember b) {
            RModuleScale.compute(G.CDBL, scalar, a, b);
        }
    };
    private final Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> CROSS = new Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c) {
            CrossProduct.compute(G.CDBL_VEC, G.CDBL, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member> DOT = new Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b, ComplexFloat64Member c) {
            DotProduct.compute(G.CDBL_VEC, G.CDBL, G.DBL, a, b, c);
        }
    };
    private final Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member> PERP = new Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b, ComplexFloat64Member c) {
            PerpDotProduct.compute(G.CDBL_VEC, G.CDBL, a, b, c);
        }
    };
    private final Procedure4<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> VTRIPLE = new Procedure4<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c, ComplexFloat64VectorMember d) {
            ComplexFloat64VectorMember b_cross_c = new ComplexFloat64VectorMember(new double[6]);
            ComplexFloat64Vector.this.crossProduct().call(b, c, b_cross_c);
            ComplexFloat64Vector.this.crossProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure4<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member> STRIPLE = new Procedure4<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c, ComplexFloat64Member d) {
            ComplexFloat64VectorMember b_cross_c = new ComplexFloat64VectorMember(new double[6]);
            ComplexFloat64Vector.this.crossProduct().call(b, c, b_cross_c);
            ComplexFloat64Vector.this.dotProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember> CONJ = new Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a, ComplexFloat64VectorMember b) {
            RModuleConjugate.compute(G.CDBL, a, b);
        }
    };
    private final Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64MatrixMember> VDP = new Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64VectorMember in1, ComplexFloat64VectorMember in2, ComplexFloat64MatrixMember out) {
            ComplexFloat64Vector.this.directProduct().call(in1, in2, out);
        }
    };
    private final Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64MatrixMember> DP = new Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64MatrixMember>(){

        @Override
        public void call(ComplexFloat64VectorMember in1, ComplexFloat64VectorMember in2, ComplexFloat64MatrixMember out) {
            RModuleDirectProduct.compute(G.CDBL, in1, in2, out);
        }
    };
    private final Function1<Boolean, ComplexFloat64VectorMember> ISNAN = new Function1<Boolean, ComplexFloat64VectorMember>(){

        @Override
        public Boolean call(ComplexFloat64VectorMember a) {
            return SequenceIsNan.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat64VectorMember> NAN = new Procedure1<ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a) {
            FillNaN.compute(G.CDBL, a);
        }
    };
    private final Function1<Boolean, ComplexFloat64VectorMember> ISINF = new Function1<Boolean, ComplexFloat64VectorMember>(){

        @Override
        public Boolean call(ComplexFloat64VectorMember a) {
            return SequenceIsInf.compute(G.CDBL, a.rawData());
        }
    };
    private final Procedure1<ComplexFloat64VectorMember> INF = new Procedure1<ComplexFloat64VectorMember>(){

        @Override
        public void call(ComplexFloat64VectorMember a) {
            FillInfinite.compute(G.CDBL, a);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember> ROUND = new Procedure4<Round.Mode, Float64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, ComplexFloat64VectorMember a, ComplexFloat64VectorMember b) {
            RModuleRound.compute(G.CDBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, ComplexFloat64VectorMember> ISZERO = new Function1<Boolean, ComplexFloat64VectorMember>(){

        @Override
        public Boolean call(ComplexFloat64VectorMember a) {
            return SequenceIsZero.compute(G.CDBL, a.rawData());
        }
    };
    private Procedure3<HighPrecisionMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> SBHP = new Procedure3<HighPrecisionMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c) {
            RModuleScaleByHighPrec.compute(G.CDBL, a, b, c);
        }
    };
    private Procedure3<RationalMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> SBR = new Procedure3<RationalMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(RationalMember a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c) {
            RModuleScaleByRational.compute(G.CDBL, a, b, c);
        }
    };
    private Procedure3<Double, ComplexFloat64VectorMember, ComplexFloat64VectorMember> SBD = new Procedure3<Double, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public void call(Double a, ComplexFloat64VectorMember b, ComplexFloat64VectorMember c) {
            RModuleScaleByDouble.compute(G.CDBL, a, b, c);
        }
    };
    private final Function3<Boolean, Float64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember> WITHIN = new Function3<Boolean, Float64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember>(){

        @Override
        public Boolean call(Float64Member tol, ComplexFloat64VectorMember a, ComplexFloat64VectorMember b) {
            return SequencesSimilar.compute(G.CDBL, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure1<ComplexFloat64VectorMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexFloat64VectorMember, ComplexFloat64VectorMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexFloat64VectorMember, ComplexFloat64VectorMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public ComplexFloat64VectorMember construct() {
        return new ComplexFloat64VectorMember();
    }

    @Override
    public ComplexFloat64VectorMember construct(ComplexFloat64VectorMember other) {
        return new ComplexFloat64VectorMember(other);
    }

    @Override
    public ComplexFloat64VectorMember construct(String s) {
        return new ComplexFloat64VectorMember(s);
    }

    @Override
    public ComplexFloat64VectorMember construct(StorageConstruction s, long d1) {
        return new ComplexFloat64VectorMember(s, d1);
    }

    @Override
    public Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<ComplexFloat64VectorMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure3<ComplexFloat64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> crossProduct() {
        return this.CROSS;
    }

    @Override
    public Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member> dotProduct() {
        return this.DOT;
    }

    @Override
    public Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member> perpDotProduct() {
        return this.PERP;
    }

    @Override
    public Procedure4<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> vectorTripleProduct() {
        return this.VTRIPLE;
    }

    @Override
    public Procedure4<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64Member> scalarTripleProduct() {
        return this.STRIPLE;
    }

    @Override
    public Procedure2<ComplexFloat64VectorMember, ComplexFloat64VectorMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64MatrixMember> vectorDirectProduct() {
        return this.VDP;
    }

    @Override
    public Procedure3<ComplexFloat64VectorMember, ComplexFloat64VectorMember, ComplexFloat64MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Function1<Boolean, ComplexFloat64VectorMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<ComplexFloat64VectorMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, ComplexFloat64VectorMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<ComplexFloat64VectorMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, ComplexFloat64VectorMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexFloat64VectorMember, ComplexFloat64VectorMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexFloat64VectorMember, ComplexFloat64VectorMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float64Member, ComplexFloat64VectorMember, ComplexFloat64VectorMember> within() {
        return this.WITHIN;
    }
}

