/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.octonion;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.OctonionNumberWithin;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OctonionConstants;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.octonion.OctonionFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class OctonionFloat64Algebra
implements SkewField<OctonionFloat64Algebra, OctonionFloat64Member>,
Conjugate<OctonionFloat64Member>,
Norm<OctonionFloat64Member, Float64Member>,
Infinite<OctonionFloat64Member>,
NaN<OctonionFloat64Member>,
Rounding<Float64Member, OctonionFloat64Member>,
RealConstants<OctonionFloat64Member>,
ImaginaryConstants<OctonionFloat64Member>,
QuaternionConstants<OctonionFloat64Member>,
OctonionConstants<OctonionFloat64Member>,
Random<OctonionFloat64Member>,
Exponential<OctonionFloat64Member>,
Trigonometric<OctonionFloat64Member>,
Hyperbolic<OctonionFloat64Member>,
Power<OctonionFloat64Member>,
Roots<OctonionFloat64Member>,
RealUnreal<OctonionFloat64Member, Float64Member>,
Scale<OctonionFloat64Member, OctonionFloat64Member>,
ScaleByHighPrec<OctonionFloat64Member>,
ScaleByRational<OctonionFloat64Member>,
ScaleByDouble<OctonionFloat64Member>,
ScaleComponents<OctonionFloat64Member, Float64Member>,
Tolerance<Float64Member, OctonionFloat64Member> {
    private static final OctonionFloat64Member ZERO = new OctonionFloat64Member(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member ONE_THIRD = new OctonionFloat64Member(0.3333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member ONE_HALF = new OctonionFloat64Member(0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member ONE = new OctonionFloat64Member(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member TWO = new OctonionFloat64Member(2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member E = new OctonionFloat64Member(Math.E, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member PI = new OctonionFloat64Member(Math.PI, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member GAMMA = new OctonionFloat64Member(0.5772156649015329, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member PHI = new OctonionFloat64Member(1.618033988749895, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member I = new OctonionFloat64Member(0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member J = new OctonionFloat64Member(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member K = new OctonionFloat64Member(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member L = new OctonionFloat64Member(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
    private static final OctonionFloat64Member I0 = new OctonionFloat64Member(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    private static final OctonionFloat64Member J0 = new OctonionFloat64Member(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    private static final OctonionFloat64Member K0 = new OctonionFloat64Member(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    private final Procedure1<OctonionFloat64Member> UNITY = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> MUL = new Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b, OctonionFloat64Member c) {
            OctonionFloat64Member tmp = new OctonionFloat64Member(ZERO);
            tmp.setR(a.r() * b.r());
            tmp.setI(a.r() * b.i());
            tmp.setJ(a.r() * b.j());
            tmp.setK(a.r() * b.k());
            tmp.setL(a.r() * b.l());
            tmp.setI0(a.r() * b.i0());
            tmp.setJ0(a.r() * b.j0());
            tmp.setK0(a.r() * b.k0());
            tmp.setI(tmp.i() + a.i() * b.r());
            tmp.setR(tmp.r() - a.i() * b.i());
            tmp.setK(tmp.k() + a.i() * b.j());
            tmp.setJ(tmp.j() - a.i() * b.k());
            tmp.setI0(tmp.i0() + a.i() * b.l());
            tmp.setL(tmp.l() - a.i() * b.i0());
            tmp.setK0(tmp.k0() - a.i() * b.j0());
            tmp.setJ0(tmp.j0() + a.i() * b.k0());
            tmp.setJ(tmp.j() + a.j() * b.r());
            tmp.setK(tmp.k() - a.j() * b.i());
            tmp.setR(tmp.r() - a.j() * b.j());
            tmp.setI(tmp.i() + a.j() * b.k());
            tmp.setJ0(tmp.j0() + a.j() * b.l());
            tmp.setK0(tmp.k0() + a.j() * b.i0());
            tmp.setL(tmp.l() - a.j() * b.j0());
            tmp.setI0(tmp.i0() - a.j() * b.k0());
            tmp.setK(tmp.k() + a.k() * b.r());
            tmp.setJ(tmp.j() + a.k() * b.i());
            tmp.setI(tmp.i() - a.k() * b.j());
            tmp.setR(tmp.r() - a.k() * b.k());
            tmp.setK0(tmp.k0() + a.k() * b.l());
            tmp.setJ0(tmp.j0() - a.k() * b.i0());
            tmp.setI0(tmp.i0() + a.k() * b.j0());
            tmp.setL(tmp.l() - a.k() * b.k0());
            tmp.setL(tmp.l() + a.l() * b.r());
            tmp.setI0(tmp.i0() - a.l() * b.i());
            tmp.setJ0(tmp.j0() - a.l() * b.j());
            tmp.setK0(tmp.k0() - a.l() * b.k());
            tmp.setR(tmp.r() - a.l() * b.l());
            tmp.setI(tmp.i() + a.l() * b.i0());
            tmp.setJ(tmp.j() + a.l() * b.j0());
            tmp.setK(tmp.k() + a.l() * b.k0());
            tmp.setI0(tmp.i0() + a.i0() * b.r());
            tmp.setL(tmp.l() + a.i0() * b.i());
            tmp.setK0(tmp.k0() - a.i0() * b.j());
            tmp.setJ0(tmp.j0() + a.i0() * b.k());
            tmp.setI(tmp.i() - a.i0() * b.l());
            tmp.setR(tmp.r() - a.i0() * b.i0());
            tmp.setK(tmp.k() - a.i0() * b.j0());
            tmp.setJ(tmp.j() + a.i0() * b.k0());
            tmp.setJ0(tmp.j0() + a.j0() * b.r());
            tmp.setK0(tmp.k0() + a.j0() * b.i());
            tmp.setL(tmp.l() + a.j0() * b.j());
            tmp.setI0(tmp.i0() - a.j0() * b.k());
            tmp.setJ(tmp.j() - a.j0() * b.l());
            tmp.setK(tmp.k() + a.j0() * b.i0());
            tmp.setR(tmp.r() - a.j0() * b.j0());
            tmp.setI(tmp.i() - a.j0() * b.k0());
            tmp.setK0(tmp.k0() + a.k0() * b.r());
            tmp.setJ0(tmp.j0() - a.k0() * b.i());
            tmp.setI0(tmp.i0() + a.k0() * b.j());
            tmp.setL(tmp.l() + a.k0() * b.k());
            tmp.setK(tmp.k() - a.k0() * b.l());
            tmp.setJ(tmp.j() - a.k0() * b.i0());
            tmp.setI(tmp.i() + a.k0() * b.j0());
            tmp.setR(tmp.r() - a.k0() * b.k0());
            OctonionFloat64Algebra.this.assign().call(tmp, c);
        }
    };
    private final Procedure3<Integer, OctonionFloat64Member, OctonionFloat64Member> POWER = new Procedure3<Integer, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(Integer power, OctonionFloat64Member a, OctonionFloat64Member b) {
            PowerAny.compute(G.ODBL, power, a, b);
        }
    };
    private final Procedure1<OctonionFloat64Member> ZER = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> NEG = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Algebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> ADD = new Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b, OctonionFloat64Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
            c.setJ(a.j() + b.j());
            c.setK(a.k() + b.k());
            c.setL(a.l() + b.l());
            c.setI0(a.i0() + b.i0());
            c.setJ0(a.j0() + b.j0());
            c.setK0(a.k0() + b.k0());
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> SUB = new Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b, OctonionFloat64Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
            c.setJ(a.j() - b.j());
            c.setK(a.k() - b.k());
            c.setL(a.l() - b.l());
            c.setI0(a.i0() - b.i0());
            c.setJ0(a.j0() - b.j0());
            c.setK0(a.k0() - b.k0());
        }
    };
    private Function2<Boolean, OctonionFloat64Member, OctonionFloat64Member> EQ = new Function2<Boolean, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public Boolean call(OctonionFloat64Member a, OctonionFloat64Member b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k() && a.l() == b.l() && a.i0() == b.i0() && a.j0() == b.j0() && a.k0() == b.k0();
        }
    };
    private Function2<Boolean, OctonionFloat64Member, OctonionFloat64Member> NEQ = new Function2<Boolean, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public Boolean call(OctonionFloat64Member a, OctonionFloat64Member b) {
            return OctonionFloat64Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<OctonionFloat64Member, OctonionFloat64Member> ASSIGN = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member from, OctonionFloat64Member to) {
            to.set(from);
        }
    };
    private Procedure2<OctonionFloat64Member, OctonionFloat64Member> INV = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            double norm2 = OctonionFloat64Algebra.this.norm2(a);
            OctonionFloat64Algebra.this.conjugate().call(a, b);
            b.setR(b.r() / norm2);
            b.setI(b.i() / norm2);
            b.setJ(b.j() / norm2);
            b.setK(b.k() / norm2);
            b.setL(b.l() / norm2);
            b.setI0(b.i0() / norm2);
            b.setJ0(b.j0() / norm2);
            b.setK0(b.k0() / norm2);
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> DIVIDE = new Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b, OctonionFloat64Member c) {
            OctonionFloat64Member tmp = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.invert().call(b, tmp);
            OctonionFloat64Algebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, OctonionFloat64Member, OctonionFloat64Member> ROUND = new Procedure4<Round.Mode, Float64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, OctonionFloat64Member a, OctonionFloat64Member b) {
            Float64Member tmp = new Float64Member();
            tmp.setV(a.r());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setI(tmp.v());
            tmp.setV(a.j());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setJ(tmp.v());
            tmp.setV(a.k());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setK(tmp.v());
            tmp.setV(a.l());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setL(tmp.v());
            tmp.setV(a.i0());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setI0(tmp.v());
            tmp.setV(a.j0());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setJ0(tmp.v());
            tmp.setV(a.k0());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setK0(tmp.v());
        }
    };
    private Function1<Boolean, OctonionFloat64Member> ISNAN = new Function1<Boolean, OctonionFloat64Member>(){

        @Override
        public Boolean call(OctonionFloat64Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i()) || Double.isNaN(a.j()) || Double.isNaN(a.k()) || Double.isNaN(a.l()) || Double.isNaN(a.i0()) || Double.isNaN(a.j0()) || Double.isNaN(a.k0());
        }
    };
    private final Procedure1<OctonionFloat64Member> NAN = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            a.setR(Double.NaN);
            a.setI(Double.NaN);
            a.setJ(Double.NaN);
            a.setK(Double.NaN);
            a.setL(Double.NaN);
            a.setI0(Double.NaN);
            a.setJ0(Double.NaN);
            a.setK0(Double.NaN);
        }
    };
    private Function1<Boolean, OctonionFloat64Member> ISINF = new Function1<Boolean, OctonionFloat64Member>(){

        @Override
        public Boolean call(OctonionFloat64Member a) {
            return OctonionFloat64Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()) || Double.isInfinite(a.j()) || Double.isInfinite(a.k()) || Double.isInfinite(a.l()) || Double.isInfinite(a.i0()) || Double.isInfinite(a.j0()) || Double.isInfinite(a.k0()));
        }
    };
    private final Procedure1<OctonionFloat64Member> INF = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            a.setR(Double.POSITIVE_INFINITY);
            a.setI(Double.POSITIVE_INFINITY);
            a.setJ(Double.POSITIVE_INFINITY);
            a.setK(Double.POSITIVE_INFINITY);
            a.setL(Double.POSITIVE_INFINITY);
            a.setI0(Double.POSITIVE_INFINITY);
            a.setJ0(Double.POSITIVE_INFINITY);
            a.setK0(Double.POSITIVE_INFINITY);
        }
    };
    private final Procedure2<OctonionFloat64Member, Float64Member> NORM = new Procedure2<OctonionFloat64Member, Float64Member>(){

        @Override
        public void call(OctonionFloat64Member a, Float64Member b) {
            b.setV(OctonionFloat64Algebra.this.norm(a));
        }
    };
    private Procedure2<OctonionFloat64Member, OctonionFloat64Member> CONJ = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            b.setR(a.r());
            b.setI(-a.i());
            b.setJ(-a.j());
            b.setK(-a.k());
            b.setL(-a.l());
            b.setI0(-a.i0());
            b.setJ0(-a.j0());
            b.setK0(-a.k0());
        }
    };
    private final Procedure1<OctonionFloat64Member> PI_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> E_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> GAMMA_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> PHI_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> I_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> J_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> K_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(K, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> L_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(L, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> I0_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(I0, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> J0_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(J0, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> K0_ = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            OctonionFloat64Algebra.this.assign().call(K0, a);
        }
    };
    private final Procedure1<OctonionFloat64Member> RAND = new Procedure1<OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextDouble());
            a.setI(rng.nextDouble());
            a.setJ(rng.nextDouble());
            a.setK(rng.nextDouble());
            a.setL(rng.nextDouble());
            a.setI0(rng.nextDouble());
            a.setJ0(rng.nextDouble());
            a.setK0(rng.nextDouble());
        }
    };
    private final Procedure2<OctonionFloat64Member, Float64Member> REAL = new Procedure2<OctonionFloat64Member, Float64Member>(){

        @Override
        public void call(OctonionFloat64Member a, Float64Member b) {
            b.setV(a.r());
        }
    };
    private Procedure2<OctonionFloat64Member, OctonionFloat64Member> UNREAL = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Algebra.this.assign().call(a, b);
            b.setR(0.0);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> SINH = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Member negA = new OctonionFloat64Member();
            OctonionFloat64Member sum = new OctonionFloat64Member();
            OctonionFloat64Member tmp1 = new OctonionFloat64Member();
            OctonionFloat64Member tmp2 = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.negate().call(a, negA);
            OctonionFloat64Algebra.this.exp().call(a, tmp1);
            OctonionFloat64Algebra.this.exp().call(negA, tmp2);
            OctonionFloat64Algebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionFloat64Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private Procedure2<OctonionFloat64Member, OctonionFloat64Member> COSH = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Member negA = new OctonionFloat64Member();
            OctonionFloat64Member sum = new OctonionFloat64Member();
            OctonionFloat64Member tmp1 = new OctonionFloat64Member();
            OctonionFloat64Member tmp2 = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.negate().call(a, negA);
            OctonionFloat64Algebra.this.exp().call(a, tmp1);
            OctonionFloat64Algebra.this.exp().call(negA, tmp2);
            OctonionFloat64Algebra.this.add().call(tmp1, tmp2, sum);
            OctonionFloat64Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> SINHANDCOSH = new Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member s, OctonionFloat64Member c) {
            OctonionFloat64Member negA = new OctonionFloat64Member();
            OctonionFloat64Member sum = new OctonionFloat64Member();
            OctonionFloat64Member tmp1 = new OctonionFloat64Member();
            OctonionFloat64Member tmp2 = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.negate().call(a, negA);
            OctonionFloat64Algebra.this.exp().call(a, tmp1);
            OctonionFloat64Algebra.this.exp().call(negA, tmp2);
            OctonionFloat64Algebra.this.subtract().call(tmp1, tmp2, sum);
            OctonionFloat64Algebra.this.divide().call(sum, TWO, s);
            OctonionFloat64Algebra.this.add().call(tmp1, tmp2, sum);
            OctonionFloat64Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> TANH = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Member s = new OctonionFloat64Member();
            OctonionFloat64Member c = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.sinhAndCosh().call(a, s, c);
            OctonionFloat64Algebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> SIN = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            OctonionFloat64Member tmp = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.unreal().call(a, tmp);
            OctonionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            b.setR(sin * cosh);
            b.setI(ws * a.i());
            b.setJ(ws * a.j());
            b.setK(ws * a.k());
            b.setL(ws * a.l());
            b.setI0(ws * a.i0());
            b.setJ0(ws * a.j0());
            b.setK0(ws * a.k0());
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> COS = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            OctonionFloat64Member tmp = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.unreal().call(a, tmp);
            OctonionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double wc = -sin * sinhc_pi;
            b.setR(cos * cosh);
            b.setI(wc * a.i());
            b.setJ(wc * a.j());
            b.setK(wc * a.k());
            b.setL(wc * a.l());
            b.setI0(wc * a.i0());
            b.setJ0(wc * a.j0());
            b.setK0(wc * a.k0());
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> SINANDCOS = new Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member s, OctonionFloat64Member c) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            OctonionFloat64Member tmp = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.unreal().call(a, tmp);
            OctonionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            double wc = -sin * sinhc_pi;
            s.setR(sin * cosh);
            s.setI(ws * a.i());
            s.setJ(ws * a.j());
            s.setK(ws * a.k());
            s.setL(ws * a.l());
            s.setI0(ws * a.i0());
            s.setJ0(ws * a.j0());
            s.setK0(ws * a.k0());
            c.setR(cos * cosh);
            c.setI(wc * a.i());
            c.setJ(wc * a.j());
            c.setK(wc * a.k());
            c.setL(wc * a.l());
            c.setI0(wc * a.i0());
            c.setJ0(wc * a.j0());
            c.setK0(wc * a.k0());
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> TAN = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Member sin = new OctonionFloat64Member();
            OctonionFloat64Member cos = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.sinAndCos().call(a, sin, cos);
            OctonionFloat64Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> EXP = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            OctonionFloat64Member tmp = new OctonionFloat64Member();
            double u = FastMath.exp((double)a.r());
            OctonionFloat64Algebra.this.unreal().call(a, tmp);
            OctonionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinc().call(z, z2);
            double w = z2.v();
            b.setR(u * FastMath.cos((double)z.v()));
            b.setI(u * w * a.i());
            b.setJ(u * w * a.j());
            b.setK(u * w * a.k());
            b.setL(u * w * a.l());
            b.setI0(u * w * a.i0());
            b.setJ0(u * w * a.j0());
            b.setK0(u * w * a.k0());
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> LOG = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Member unreal = new OctonionFloat64Member();
            ComplexFloat64Member tmp = new ComplexFloat64Member();
            Float64Member norm = new Float64Member();
            OctonionFloat64Algebra.this.assign().call(a, b);
            OctonionFloat64Algebra.this.unreal().call(a, unreal);
            OctonionFloat64Algebra.this.norm().call(unreal, norm);
            tmp.setR(a.r());
            tmp.setI(norm.v());
            G.CDBL.log().call(tmp, tmp);
            double factor = norm.v() == 0.0 ? tmp.i() : tmp.i() / norm.v();
            OctonionFloat64Algebra.this.multiplier(tmp.r(), factor, b);
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> POW = new Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b, OctonionFloat64Member c) {
            OctonionFloat64Member logA = new OctonionFloat64Member();
            OctonionFloat64Member bLogA = new OctonionFloat64Member();
            OctonionFloat64Algebra.this.log().call(a, logA);
            OctonionFloat64Algebra.this.multiply().call(b, logA, bLogA);
            OctonionFloat64Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> SINCH = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            Sinch.compute(G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> SINCHPI = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            Sinchpi.compute(G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> SINC = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            Sinc.compute(G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> SINCPI = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            Sincpi.compute(G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> SQRT = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<OctonionFloat64Member, OctonionFloat64Member> CBRT = new Procedure2<OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64Member b) {
            OctonionFloat64Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, OctonionFloat64Member> ISZERO = new Function1<Boolean, OctonionFloat64Member>(){

        @Override
        public Boolean call(OctonionFloat64Member a) {
            return a.r() == 0.0 && a.i() == 0.0 && a.j() == 0.0 && a.k() == 0.0 && a.l() == 0.0 && a.i0() == 0.0 && a.j0() == 0.0 && a.k0() == 0.0;
        }
    };
    private final Procedure3<HighPrecisionMember, OctonionFloat64Member, OctonionFloat64Member> SBHP = new Procedure3<HighPrecisionMember, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(HighPrecisionMember a, OctonionFloat64Member b, OctonionFloat64Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j()));
            c.setJ(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k()));
            c.setK(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.l()));
            c.setL(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i0()));
            c.setI0(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j0()));
            c.setJ0(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k0()));
            c.setK0(tmp.doubleValue());
        }
    };
    private final Procedure3<RationalMember, OctonionFloat64Member, OctonionFloat64Member> SBR = new Procedure3<RationalMember, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(RationalMember a, OctonionFloat64Member b, OctonionFloat64Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.j());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.k());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.l());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setL(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.i0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI0(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.j0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ0(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.k0());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK0(tmp.doubleValue());
        }
    };
    private final Procedure3<Double, OctonionFloat64Member, OctonionFloat64Member> SBD = new Procedure3<Double, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(Double a, OctonionFloat64Member b, OctonionFloat64Member c) {
            c.setR(a * b.r());
            c.setI(a * b.i());
            c.setJ(a * b.j());
            c.setK(a * b.k());
            c.setL(a * b.l());
            c.setI0(a * b.i0());
            c.setJ0(a * b.j0());
            c.setK0(a * b.k0());
        }
    };
    private final Procedure3<Float64Member, OctonionFloat64Member, OctonionFloat64Member> SC = new Procedure3<Float64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public void call(Float64Member a, OctonionFloat64Member b, OctonionFloat64Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
            c.setJ(a.v() * b.j());
            c.setK(a.v() * b.k());
            c.setL(a.v() * b.l());
            c.setI0(a.v() * b.i0());
            c.setJ0(a.v() * b.j0());
            c.setK0(a.v() * b.k0());
        }
    };
    private final Function3<Boolean, Float64Member, OctonionFloat64Member, OctonionFloat64Member> WITHIN = new Function3<Boolean, Float64Member, OctonionFloat64Member, OctonionFloat64Member>(){

        @Override
        public Boolean call(Float64Member tol, OctonionFloat64Member a, OctonionFloat64Member b) {
            return OctonionNumberWithin.compute(G.DBL, tol, a, b);
        }
    };

    @Override
    public Procedure1<OctonionFloat64Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, OctonionFloat64Member, OctonionFloat64Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<OctonionFloat64Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, OctonionFloat64Member, OctonionFloat64Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, OctonionFloat64Member, OctonionFloat64Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public OctonionFloat64Member construct() {
        return new OctonionFloat64Member();
    }

    @Override
    public OctonionFloat64Member construct(OctonionFloat64Member other) {
        return new OctonionFloat64Member(other);
    }

    @Override
    public OctonionFloat64Member construct(String s) {
        return new OctonionFloat64Member(s);
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, OctonionFloat64Member, OctonionFloat64Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, OctonionFloat64Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<OctonionFloat64Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, OctonionFloat64Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<OctonionFloat64Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<OctonionFloat64Member, Float64Member> norm() {
        return this.NORM;
    }

    private double norm(OctonionFloat64Member a) {
        double max = Math.max(Math.abs(a.r()), Math.abs(a.i()));
        max = Math.max(max, Math.abs(a.j()));
        max = Math.max(max, Math.abs(a.k()));
        max = Math.max(max, Math.abs(a.l()));
        max = Math.max(max, Math.abs(a.i0()));
        max = Math.max(max, Math.abs(a.j0()));
        if ((max = Math.max(max, Math.abs(a.k0()))) == 0.0) {
            return 0.0;
        }
        double sum = a.r() / max * (a.r() / max);
        sum += a.i() / max * (a.i() / max);
        sum += a.j() / max * (a.j() / max);
        sum += a.k() / max * (a.k() / max);
        sum += a.l() / max * (a.l() / max);
        sum += a.i0() / max * (a.i0() / max);
        sum += a.j0() / max * (a.j0() / max);
        return max * Math.sqrt(sum += a.k0() / max * (a.k0() / max));
    }

    private double norm2(OctonionFloat64Member a) {
        double norm = this.norm(a);
        return norm * norm;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure1<OctonionFloat64Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> I() {
        return this.I_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> J() {
        return this.J_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> K() {
        return this.K_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> L() {
        return this.L_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> I0() {
        return this.I0_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> J0() {
        return this.J0_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> K0() {
        return this.K0_;
    }

    @Override
    public Procedure1<OctonionFloat64Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<OctonionFloat64Member, Float64Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> tan() {
        return this.TAN;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> log() {
        return this.LOG;
    }

    private void multiplier(double r, double factor, OctonionFloat64Member result) {
        if (Double.isNaN(factor) || Double.isInfinite(factor)) {
            if (result.i() == 0.0 && result.j() == 0.0 && result.k() == 0.0) {
                result.setR(r);
                result.setI(result.i() * factor);
                result.setJ(result.j() * factor);
                result.setK(result.k() * factor);
                result.setL(result.l() * factor);
                result.setI0(result.i0() * factor);
                result.setJ0(result.j0() * factor);
                result.setK0(result.k0() * factor);
            } else {
                double signum = Math.signum(factor);
                result.setR(r);
                if (result.i() == 0.0) {
                    result.setI(signum * result.i());
                } else {
                    result.setI(factor * result.i());
                }
                if (result.j() == 0.0) {
                    result.setJ(signum * result.j());
                } else {
                    result.setJ(factor * result.j());
                }
                if (result.k() == 0.0) {
                    result.setK(signum * result.k());
                } else {
                    result.setK(factor * result.k());
                }
                if (result.l() == 0.0) {
                    result.setL(signum * result.l());
                } else {
                    result.setL(factor * result.l());
                }
                if (result.i0() == 0.0) {
                    result.setI0(signum * result.i0());
                } else {
                    result.setI0(factor * result.i0());
                }
                if (result.j0() == 0.0) {
                    result.setJ0(signum * result.j0());
                } else {
                    result.setJ0(factor * result.j0());
                }
                if (result.k0() == 0.0) {
                    result.setK0(signum * result.k0());
                } else {
                    result.setK0(factor * result.k0());
                }
            }
        } else {
            result.setR(r);
            result.setI(result.i() * factor);
            result.setJ(result.j() * factor);
            result.setK(result.k() * factor);
            result.setL(result.l() * factor);
            result.setI0(result.i0() * factor);
            result.setJ0(result.j0() * factor);
            result.setK0(result.k0() * factor);
        }
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<OctonionFloat64Member, OctonionFloat64Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, OctonionFloat64Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64Member, OctonionFloat64Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, OctonionFloat64Member, OctonionFloat64Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, OctonionFloat64Member, OctonionFloat64Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, OctonionFloat64Member, OctonionFloat64Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float64Member, OctonionFloat64Member, OctonionFloat64Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float64Member, OctonionFloat64Member, OctonionFloat64Member> within() {
        return this.WITHIN;
    }
}

