/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.octonion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.misc.LongUtils;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.octonion.OctonionFloat64Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class OctonionFloat64CartesianTensorProductMember
implements TensorMember<OctonionFloat64Member>,
Gettable<OctonionFloat64CartesianTensorProductMember>,
Settable<OctonionFloat64CartesianTensorProductMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<OctonionFloat64Member> {
    private static final OctonionFloat64Member ZERO = new OctonionFloat64Member();
    private int rank;
    private long dimCount;
    private IndexedDataSource<OctonionFloat64Member> storage;
    private long[] dims;
    private long[] multipliers;
    private StorageConstruction s;
    private static ThreadLocal<OctonionFloat64Member> tmpOct = new ThreadLocal<OctonionFloat64Member>(){

        @Override
        protected OctonionFloat64Member initialValue() {
            return new OctonionFloat64Member();
        }
    };

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        return this.rank;
    }

    @Override
    public int upperRank() {
        return 0;
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return true;
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return false;
    }

    @Override
    public long dimension() {
        return this.dimCount;
    }

    public OctonionFloat64CartesianTensorProductMember() {
        this.rank = 0;
        this.dimCount = 0L;
        this.dims = new long[0];
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, 1L, new OctonionFloat64Member());
        this.multipliers = this.calcMultipliers();
    }

    public OctonionFloat64CartesianTensorProductMember(int rank, long dimCount) {
        if (rank < 0) {
            throw new IllegalArgumentException("bad rank in tensor constructor");
        }
        if (dimCount < 0L) {
            throw new IllegalArgumentException("bad dimensionality in tensor constructor");
        }
        this.rank = rank;
        this.dimCount = dimCount;
        this.dims = new long[rank];
        for (int i = 0; i < rank; ++i) {
            this.dims[i] = dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new OctonionFloat64Member());
        this.multipliers = this.calcMultipliers();
    }

    public OctonionFloat64CartesianTensorProductMember(int rank, long dimCount, double[] vals) {
        this(rank, dimCount);
        if ((long)vals.length != this.storage.size() * 8L) {
            throw new IllegalArgumentException("incorrect number of values given in tensor constructor");
        }
        OctonionFloat64Member value = new OctonionFloat64Member();
        for (int i = 0; i < vals.length; i += 8) {
            value.setR(vals[i]);
            value.setI(vals[i + 1]);
            value.setJ(vals[i + 2]);
            value.setK(vals[i + 3]);
            value.setL(vals[i + 4]);
            value.setI0(vals[i + 5]);
            value.setJ0(vals[i + 6]);
            value.setK0(vals[i + 7]);
            this.storage.set(i, value);
        }
    }

    public OctonionFloat64CartesianTensorProductMember(long[] dims) {
        this.rank = dims.length;
        long max = 0L;
        for (long d : dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new OctonionFloat64Member());
        this.multipliers = this.calcMultipliers();
    }

    public OctonionFloat64CartesianTensorProductMember(long[] dims, double[] vals) {
        this(dims);
        long numElems = LongUtils.numElements(dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        if ((long)vals.length != numElems * 8L) {
            throw new IllegalArgumentException("incorrect number of values provided to tensor constructor");
        }
        OctonionFloat64Member value = new OctonionFloat64Member();
        if (numElems == 1L) {
            value.setR(vals[0]);
            value.setI(vals[1]);
            value.setJ(vals[2]);
            value.setK(vals[3]);
            value.setL(vals[4]);
            value.setI0(vals[5]);
            value.setJ0(vals[6]);
            value.setK0(vals[7]);
            this.storage.set(0L, value);
        } else {
            int i;
            long[] point1 = new long[dims.length];
            long[] point2 = new long[dims.length];
            for (i = 0; i < dims.length; ++i) {
                point2[i] = dims[i] - 1L;
            }
            i = 0;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                value.setR(vals[i]);
                value.setI(vals[i + 1]);
                value.setJ(vals[i + 2]);
                value.setK(vals[i + 3]);
                value.setL(vals[i + 4]);
                value.setI0(vals[i + 5]);
                value.setJ0(vals[i + 6]);
                value.setK0(vals[i + 7]);
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                i += 8;
            }
        }
    }

    public OctonionFloat64CartesianTensorProductMember(OctonionFloat64CartesianTensorProductMember other) {
        this.set(other);
    }

    public OctonionFloat64CartesianTensorProductMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.values();
        long[] tmpDims = (long[])rep.dimensions().clone();
        this.rank = tmpDims.length;
        long max = 0L;
        for (long d : tmpDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new OctonionFloat64Member());
        this.multipliers = this.calcMultipliers();
        OctonionFloat64Member value = new OctonionFloat64Member();
        if (numElems == 1L) {
            OctonionRepresentation val = data.get(0L);
            value.setR(val.r().doubleValue());
            value.setI(val.i().doubleValue());
            value.setJ(val.j().doubleValue());
            value.setK(val.k().doubleValue());
            value.setL(val.l().doubleValue());
            value.setI0(val.i0().doubleValue());
            value.setJ0(val.j0().doubleValue());
            value.setK0(val.k0().doubleValue());
            this.storage.set(0L, value);
        } else {
            long[] point1 = new long[tmpDims.length];
            long[] point2 = new long[tmpDims.length];
            for (int i = 0; i < tmpDims.length; ++i) {
                point2[i] = tmpDims[i] - 1L;
            }
            long i = 0L;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(this.dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                OctonionRepresentation val = data.get(i);
                value.setR(val.r().doubleValue());
                value.setI(val.i().doubleValue());
                value.setJ(val.j().doubleValue());
                value.setK(val.k().doubleValue());
                value.setL(val.l().doubleValue());
                value.setI0(val.i0().doubleValue());
                value.setJ0(val.j0().doubleValue());
                value.setK0(val.k0().doubleValue());
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                ++i;
            }
        }
    }

    public OctonionFloat64CartesianTensorProductMember(StorageConstruction s, long[] nd) {
        this.rank = this.dims.length;
        long max = 0L;
        for (long d : this.dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        this.s = s;
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.storage = Storage.allocate(s, numElems, new OctonionFloat64Member());
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public void set(OctonionFloat64CartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        this.rank = other.rank;
        this.dimCount = other.dimCount;
        this.dims = (long[])other.dims.clone();
        this.multipliers = (long[])other.multipliers.clone();
        this.storage = (IndexedDataSource)other.storage.duplicate();
        this.s = other.s;
    }

    @Override
    public void get(OctonionFloat64CartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        other.rank = this.rank;
        other.dimCount = this.dimCount;
        other.dims = (long[])this.dims.clone();
        other.multipliers = (long[])this.multipliers.clone();
        other.storage = (IndexedDataSource)this.storage.duplicate();
        other.s = this.s;
    }

    @Override
    public boolean alloc(long[] newDims) {
        boolean theSame = true;
        if (newDims.length != this.dims.length) {
            theSame = false;
        } else {
            for (int i = 0; i < newDims.length; ++i) {
                if (newDims[i] == this.dims[i]) continue;
                theSame = false;
                break;
            }
        }
        if (theSame) {
            return false;
        }
        this.rank = newDims.length;
        long max = 0L;
        for (long d : newDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        long newCount = LongUtils.numElements(this.dims);
        if (newCount == 0L) {
            newCount = 1L;
        }
        if (this.storage == null || newCount != this.storage.size()) {
            this.storage = Storage.allocate(this.s, newCount, new OctonionFloat64Member());
            return true;
        }
        return false;
    }

    @Override
    public void init(long[] newDims) {
        if (!this.alloc(newDims)) {
            long storageSize = this.storage.size();
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    public long numElems() {
        return this.storage.size();
    }

    void v(long index, OctonionFloat64Member value) {
        this.storage.get(index, value);
    }

    @Override
    public void v(IntegerIndex index, OctonionFloat64Member value) {
        long idx = this.indexToLong(index);
        this.storage.get(idx, value);
    }

    void setV(long index, OctonionFloat64Member value) {
        this.storage.set(index, value);
    }

    @Override
    public void setV(IntegerIndex index, OctonionFloat64Member value) {
        long idx = this.indexToLong(index);
        this.storage.set(idx, value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        OctonionFloat64Member value = new OctonionFloat64Member();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = BigDecimal.valueOf(value.r());
            BigDecimal im = BigDecimal.valueOf(value.i());
            BigDecimal j = BigDecimal.valueOf(value.j());
            BigDecimal k = BigDecimal.valueOf(value.k());
            BigDecimal l = BigDecimal.valueOf(value.l());
            BigDecimal i0 = BigDecimal.valueOf(value.i0());
            BigDecimal j0 = BigDecimal.valueOf(value.j0());
            BigDecimal k0 = BigDecimal.valueOf(value.k0());
            OctonionRepresentation o = new OctonionRepresentation(re, im, j, k, l, i0, j0, k0);
            values.set(i, o);
        }
        rep.setTensor(this.dims, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionFloat64Member value = new OctonionFloat64Member();
        BigList<OctonionRepresentation> tensor = rep.getTensor();
        this.init(rep.getTensorDims());
        long tensorSize = tensor.size();
        for (long i = 0L; i < tensorSize; ++i) {
            OctonionRepresentation o = tensor.get(i);
            value.setR(o.r().doubleValue());
            value.setI(o.i().doubleValue());
            value.setJ(o.j().doubleValue());
            value.setK(o.k().doubleValue());
            value.setL(o.l().doubleValue());
            value.setI0(o.i0().doubleValue());
            value.setJ0(o.j0().doubleValue());
            value.setK0(o.k0().doubleValue());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        OctonionFloat64Member tmp = new OctonionFloat64Member();
        IntegerIndex index = new IntegerIndex(this.dims.length);
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, tmp);
            this.longToIntegerIndex(i, index);
            int j = 0;
            while (j < index.numDimensions() && index.get(j++) == 0L) {
                builder.append('[');
            }
            if (index.get(0) != 0L) {
                builder.append(',');
            }
            builder.append('{');
            builder.append(tmp.r());
            builder.append(',');
            builder.append(tmp.i());
            builder.append(',');
            builder.append(tmp.j());
            builder.append(',');
            builder.append(tmp.k());
            builder.append(',');
            builder.append(tmp.l());
            builder.append(',');
            builder.append(tmp.i0());
            builder.append(',');
            builder.append(tmp.j0());
            builder.append(',');
            builder.append(tmp.k0());
            builder.append('}');
            j = 0;
            while (j < index.numDimensions() && index.get(j) == this.dims[j++] - 1L) {
                builder.append(']');
            }
        }
        return builder.toString();
    }

    private long[] calcMultipliers() {
        if (this.dims.length == 0) {
            return new long[0];
        }
        long[] result = new long[this.dims.length - 1];
        long mult = 1L;
        for (int i = 0; i < result.length; ++i) {
            result[i] = mult;
            mult *= this.dims[i];
        }
        return result;
    }

    private long indexToLong(IntegerIndex idx) {
        if (idx.numDimensions() == 0) {
            throw new IllegalArgumentException("null index");
        }
        if (idx.numDimensions() >= this.dims.length && this.indexOob(idx, 0)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        long index = 0L;
        long mult = 1L;
        for (int i = 0; i < this.dims.length; ++i) {
            index += mult * idx.get(i);
            mult *= this.dims[i];
        }
        return index;
    }

    private void longToIntegerIndex(long idx, IntegerIndex result) {
        int i;
        if (idx < 0L) {
            throw new IllegalArgumentException("negative index in tensor addressing");
        }
        if (idx >= this.storage.size()) {
            throw new IllegalArgumentException("index beyond end of tensor storage");
        }
        if (result.numDimensions() < this.dims.length) {
            throw new IllegalArgumentException("mismatched dims in tensor member");
        }
        for (i = this.dims.length; i < result.numDimensions(); ++i) {
            result.set(i, 0L);
        }
        for (i = this.dims.length - 1; i >= 0; --i) {
            result.set(i, idx / this.multipliers[i]);
            idx %= this.multipliers[i];
        }
    }

    private boolean indexOob(IntegerIndex idx, int component) {
        long index;
        int i;
        if (component < 0) {
            throw new IllegalArgumentException("negative component specified in indexOob");
        }
        if (component > 7) {
            return true;
        }
        for (i = 0; i < this.dims.length; ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index < this.dims[i]) continue;
            return true;
        }
        for (i = this.dims.length; i < idx.numDimensions(); ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int numDimensions() {
        return this.dims.length;
    }

    @Override
    public void reshape(long[] dims) {
        if (Arrays.equals(this.dims, dims)) {
            return;
        }
        throw new IllegalArgumentException("to implement");
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d >= this.dims.length) {
            return 1L;
        }
        return this.dims[d];
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.DOUBLE;
    }

    @Override
    public int componentCount() {
        return 8;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v.doubleValue());
                } else {
                    tmp.setI(v.doubleValue());
                }
            } else if (component == 2) {
                tmp.setJ(v.doubleValue());
            } else {
                tmp.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v.doubleValue());
            } else {
                tmp.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            tmp.setJ0(v.doubleValue());
        } else {
            tmp.setK0(v.doubleValue());
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v.doubleValue());
                } else {
                    tmp.setI(v.doubleValue());
                }
            } else if (component == 2) {
                tmp.setJ(v.doubleValue());
            } else {
                tmp.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v.doubleValue());
            } else {
                tmp.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            tmp.setJ0(v.doubleValue());
        } else {
            tmp.setK0(v.doubleValue());
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        if (this.indexOob(index, component)) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v.doubleValue());
                    } else {
                        tmp.setI(v.doubleValue());
                    }
                } else if (component == 2) {
                    tmp.setJ(v.doubleValue());
                } else {
                    tmp.setK(v.doubleValue());
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v.doubleValue());
                } else {
                    tmp.setI0(v.doubleValue());
                }
            } else if (component == 6) {
                tmp.setJ0(v.doubleValue());
            } else {
                tmp.setK0(v.doubleValue());
            }
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(index, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v.doubleValue());
                    } else {
                        tmp.setI(v.doubleValue());
                    }
                } else if (component == 2) {
                    tmp.setJ(v.doubleValue());
                } else {
                    tmp.setK(v.doubleValue());
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v.doubleValue());
                } else {
                    tmp.setI0(v.doubleValue());
                }
            } else if (component == 6) {
                tmp.setJ0(v.doubleValue());
            } else {
                tmp.setK0(v.doubleValue());
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)tmp.r();
                }
                return (byte)tmp.i();
            }
            if (component == 2) {
                return (byte)tmp.j();
            }
            return (byte)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)tmp.l();
            }
            return (byte)tmp.i0();
        }
        if (component == 6) {
            return (byte)tmp.j0();
        }
        return (byte)tmp.k0();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)tmp.r();
                }
                return (short)tmp.i();
            }
            if (component == 2) {
                return (short)tmp.j();
            }
            return (short)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)tmp.l();
            }
            return (short)tmp.i0();
        }
        if (component == 6) {
            return (short)tmp.j0();
        }
        return (short)tmp.k0();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)tmp.r();
                }
                return (int)tmp.i();
            }
            if (component == 2) {
                return (int)tmp.j();
            }
            return (int)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)tmp.l();
            }
            return (int)tmp.i0();
        }
        if (component == 6) {
            return (int)tmp.j0();
        }
        return (int)tmp.k0();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)tmp.r();
                }
                return (long)tmp.i();
            }
            if (component == 2) {
                return (long)tmp.j();
            }
            return (long)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)tmp.l();
            }
            return (long)tmp.i0();
        }
        if (component == 6) {
            return (long)tmp.j0();
        }
        return (long)tmp.k0();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (float)tmp.r();
                }
                return (float)tmp.i();
            }
            if (component == 2) {
                return (float)tmp.j();
            }
            return (float)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (float)tmp.l();
            }
            return (float)tmp.i0();
        }
        if (component == 6) {
            return (float)tmp.j0();
        }
        return (float)tmp.k0();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r()).toBigInteger();
                }
                return BigDecimal.valueOf(tmp.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r());
                }
                return BigDecimal.valueOf(tmp.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j());
            }
            return BigDecimal.valueOf(tmp.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l());
            }
            return BigDecimal.valueOf(tmp.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0());
        }
        return BigDecimal.valueOf(tmp.k0());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)tmp.r();
                }
                return (byte)tmp.i();
            }
            if (component == 2) {
                return (byte)tmp.j();
            }
            return (byte)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)tmp.l();
            }
            return (byte)tmp.i0();
        }
        if (component == 6) {
            return (byte)tmp.j0();
        }
        return (byte)tmp.k0();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)tmp.r();
                }
                return (short)tmp.i();
            }
            if (component == 2) {
                return (short)tmp.j();
            }
            return (short)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)tmp.l();
            }
            return (short)tmp.i0();
        }
        if (component == 6) {
            return (short)tmp.j0();
        }
        return (short)tmp.k0();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)tmp.r();
                }
                return (int)tmp.i();
            }
            if (component == 2) {
                return (int)tmp.j();
            }
            return (int)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)tmp.l();
            }
            return (int)tmp.i0();
        }
        if (component == 6) {
            return (int)tmp.j0();
        }
        return (int)tmp.k0();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0L;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)tmp.r();
                }
                return (long)tmp.i();
            }
            if (component == 2) {
                return (long)tmp.j();
            }
            return (long)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)tmp.l();
            }
            return (long)tmp.i0();
        }
        if (component == 6) {
            return (long)tmp.j0();
        }
        return (long)tmp.k0();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0f;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (float)tmp.r();
                }
                return (float)tmp.i();
            }
            if (component == 2) {
                return (float)tmp.j();
            }
            return (float)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (float)tmp.l();
            }
            return (float)tmp.i0();
        }
        if (component == 6) {
            return (float)tmp.j0();
        }
        return (float)tmp.k0();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigInteger.ZERO;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r()).toBigInteger();
                }
                return BigDecimal.valueOf(tmp.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigDecimal.ZERO;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r());
                }
                return BigDecimal.valueOf(tmp.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j());
            }
            return BigDecimal.valueOf(tmp.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l());
            }
            return BigDecimal.valueOf(tmp.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0());
        }
        return BigDecimal.valueOf(tmp.k0());
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<OctonionFloat64Member> rawData() {
        return this.storage;
    }
}

