/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.octonion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.octonion.OctonionFloat64Algebra;
import nom.bdezonia.zorbage.type.data.float64.octonion.OctonionFloat64MatrixMember;
import nom.bdezonia.zorbage.type.data.float64.octonion.OctonionFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class OctonionFloat64Matrix
implements RingWithUnity<OctonionFloat64Matrix, OctonionFloat64MatrixMember>,
MatrixRing<OctonionFloat64Matrix, OctonionFloat64MatrixMember, OctonionFloat64Algebra, OctonionFloat64Member>,
Constructible2dLong<OctonionFloat64MatrixMember>,
Rounding<Float64Member, OctonionFloat64MatrixMember>,
Norm<OctonionFloat64MatrixMember, Float64Member>,
DirectProduct<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>,
Exponential<OctonionFloat64MatrixMember>,
Trigonometric<OctonionFloat64MatrixMember>,
Hyperbolic<OctonionFloat64MatrixMember>,
RealConstants<OctonionFloat64MatrixMember>,
Infinite<OctonionFloat64MatrixMember>,
NaN<OctonionFloat64MatrixMember>,
ScaleByHighPrec<OctonionFloat64MatrixMember>,
ScaleByRational<OctonionFloat64MatrixMember>,
ScaleByDouble<OctonionFloat64MatrixMember>,
Tolerance<Float64Member, OctonionFloat64MatrixMember> {
    private final Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> MUL = new Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            MatrixMultiply.compute(G.ODBL, a, b, c);
        }
    };
    private final Procedure3<Integer, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> POWER = new Procedure3<Integer, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(Integer power, OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            MatrixPower.compute(power, G.ODBL, G.ODBL_RMOD, G.ODBL_MAT, a, b);
        }
    };
    private Procedure1<OctonionFloat64MatrixMember> ZER = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> NEG = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            MatrixNegate.compute(G.ODBL, a, b);
        }
    };
    private final Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> ADD = new Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            MatrixAddition.compute(G.ODBL, a, b, c);
        }
    };
    private final Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SUB = new Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            MatrixSubtraction.compute(G.ODBL, a, b, c);
        }
    };
    private final Function2<Boolean, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> EQ = new Function2<Boolean, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            return MatrixEqual.compute(G.ODBL, a, b);
        }
    };
    private final Function2<Boolean, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> NEQ = new Function2<Boolean, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            return OctonionFloat64Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> ASSIGN = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember from, OctonionFloat64MatrixMember to) {
            MatrixAssign.compute(G.ODBL, from, to);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, Float64Member> NORM = new Procedure2<OctonionFloat64MatrixMember, Float64Member>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, Float64Member b) {
            MatrixSpectralNorm.compute(G.ODBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> ROUND = new Procedure4<Round.Mode, Float64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            MatrixRound.compute(G.ODBL, mode, delta, a, b);
        }
    };
    private Function1<Boolean, OctonionFloat64MatrixMember> ISNAN = new Function1<Boolean, OctonionFloat64MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat64MatrixMember a) {
            return SequenceIsNan.compute(G.ODBL, a.rawData());
        }
    };
    private final Procedure1<OctonionFloat64MatrixMember> NAN = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            FillNaN.compute(G.ODBL, a);
        }
    };
    private Function1<Boolean, OctonionFloat64MatrixMember> ISINF = new Function1<Boolean, OctonionFloat64MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat64MatrixMember a) {
            return SequenceIsInf.compute(G.ODBL, a.rawData());
        }
    };
    private final Procedure1<OctonionFloat64MatrixMember> INF = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            FillInfinite.compute(G.ODBL, a);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> CONJ = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            MatrixConjugate.compute(G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> TRANSP = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            MatrixTranspose.compute(G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> CONJTRANSP = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            OctonionFloat64MatrixMember tmp = new OctonionFloat64MatrixMember();
            OctonionFloat64Matrix.this.conjugate().call(a, tmp);
            OctonionFloat64Matrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64Member> DET = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64Member>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64Member b) {
            MatrixDeterminant.compute(G.ODBL_MAT, G.ODBL, a, b);
        }
    };
    private final Procedure1<OctonionFloat64MatrixMember> UNITY = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            MatrixUnity.compute(G.ODBL, a);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> INVERT = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            MatrixInvert.compute(G.ODBL, G.ODBL_RMOD, G.ODBL_MAT, a, b);
        }
    };
    private final Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> DIVIDE = new Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            OctonionFloat64MatrixMember invB = OctonionFloat64Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            OctonionFloat64Matrix.this.invert().call(b, invB);
            OctonionFloat64Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> DP = new Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember in1, OctonionFloat64MatrixMember in2, OctonionFloat64MatrixMember out) {
            MatrixDirectProduct.compute(G.ODBL, in1, in2, out);
        }
    };
    private final Procedure3<OctonionFloat64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SCALE = new Procedure3<OctonionFloat64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64Member a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            MatrixScale.compute(G.ODBL, a, b, c);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SINH = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.ODBL_MAT, G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> COSH = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.ODBL_MAT, G.ODBL, a, b);
        }
    };
    private final Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SINHANDCOSH = new Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember s, OctonionFloat64MatrixMember c) {
            OctonionFloat64Matrix.this.sinh().call(a, s);
            OctonionFloat64Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> TANH = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            OctonionFloat64MatrixMember s = OctonionFloat64Matrix.this.construct();
            OctonionFloat64MatrixMember c = OctonionFloat64Matrix.this.construct();
            OctonionFloat64Matrix.this.sinhAndCosh().call(a, s, c);
            OctonionFloat64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SINCH = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            Sinch.compute(G.ODBL_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SINCHPI = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            Sinchpi.compute(G.ODBL_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SIN = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            TaylorEstimateSin.compute(18, G.ODBL_MAT, G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> COS = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            TaylorEstimateCos.compute(18, G.ODBL_MAT, G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> TAN = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            OctonionFloat64MatrixMember s = OctonionFloat64Matrix.this.construct();
            OctonionFloat64MatrixMember c = OctonionFloat64Matrix.this.construct();
            OctonionFloat64Matrix.this.sinAndCos().call(a, s, c);
            OctonionFloat64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SINANDCOS = new Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember s, OctonionFloat64MatrixMember c) {
            OctonionFloat64Matrix.this.sin().call(a, s);
            OctonionFloat64Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SINC = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            Sinc.compute(G.ODBL_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SINCPI = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            Sincpi.compute(G.ODBL_MAT, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> EXP = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            TaylorEstimateExp.compute(35, G.ODBL_MAT, G.ODBL, a, b);
        }
    };
    private final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> LOG = new Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            TaylorEstimateLog.compute(8, G.ODBL_MAT, G.ODBL, a, b);
        }
    };
    private final Function1<Boolean, OctonionFloat64MatrixMember> ISZERO = new Function1<Boolean, OctonionFloat64MatrixMember>(){

        @Override
        public Boolean call(OctonionFloat64MatrixMember a) {
            return SequenceIsZero.compute(G.ODBL, a.rawData());
        }
    };
    private final Procedure1<OctonionFloat64MatrixMember> PI = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            OctonionFloat64Member pi = G.ODBL.construct();
            G.ODBL.PI().call(pi);
            MatrixConstantDiagonal.compute(G.ODBL, pi, a);
        }
    };
    private final Procedure1<OctonionFloat64MatrixMember> E = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            OctonionFloat64Member e = G.ODBL.construct();
            G.ODBL.E().call(e);
            MatrixConstantDiagonal.compute(G.ODBL, e, a);
        }
    };
    private final Procedure1<OctonionFloat64MatrixMember> PHI = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            OctonionFloat64Member phi = G.ODBL.construct();
            G.ODBL.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.ODBL, phi, a);
        }
    };
    private final Procedure1<OctonionFloat64MatrixMember> GAMMA = new Procedure1<OctonionFloat64MatrixMember>(){

        @Override
        public void call(OctonionFloat64MatrixMember a) {
            OctonionFloat64Member gamma = G.ODBL.construct();
            G.ODBL.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.ODBL, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SBHP = new Procedure3<HighPrecisionMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.ODBL, a, b, c);
        }
    };
    private Procedure3<RationalMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SBR = new Procedure3<RationalMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(RationalMember a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            MatrixScaleByRational.compute(G.ODBL, a, b, c);
        }
    };
    private Procedure3<Double, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> SBD = new Procedure3<Double, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public void call(Double a, OctonionFloat64MatrixMember b, OctonionFloat64MatrixMember c) {
            MatrixScaleByDouble.compute(G.ODBL, a, b, c);
        }
    };
    private final Function3<Boolean, Float64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> WITHIN = new Function3<Boolean, Float64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember>(){

        @Override
        public Boolean call(Float64Member tol, OctonionFloat64MatrixMember a, OctonionFloat64MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.ODBL, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public OctonionFloat64MatrixMember construct() {
        return new OctonionFloat64MatrixMember();
    }

    @Override
    public OctonionFloat64MatrixMember construct(OctonionFloat64MatrixMember other) {
        return new OctonionFloat64MatrixMember(other);
    }

    @Override
    public OctonionFloat64MatrixMember construct(String s) {
        return new OctonionFloat64MatrixMember(s);
    }

    @Override
    public OctonionFloat64MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new OctonionFloat64MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, OctonionFloat64MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, OctonionFloat64MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public final Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> invert() {
        return this.INVERT;
    }

    @Override
    public Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<OctonionFloat64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, OctonionFloat64MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<OctonionFloat64MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float64Member, OctonionFloat64MatrixMember, OctonionFloat64MatrixMember> within() {
        return this.WITHIN;
    }
}

