/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.octonion;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.MatrixReshape;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.octonion.OctonionFloat64Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class OctonionFloat64MatrixMember
implements MatrixMember<OctonionFloat64Member>,
Gettable<OctonionFloat64MatrixMember>,
Settable<OctonionFloat64MatrixMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<OctonionFloat64Member> {
    private static final OctonionFloat64Member ZERO = new OctonionFloat64Member();
    private IndexedDataSource<OctonionFloat64Member> storage;
    private long rows;
    private long cols;
    private StorageConstruction s;
    private static ThreadLocal<OctonionFloat64Member> tmpOct = new ThreadLocal<OctonionFloat64Member>(){

        @Override
        protected OctonionFloat64Member initialValue() {
            return new OctonionFloat64Member();
        }
    };

    public OctonionFloat64MatrixMember() {
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(0L, 0L);
    }

    public OctonionFloat64MatrixMember(int r, int c, double[] vals) {
        if (vals.length != r * c * 8) {
            throw new IllegalArgumentException("input values do not match declared shape");
        }
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(r, c);
        OctonionFloat64Member tmp = new OctonionFloat64Member();
        int octCount = vals.length / 8;
        for (int i = 0; i < octCount; ++i) {
            tmp.setR(vals[8 * i]);
            tmp.setI(vals[8 * i + 1]);
            tmp.setJ(vals[8 * i + 2]);
            tmp.setK(vals[8 * i + 3]);
            tmp.setL(vals[8 * i + 4]);
            tmp.setI0(vals[8 * i + 5]);
            tmp.setJ0(vals[8 * i + 6]);
            tmp.setK0(vals[8 * i + 7]);
            this.storage.set(i, tmp);
        }
    }

    public OctonionFloat64MatrixMember(OctonionFloat64MatrixMember other) {
        this.set(other);
    }

    public OctonionFloat64MatrixMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.firstMatrixValues();
        long[] dimensions = rep.dimensions();
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(dimensions[1], dimensions[0]);
        OctonionFloat64Member tmp = new OctonionFloat64Member();
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            OctonionRepresentation val = data.get(i);
            tmp.setR(val.r().doubleValue());
            tmp.setI(val.i().doubleValue());
            tmp.setJ(val.j().doubleValue());
            tmp.setK(val.k().doubleValue());
            tmp.setL(val.l().doubleValue());
            tmp.setI0(val.i0().doubleValue());
            tmp.setJ0(val.j0().doubleValue());
            tmp.setK0(val.k0().doubleValue());
            this.storage.set(i, tmp);
        }
    }

    public OctonionFloat64MatrixMember(StorageConstruction s, long d1, long d2) {
        this.rows = -1L;
        this.cols = -1L;
        this.s = s;
        this.init(d2, d1);
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public long rows() {
        return this.rows;
    }

    @Override
    public long cols() {
        return this.cols;
    }

    @Override
    public boolean alloc(long r, long c) {
        if (this.rows != r || this.cols != c) {
            this.rows = r;
            this.cols = c;
        }
        if (this.storage == null || this.storage.size() != r * c) {
            this.storage = Storage.allocate(this.s, r * c, new OctonionFloat64Member());
            return true;
        }
        return false;
    }

    @Override
    public void init(long r, long c) {
        if (!this.alloc(r, c)) {
            long storageSize = r * c;
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    @Override
    public void v(long r, long c, OctonionFloat64Member value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.get(index, value);
    }

    @Override
    public void setV(long r, long c, OctonionFloat64Member value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.set(index, value);
    }

    @Override
    public void set(OctonionFloat64MatrixMember other) {
        if (this == other) {
            return;
        }
        this.rows = other.rows;
        this.cols = other.cols;
        this.s = other.s;
        this.storage = (IndexedDataSource)other.storage.duplicate();
    }

    @Override
    public void get(OctonionFloat64MatrixMember other) {
        if (this == other) {
            return;
        }
        other.rows = this.rows;
        other.cols = this.cols;
        other.s = this.s;
        other.storage = (IndexedDataSource)this.storage.duplicate();
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        OctonionFloat64Member value = new OctonionFloat64Member();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = BigDecimal.valueOf(value.r());
            BigDecimal im = BigDecimal.valueOf(value.i());
            BigDecimal j = BigDecimal.valueOf(value.j());
            BigDecimal k = BigDecimal.valueOf(value.k());
            BigDecimal l = BigDecimal.valueOf(value.l());
            BigDecimal i0 = BigDecimal.valueOf(value.i0());
            BigDecimal j0 = BigDecimal.valueOf(value.j0());
            BigDecimal k0 = BigDecimal.valueOf(value.k0());
            OctonionRepresentation o = new OctonionRepresentation(re, im, j, k, l, i0, j0, k0);
            values.set(i, o);
        }
        rep.setMatrix(this.rows, this.cols, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionFloat64Member value = new OctonionFloat64Member();
        BigList<OctonionRepresentation> mat = rep.getMatrix();
        this.alloc(rep.getMatrixRowDim(), rep.getMatrixColDim());
        long matSize = mat.size();
        for (long i = 0L; i < matSize; ++i) {
            OctonionRepresentation o = mat.get(i);
            value.setR(o.r().doubleValue());
            value.setI(o.i().doubleValue());
            value.setJ(o.j().doubleValue());
            value.setK(o.k().doubleValue());
            value.setL(o.l().doubleValue());
            value.setI0(o.i0().doubleValue());
            value.setJ0(o.j0().doubleValue());
            value.setK0(o.k0().doubleValue());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        OctonionFloat64Member tmp = new OctonionFloat64Member();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (long r = 0L; r < this.rows; ++r) {
            builder.append('[');
            for (long c = 0L; c < this.cols; ++c) {
                if (c != 0L) {
                    builder.append(',');
                }
                this.v(r, c, tmp);
                builder.append(tmp.toString());
            }
            builder.append(']');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public void reshape(long rows, long cols) {
        MatrixReshape.compute(G.ODBL_MAT, G.ODBL, rows, cols, this);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d == 0) {
            return this.cols;
        }
        if (d == 1) {
            return this.rows;
        }
        return 1L;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.DOUBLE;
    }

    @Override
    public int componentCount() {
        return 8;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v);
                } else {
                    tmp.setI(v);
                }
            } else if (component == 2) {
                tmp.setJ(v);
            } else {
                tmp.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v);
            } else {
                tmp.setI0(v);
            }
        } else if (component == 6) {
            tmp.setJ0(v);
        } else {
            tmp.setK0(v);
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v.doubleValue());
                } else {
                    tmp.setI(v.doubleValue());
                }
            } else if (component == 2) {
                tmp.setJ(v.doubleValue());
            } else {
                tmp.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v.doubleValue());
            } else {
                tmp.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            tmp.setJ0(v.doubleValue());
        } else {
            tmp.setK0(v.doubleValue());
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        long c = index.get(0);
        long r = index.get(1);
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(r, c, tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    tmp.setR(v.doubleValue());
                } else {
                    tmp.setI(v.doubleValue());
                }
            } else if (component == 2) {
                tmp.setJ(v.doubleValue());
            } else {
                tmp.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                tmp.setL(v.doubleValue());
            } else {
                tmp.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            tmp.setJ0(v.doubleValue());
        } else {
            tmp.setK0(v.doubleValue());
        }
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v);
                    } else {
                        tmp.setI(v);
                    }
                } else if (component == 2) {
                    tmp.setJ(v);
                } else {
                    tmp.setK(v);
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v);
                } else {
                    tmp.setI0(v);
                }
            } else if (component == 6) {
                tmp.setJ0(v);
            } else {
                tmp.setK0(v);
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v.doubleValue());
                    } else {
                        tmp.setI(v.doubleValue());
                    }
                } else if (component == 2) {
                    tmp.setJ(v.doubleValue());
                } else {
                    tmp.setK(v.doubleValue());
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v.doubleValue());
                } else {
                    tmp.setI0(v.doubleValue());
                }
            } else if (component == 6) {
                tmp.setJ0(v.doubleValue());
            } else {
                tmp.setK0(v.doubleValue());
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(0) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            long c = index.get(0);
            long r = index.get(1);
            OctonionFloat64Member tmp = tmpOct.get();
            this.v(r, c, tmp);
            if (component < 4) {
                if (component < 2) {
                    if (component == 0) {
                        tmp.setR(v.doubleValue());
                    } else {
                        tmp.setI(v.doubleValue());
                    }
                } else if (component == 2) {
                    tmp.setJ(v.doubleValue());
                } else {
                    tmp.setK(v.doubleValue());
                }
            } else if (component < 6) {
                if (component == 4) {
                    tmp.setL(v.doubleValue());
                } else {
                    tmp.setI0(v.doubleValue());
                }
            } else if (component == 6) {
                tmp.setJ0(v.doubleValue());
            } else {
                tmp.setK0(v.doubleValue());
            }
            this.setV(r, c, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)tmp.r();
                }
                return (byte)tmp.i();
            }
            if (component == 2) {
                return (byte)tmp.j();
            }
            return (byte)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)tmp.l();
            }
            return (byte)tmp.i0();
        }
        if (component == 6) {
            return (byte)tmp.j0();
        }
        return (byte)tmp.k0();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)tmp.r();
                }
                return (short)tmp.i();
            }
            if (component == 2) {
                return (short)tmp.j();
            }
            return (short)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)tmp.l();
            }
            return (short)tmp.i0();
        }
        if (component == 6) {
            return (short)tmp.j0();
        }
        return (short)tmp.k0();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)tmp.r();
                }
                return (int)tmp.i();
            }
            if (component == 2) {
                return (int)tmp.j();
            }
            return (int)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)tmp.l();
            }
            return (int)tmp.i0();
        }
        if (component == 6) {
            return (int)tmp.j0();
        }
        return (int)tmp.k0();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0L;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)tmp.r();
                }
                return (long)tmp.i();
            }
            if (component == 2) {
                return (long)tmp.j();
            }
            return (long)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)tmp.l();
            }
            return (long)tmp.i0();
        }
        if (component == 6) {
            return (long)tmp.j0();
        }
        return (long)tmp.k0();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0.0f;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (float)tmp.r();
                }
                return (float)tmp.i();
            }
            if (component == 2) {
                return (float)tmp.j();
            }
            return (float)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (float)tmp.l();
            }
            return (float)tmp.i0();
        }
        if (component == 6) {
            return (float)tmp.j0();
        }
        return (float)tmp.k0();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return 0.0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return BigInteger.ZERO;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r()).toBigInteger();
                }
                return BigDecimal.valueOf(tmp.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component > 7) {
            return BigDecimal.ZERO;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r());
                }
                return BigDecimal.valueOf(tmp.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j());
            }
            return BigDecimal.valueOf(tmp.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l());
            }
            return BigDecimal.valueOf(tmp.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0());
        }
        return BigDecimal.valueOf(tmp.k0());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)tmp.r();
                }
                return (byte)tmp.i();
            }
            if (component == 2) {
                return (byte)tmp.j();
            }
            return (byte)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)tmp.l();
            }
            return (byte)tmp.i0();
        }
        if (component == 6) {
            return (byte)tmp.j0();
        }
        return (byte)tmp.k0();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)tmp.r();
                }
                return (short)tmp.i();
            }
            if (component == 2) {
                return (short)tmp.j();
            }
            return (short)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)tmp.l();
            }
            return (short)tmp.i0();
        }
        if (component == 6) {
            return (short)tmp.j0();
        }
        return (short)tmp.k0();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)tmp.r();
                }
                return (int)tmp.i();
            }
            if (component == 2) {
                return (int)tmp.j();
            }
            return (int)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)tmp.l();
            }
            return (int)tmp.i0();
        }
        if (component == 6) {
            return (int)tmp.j0();
        }
        return (int)tmp.k0();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)tmp.r();
                }
                return (long)tmp.i();
            }
            if (component == 2) {
                return (long)tmp.j();
            }
            return (long)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)tmp.l();
            }
            return (long)tmp.i0();
        }
        if (component == 6) {
            return (long)tmp.j0();
        }
        return (long)tmp.k0();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (float)tmp.r();
                }
                return (float)tmp.i();
            }
            if (component == 2) {
                return (float)tmp.j();
            }
            return (float)tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (float)tmp.l();
            }
            return (float)tmp.i0();
        }
        if (component == 6) {
            return (float)tmp.j0();
        }
        return (float)tmp.k0();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return tmp.r();
                }
                return tmp.i();
            }
            if (component == 2) {
                return tmp.j();
            }
            return tmp.k();
        }
        if (component < 6) {
            if (component == 4) {
                return tmp.l();
            }
            return tmp.i0();
        }
        if (component == 6) {
            return tmp.j0();
        }
        return tmp.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r()).toBigInteger();
                }
                return BigDecimal.valueOf(tmp.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l()).toBigInteger();
            }
            return BigDecimal.valueOf(tmp.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(tmp.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        OctonionFloat64Member tmp = tmpOct.get();
        this.v(index.get(1), index.get(0), tmp);
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(tmp.r());
                }
                return BigDecimal.valueOf(tmp.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(tmp.j());
            }
            return BigDecimal.valueOf(tmp.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(tmp.l());
            }
            return BigDecimal.valueOf(tmp.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(tmp.j0());
        }
        return BigDecimal.valueOf(tmp.k0());
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<OctonionFloat64Member> rawData() {
        return this.storage;
    }
}

