/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.octonion;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetOctonion;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetOctonion;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;

public final class OctonionFloat64Member
implements NumberMember<OctonionFloat64Member>,
DoubleCoder,
Allocatable<OctonionFloat64Member>,
Duplicatable<OctonionFloat64Member>,
Settable<OctonionFloat64Member>,
Gettable<OctonionFloat64Member>,
PrimitiveConversion,
UniversalRepresentation,
SetOctonion<Float64Member>,
GetOctonion<Float64Member> {
    private double r;
    private double i;
    private double j;
    private double k;
    private double l;
    private double i0;
    private double j0;
    private double k0;

    public OctonionFloat64Member() {
        this.primitiveInit();
    }

    public OctonionFloat64Member(double r, double i, double j, double k, double l, double i0, double j0, double k0) {
        this.setR(r);
        this.setI(i);
        this.setJ(j);
        this.setK(k);
        this.setL(l);
        this.setI0(i0);
        this.setJ0(j0);
        this.setK0(k0);
    }

    public OctonionFloat64Member(OctonionFloat64Member value) {
        this.set(value);
    }

    public OctonionFloat64Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        this.setR(val.r().doubleValue());
        this.setI(val.i().doubleValue());
        this.setJ(val.j().doubleValue());
        this.setK(val.k().doubleValue());
        this.setL(val.l().doubleValue());
        this.setI0(val.i0().doubleValue());
        this.setJ0(val.j0().doubleValue());
        this.setK0(val.k0().doubleValue());
    }

    public double r() {
        return this.r;
    }

    public double i() {
        return this.i;
    }

    public double j() {
        return this.j;
    }

    public double k() {
        return this.k;
    }

    public double l() {
        return this.l;
    }

    public double i0() {
        return this.i0;
    }

    public double j0() {
        return this.j0;
    }

    public double k0() {
        return this.k0;
    }

    @Override
    public void setR(double val) {
        this.r = val;
    }

    @Override
    public void setI(double val) {
        this.i = val;
    }

    @Override
    public void setJ(double val) {
        this.j = val;
    }

    @Override
    public void setK(double val) {
        this.k = val;
    }

    @Override
    public void setL(double val) {
        this.l = val;
    }

    @Override
    public void setI0(double val) {
        this.i0 = val;
    }

    @Override
    public void setJ0(double val) {
        this.j0 = val;
    }

    @Override
    public void setK0(double val) {
        this.k0 = val;
    }

    @Override
    public void set(OctonionFloat64Member other) {
        this.r = other.r;
        this.i = other.i;
        this.j = other.j;
        this.k = other.k;
        this.l = other.l;
        this.i0 = other.i0;
        this.j0 = other.j0;
        this.k0 = other.k0;
    }

    @Override
    public void get(OctonionFloat64Member other) {
        other.r = this.r;
        other.i = this.i;
        other.j = this.j;
        other.k = this.k;
        other.l = this.l;
        other.i0 = this.i0;
        other.j0 = this.j0;
        other.k0 = this.k0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(this.r());
        builder.append(',');
        builder.append(this.i());
        builder.append(',');
        builder.append(this.j());
        builder.append(',');
        builder.append(this.k());
        builder.append(',');
        builder.append(this.l());
        builder.append(',');
        builder.append(this.i0());
        builder.append(',');
        builder.append(this.j0());
        builder.append(',');
        builder.append(this.k0());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public int doubleCount() {
        return 8;
    }

    @Override
    public void fromDoubleArray(double[] arr, int index) {
        this.r = arr[index];
        this.i = arr[index + 1];
        this.j = arr[index + 2];
        this.k = arr[index + 3];
        this.l = arr[index + 4];
        this.i0 = arr[index + 5];
        this.j0 = arr[index + 6];
        this.k0 = arr[index + 7];
    }

    @Override
    public void toDoubleArray(double[] arr, int index) {
        arr[index] = this.r;
        arr[index + 1] = this.i;
        arr[index + 2] = this.j;
        arr[index + 3] = this.k;
        arr[index + 4] = this.l;
        arr[index + 5] = this.i0;
        arr[index + 6] = this.j0;
        arr[index + 7] = this.k0;
    }

    @Override
    public void fromDoubleFile(RandomAccessFile raf) throws IOException {
        this.r = raf.readDouble();
        this.i = raf.readDouble();
        this.j = raf.readDouble();
        this.k = raf.readDouble();
        this.l = raf.readDouble();
        this.i0 = raf.readDouble();
        this.j0 = raf.readDouble();
        this.k0 = raf.readDouble();
    }

    @Override
    public void toDoubleFile(RandomAccessFile raf) throws IOException {
        raf.writeDouble(this.r);
        raf.writeDouble(this.i);
        raf.writeDouble(this.j);
        raf.writeDouble(this.k);
        raf.writeDouble(this.l);
        raf.writeDouble(this.i0);
        raf.writeDouble(this.j0);
        raf.writeDouble(this.k0);
    }

    @Override
    public OctonionFloat64Member allocate() {
        return new OctonionFloat64Member();
    }

    @Override
    public OctonionFloat64Member duplicate() {
        return new OctonionFloat64Member(this);
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(OctonionFloat64Member value) {
        this.get(value);
    }

    @Override
    public void setV(OctonionFloat64Member value) {
        this.set(value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(BigDecimal.valueOf(this.r()), BigDecimal.valueOf(this.i()), BigDecimal.valueOf(this.j()), BigDecimal.valueOf(this.k()), BigDecimal.valueOf(this.l()), BigDecimal.valueOf(this.i0()), BigDecimal.valueOf(this.j0()), BigDecimal.valueOf(this.k0())));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionRepresentation v = rep.getValue();
        this.setR(v.r().doubleValue());
        this.setI(v.i().doubleValue());
        this.setJ(v.j().doubleValue());
        this.setK(v.k().doubleValue());
        this.setL(v.l().doubleValue());
        this.setI0(v.i0().doubleValue());
        this.setJ0(v.j0().doubleValue());
        this.setK0(v.k0().doubleValue());
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.DOUBLE;
    }

    @Override
    public long dimension(int i) {
        return 0L;
    }

    @Override
    public int componentCount() {
        return 8;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.doubleValue());
                } else {
                    this.setI(v.doubleValue());
                }
            } else if (component == 2) {
                this.setJ(v.doubleValue());
            } else {
                this.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.doubleValue());
            } else {
                this.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            this.setJ0(v.doubleValue());
        } else {
            this.setK0(v.doubleValue());
        }
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.doubleValue());
                } else {
                    this.setI(v.doubleValue());
                }
            } else if (component == 2) {
                this.setJ(v.doubleValue());
            } else {
                this.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.doubleValue());
            } else {
                this.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            this.setJ0(v.doubleValue());
        } else {
            this.setK0(v.doubleValue());
        }
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v);
                } else {
                    this.setI(v);
                }
            } else if (component == 2) {
                this.setJ(v);
            } else {
                this.setK(v);
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v);
            } else {
                this.setI0(v);
            }
        } else if (component == 6) {
            this.setJ0(v);
        } else {
            this.setK0(v);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.doubleValue());
                } else {
                    this.setI(v.doubleValue());
                }
            } else if (component == 2) {
                this.setJ(v.doubleValue());
            } else {
                this.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.doubleValue());
            } else {
                this.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            this.setJ0(v.doubleValue());
        } else {
            this.setK0(v.doubleValue());
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    this.setR(v.doubleValue());
                } else {
                    this.setI(v.doubleValue());
                }
            } else if (component == 2) {
                this.setJ(v.doubleValue());
            } else {
                this.setK(v.doubleValue());
            }
        } else if (component < 6) {
            if (component == 4) {
                this.setL(v.doubleValue());
            } else {
                this.setI0(v.doubleValue());
            }
        } else if (component == 6) {
            this.setJ0(v.doubleValue());
        } else {
            this.setK0(v.doubleValue());
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)this.r();
                }
                return (byte)this.i();
            }
            if (component == 2) {
                return (byte)this.j();
            }
            return (byte)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)this.l();
            }
            return (byte)this.i0();
        }
        if (component == 6) {
            return (byte)this.j0();
        }
        return (byte)this.k0();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)this.r();
                }
                return (short)this.i();
            }
            if (component == 2) {
                return (short)this.j();
            }
            return (short)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)this.l();
            }
            return (short)this.i0();
        }
        if (component == 6) {
            return (short)this.j0();
        }
        return (short)this.k0();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)this.r();
                }
                return (int)this.i();
            }
            if (component == 2) {
                return (int)this.j();
            }
            return (int)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)this.l();
            }
            return (int)this.i0();
        }
        if (component == 6) {
            return (int)this.j0();
        }
        return (int)this.k0();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)this.r();
                }
                return (long)this.i();
            }
            if (component == 2) {
                return (long)this.j();
            }
            return (long)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)this.l();
            }
            return (long)this.i0();
        }
        if (component == 6) {
            return (long)this.j0();
        }
        return (long)this.k0();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (float)this.r();
                }
                return (float)this.i();
            }
            if (component == 2) {
                return (float)this.j();
            }
            return (float)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (float)this.l();
            }
            return (float)this.i0();
        }
        if (component == 6) {
            return (float)this.j0();
        }
        return (float)this.k0();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return this.r();
                }
                return this.i();
            }
            if (component == 2) {
                return this.j();
            }
            return this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return this.l();
            }
            return this.i0();
        }
        if (component == 6) {
            return this.j0();
        }
        return this.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r()).toBigInteger();
                }
                return BigDecimal.valueOf(this.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j()).toBigInteger();
            }
            return BigDecimal.valueOf(this.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r());
                }
                return BigDecimal.valueOf(this.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j());
            }
            return BigDecimal.valueOf(this.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l());
            }
            return BigDecimal.valueOf(this.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0());
        }
        return BigDecimal.valueOf(this.k0());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (byte)this.r();
                }
                return (byte)this.i();
            }
            if (component == 2) {
                return (byte)this.j();
            }
            return (byte)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (byte)this.l();
            }
            return (byte)this.i0();
        }
        if (component == 6) {
            return (byte)this.j0();
        }
        return (byte)this.k0();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (short)this.r();
                }
                return (short)this.i();
            }
            if (component == 2) {
                return (short)this.j();
            }
            return (short)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (short)this.l();
            }
            return (short)this.i0();
        }
        if (component == 6) {
            return (short)this.j0();
        }
        return (short)this.k0();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (int)this.r();
                }
                return (int)this.i();
            }
            if (component == 2) {
                return (int)this.j();
            }
            return (int)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (int)this.l();
            }
            return (int)this.i0();
        }
        if (component == 6) {
            return (int)this.j0();
        }
        return (int)this.k0();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (long)this.r();
                }
                return (long)this.i();
            }
            if (component == 2) {
                return (long)this.j();
            }
            return (long)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (long)this.l();
            }
            return (long)this.i0();
        }
        if (component == 6) {
            return (long)this.j0();
        }
        return (long)this.k0();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return (float)this.r();
                }
                return (float)this.i();
            }
            if (component == 2) {
                return (float)this.j();
            }
            return (float)this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return (float)this.l();
            }
            return (float)this.i0();
        }
        if (component == 6) {
            return (float)this.j0();
        }
        return (float)this.k0();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return this.r();
                }
                return this.i();
            }
            if (component == 2) {
                return this.j();
            }
            return this.k();
        }
        if (component < 6) {
            if (component == 4) {
                return this.l();
            }
            return this.i0();
        }
        if (component == 6) {
            return this.j0();
        }
        return this.k0();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r()).toBigInteger();
                }
                return BigDecimal.valueOf(this.i()).toBigInteger();
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j()).toBigInteger();
            }
            return BigDecimal.valueOf(this.k()).toBigInteger();
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i0()).toBigInteger();
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k0()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 7;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        if (component < 4) {
            if (component < 2) {
                if (component == 0) {
                    return BigDecimal.valueOf(this.r());
                }
                return BigDecimal.valueOf(this.i());
            }
            if (component == 2) {
                return BigDecimal.valueOf(this.j());
            }
            return BigDecimal.valueOf(this.k());
        }
        if (component < 6) {
            if (component == 4) {
                return BigDecimal.valueOf(this.l());
            }
            return BigDecimal.valueOf(this.i0());
        }
        if (component == 6) {
            return BigDecimal.valueOf(this.j0());
        }
        return BigDecimal.valueOf(this.k0());
    }

    @Override
    public void primitiveInit() {
        this.k0 = 0.0;
        this.j0 = 0.0;
        this.i0 = 0.0;
        this.l = 0.0;
        this.k = 0.0;
        this.j = 0.0;
        this.i = 0.0;
        this.r = 0.0;
    }

    @Override
    public void setR(Float64Member val) {
        this.setR(val.v());
    }

    @Override
    public void setI(Float64Member val) {
        this.setI(val.v());
    }

    @Override
    public void setJ(Float64Member val) {
        this.setJ(val.v());
    }

    @Override
    public void setK(Float64Member val) {
        this.setK(val.v());
    }

    @Override
    public void setL(Float64Member val) {
        this.setL(val.v());
    }

    @Override
    public void setI0(Float64Member val) {
        this.setI0(val.v());
    }

    @Override
    public void setJ0(Float64Member val) {
        this.setJ0(val.v());
    }

    @Override
    public void setK0(Float64Member val) {
        this.setK0(val.v());
    }

    @Override
    public void getR(Float64Member v) {
        v.setV(this.r);
    }

    @Override
    public void getI(Float64Member v) {
        v.setV(this.i);
    }

    @Override
    public void getJ(Float64Member v) {
        v.setV(this.j);
    }

    @Override
    public void getK(Float64Member v) {
        v.setV(this.k);
    }

    @Override
    public void getL(Float64Member v) {
        v.setV(this.l);
    }

    @Override
    public void getI0(Float64Member v) {
        v.setV(this.i0);
    }

    @Override
    public void getJ0(Float64Member v) {
        v.setV(this.j0);
    }

    @Override
    public void getK0(Float64Member v) {
        v.setV(this.k0);
    }
}

