/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.quaternion;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.PowerAny;
import nom.bdezonia.zorbage.algorithm.QuaternionNumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.QuaternionConstants;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.SkewField;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float64.quaternion.QuaternionFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat64Algebra
implements SkewField<QuaternionFloat64Algebra, QuaternionFloat64Member>,
RealConstants<QuaternionFloat64Member>,
ImaginaryConstants<QuaternionFloat64Member>,
QuaternionConstants<QuaternionFloat64Member>,
Norm<QuaternionFloat64Member, Float64Member>,
Conjugate<QuaternionFloat64Member>,
Infinite<QuaternionFloat64Member>,
NaN<QuaternionFloat64Member>,
Rounding<Float64Member, QuaternionFloat64Member>,
Random<QuaternionFloat64Member>,
Exponential<QuaternionFloat64Member>,
Trigonometric<QuaternionFloat64Member>,
Hyperbolic<QuaternionFloat64Member>,
Power<QuaternionFloat64Member>,
Roots<QuaternionFloat64Member>,
RealUnreal<QuaternionFloat64Member, Float64Member>,
Scale<QuaternionFloat64Member, QuaternionFloat64Member>,
ScaleByHighPrec<QuaternionFloat64Member>,
ScaleByRational<QuaternionFloat64Member>,
ScaleByDouble<QuaternionFloat64Member>,
ScaleComponents<QuaternionFloat64Member, Float64Member>,
Tolerance<Float64Member, QuaternionFloat64Member> {
    private static final QuaternionFloat64Member ZERO = new QuaternionFloat64Member(0.0, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member ONE_THIRD = new QuaternionFloat64Member(0.3333333333333333, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member ONE_HALF = new QuaternionFloat64Member(0.5, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member ONE = new QuaternionFloat64Member(1.0, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member TWO = new QuaternionFloat64Member(2.0, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member E = new QuaternionFloat64Member(Math.E, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member PI = new QuaternionFloat64Member(Math.PI, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member GAMMA = new QuaternionFloat64Member(0.5772156649015329, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member PHI = new QuaternionFloat64Member(1.618033988749895, 0.0, 0.0, 0.0);
    private static final QuaternionFloat64Member I = new QuaternionFloat64Member(0.0, 1.0, 0.0, 0.0);
    private static final QuaternionFloat64Member J = new QuaternionFloat64Member(0.0, 0.0, 1.0, 0.0);
    private static final QuaternionFloat64Member K = new QuaternionFloat64Member(0.0, 0.0, 0.0, 1.0);
    private final Procedure1<QuaternionFloat64Member> UNITY = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> MUL = new Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            double r = a.r() * b.r() - a.i() * b.i() - a.j() * b.j() - a.k() * b.k();
            double i = a.r() * b.i() + a.i() * b.r() + a.j() * b.k() - a.k() * b.j();
            double j = a.r() * b.j() - a.i() * b.k() + a.j() * b.r() + a.k() * b.i();
            double k = a.r() * b.k() + a.i() * b.j() - a.j() * b.i() + a.k() * b.r();
            c.setR(r);
            c.setI(i);
            c.setJ(j);
            c.setK(k);
        }
    };
    private final Procedure3<Integer, QuaternionFloat64Member, QuaternionFloat64Member> POWER = new Procedure3<Integer, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(Integer power, QuaternionFloat64Member a, QuaternionFloat64Member b) {
            PowerAny.compute(G.QDBL, power, a, b);
        }
    };
    private final Procedure1<QuaternionFloat64Member> ZER = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> NEG = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Algebra.this.subtract().call(ZERO, a, b);
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> ADD = new Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            c.setR(a.r() + b.r());
            c.setI(a.i() + b.i());
            c.setJ(a.j() + b.j());
            c.setK(a.k() + b.k());
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> SUB = new Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            c.setR(a.r() - b.r());
            c.setI(a.i() - b.i());
            c.setJ(a.j() - b.j());
            c.setK(a.k() - b.k());
        }
    };
    private final Function2<Boolean, QuaternionFloat64Member, QuaternionFloat64Member> EQ = new Function2<Boolean, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public Boolean call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            return a.r() == b.r() && a.i() == b.i() && a.j() == b.j() && a.k() == b.k();
        }
    };
    private final Function2<Boolean, QuaternionFloat64Member, QuaternionFloat64Member> NEQ = new Function2<Boolean, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public Boolean call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            return QuaternionFloat64Algebra.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> ASSIGN = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member from, QuaternionFloat64Member to) {
            to.set(from);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> INV = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Member c = new QuaternionFloat64Member();
            QuaternionFloat64Member scale = new QuaternionFloat64Member();
            Float64Member nval = new Float64Member();
            QuaternionFloat64Algebra.this.norm().call(a, nval);
            scale.setR(1.0 / (nval.v() * nval.v()));
            QuaternionFloat64Algebra.this.conjugate().call(a, c);
            QuaternionFloat64Algebra.this.multiply().call(scale, c, b);
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> DIVIDE = new Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            QuaternionFloat64Member tmp = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.invert().call(b, tmp);
            QuaternionFloat64Algebra.this.multiply().call(a, tmp, c);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> CONJ = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            b.setR(a.r());
            b.setI(-a.i());
            b.setJ(-a.j());
            b.setK(-a.k());
        }
    };
    private final Procedure2<QuaternionFloat64Member, Float64Member> NORM = new Procedure2<QuaternionFloat64Member, Float64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, Float64Member b) {
            double max = Math.max(Math.abs(a.r()), Math.abs(a.i()));
            max = Math.max(max, Math.abs(a.j()));
            if ((max = Math.max(max, Math.abs(a.k()))) == 0.0) {
                b.setV(0.0);
            } else {
                double sum = a.r() / max * (a.r() / max);
                sum += a.i() / max * (a.i() / max);
                sum += a.j() / max * (a.j() / max);
                b.setV(max * Math.sqrt(sum += a.k() / max * (a.k() / max)));
            }
        }
    };
    private final Procedure1<QuaternionFloat64Member> PI_ = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<QuaternionFloat64Member> E_ = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<QuaternionFloat64Member> GAMMA_ = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<QuaternionFloat64Member> PHI_ = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure1<QuaternionFloat64Member> I_ = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(I, a);
        }
    };
    private final Procedure1<QuaternionFloat64Member> J_ = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(J, a);
        }
    };
    private final Procedure1<QuaternionFloat64Member> K_ = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            QuaternionFloat64Algebra.this.assign().call(K, a);
        }
    };
    private Procedure4<Round.Mode, Float64Member, QuaternionFloat64Member, QuaternionFloat64Member> ROUND = new Procedure4<Round.Mode, Float64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Float64Member tmp = new Float64Member();
            tmp.setV(a.r());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setR(tmp.v());
            tmp.setV(a.i());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setI(tmp.v());
            tmp.setV(a.j());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setJ(tmp.v());
            tmp.setV(a.k());
            Round.compute(G.DBL, mode, delta, tmp, tmp);
            b.setK(tmp.v());
        }
    };
    private Function1<Boolean, QuaternionFloat64Member> ISNAN = new Function1<Boolean, QuaternionFloat64Member>(){

        @Override
        public Boolean call(QuaternionFloat64Member a) {
            return Double.isNaN(a.r()) || Double.isNaN(a.i()) || Double.isNaN(a.j()) || Double.isNaN(a.k());
        }
    };
    private final Procedure1<QuaternionFloat64Member> NAN = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            a.setR(Double.NaN);
            a.setI(Double.NaN);
            a.setJ(Double.NaN);
            a.setK(Double.NaN);
        }
    };
    private Function1<Boolean, QuaternionFloat64Member> ISINF = new Function1<Boolean, QuaternionFloat64Member>(){

        @Override
        public Boolean call(QuaternionFloat64Member a) {
            return QuaternionFloat64Algebra.this.isNaN().call(a) == false && (Double.isInfinite(a.r()) || Double.isInfinite(a.i()) || Double.isInfinite(a.j()) || Double.isInfinite(a.k()));
        }
    };
    private final Procedure1<QuaternionFloat64Member> INF = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            a.setR(Double.POSITIVE_INFINITY);
            a.setI(Double.POSITIVE_INFINITY);
            a.setJ(Double.POSITIVE_INFINITY);
            a.setK(Double.POSITIVE_INFINITY);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> EXP = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            QuaternionFloat64Member tmp = new QuaternionFloat64Member();
            double u = FastMath.exp((double)a.r());
            QuaternionFloat64Algebra.this.unreal().call(a, tmp);
            QuaternionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinc().call(z, z2);
            double w = z2.v();
            b.setR(u * FastMath.cos((double)z.v()));
            b.setI(u * w * a.i());
            b.setJ(u * w * a.j());
            b.setK(u * w * a.k());
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> LOG = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Float64Member norm = new Float64Member();
            Float64Member term = new Float64Member();
            Float64Member v1 = new Float64Member();
            Float64Member v2 = new Float64Member();
            Float64Member v3 = new Float64Member();
            QuaternionFloat64Algebra.this.norm().call(a, norm);
            Float64Member multiplier = new Float64Member(a.r() / norm.v());
            v1.setV(a.i() * multiplier.v());
            v2.setV(a.j() * multiplier.v());
            v3.setV(a.k() * multiplier.v());
            G.DBL.acos().call(multiplier, term);
            b.setR(Math.log(norm.v()));
            b.setI(v1.v() * term.v());
            b.setJ(v2.v() * term.v());
            b.setK(v3.v() * term.v());
        }
    };
    private final Procedure1<QuaternionFloat64Member> RAND = new Procedure1<QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setR(rng.nextDouble());
            a.setI(rng.nextDouble());
            a.setJ(rng.nextDouble());
            a.setK(rng.nextDouble());
        }
    };
    private final Procedure2<QuaternionFloat64Member, Float64Member> REAL = new Procedure2<QuaternionFloat64Member, Float64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, Float64Member b) {
            b.setV(a.r());
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> UNREAL = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Algebra.this.assign().call(a, b);
            b.setR(0.0);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> SINH = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Member negA = new QuaternionFloat64Member();
            QuaternionFloat64Member sum = new QuaternionFloat64Member();
            QuaternionFloat64Member tmp1 = new QuaternionFloat64Member();
            QuaternionFloat64Member tmp2 = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.negate().call(a, negA);
            QuaternionFloat64Algebra.this.exp().call(a, tmp1);
            QuaternionFloat64Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat64Algebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionFloat64Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> COSH = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Member negA = new QuaternionFloat64Member();
            QuaternionFloat64Member sum = new QuaternionFloat64Member();
            QuaternionFloat64Member tmp1 = new QuaternionFloat64Member();
            QuaternionFloat64Member tmp2 = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.negate().call(a, negA);
            QuaternionFloat64Algebra.this.exp().call(a, tmp1);
            QuaternionFloat64Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat64Algebra.this.add().call(tmp1, tmp2, sum);
            QuaternionFloat64Algebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> SINHANDCOSH = new Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member s, QuaternionFloat64Member c) {
            QuaternionFloat64Member negA = new QuaternionFloat64Member();
            QuaternionFloat64Member sum = new QuaternionFloat64Member();
            QuaternionFloat64Member tmp1 = new QuaternionFloat64Member();
            QuaternionFloat64Member tmp2 = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.negate().call(a, negA);
            QuaternionFloat64Algebra.this.exp().call(a, tmp1);
            QuaternionFloat64Algebra.this.exp().call(negA, tmp2);
            QuaternionFloat64Algebra.this.subtract().call(tmp1, tmp2, sum);
            QuaternionFloat64Algebra.this.divide().call(sum, TWO, s);
            QuaternionFloat64Algebra.this.add().call(tmp1, tmp2, sum);
            QuaternionFloat64Algebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> TANH = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Member s = new QuaternionFloat64Member();
            QuaternionFloat64Member c = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.sinhAndCosh().call(a, s, c);
            QuaternionFloat64Algebra.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> SIN = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            QuaternionFloat64Member tmp = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.unreal().call(a, tmp);
            QuaternionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            b.setR(sin * cosh);
            b.setI(ws * a.i());
            b.setJ(ws * a.j());
            b.setK(ws * a.k());
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> COS = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            QuaternionFloat64Member tmp = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.unreal().call(a, tmp);
            QuaternionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double wc = -sin * sinhc_pi;
            b.setR(cos * cosh);
            b.setI(wc * a.i());
            b.setJ(wc * a.j());
            b.setK(wc * a.k());
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> SINANDCOS = new Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member s, QuaternionFloat64Member c) {
            Float64Member z = new Float64Member();
            Float64Member z2 = new Float64Member();
            QuaternionFloat64Member tmp = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.unreal().call(a, tmp);
            QuaternionFloat64Algebra.this.norm().call(tmp, z);
            G.DBL.sinch().call(z, z2);
            double cos = FastMath.cos((double)a.r());
            double sin = FastMath.sin((double)a.r());
            double sinhc_pi = z2.v();
            double cosh = FastMath.cosh((double)z.v());
            double ws = cos * sinhc_pi;
            double wc = -sin * sinhc_pi;
            s.setR(sin * cosh);
            s.setI(ws * a.i());
            s.setJ(ws * a.j());
            s.setK(ws * a.k());
            c.setR(cos * cosh);
            c.setI(wc * a.i());
            c.setJ(wc * a.j());
            c.setK(wc * a.k());
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> TAN = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Member sin = new QuaternionFloat64Member();
            QuaternionFloat64Member cos = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.sinAndCos().call(a, sin, cos);
            QuaternionFloat64Algebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> POW = new Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            QuaternionFloat64Member logA = new QuaternionFloat64Member();
            QuaternionFloat64Member bLogA = new QuaternionFloat64Member();
            QuaternionFloat64Algebra.this.log().call(a, logA);
            QuaternionFloat64Algebra.this.multiply().call(b, logA, bLogA);
            QuaternionFloat64Algebra.this.exp().call(bLogA, c);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> SINCH = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Sinch.compute(G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> SINCHPI = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Sinchpi.compute(G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> SINC = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Sinc.compute(G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> SINCPI = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            Sincpi.compute(G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> SQRT = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Algebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> CBRT = new Procedure2<QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64Member b) {
            QuaternionFloat64Algebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat64Member> ISZERO = new Function1<Boolean, QuaternionFloat64Member>(){

        @Override
        public Boolean call(QuaternionFloat64Member a) {
            return a.r() == 0.0 && a.i() == 0.0 && a.j() == 0.0 && a.k() == 0.0;
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionFloat64Member, QuaternionFloat64Member> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.r()));
            c.setR(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.i()));
            c.setI(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.j()));
            c.setJ(tmp.doubleValue());
            tmp = a.v().multiply(BigDecimal.valueOf(b.k()));
            c.setK(tmp.doubleValue());
        }
    };
    private final Procedure3<RationalMember, QuaternionFloat64Member, QuaternionFloat64Member> SBR = new Procedure3<RationalMember, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(RationalMember a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.r());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.i());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.j());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setJ(tmp.doubleValue());
            tmp = BigDecimal.valueOf(b.k());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setK(tmp.doubleValue());
        }
    };
    private final Procedure3<Double, QuaternionFloat64Member, QuaternionFloat64Member> SBD = new Procedure3<Double, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(Double a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            c.setR(a * b.r());
            c.setI(a * b.i());
            c.setJ(a * b.j());
            c.setK(a * b.k());
        }
    };
    private final Procedure3<Float64Member, QuaternionFloat64Member, QuaternionFloat64Member> SC = new Procedure3<Float64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public void call(Float64Member a, QuaternionFloat64Member b, QuaternionFloat64Member c) {
            c.setR(a.v() * b.r());
            c.setI(a.v() * b.i());
            c.setJ(a.v() * b.j());
            c.setK(a.v() * b.k());
        }
    };
    private final Function3<Boolean, Float64Member, QuaternionFloat64Member, QuaternionFloat64Member> WITHIN = new Function3<Boolean, Float64Member, QuaternionFloat64Member, QuaternionFloat64Member>(){

        @Override
        public Boolean call(Float64Member tol, QuaternionFloat64Member a, QuaternionFloat64Member b) {
            return QuaternionNumberWithin.compute(G.DBL, tol, a, b);
        }
    };

    @Override
    public Procedure1<QuaternionFloat64Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat64Member, QuaternionFloat64Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, QuaternionFloat64Member, QuaternionFloat64Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat64Member, QuaternionFloat64Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public QuaternionFloat64Member construct() {
        return new QuaternionFloat64Member();
    }

    @Override
    public QuaternionFloat64Member construct(QuaternionFloat64Member other) {
        return new QuaternionFloat64Member(other);
    }

    @Override
    public QuaternionFloat64Member construct(String s) {
        return new QuaternionFloat64Member(s);
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> I() {
        return this.I_;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> J() {
        return this.J_;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> K() {
        return this.K_;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, QuaternionFloat64Member, QuaternionFloat64Member> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> log() {
        return this.LOG;
    }

    @Override
    public Procedure1<QuaternionFloat64Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, Float64Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<QuaternionFloat64Member, QuaternionFloat64Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64Member, QuaternionFloat64Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat64Member, QuaternionFloat64Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat64Member, QuaternionFloat64Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat64Member, QuaternionFloat64Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float64Member, QuaternionFloat64Member, QuaternionFloat64Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float64Member, QuaternionFloat64Member, QuaternionFloat64Member> within() {
        return this.WITHIN;
    }
}

