/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.quaternion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorLikeProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.quaternion.QuaternionFloat64Algebra;
import nom.bdezonia.zorbage.type.data.float64.quaternion.QuaternionFloat64CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float64.quaternion.QuaternionFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat64CartesianTensorProduct
implements TensorLikeProduct<QuaternionFloat64CartesianTensorProduct, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64Algebra, QuaternionFloat64Member>,
ConstructibleNdLong<QuaternionFloat64CartesianTensorProductMember>,
Norm<QuaternionFloat64CartesianTensorProductMember, Float64Member>,
Scale<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64Member>,
Rounding<Float64Member, QuaternionFloat64CartesianTensorProductMember>,
Infinite<QuaternionFloat64CartesianTensorProductMember>,
NaN<QuaternionFloat64CartesianTensorProductMember>,
ScaleByHighPrec<QuaternionFloat64CartesianTensorProductMember>,
ScaleByRational<QuaternionFloat64CartesianTensorProductMember>,
ScaleByDouble<QuaternionFloat64CartesianTensorProductMember>,
Tolerance<Float64Member, QuaternionFloat64CartesianTensorProductMember> {
    private final Function2<Boolean, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> EQ = new Function2<Boolean, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QDBL, G.DBL.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> NEQ = new Function2<Boolean, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            return QuaternionFloat64CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> ASSIGN = new Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember from, QuaternionFloat64CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.QDBL, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<QuaternionFloat64CartesianTensorProductMember> ZER = new Procedure1<QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> NEG = new Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QDBL, G.QDBL.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> ADDEL = new Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b, QuaternionFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QDBL, G.QDBL.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> SUBEL = new Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b, QuaternionFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QDBL, G.QDBL.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<QuaternionFloat64CartesianTensorProductMember, Float64Member> NORM = new Procedure2<QuaternionFloat64CartesianTensorProductMember, Float64Member>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, Float64Member b) {
            TensorNorm.compute(G.QDBL, G.DBL, a.rawData(), b);
        }
    };
    private final Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> CONJ = new Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.QDBL, G.QDBL.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> SCALE = new Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64Member scalar, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.QDBL, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> ADDSCALAR = new Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64Member scalar, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.QDBL, scalar, G.QDBL.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> SUBSCALAR = new Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64Member scalar, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            QuaternionFloat64Member tmp = G.QDBL.construct();
            G.QDBL.negate().call(scalar, tmp);
            QuaternionFloat64CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> MULEL = new Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b, QuaternionFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QDBL, G.QDBL.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> DIVIDEEL = new Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b, QuaternionFloat64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.QDBL, G.QDBL.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> MUL = new Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b, QuaternionFloat64CartesianTensorProductMember c) {
            QuaternionFloat64CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorContract.compute(G.QDBL, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> SEMI = new Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.QDBL_TEN, G.QDBL, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> COMMA = new Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.QDBL_TEN, G.QDBL, index, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> POWER = new Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorPower.compute(G.QDBL_TEN, power, a, b);
        }
    };
    private final Procedure1<QuaternionFloat64CartesianTensorProductMember> UNITY = new Procedure1<QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember result) {
            TensorUnity.compute(G.QDBL_TEN, G.QDBL, result);
        }
    };
    private final Function1<Boolean, QuaternionFloat64CartesianTensorProductMember> ISNAN = new Function1<Boolean, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat64CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.QDBL, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat64CartesianTensorProductMember> NAN = new Procedure1<QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a) {
            FillNaN.compute(G.QDBL, a);
        }
    };
    private final Function1<Boolean, QuaternionFloat64CartesianTensorProductMember> ISINF = new Function1<Boolean, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat64CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.QDBL, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat64CartesianTensorProductMember> INF = new Procedure1<QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a) {
            FillInfinite.compute(G.QDBL, a);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorRound.compute(G.QDBL_TEN, G.QDBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat64CartesianTensorProductMember> ISZERO = new Function1<Boolean, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(QuaternionFloat64CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.QDBL, a.rawData());
        }
    };
    private final Procedure3<RationalMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> SBR = new Procedure3<RationalMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.QDBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> SBD = new Procedure3<Double, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.QDBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.QDBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64Member tol, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.QDBL, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> MULBYSCALAR = new Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64Member factor, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            QuaternionFloat64CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64Member factor, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            QuaternionFloat64Member invFactor = G.QDBL.construct();
            G.QDBL.invert().call(factor, invFactor);
            QuaternionFloat64CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> RAISE = new Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> LOWER = new Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            QuaternionFloat64CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b, QuaternionFloat64CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            QuaternionFloat64CartesianTensorProductMember tmp = QuaternionFloat64CartesianTensorProduct.this.construct();
            QuaternionFloat64CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            QuaternionFloat64CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> OUTER = new Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember>(){

        @Override
        public void call(QuaternionFloat64CartesianTensorProductMember a, QuaternionFloat64CartesianTensorProductMember b, QuaternionFloat64CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.QDBL_TEN, G.QDBL, a, b, c);
        }
    };

    @Override
    public QuaternionFloat64CartesianTensorProductMember construct() {
        return new QuaternionFloat64CartesianTensorProductMember();
    }

    @Override
    public QuaternionFloat64CartesianTensorProductMember construct(QuaternionFloat64CartesianTensorProductMember other) {
        return new QuaternionFloat64CartesianTensorProductMember(other);
    }

    @Override
    public QuaternionFloat64CartesianTensorProductMember construct(String s) {
        return new QuaternionFloat64CartesianTensorProductMember(s);
    }

    @Override
    public QuaternionFloat64CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new QuaternionFloat64CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<QuaternionFloat64CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<QuaternionFloat64CartesianTensorProductMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat64CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat64CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat64CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember, QuaternionFloat64CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

