/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.quaternion;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.quaternion.QuaternionFloat64Algebra;
import nom.bdezonia.zorbage.type.data.float64.quaternion.QuaternionFloat64MatrixMember;
import nom.bdezonia.zorbage.type.data.float64.quaternion.QuaternionFloat64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class QuaternionFloat64Matrix
implements RingWithUnity<QuaternionFloat64Matrix, QuaternionFloat64MatrixMember>,
MatrixRing<QuaternionFloat64Matrix, QuaternionFloat64MatrixMember, QuaternionFloat64Algebra, QuaternionFloat64Member>,
Constructible2dLong<QuaternionFloat64MatrixMember>,
Rounding<Float64Member, QuaternionFloat64MatrixMember>,
Norm<QuaternionFloat64MatrixMember, Float64Member>,
DirectProduct<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>,
Exponential<QuaternionFloat64MatrixMember>,
Trigonometric<QuaternionFloat64MatrixMember>,
Hyperbolic<QuaternionFloat64MatrixMember>,
RealConstants<QuaternionFloat64MatrixMember>,
Infinite<QuaternionFloat64MatrixMember>,
NaN<QuaternionFloat64MatrixMember>,
ScaleByHighPrec<QuaternionFloat64MatrixMember>,
ScaleByRational<QuaternionFloat64MatrixMember>,
ScaleByDouble<QuaternionFloat64MatrixMember>,
Tolerance<Float64Member, QuaternionFloat64MatrixMember> {
    private final Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> MUL = new Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            MatrixMultiply.compute(G.QDBL, a, b, c);
        }
    };
    private final Procedure3<Integer, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> POWER = new Procedure3<Integer, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(Integer power, QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            MatrixPower.compute(power, G.QDBL, G.QDBL_RMOD, G.QDBL_MAT, a, b);
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> ZER = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> NEG = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            MatrixNegate.compute(G.QDBL, a, b);
        }
    };
    private final Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> ADD = new Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            MatrixAddition.compute(G.QDBL, a, b, c);
        }
    };
    private final Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SUB = new Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            MatrixSubtraction.compute(G.QDBL, a, b, c);
        }
    };
    private final Function2<Boolean, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> EQ = new Function2<Boolean, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            return MatrixEqual.compute(G.QDBL, a, b);
        }
    };
    private final Function2<Boolean, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> NEQ = new Function2<Boolean, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            return QuaternionFloat64Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> ASSIGN = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember from, QuaternionFloat64MatrixMember to) {
            MatrixAssign.compute(G.QDBL, from, to);
        }
    };
    private Procedure2<QuaternionFloat64MatrixMember, Float64Member> NORM = new Procedure2<QuaternionFloat64MatrixMember, Float64Member>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, Float64Member b) {
            MatrixSpectralNorm.compute(G.QDBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> ROUND = new Procedure4<Round.Mode, Float64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            MatrixRound.compute(G.QDBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat64MatrixMember> ISNAN = new Function1<Boolean, QuaternionFloat64MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat64MatrixMember a) {
            return SequenceIsNan.compute(G.QDBL, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> NAN = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            FillNaN.compute(G.QDBL, a);
        }
    };
    private final Function1<Boolean, QuaternionFloat64MatrixMember> ISINF = new Function1<Boolean, QuaternionFloat64MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat64MatrixMember a) {
            return SequenceIsInf.compute(G.QDBL, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> INF = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            FillInfinite.compute(G.QDBL, a);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> CONJ = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            MatrixConjugate.compute(G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> TRANSP = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            MatrixTranspose.compute(G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> CONJTRANSP = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            QuaternionFloat64MatrixMember tmp = new QuaternionFloat64MatrixMember();
            QuaternionFloat64Matrix.this.conjugate().call(a, tmp);
            QuaternionFloat64Matrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64Member> DET = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64Member>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64Member b) {
            MatrixDeterminant.compute(G.QDBL_MAT, G.QDBL, a, b);
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> UNITY = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            MatrixUnity.compute(G.QDBL, a);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> INV = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            MatrixInvert.compute(G.QDBL, G.QDBL_RMOD, G.QDBL_MAT, a, b);
        }
    };
    private final Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> DIVIDE = new Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            QuaternionFloat64MatrixMember invB = QuaternionFloat64Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            QuaternionFloat64Matrix.this.invert().call(b, invB);
            QuaternionFloat64Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> DP = new Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember in1, QuaternionFloat64MatrixMember in2, QuaternionFloat64MatrixMember out) {
            MatrixDirectProduct.compute(G.QDBL, in1, in2, out);
        }
    };
    private final Procedure3<QuaternionFloat64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SCALE = new Procedure3<QuaternionFloat64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64Member a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            MatrixScale.compute(G.QDBL, a, b, c);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SINH = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.QDBL_MAT, G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> COSH = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.QDBL_MAT, G.QDBL, a, b);
        }
    };
    private final Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SINHANDCOSH = new Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember s, QuaternionFloat64MatrixMember c) {
            QuaternionFloat64Matrix.this.sinh().call(a, s);
            QuaternionFloat64Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> TANH = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            QuaternionFloat64MatrixMember s = QuaternionFloat64Matrix.this.construct();
            QuaternionFloat64MatrixMember c = QuaternionFloat64Matrix.this.construct();
            QuaternionFloat64Matrix.this.sinhAndCosh().call(a, s, c);
            QuaternionFloat64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SINCH = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            Sinch.compute(G.QDBL_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SINCHPI = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            Sinchpi.compute(G.QDBL_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SIN = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            TaylorEstimateSin.compute(18, G.QDBL_MAT, G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> COS = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            TaylorEstimateCos.compute(18, G.QDBL_MAT, G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> TAN = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            QuaternionFloat64MatrixMember s = QuaternionFloat64Matrix.this.construct();
            QuaternionFloat64MatrixMember c = QuaternionFloat64Matrix.this.construct();
            QuaternionFloat64Matrix.this.sinAndCos().call(a, s, c);
            QuaternionFloat64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SINANDCOS = new Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember s, QuaternionFloat64MatrixMember c) {
            QuaternionFloat64Matrix.this.sin().call(a, s);
            QuaternionFloat64Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SINC = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            Sinc.compute(G.QDBL_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SINCPI = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            Sincpi.compute(G.QDBL_MAT, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> EXP = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            TaylorEstimateExp.compute(35, G.QDBL_MAT, G.QDBL, a, b);
        }
    };
    private final Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> LOG = new Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            TaylorEstimateLog.compute(8, G.QDBL_MAT, G.QDBL, a, b);
        }
    };
    private final Function1<Boolean, QuaternionFloat64MatrixMember> ISZERO = new Function1<Boolean, QuaternionFloat64MatrixMember>(){

        @Override
        public Boolean call(QuaternionFloat64MatrixMember a) {
            return SequenceIsZero.compute(G.QDBL, a.rawData());
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> PI = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            QuaternionFloat64Member pi = G.QDBL.construct();
            G.QDBL.PI().call(pi);
            MatrixConstantDiagonal.compute(G.QDBL, pi, a);
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> E = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            QuaternionFloat64Member e = G.QDBL.construct();
            G.QDBL.E().call(e);
            MatrixConstantDiagonal.compute(G.QDBL, e, a);
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> PHI = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            QuaternionFloat64Member phi = G.QDBL.construct();
            G.QDBL.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.QDBL, phi, a);
        }
    };
    private final Procedure1<QuaternionFloat64MatrixMember> GAMMA = new Procedure1<QuaternionFloat64MatrixMember>(){

        @Override
        public void call(QuaternionFloat64MatrixMember a) {
            QuaternionFloat64Member gamma = G.QDBL.construct();
            G.QDBL.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.QDBL, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SBHP = new Procedure3<HighPrecisionMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.QDBL, a, b, c);
        }
    };
    private Procedure3<RationalMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SBR = new Procedure3<RationalMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(RationalMember a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            MatrixScaleByRational.compute(G.QDBL, a, b, c);
        }
    };
    private Procedure3<Double, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> SBD = new Procedure3<Double, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public void call(Double a, QuaternionFloat64MatrixMember b, QuaternionFloat64MatrixMember c) {
            MatrixScaleByDouble.compute(G.QDBL, a, b, c);
        }
    };
    private final Function3<Boolean, Float64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> WITHIN = new Function3<Boolean, Float64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember>(){

        @Override
        public Boolean call(Float64Member tol, QuaternionFloat64MatrixMember a, QuaternionFloat64MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.QDBL, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public QuaternionFloat64MatrixMember construct() {
        return new QuaternionFloat64MatrixMember();
    }

    @Override
    public QuaternionFloat64MatrixMember construct(QuaternionFloat64MatrixMember other) {
        return new QuaternionFloat64MatrixMember(other);
    }

    @Override
    public QuaternionFloat64MatrixMember construct(String s) {
        return new QuaternionFloat64MatrixMember(s);
    }

    @Override
    public QuaternionFloat64MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new QuaternionFloat64MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<QuaternionFloat64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, QuaternionFloat64MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<QuaternionFloat64MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float64Member, QuaternionFloat64MatrixMember, QuaternionFloat64MatrixMember> within() {
        return this.WITHIN;
    }
}

