/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.quaternion;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.GetQuaternion;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.SetQuaternion;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.ctor.Duplicatable;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.coder.DoubleCoder;

public final class QuaternionFloat64Member
implements NumberMember<QuaternionFloat64Member>,
DoubleCoder,
Allocatable<QuaternionFloat64Member>,
Duplicatable<QuaternionFloat64Member>,
Settable<QuaternionFloat64Member>,
Gettable<QuaternionFloat64Member>,
PrimitiveConversion,
UniversalRepresentation,
SetQuaternion<Float64Member>,
GetQuaternion<Float64Member> {
    private double r;
    private double i;
    private double j;
    private double k;

    public QuaternionFloat64Member() {
        this.primitiveInit();
    }

    public QuaternionFloat64Member(double r, double i, double j, double k) {
        this.setR(r);
        this.setI(i);
        this.setJ(j);
        this.setK(k);
    }

    public QuaternionFloat64Member(QuaternionFloat64Member value) {
        this.set(value);
    }

    public QuaternionFloat64Member(String value) {
        TensorStringRepresentation rep = new TensorStringRepresentation(value);
        OctonionRepresentation val = rep.firstValue();
        this.setR(val.r().doubleValue());
        this.setI(val.i().doubleValue());
        this.setJ(val.j().doubleValue());
        this.setK(val.k().doubleValue());
    }

    public double r() {
        return this.r;
    }

    public double i() {
        return this.i;
    }

    public double j() {
        return this.j;
    }

    public double k() {
        return this.k;
    }

    @Override
    public void setR(double val) {
        this.r = val;
    }

    @Override
    public void setI(double val) {
        this.i = val;
    }

    @Override
    public void setJ(double val) {
        this.j = val;
    }

    @Override
    public void setK(double val) {
        this.k = val;
    }

    @Override
    public void set(QuaternionFloat64Member other) {
        this.r = other.r;
        this.i = other.i;
        this.j = other.j;
        this.k = other.k;
    }

    @Override
    public void get(QuaternionFloat64Member other) {
        other.r = this.r;
        other.i = this.i;
        other.j = this.j;
        other.k = this.k;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(this.r());
        builder.append(',');
        builder.append(this.i());
        builder.append(',');
        builder.append(this.j());
        builder.append(',');
        builder.append(this.k());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public int doubleCount() {
        return 4;
    }

    @Override
    public void fromDoubleArray(double[] arr, int index) {
        this.r = arr[index];
        this.i = arr[index + 1];
        this.j = arr[index + 2];
        this.k = arr[index + 3];
    }

    @Override
    public void toDoubleArray(double[] arr, int index) {
        arr[index] = this.r;
        arr[index + 1] = this.i;
        arr[index + 2] = this.j;
        arr[index + 3] = this.k;
    }

    @Override
    public void fromDoubleFile(RandomAccessFile raf) throws IOException {
        this.r = raf.readDouble();
        this.i = raf.readDouble();
        this.j = raf.readDouble();
        this.k = raf.readDouble();
    }

    @Override
    public void toDoubleFile(RandomAccessFile raf) throws IOException {
        raf.writeDouble(this.r);
        raf.writeDouble(this.i);
        raf.writeDouble(this.j);
        raf.writeDouble(this.k);
    }

    @Override
    public QuaternionFloat64Member allocate() {
        return new QuaternionFloat64Member();
    }

    @Override
    public QuaternionFloat64Member duplicate() {
        return new QuaternionFloat64Member(this);
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(QuaternionFloat64Member value) {
        this.get(value);
    }

    @Override
    public void setV(QuaternionFloat64Member value) {
        this.set(value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        rep.setValue(new OctonionRepresentation(BigDecimal.valueOf(this.r()), BigDecimal.valueOf(this.i()), BigDecimal.valueOf(this.j()), BigDecimal.valueOf(this.k())));
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        OctonionRepresentation v = rep.getValue();
        this.setR(v.r().doubleValue());
        this.setI(v.i().doubleValue());
        this.setJ(v.j().doubleValue());
        this.setK(v.k().doubleValue());
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.DOUBLE;
    }

    @Override
    public long dimension(int i) {
        return 0L;
    }

    @Override
    public int componentCount() {
        return 4;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v.doubleValue());
            } else {
                this.setI(v.doubleValue());
            }
        } else if (component == 2) {
            this.setJ(v.doubleValue());
        } else {
            this.setK(v.doubleValue());
        }
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        if (component < 2) {
            if (component == 0) {
                this.setR(v.doubleValue());
            } else {
                this.setI(v.doubleValue());
            }
        } else if (component == 2) {
            this.setJ(v.doubleValue());
        } else {
            this.setK(v.doubleValue());
        }
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v);
            } else {
                this.setI(v);
            }
        } else if (component == 2) {
            this.setJ(v);
        } else {
            this.setK(v);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v.doubleValue());
            } else {
                this.setI(v.doubleValue());
            }
        } else if (component == 2) {
            this.setJ(v.doubleValue());
        } else {
            this.setK(v.doubleValue());
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else if (component < 2) {
            if (component == 0) {
                this.setR(v.doubleValue());
            } else {
                this.setI(v.doubleValue());
            }
        } else if (component == 2) {
            this.setJ(v.doubleValue());
        } else {
            this.setK(v.doubleValue());
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (byte)this.r();
            }
            return (byte)this.i();
        }
        if (component == 2) {
            return (byte)this.j();
        }
        return (byte)this.k();
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (short)this.r();
            }
            return (short)this.i();
        }
        if (component == 2) {
            return (short)this.j();
        }
        return (short)this.k();
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (int)this.r();
            }
            return (int)this.i();
        }
        if (component == 2) {
            return (int)this.j();
        }
        return (int)this.k();
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (long)this.r();
            }
            return (long)this.i();
        }
        if (component == 2) {
            return (long)this.j();
        }
        return (long)this.k();
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return (float)this.r();
            }
            return (float)this.i();
        }
        if (component == 2) {
            return (float)this.j();
        }
        return (float)this.k();
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i()).toBigInteger();
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r());
            }
            return BigDecimal.valueOf(this.i());
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j());
        }
        return BigDecimal.valueOf(this.k());
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return (byte)this.r();
            }
            return (byte)this.i();
        }
        if (component == 2) {
            return (byte)this.j();
        }
        return (byte)this.k();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return (short)this.r();
            }
            return (short)this.i();
        }
        if (component == 2) {
            return (short)this.j();
        }
        return (short)this.k();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        if (component < 2) {
            if (component == 0) {
                return (int)this.r();
            }
            return (int)this.i();
        }
        if (component == 2) {
            return (int)this.j();
        }
        return (int)this.k();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        if (component < 2) {
            if (component == 0) {
                return (long)this.r();
            }
            return (long)this.i();
        }
        if (component == 2) {
            return (long)this.j();
        }
        return (long)this.k();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        if (component < 2) {
            if (component == 0) {
                return (float)this.r();
            }
            return (float)this.i();
        }
        if (component == 2) {
            return (float)this.j();
        }
        return (float)this.k();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        if (component < 2) {
            if (component == 0) {
                return this.r();
            }
            return this.i();
        }
        if (component == 2) {
            return this.j();
        }
        return this.k();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r()).toBigInteger();
            }
            return BigDecimal.valueOf(this.i()).toBigInteger();
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j()).toBigInteger();
        }
        return BigDecimal.valueOf(this.k()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 3;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        if (component < 2) {
            if (component == 0) {
                return BigDecimal.valueOf(this.r());
            }
            return BigDecimal.valueOf(this.i());
        }
        if (component == 2) {
            return BigDecimal.valueOf(this.j());
        }
        return BigDecimal.valueOf(this.k());
    }

    @Override
    public void primitiveInit() {
        this.k = 0.0;
        this.j = 0.0;
        this.i = 0.0;
        this.r = 0.0;
    }

    @Override
    public void setR(Float64Member val) {
        this.setR(val.v());
    }

    @Override
    public void setI(Float64Member val) {
        this.setI(val.v());
    }

    @Override
    public void setJ(Float64Member val) {
        this.setJ(val.v());
    }

    @Override
    public void setK(Float64Member val) {
        this.setK(val.v());
    }

    @Override
    public void getR(Float64Member v) {
        v.setV(this.r);
    }

    @Override
    public void getI(Float64Member v) {
        v.setV(this.i);
    }

    @Override
    public void getJ(Float64Member v) {
        v.setV(this.j);
    }

    @Override
    public void getK(Float64Member v) {
        v.setV(this.k);
    }
}

