/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.real;

import java.math.BigDecimal;
import java.util.concurrent.ThreadLocalRandom;
import net.jafama.FastMath;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Max;
import nom.bdezonia.zorbage.algorithm.Min;
import nom.bdezonia.zorbage.algorithm.NumberWithin;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;
import nom.bdezonia.zorbage.type.algebra.InverseTrigonometric;
import nom.bdezonia.zorbage.type.algebra.MiscFloat;
import nom.bdezonia.zorbage.type.algebra.ModularDivision;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.OrderedField;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.PredSucc;
import nom.bdezonia.zorbage.type.algebra.Random;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float64Algebra
implements OrderedField<Float64Algebra, Float64Member>,
Bounded<Float64Member>,
Norm<Float64Member, Float64Member>,
RealConstants<Float64Member>,
Exponential<Float64Member>,
Trigonometric<Float64Member>,
InverseTrigonometric<Float64Member>,
Hyperbolic<Float64Member>,
InverseHyperbolic<Float64Member>,
Infinite<Float64Member>,
NaN<Float64Member>,
Roots<Float64Member>,
Power<Float64Member>,
Rounding<Float64Member, Float64Member>,
Random<Float64Member>,
RealUnreal<Float64Member, Float64Member>,
PredSucc<Float64Member>,
MiscFloat<Float64Member>,
ModularDivision<Float64Member>,
Conjugate<Float64Member>,
Scale<Float64Member, Float64Member>,
ScaleByHighPrec<Float64Member>,
ScaleByRational<Float64Member>,
ScaleByDouble<Float64Member>,
ScaleComponents<Float64Member, Float64Member>,
Tolerance<Float64Member, Float64Member> {
    private static final Float64Member PI = new Float64Member(Math.PI);
    private static final Float64Member E = new Float64Member(Math.E);
    private static final Float64Member GAMMA = new Float64Member(0.5772156649015329);
    private static final Float64Member PHI = new Float64Member(1.618033988749895);
    private final Function2<Boolean, Float64Member, Float64Member> EQ = new Function2<Boolean, Float64Member, Float64Member>(){

        @Override
        public Boolean call(Float64Member a, Float64Member b) {
            return a.v() == b.v();
        }
    };
    private final Function2<Boolean, Float64Member, Float64Member> NEQ = new Function2<Boolean, Float64Member, Float64Member>(){

        @Override
        public Boolean call(Float64Member a, Float64Member b) {
            return a.v() != b.v();
        }
    };
    private final Procedure2<Float64Member, Float64Member> ASSIGN = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member from, Float64Member to) {
            to.set(from);
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> ADD = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(a.v() + b.v());
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> SUB = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(a.v() - b.v());
        }
    };
    private final Procedure1<Float64Member> ZER = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float64Member, Float64Member> NEG = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(-a.v());
        }
    };
    private final Procedure1<Float64Member> UNITY = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            a.setV(1.0);
        }
    };
    private final Procedure2<Float64Member, Float64Member> INV = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(1.0 / a.v());
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> DIVIDE = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(a.v() / b.v());
        }
    };
    private final Function2<Boolean, Float64Member, Float64Member> LESS = new Function2<Boolean, Float64Member, Float64Member>(){

        @Override
        public Boolean call(Float64Member a, Float64Member b) {
            return a.v() < b.v();
        }
    };
    private final Function2<Boolean, Float64Member, Float64Member> LE = new Function2<Boolean, Float64Member, Float64Member>(){

        @Override
        public Boolean call(Float64Member a, Float64Member b) {
            return a.v() <= b.v();
        }
    };
    private final Function2<Boolean, Float64Member, Float64Member> GREAT = new Function2<Boolean, Float64Member, Float64Member>(){

        @Override
        public Boolean call(Float64Member a, Float64Member b) {
            return a.v() > b.v();
        }
    };
    private final Function2<Boolean, Float64Member, Float64Member> GE = new Function2<Boolean, Float64Member, Float64Member>(){

        @Override
        public Boolean call(Float64Member a, Float64Member b) {
            return a.v() >= b.v();
        }
    };
    private Function2<Integer, Float64Member, Float64Member> CMP = new Function2<Integer, Float64Member, Float64Member>(){

        @Override
        public Integer call(Float64Member a, Float64Member b) {
            if (a.v() < b.v()) {
                return -1;
            }
            if (a.v() > b.v()) {
                return 1;
            }
            return 0;
        }
    };
    private Function1<Integer, Float64Member> SIG = new Function1<Integer, Float64Member>(){

        @Override
        public Integer call(Float64Member a) {
            if (a.v() < 0.0) {
                return -1;
            }
            if (a.v() > 0.0) {
                return 1;
            }
            return 0;
        }
    };
    private final Procedure1<Float64Member> MAXBOUND = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            a.setV(Double.MAX_VALUE);
        }
    };
    private final Procedure1<Float64Member> MINBOUND = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            a.setV(-1.7976931348623157E308);
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> MUL = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Procedure3<Integer, Float64Member, Float64Member> POWER = new Procedure3<Integer, Float64Member, Float64Member>(){

        @Override
        public void call(Integer power, Float64Member a, Float64Member b) {
            if (power == 0 && a.v() == 0.0) {
                b.setV(Double.NaN);
            } else {
                b.setV(FastMath.pow((double)a.v(), (double)power.intValue()));
            }
        }
    };
    private final Procedure2<Float64Member, Float64Member> ABS = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.abs(a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> NORM = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Float64Algebra.this.abs().call(a, b);
        }
    };
    private final Procedure1<Float64Member> PI_ = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            Float64Algebra.this.assign().call(PI, a);
        }
    };
    private final Procedure1<Float64Member> E_ = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            Float64Algebra.this.assign().call(E, a);
        }
    };
    private final Procedure1<Float64Member> GAMMA_ = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            Float64Algebra.this.assign().call(GAMMA, a);
        }
    };
    private final Procedure1<Float64Member> PHI_ = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            Float64Algebra.this.assign().call(PHI, a);
        }
    };
    private final Procedure2<Float64Member, Float64Member> EXP = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.exp((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> EXPM1 = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.expm1((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> LOG = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.log(a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> LOG1P = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.log1p(a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> COS = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.cos((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> SIN = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.sin((double)a.v()));
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> SINANDCOS = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member s, Float64Member c) {
            Float64Algebra.this.sin().call(a, s);
            Float64Algebra.this.cos().call(a, c);
        }
    };
    private final Procedure2<Float64Member, Float64Member> TAN = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.tan((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> CSC = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(1.0 / FastMath.sin((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> SEC = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(1.0 / FastMath.cos((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> COT = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(1.0 / FastMath.tan((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> COSH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.cosh((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> SINH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.sinh((double)a.v()));
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> SINHANDCOSH = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member s, Float64Member c) {
            Float64Algebra.this.sinh().call(a, s);
            Float64Algebra.this.cosh().call(a, c);
        }
    };
    private final Procedure2<Float64Member, Float64Member> TANH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.tanh((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> CSCH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(1.0 / FastMath.sinh((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> SECH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(1.0 / FastMath.cosh((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> COTH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(1.0 / FastMath.tanh((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> ACOS = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.acos((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> ASIN = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.asin((double)a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> ATAN = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.atan((double)a.v()));
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> ATAN2 = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(FastMath.atan2((double)a.v(), (double)b.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> ACSC = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Float64Member tmp = new Float64Member(1.0 / a.v());
            Float64Algebra.this.asin().call(tmp, b);
        }
    };
    private final Procedure2<Float64Member, Float64Member> ASEC = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Float64Member tmp = new Float64Member(1.0 / a.v());
            Float64Algebra.this.acos().call(tmp, b);
        }
    };
    private final Procedure2<Float64Member, Float64Member> ACOT = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Float64Member tmp = new Float64Member(1.0 / a.v());
            Float64Algebra.this.atan().call(tmp, b);
        }
    };
    private Procedure2<Float64Member, Float64Member> ACOSH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.log(a.v() + Math.sqrt(a.v() * a.v() - 1.0)));
        }
    };
    private Procedure2<Float64Member, Float64Member> ASINH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.log(a.v() + Math.sqrt(a.v() * a.v() + 1.0)));
        }
    };
    private Procedure2<Float64Member, Float64Member> ATANH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(0.5 * (-Math.log(1.0 - a.v()) + Math.log(1.0 + a.v())));
        }
    };
    private final Procedure2<Float64Member, Float64Member> ACSCH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Float64Member tmp = new Float64Member(1.0 / a.v());
            Float64Algebra.this.asinh().call(tmp, b);
        }
    };
    private final Procedure2<Float64Member, Float64Member> ASECH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Float64Member tmp = new Float64Member(1.0 / a.v());
            Float64Algebra.this.acosh().call(tmp, b);
        }
    };
    private final Procedure2<Float64Member, Float64Member> ACOTH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Float64Member tmp = new Float64Member(1.0 / a.v());
            Float64Algebra.this.atanh().call(tmp, b);
        }
    };
    private final Function1<Boolean, Float64Member> ISNAN = new Function1<Boolean, Float64Member>(){

        @Override
        public Boolean call(Float64Member a) {
            return Double.isNaN(a.v());
        }
    };
    private final Procedure1<Float64Member> NAN = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            a.setV(Double.NaN);
        }
    };
    private final Function1<Boolean, Float64Member> ISINF = new Function1<Boolean, Float64Member>(){

        @Override
        public Boolean call(Float64Member a) {
            return Double.isInfinite(a.v());
        }
    };
    private final Procedure1<Float64Member> INF = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            a.setV(Double.POSITIVE_INFINITY);
        }
    };
    private final Procedure1<Float64Member> NINF = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            a.setV(Double.NEGATIVE_INFINITY);
        }
    };
    private final Procedure2<Float64Member, Float64Member> SQRT = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.sqrt(a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> CBRT = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(FastMath.cbrt((double)a.v()));
        }
    };
    private final Procedure4<Round.Mode, Float64Member, Float64Member, Float64Member> ROUND = new Procedure4<Round.Mode, Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, Float64Member a, Float64Member b) {
            Round.compute(G.DBL, mode, delta, a, b);
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> MIN = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            Min.compute(G.DBL, a, b, c);
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> MAX = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            Max.compute(G.DBL, a, b, c);
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> POW = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            if (a.v() == 0.0 && b.v() == 0.0) {
                c.setV(Double.NaN);
            } else {
                c.setV(FastMath.pow((double)a.v(), (double)b.v()));
            }
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> IEEE = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(Math.IEEEremainder(a.v(), b.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> LOG10 = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.log10(a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> TODEG = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.toDegrees(a.v()));
        }
    };
    private final Procedure2<Float64Member, Float64Member> TORAD = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.toRadians(a.v()));
        }
    };
    private final Procedure1<Float64Member> RAND = new Procedure1<Float64Member>(){

        @Override
        public void call(Float64Member a) {
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            a.setV(rng.nextDouble());
        }
    };
    private final Procedure2<Float64Member, Float64Member> REAL = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(a.v());
        }
    };
    private final Procedure2<Float64Member, Float64Member> UNREAL = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(0.0);
        }
    };
    private final Procedure2<Float64Member, Float64Member> PRED = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.nextAfter(a.v(), Double.NEGATIVE_INFINITY));
        }
    };
    private final Procedure2<Float64Member, Float64Member> SUCC = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.nextUp(a.v()));
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> CPS = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(Math.copySign(a.v(), b.v()));
        }
    };
    private final Function1<Integer, Float64Member> GEXP = new Function1<Integer, Float64Member>(){

        @Override
        public Integer call(Float64Member a) {
            return Math.getExponent(a.v());
        }
    };
    private final Procedure3<Integer, Float64Member, Float64Member> SCALB = new Procedure3<Integer, Float64Member, Float64Member>(){

        @Override
        public void call(Integer scaleFactor, Float64Member a, Float64Member b) {
            b.setV(Math.scalb(a.v(), (int)scaleFactor));
        }
    };
    private final Procedure2<Float64Member, Float64Member> ULP = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            b.setV(Math.ulp(a.v()));
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> DIV = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member d) {
            double v = a.v() / b.v();
            v = v > 0.0 ? Math.floor(v) : Math.ceil(v);
            d.setV(v);
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> MOD = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member m) {
            m.setV(a.v() % b.v());
        }
    };
    private final Procedure4<Float64Member, Float64Member, Float64Member, Float64Member> DIVMOD = new Procedure4<Float64Member, Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member d, Float64Member m) {
            Float64Algebra.this.div().call(a, b, d);
            Float64Algebra.this.mod().call(a, b, m);
        }
    };
    private Procedure2<Float64Member, Float64Member> SINCH = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Sinch.compute(G.DBL, a, b);
        }
    };
    private Procedure2<Float64Member, Float64Member> SINCHPI = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Sinchpi.compute(G.DBL, a, b);
        }
    };
    private Procedure2<Float64Member, Float64Member> SINC = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Sinc.compute(G.DBL, a, b);
        }
    };
    private Procedure2<Float64Member, Float64Member> SINCPI = new Procedure2<Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b) {
            Sincpi.compute(G.DBL, a, b);
        }
    };
    private final Function1<Boolean, Float64Member> ISZERO = new Function1<Boolean, Float64Member>(){

        @Override
        public Boolean call(Float64Member a) {
            return a.v() == 0.0;
        }
    };
    private final Procedure3<HighPrecisionMember, Float64Member, Float64Member> SBHP = new Procedure3<HighPrecisionMember, Float64Member, Float64Member>(){

        @Override
        public void call(HighPrecisionMember a, Float64Member b, Float64Member c) {
            BigDecimal tmp = a.v().multiply(BigDecimal.valueOf(b.v()));
            c.setV(tmp.doubleValue());
        }
    };
    private final Procedure3<RationalMember, Float64Member, Float64Member> SBR = new Procedure3<RationalMember, Float64Member, Float64Member>(){

        @Override
        public void call(RationalMember a, Float64Member b, Float64Member c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = BigDecimal.valueOf(b.v());
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setV(tmp.doubleValue());
        }
    };
    private final Procedure3<Double, Float64Member, Float64Member> SBD = new Procedure3<Double, Float64Member, Float64Member>(){

        @Override
        public void call(Double a, Float64Member b, Float64Member c) {
            c.setV(a * b.v());
        }
    };
    private final Procedure3<Float64Member, Float64Member, Float64Member> SC = new Procedure3<Float64Member, Float64Member, Float64Member>(){

        @Override
        public void call(Float64Member a, Float64Member b, Float64Member c) {
            c.setV(a.v() * b.v());
        }
    };
    private final Function3<Boolean, Float64Member, Float64Member, Float64Member> WITHIN = new Function3<Boolean, Float64Member, Float64Member, Float64Member>(){

        @Override
        public Boolean call(Float64Member tol, Float64Member a, Float64Member b) {
            return NumberWithin.compute(G.DBL, tol, a, b);
        }
    };

    @Override
    public Function2<Boolean, Float64Member, Float64Member> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float64Member, Float64Member> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Float64Member construct() {
        return new Float64Member();
    }

    @Override
    public Float64Member construct(Float64Member other) {
        return new Float64Member(other);
    }

    @Override
    public Float64Member construct(String s) {
        return new Float64Member(s);
    }

    @Override
    public Procedure2<Float64Member, Float64Member> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> subtract() {
        return this.SUB;
    }

    @Override
    public Procedure1<Float64Member> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> negate() {
        return this.NEG;
    }

    @Override
    public Procedure1<Float64Member> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> divide() {
        return this.DIVIDE;
    }

    @Override
    public Function2<Boolean, Float64Member, Float64Member> isLess() {
        return this.LESS;
    }

    @Override
    public Function2<Boolean, Float64Member, Float64Member> isLessEqual() {
        return this.LE;
    }

    @Override
    public Function2<Boolean, Float64Member, Float64Member> isGreater() {
        return this.GREAT;
    }

    @Override
    public Function2<Boolean, Float64Member, Float64Member> isGreaterEqual() {
        return this.GE;
    }

    @Override
    public Function2<Integer, Float64Member, Float64Member> compare() {
        return this.CMP;
    }

    @Override
    public Function1<Integer, Float64Member> signum() {
        return this.SIG;
    }

    @Override
    public Procedure1<Float64Member> maxBound() {
        return this.MAXBOUND;
    }

    @Override
    public Procedure1<Float64Member> minBound() {
        return this.MINBOUND;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, Float64Member, Float64Member> power() {
        return this.POWER;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> abs() {
        return this.ABS;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<Float64Member> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<Float64Member> E() {
        return this.E_;
    }

    @Override
    public Procedure1<Float64Member> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<Float64Member> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> exp() {
        return this.EXP;
    }

    public Procedure2<Float64Member, Float64Member> expm1() {
        return this.EXPM1;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> log() {
        return this.LOG;
    }

    public Procedure2<Float64Member, Float64Member> log1p() {
        return this.LOG1P;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> sin() {
        return this.SIN;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> tan() {
        return this.TAN;
    }

    public Procedure2<Float64Member, Float64Member> csc() {
        return this.CSC;
    }

    public Procedure2<Float64Member, Float64Member> sec() {
        return this.SEC;
    }

    public Procedure2<Float64Member, Float64Member> cot() {
        return this.COT;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> tanh() {
        return this.TANH;
    }

    public Procedure2<Float64Member, Float64Member> csch() {
        return this.CSCH;
    }

    public Procedure2<Float64Member, Float64Member> sech() {
        return this.SECH;
    }

    public Procedure2<Float64Member, Float64Member> coth() {
        return this.COTH;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> acos() {
        return this.ACOS;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> asin() {
        return this.ASIN;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> atan() {
        return this.ATAN;
    }

    public Procedure3<Float64Member, Float64Member, Float64Member> atan2() {
        return this.ATAN2;
    }

    public Procedure2<Float64Member, Float64Member> acsc() {
        return this.ACSC;
    }

    public Procedure2<Float64Member, Float64Member> asec() {
        return this.ASEC;
    }

    public Procedure2<Float64Member, Float64Member> acot() {
        return this.ACOT;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> acosh() {
        return this.ACOSH;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> asinh() {
        return this.ASINH;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> atanh() {
        return this.ATANH;
    }

    public Procedure2<Float64Member, Float64Member> acsch() {
        return this.ACSCH;
    }

    public Procedure2<Float64Member, Float64Member> asech() {
        return this.ASECH;
    }

    public Procedure2<Float64Member, Float64Member> acoth() {
        return this.ACOTH;
    }

    @Override
    public Function1<Boolean, Float64Member> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float64Member> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float64Member> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float64Member> infinite() {
        return this.INF;
    }

    public Procedure1<Float64Member> negInfinite() {
        return this.NINF;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> cbrt() {
        return this.CBRT;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, Float64Member, Float64Member> round() {
        return this.ROUND;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> min() {
        return this.MIN;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> max() {
        return this.MAX;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> pow() {
        return this.POW;
    }

    public Procedure3<Float64Member, Float64Member, Float64Member> IEEEremainder() {
        return this.IEEE;
    }

    public Procedure2<Float64Member, Float64Member> log10() {
        return this.LOG10;
    }

    public Procedure2<Float64Member, Float64Member> toDegrees() {
        return this.TODEG;
    }

    public Procedure2<Float64Member, Float64Member> toRadians() {
        return this.TORAD;
    }

    @Override
    public Procedure1<Float64Member> random() {
        return this.RAND;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> pred() {
        return this.PRED;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> succ() {
        return this.SUCC;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> copySign() {
        return this.CPS;
    }

    @Override
    public Function1<Integer, Float64Member> getExponent() {
        return this.GEXP;
    }

    @Override
    public Procedure3<Integer, Float64Member, Float64Member> scalb() {
        return this.SCALB;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> ulp() {
        return this.ULP;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> div() {
        return this.DIV;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> mod() {
        return this.MOD;
    }

    @Override
    public Procedure4<Float64Member, Float64Member, Float64Member, Float64Member> divMod() {
        return this.DIVMOD;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<Float64Member, Float64Member> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Function1<Boolean, Float64Member> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float64Member, Float64Member> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float64Member, Float64Member> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float64Member, Float64Member> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<Float64Member, Float64Member, Float64Member> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, Float64Member, Float64Member, Float64Member> within() {
        return this.WITHIN;
    }
}

