/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorRound;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Algebra;
import nom.bdezonia.zorbage.type.data.float64.real.Float64CartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float64CartesianTensorProduct
implements TensorProduct<Float64CartesianTensorProduct, Float64CartesianTensorProductMember, Float64Algebra, Float64Member>,
ConstructibleNdLong<Float64CartesianTensorProductMember>,
Norm<Float64CartesianTensorProductMember, Float64Member>,
Scale<Float64CartesianTensorProductMember, Float64Member>,
Rounding<Float64Member, Float64CartesianTensorProductMember>,
Infinite<Float64CartesianTensorProductMember>,
NaN<Float64CartesianTensorProductMember>,
ScaleByHighPrec<Float64CartesianTensorProductMember>,
ScaleByRational<Float64CartesianTensorProductMember>,
ScaleByDouble<Float64CartesianTensorProductMember>,
Tolerance<Float64Member, Float64CartesianTensorProductMember> {
    private final Function2<Boolean, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> EQ = new Function2<Boolean, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.DBL, G.DBL.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> NEQ = new Function2<Boolean, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            return Float64CartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> ASSIGN = new Procedure2<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember from, Float64CartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.DBL, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<Float64CartesianTensorProductMember> ZER = new Procedure1<Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> NEG = new Procedure2<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.DBL, G.DBL.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> ADDEL = new Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b, Float64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.DBL, G.DBL.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> SUBEL = new Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b, Float64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.DBL, G.DBL.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<Float64CartesianTensorProductMember, Float64Member> NORM = new Procedure2<Float64CartesianTensorProductMember, Float64Member>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64Member b) {
            TensorNorm.compute(G.DBL, G.DBL, a.rawData(), b);
        }
    };
    private final Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> SCALE = new Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64Member scalar, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.DBL, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> ADDSCALAR = new Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64Member scalar, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.DBL, scalar, G.DBL.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> SUBSCALAR = new Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64Member scalar, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            Float64Member tmp = G.DBL.construct();
            G.DBL.negate().call(scalar, tmp);
            Float64CartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> MULEL = new Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b, Float64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.DBL, G.DBL.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> DIVIDEEL = new Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b, Float64CartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.DBL, G.DBL.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> MUL = new Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b, Float64CartesianTensorProductMember c) {
            Float64CartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorContract.compute(G.DBL, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> SEMI = new Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.DBL_TEN, G.DBL, index, a, b);
        }
    };
    private final Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> COMMA = new Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Integer index, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.DBL_TEN, G.DBL, index, a, b);
        }
    };
    private final Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> POWER = new Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Integer power, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorPower.compute(G.DBL_TEN, power, a, b);
        }
    };
    private final Procedure1<Float64CartesianTensorProductMember> UNITY = new Procedure1<Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember result) {
            TensorUnity.compute(G.DBL_TEN, G.DBL, result);
        }
    };
    private final Function1<Boolean, Float64CartesianTensorProductMember> ISNAN = new Function1<Boolean, Float64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64CartesianTensorProductMember a) {
            return SequenceIsNan.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure1<Float64CartesianTensorProductMember> NAN = new Procedure1<Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a) {
            FillNaN.compute(G.DBL, a);
        }
    };
    private final Function1<Boolean, Float64CartesianTensorProductMember> ISINF = new Function1<Boolean, Float64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64CartesianTensorProductMember a) {
            return SequenceIsInf.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure1<Float64CartesianTensorProductMember> INF = new Procedure1<Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a) {
            FillInfinite.compute(G.DBL, a);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> ROUND = new Procedure4<Round.Mode, Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorRound.compute(G.DBL_TEN, G.DBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float64CartesianTensorProductMember> ISZERO = new Function1<Boolean, Float64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64CartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure3<RationalMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> SBR = new Procedure3<RationalMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.DBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> SBD = new Procedure3<Double, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Double factor, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.DBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.DBL, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> WITHIN = new Function3<Boolean, Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public Boolean call(Float64Member tol, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.DBL, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> MULBYSCALAR = new Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64Member factor, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            Float64CartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> DIVBYSCALAR = new Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64Member factor, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            Float64Member invFactor = G.DBL.construct();
            G.DBL.invert().call(factor, invFactor);
            Float64CartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> RAISE = new Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> LOWER = new Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            Float64CartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b, Float64CartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            Float64CartesianTensorProductMember tmp = Float64CartesianTensorProduct.this.construct();
            Float64CartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            Float64CartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> OUTER = new Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember>(){

        @Override
        public void call(Float64CartesianTensorProductMember a, Float64CartesianTensorProductMember b, Float64CartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.DBL_TEN, G.DBL, a, b, c);
        }
    };

    @Override
    public Float64CartesianTensorProductMember construct() {
        return new Float64CartesianTensorProductMember();
    }

    @Override
    public Float64CartesianTensorProductMember construct(Float64CartesianTensorProductMember other) {
        return new Float64CartesianTensorProductMember(other);
    }

    @Override
    public Float64CartesianTensorProductMember construct(String s) {
        return new Float64CartesianTensorProductMember(s);
    }

    @Override
    public Float64CartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new Float64CartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<Float64CartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<Float64CartesianTensorProductMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<Float64CartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, Float64CartesianTensorProductMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float64CartesianTensorProductMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float64CartesianTensorProductMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float64CartesianTensorProductMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float64CartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<Float64Member, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<Float64CartesianTensorProductMember, Float64CartesianTensorProductMember, Float64CartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

