/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixRound;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Algebra;
import nom.bdezonia.zorbage.type.data.float64.real.Float64MatrixMember;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float64Matrix
implements RingWithUnity<Float64Matrix, Float64MatrixMember>,
MatrixRing<Float64Matrix, Float64MatrixMember, Float64Algebra, Float64Member>,
Constructible2dLong<Float64MatrixMember>,
Rounding<Float64Member, Float64MatrixMember>,
Norm<Float64MatrixMember, Float64Member>,
DirectProduct<Float64MatrixMember, Float64MatrixMember>,
Exponential<Float64MatrixMember>,
Trigonometric<Float64MatrixMember>,
Hyperbolic<Float64MatrixMember>,
RealConstants<Float64MatrixMember>,
Infinite<Float64MatrixMember>,
NaN<Float64MatrixMember>,
ScaleByHighPrec<Float64MatrixMember>,
ScaleByRational<Float64MatrixMember>,
ScaleByDouble<Float64MatrixMember>,
Tolerance<Float64Member, Float64MatrixMember> {
    private final Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> MUL = new Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b, Float64MatrixMember c) {
            MatrixMultiply.compute(G.DBL, a, b, c);
        }
    };
    private final Procedure3<Integer, Float64MatrixMember, Float64MatrixMember> POWER = new Procedure3<Integer, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Integer power, Float64MatrixMember a, Float64MatrixMember b) {
            MatrixPower.compute(power, G.DBL, G.DBL_VEC, G.DBL_MAT, a, b);
        }
    };
    private final Procedure1<Float64MatrixMember> ZER = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> NEG = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            MatrixNegate.compute(G.DBL, a, b);
        }
    };
    private final Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> ADD = new Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b, Float64MatrixMember c) {
            MatrixAddition.compute(G.DBL, a, b, c);
        }
    };
    private final Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> SUB = new Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b, Float64MatrixMember c) {
            MatrixSubtraction.compute(G.DBL, a, b, c);
        }
    };
    private final Function2<Boolean, Float64MatrixMember, Float64MatrixMember> EQ = new Function2<Boolean, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public Boolean call(Float64MatrixMember a, Float64MatrixMember b) {
            return MatrixEqual.compute(G.DBL, a, b);
        }
    };
    private final Function2<Boolean, Float64MatrixMember, Float64MatrixMember> NEQ = new Function2<Boolean, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public Boolean call(Float64MatrixMember a, Float64MatrixMember b) {
            return Float64Matrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> ASSIGN = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember from, Float64MatrixMember to) {
            MatrixAssign.compute(G.DBL, from, to);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64Member> NORM = new Procedure2<Float64MatrixMember, Float64Member>(){

        @Override
        public void call(Float64MatrixMember a, Float64Member b) {
            MatrixSpectralNorm.compute(G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, Float64MatrixMember, Float64MatrixMember> ROUND = new Procedure4<Round.Mode, Float64Member, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, Float64MatrixMember a, Float64MatrixMember b) {
            MatrixRound.compute(G.DBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float64MatrixMember> ISNAN = new Function1<Boolean, Float64MatrixMember>(){

        @Override
        public Boolean call(Float64MatrixMember a) {
            return SequenceIsNan.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure1<Float64MatrixMember> NAN = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            FillNaN.compute(G.DBL, a);
        }
    };
    private final Function1<Boolean, Float64MatrixMember> ISINF = new Function1<Boolean, Float64MatrixMember>(){

        @Override
        public Boolean call(Float64MatrixMember a) {
            return SequenceIsInf.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure1<Float64MatrixMember> INF = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            FillInfinite.compute(G.DBL, a);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> TRANSP = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            MatrixTranspose.compute(G.DBL, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> CONJTRANSP = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            Float64Matrix.this.transpose().call(a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64Member> DET = new Procedure2<Float64MatrixMember, Float64Member>(){

        @Override
        public void call(Float64MatrixMember a, Float64Member b) {
            MatrixDeterminant.compute(G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure1<Float64MatrixMember> UNITY = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            MatrixUnity.compute(G.DBL, a);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> INV = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            MatrixInvert.compute(G.DBL, G.DBL_VEC, G.DBL_MAT, a, b);
        }
    };
    private final Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> DIVIDE = new Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b, Float64MatrixMember c) {
            Float64MatrixMember invB = Float64Matrix.this.construct(b.storageType(), b.rows(), b.cols());
            Float64Matrix.this.invert().call(b, invB);
            Float64Matrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> DP = new Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember in1, Float64MatrixMember in2, Float64MatrixMember out) {
            MatrixDirectProduct.compute(G.DBL, in1, in2, out);
        }
    };
    private final Procedure3<Float64Member, Float64MatrixMember, Float64MatrixMember> SCALE = new Procedure3<Float64Member, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64Member a, Float64MatrixMember b, Float64MatrixMember c) {
            MatrixScale.compute(G.DBL, a, b, c);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> SINH = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            TaylorEstimateSinh.compute(18, G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> COSH = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            TaylorEstimateCosh.compute(18, G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> SINHANDCOSH = new Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember s, Float64MatrixMember c) {
            Float64Matrix.this.sinh().call(a, s);
            Float64Matrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> TANH = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            Float64MatrixMember s = Float64Matrix.this.construct();
            Float64MatrixMember c = Float64Matrix.this.construct();
            Float64Matrix.this.sinhAndCosh().call(a, s, c);
            Float64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> SINCH = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            Sinch.compute(G.DBL_MAT, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> SINCHPI = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            Sinchpi.compute(G.DBL_MAT, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> SIN = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            TaylorEstimateSin.compute(18, G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> COS = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            TaylorEstimateCos.compute(18, G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> TAN = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            Float64MatrixMember s = Float64Matrix.this.construct();
            Float64MatrixMember c = Float64Matrix.this.construct();
            Float64Matrix.this.sinAndCos().call(a, s, c);
            Float64Matrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> SINANDCOS = new Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember s, Float64MatrixMember c) {
            Float64Matrix.this.sin().call(a, s);
            Float64Matrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> SINC = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            Sinc.compute(G.DBL_MAT, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> SINCPI = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            Sincpi.compute(G.DBL_MAT, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> EXP = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            TaylorEstimateExp.compute(35, G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Procedure2<Float64MatrixMember, Float64MatrixMember> LOG = new Procedure2<Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a, Float64MatrixMember b) {
            TaylorEstimateLog.compute(8, G.DBL_MAT, G.DBL, a, b);
        }
    };
    private final Function1<Boolean, Float64MatrixMember> ISZERO = new Function1<Boolean, Float64MatrixMember>(){

        @Override
        public Boolean call(Float64MatrixMember a) {
            return SequenceIsZero.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure1<Float64MatrixMember> PI = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            Float64Member pi = G.DBL.construct();
            G.DBL.PI().call(pi);
            MatrixConstantDiagonal.compute(G.DBL, pi, a);
        }
    };
    private final Procedure1<Float64MatrixMember> E = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            Float64Member e = G.DBL.construct();
            G.DBL.E().call(e);
            MatrixConstantDiagonal.compute(G.DBL, e, a);
        }
    };
    private final Procedure1<Float64MatrixMember> PHI = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            Float64Member phi = G.DBL.construct();
            G.DBL.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.DBL, phi, a);
        }
    };
    private final Procedure1<Float64MatrixMember> GAMMA = new Procedure1<Float64MatrixMember>(){

        @Override
        public void call(Float64MatrixMember a) {
            Float64Member gamma = G.DBL.construct();
            G.DBL.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.DBL, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, Float64MatrixMember, Float64MatrixMember> SBHP = new Procedure3<HighPrecisionMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, Float64MatrixMember b, Float64MatrixMember c) {
            MatrixScaleByHighPrec.compute(G.DBL, a, b, c);
        }
    };
    private Procedure3<RationalMember, Float64MatrixMember, Float64MatrixMember> SBR = new Procedure3<RationalMember, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(RationalMember a, Float64MatrixMember b, Float64MatrixMember c) {
            MatrixScaleByRational.compute(G.DBL, a, b, c);
        }
    };
    private Procedure3<Double, Float64MatrixMember, Float64MatrixMember> SBD = new Procedure3<Double, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public void call(Double a, Float64MatrixMember b, Float64MatrixMember c) {
            MatrixScaleByDouble.compute(G.DBL, a, b, c);
        }
    };
    private final Function3<Boolean, Float64Member, Float64MatrixMember, Float64MatrixMember> WITHIN = new Function3<Boolean, Float64Member, Float64MatrixMember, Float64MatrixMember>(){

        @Override
        public Boolean call(Float64Member tol, Float64MatrixMember a, Float64MatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.DBL, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, Float64MatrixMember, Float64MatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<Float64MatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, Float64MatrixMember, Float64MatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float64MatrixMember, Float64MatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Float64MatrixMember construct() {
        return new Float64MatrixMember();
    }

    @Override
    public Float64MatrixMember construct(Float64MatrixMember other) {
        return new Float64MatrixMember(other);
    }

    @Override
    public Float64MatrixMember construct(String s) {
        return new Float64MatrixMember(s);
    }

    @Override
    public Float64MatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new Float64MatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, Float64MatrixMember, Float64MatrixMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float64MatrixMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float64MatrixMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float64MatrixMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float64MatrixMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64Member> det() {
        return this.DET;
    }

    @Override
    public Procedure1<Float64MatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<Float64Member, Float64MatrixMember, Float64MatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<Float64MatrixMember, Float64MatrixMember, Float64MatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<Float64MatrixMember, Float64MatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, Float64MatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<Float64MatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<Float64MatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<Float64MatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<Float64MatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float64MatrixMember, Float64MatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float64MatrixMember, Float64MatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float64MatrixMember, Float64MatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float64Member, Float64MatrixMember, Float64MatrixMember> within() {
        return this.WITHIN;
    }
}

