/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.real;

import java.math.BigDecimal;
import java.math.BigInteger;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.MatrixReshape;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class Float64MatrixMember
implements MatrixMember<Float64Member>,
Settable<Float64MatrixMember>,
Gettable<Float64MatrixMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<Float64Member> {
    private static final Float64Member ZERO = new Float64Member(0.0);
    private IndexedDataSource<Float64Member> storage;
    private long rows;
    private long cols;
    private StorageConstruction s;
    private static ThreadLocal<Float64Member> tmpFloat = new ThreadLocal<Float64Member>(){

        @Override
        protected Float64Member initialValue() {
            return new Float64Member();
        }
    };

    public Float64MatrixMember() {
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(0L, 0L);
    }

    public Float64MatrixMember(int r, int c, double[] vals) {
        if (vals.length != r * c * 1) {
            throw new IllegalArgumentException("input values do not match declared shape");
        }
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(r, c);
        Float64Member tmp = new Float64Member();
        for (int i = 0; i < vals.length; ++i) {
            tmp.setV(vals[i]);
            this.storage.set(i, tmp);
        }
    }

    public Float64MatrixMember(Float64MatrixMember other) {
        this.set(other);
    }

    public Float64MatrixMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.firstMatrixValues();
        long[] dimensions = rep.dimensions();
        this.rows = -1L;
        this.cols = -1L;
        this.s = StorageConstruction.MEM_ARRAY;
        this.init(dimensions[1], dimensions[0]);
        Float64Member tmp = new Float64Member();
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            OctonionRepresentation val = data.get(i);
            tmp.setV(val.r().doubleValue());
            this.storage.set(i, tmp);
        }
    }

    public Float64MatrixMember(StorageConstruction s, long d1, long d2) {
        this.rows = -1L;
        this.cols = -1L;
        this.s = s;
        this.init(d2, d1);
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public long rows() {
        return this.rows;
    }

    @Override
    public long cols() {
        return this.cols;
    }

    @Override
    public boolean alloc(long r, long c) {
        if (this.rows != r || this.cols != c) {
            this.rows = r;
            this.cols = c;
        }
        if (this.storage == null || this.storage.size() != r * c) {
            this.storage = Storage.allocate(this.s, r * c, new Float64Member());
            return true;
        }
        return false;
    }

    @Override
    public void init(long r, long c) {
        if (!this.alloc(r, c)) {
            long storageSize = r * c;
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    @Override
    public void v(long r, long c, Float64Member value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.get(index, value);
    }

    @Override
    public void setV(long r, long c, Float64Member value) {
        if (r < 0L || r >= this.rows || c < 0L || c >= this.cols) {
            throw new IllegalArgumentException("matrix oob access");
        }
        long index = r * this.cols + c;
        this.storage.set(index, value);
    }

    @Override
    public void set(Float64MatrixMember other) {
        if (this == other) {
            return;
        }
        this.rows = other.rows;
        this.cols = other.cols;
        this.s = other.s;
        this.storage = (IndexedDataSource)other.storage.duplicate();
    }

    @Override
    public void get(Float64MatrixMember other) {
        if (this == other) {
            return;
        }
        other.rows = this.rows;
        other.cols = this.cols;
        other.s = this.s;
        other.storage = (IndexedDataSource)this.storage.duplicate();
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        Float64Member value = new Float64Member();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = BigDecimal.valueOf(value.v());
            OctonionRepresentation o = new OctonionRepresentation(re);
            values.set(i, o);
        }
        rep.setMatrix(this.rows, this.cols, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        Float64Member value = new Float64Member();
        BigList<OctonionRepresentation> mat = rep.getMatrix();
        this.alloc(rep.getMatrixRowDim(), rep.getMatrixColDim());
        long matSize = mat.size();
        for (long i = 0L; i < matSize; ++i) {
            OctonionRepresentation o = mat.get(i);
            value.setV(o.r().doubleValue());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        Float64Member tmp = new Float64Member();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (long r = 0L; r < this.rows; ++r) {
            builder.append('[');
            for (long c = 0L; c < this.cols; ++c) {
                if (c != 0L) {
                    builder.append(',');
                }
                this.v(r, c, tmp);
                builder.append(tmp.toString());
            }
            builder.append(']');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public void reshape(long rows, long cols) {
        MatrixReshape.compute(G.DBL_MAT, G.DBL, rows, cols, this);
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d == 0) {
            return this.cols;
        }
        if (d == 1) {
            return this.rows;
        }
        return 1L;
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.DOUBLE;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v);
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v);
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v);
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v);
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v);
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v);
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v.doubleValue());
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        Float64Member tmp = tmpFloat.get();
        long c = index.get(0);
        long r = index.get(1);
        tmp.setV(v.doubleValue());
        this.setV(r, c, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v);
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v);
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v);
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v);
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v);
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v);
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v.doubleValue());
            this.setV(r, c, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            Float64Member tmp = tmpFloat.get();
            long c = index.get(0);
            long r = index.get(1);
            tmp.setV(v.doubleValue());
            this.setV(r, c, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return (byte)tmp.v();
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return (short)tmp.v();
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return (int)tmp.v();
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return (long)tmp.v();
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return (float)tmp.v();
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return tmp.v();
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return BigDecimal.valueOf(tmp.v()).toBigInteger();
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        if (component == 0) {
            Float64Member tmp = tmpFloat.get();
            this.v(index.get(1), index.get(0), tmp);
            return BigDecimal.valueOf(tmp.v());
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return (byte)tmp.v();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return (short)tmp.v();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return (int)tmp.v();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0L;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return (long)tmp.v();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0f;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return (float)tmp.v();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return 0.0;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return tmp.v();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigInteger.ZERO;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return BigDecimal.valueOf(tmp.v()).toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        boolean oob;
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        boolean bl = oob = component > 0;
        if (!oob) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == 0) {
                    if (index.get(0) < this.cols) continue;
                    oob = true;
                    break;
                }
                if (i == 1) {
                    if (index.get(1) < this.rows) continue;
                    oob = true;
                    break;
                }
                if (index.get(i) == 0L) continue;
                oob = true;
                break;
            }
        }
        if (oob) {
            return BigDecimal.ZERO;
        }
        Float64Member tmp = tmpFloat.get();
        this.v(index.get(1), index.get(0), tmp);
        return BigDecimal.valueOf(tmp.v());
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<Float64Member> rawData() {
        return this.storage;
    }
}

