/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.float64.real;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.CrossProduct;
import nom.bdezonia.zorbage.algorithm.DotProduct;
import nom.bdezonia.zorbage.algorithm.FillInfinite;
import nom.bdezonia.zorbage.algorithm.FillNaN;
import nom.bdezonia.zorbage.algorithm.PerpDotProduct;
import nom.bdezonia.zorbage.algorithm.RModuleAdd;
import nom.bdezonia.zorbage.algorithm.RModuleAssign;
import nom.bdezonia.zorbage.algorithm.RModuleDefaultNorm;
import nom.bdezonia.zorbage.algorithm.RModuleDirectProduct;
import nom.bdezonia.zorbage.algorithm.RModuleEqual;
import nom.bdezonia.zorbage.algorithm.RModuleNegate;
import nom.bdezonia.zorbage.algorithm.RModuleRound;
import nom.bdezonia.zorbage.algorithm.RModuleScale;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByDouble;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.RModuleScaleByRational;
import nom.bdezonia.zorbage.algorithm.RModuleSubtract;
import nom.bdezonia.zorbage.algorithm.Round;
import nom.bdezonia.zorbage.algorithm.SequenceIsInf;
import nom.bdezonia.zorbage.algorithm.SequenceIsNan;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Infinite;
import nom.bdezonia.zorbage.type.algebra.NaN;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Products;
import nom.bdezonia.zorbage.type.algebra.Rounding;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.VectorSpace;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Algebra;
import nom.bdezonia.zorbage.type.data.float64.real.Float64MatrixMember;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.float64.real.Float64VectorMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class Float64Vector
implements VectorSpace<Float64Vector, Float64VectorMember, Float64Algebra, Float64Member>,
Constructible1dLong<Float64VectorMember>,
Norm<Float64VectorMember, Float64Member>,
Products<Float64VectorMember, Float64Member, Float64MatrixMember>,
DirectProduct<Float64VectorMember, Float64MatrixMember>,
Rounding<Float64Member, Float64VectorMember>,
Infinite<Float64VectorMember>,
NaN<Float64VectorMember>,
ScaleByHighPrec<Float64VectorMember>,
ScaleByRational<Float64VectorMember>,
ScaleByDouble<Float64VectorMember>,
Tolerance<Float64Member, Float64VectorMember> {
    private final Procedure1<Float64VectorMember> ZER = new Procedure1<Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<Float64VectorMember, Float64VectorMember> NEG = new Procedure2<Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b) {
            RModuleNegate.compute(G.DBL, a, b);
        }
    };
    private final Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember> ADD = new Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b, Float64VectorMember c) {
            RModuleAdd.compute(G.DBL, a, b, c);
        }
    };
    private final Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember> SUB = new Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b, Float64VectorMember c) {
            RModuleSubtract.compute(G.DBL, a, b, c);
        }
    };
    private final Function2<Boolean, Float64VectorMember, Float64VectorMember> EQ = new Function2<Boolean, Float64VectorMember, Float64VectorMember>(){

        @Override
        public Boolean call(Float64VectorMember a, Float64VectorMember b) {
            return RModuleEqual.compute(G.DBL, a, b);
        }
    };
    private final Function2<Boolean, Float64VectorMember, Float64VectorMember> NEQ = new Function2<Boolean, Float64VectorMember, Float64VectorMember>(){

        @Override
        public Boolean call(Float64VectorMember a, Float64VectorMember b) {
            return Float64Vector.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<Float64VectorMember, Float64VectorMember> ASSIGN = new Procedure2<Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember from, Float64VectorMember to) {
            RModuleAssign.compute(G.DBL, from, to);
        }
    };
    private Procedure2<Float64VectorMember, Float64Member> NORM = new Procedure2<Float64VectorMember, Float64Member>(){

        @Override
        public void call(Float64VectorMember a, Float64Member b) {
            RModuleDefaultNorm.compute(G.DBL, G.DBL, a, b);
        }
    };
    private final Procedure3<Float64Member, Float64VectorMember, Float64VectorMember> SCALE = new Procedure3<Float64Member, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Float64Member scalar, Float64VectorMember a, Float64VectorMember b) {
            RModuleScale.compute(G.DBL, scalar, a, b);
        }
    };
    private final Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember> CROSS = new Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b, Float64VectorMember c) {
            CrossProduct.compute(G.DBL_VEC, G.DBL, a, b, c);
        }
    };
    private final Procedure3<Float64VectorMember, Float64VectorMember, Float64Member> DOT = new Procedure3<Float64VectorMember, Float64VectorMember, Float64Member>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b, Float64Member c) {
            DotProduct.compute(G.DBL_VEC, G.DBL, G.DBL, a, b, c);
        }
    };
    private final Procedure3<Float64VectorMember, Float64VectorMember, Float64Member> PERP = new Procedure3<Float64VectorMember, Float64VectorMember, Float64Member>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b, Float64Member c) {
            PerpDotProduct.compute(G.DBL_VEC, G.DBL, a, b, c);
        }
    };
    private final Procedure4<Float64VectorMember, Float64VectorMember, Float64VectorMember, Float64VectorMember> VTRIPLE = new Procedure4<Float64VectorMember, Float64VectorMember, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b, Float64VectorMember c, Float64VectorMember d) {
            Float64VectorMember b_cross_c = new Float64VectorMember(new double[3]);
            Float64Vector.this.crossProduct().call(b, c, b_cross_c);
            Float64Vector.this.crossProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure4<Float64VectorMember, Float64VectorMember, Float64VectorMember, Float64Member> STRIPLE = new Procedure4<Float64VectorMember, Float64VectorMember, Float64VectorMember, Float64Member>(){

        @Override
        public void call(Float64VectorMember a, Float64VectorMember b, Float64VectorMember c, Float64Member d) {
            Float64VectorMember b_cross_c = new Float64VectorMember(new double[3]);
            Float64Vector.this.crossProduct().call(b, c, b_cross_c);
            Float64Vector.this.dotProduct().call(a, b_cross_c, d);
        }
    };
    private final Procedure3<Float64VectorMember, Float64VectorMember, Float64MatrixMember> VDP = new Procedure3<Float64VectorMember, Float64VectorMember, Float64MatrixMember>(){

        @Override
        public void call(Float64VectorMember in1, Float64VectorMember in2, Float64MatrixMember out) {
            Float64Vector.this.directProduct().call(in1, in2, out);
        }
    };
    private final Procedure3<Float64VectorMember, Float64VectorMember, Float64MatrixMember> DP = new Procedure3<Float64VectorMember, Float64VectorMember, Float64MatrixMember>(){

        @Override
        public void call(Float64VectorMember in1, Float64VectorMember in2, Float64MatrixMember out) {
            RModuleDirectProduct.compute(G.DBL, in1, in2, out);
        }
    };
    private final Function1<Boolean, Float64VectorMember> ISNAN = new Function1<Boolean, Float64VectorMember>(){

        @Override
        public Boolean call(Float64VectorMember a) {
            return SequenceIsNan.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure1<Float64VectorMember> NAN = new Procedure1<Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a) {
            FillNaN.compute(G.DBL, a);
        }
    };
    private final Function1<Boolean, Float64VectorMember> ISINF = new Function1<Boolean, Float64VectorMember>(){

        @Override
        public Boolean call(Float64VectorMember a) {
            return SequenceIsInf.compute(G.DBL, a.rawData());
        }
    };
    private final Procedure1<Float64VectorMember> INF = new Procedure1<Float64VectorMember>(){

        @Override
        public void call(Float64VectorMember a) {
            FillInfinite.compute(G.DBL, a);
        }
    };
    private final Procedure4<Round.Mode, Float64Member, Float64VectorMember, Float64VectorMember> ROUND = new Procedure4<Round.Mode, Float64Member, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Round.Mode mode, Float64Member delta, Float64VectorMember a, Float64VectorMember b) {
            RModuleRound.compute(G.DBL, mode, delta, a, b);
        }
    };
    private final Function1<Boolean, Float64VectorMember> ISZERO = new Function1<Boolean, Float64VectorMember>(){

        @Override
        public Boolean call(Float64VectorMember a) {
            return SequenceIsZero.compute(G.DBL, a.rawData());
        }
    };
    private Procedure3<HighPrecisionMember, Float64VectorMember, Float64VectorMember> SBHP = new Procedure3<HighPrecisionMember, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(HighPrecisionMember a, Float64VectorMember b, Float64VectorMember c) {
            RModuleScaleByHighPrec.compute(G.DBL, a, b, c);
        }
    };
    private Procedure3<RationalMember, Float64VectorMember, Float64VectorMember> SBR = new Procedure3<RationalMember, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(RationalMember a, Float64VectorMember b, Float64VectorMember c) {
            RModuleScaleByRational.compute(G.DBL, a, b, c);
        }
    };
    private Procedure3<Double, Float64VectorMember, Float64VectorMember> SBD = new Procedure3<Double, Float64VectorMember, Float64VectorMember>(){

        @Override
        public void call(Double a, Float64VectorMember b, Float64VectorMember c) {
            RModuleScaleByDouble.compute(G.DBL, a, b, c);
        }
    };
    private final Function3<Boolean, Float64Member, Float64VectorMember, Float64VectorMember> WITHIN = new Function3<Boolean, Float64Member, Float64VectorMember, Float64VectorMember>(){

        @Override
        public Boolean call(Float64Member tol, Float64VectorMember a, Float64VectorMember b) {
            return SequencesSimilar.compute(G.DBL, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure1<Float64VectorMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<Float64VectorMember, Float64VectorMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, Float64VectorMember, Float64VectorMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, Float64VectorMember, Float64VectorMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Float64VectorMember construct() {
        return new Float64VectorMember();
    }

    @Override
    public Float64VectorMember construct(Float64VectorMember other) {
        return new Float64VectorMember(other);
    }

    @Override
    public Float64VectorMember construct(String s) {
        return new Float64VectorMember(s);
    }

    @Override
    public Float64VectorMember construct(StorageConstruction s, long d1) {
        return new Float64VectorMember(s, d1);
    }

    @Override
    public Procedure2<Float64VectorMember, Float64VectorMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure2<Float64VectorMember, Float64Member> norm() {
        return this.NORM;
    }

    @Override
    public Procedure3<Float64Member, Float64VectorMember, Float64VectorMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<Float64VectorMember, Float64VectorMember, Float64VectorMember> crossProduct() {
        return this.CROSS;
    }

    @Override
    public Procedure3<Float64VectorMember, Float64VectorMember, Float64Member> dotProduct() {
        return this.DOT;
    }

    @Override
    public Procedure3<Float64VectorMember, Float64VectorMember, Float64Member> perpDotProduct() {
        return this.PERP;
    }

    @Override
    public Procedure4<Float64VectorMember, Float64VectorMember, Float64VectorMember, Float64VectorMember> vectorTripleProduct() {
        return this.VTRIPLE;
    }

    @Override
    public Procedure4<Float64VectorMember, Float64VectorMember, Float64VectorMember, Float64Member> scalarTripleProduct() {
        return this.STRIPLE;
    }

    @Override
    public Procedure2<Float64VectorMember, Float64VectorMember> conjugate() {
        return this.ASSIGN;
    }

    @Override
    public Procedure3<Float64VectorMember, Float64VectorMember, Float64MatrixMember> vectorDirectProduct() {
        return this.VDP;
    }

    @Override
    public Procedure3<Float64VectorMember, Float64VectorMember, Float64MatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Function1<Boolean, Float64VectorMember> isNaN() {
        return this.ISNAN;
    }

    @Override
    public Procedure1<Float64VectorMember> nan() {
        return this.NAN;
    }

    @Override
    public Function1<Boolean, Float64VectorMember> isInfinite() {
        return this.ISINF;
    }

    @Override
    public Procedure1<Float64VectorMember> infinite() {
        return this.INF;
    }

    @Override
    public Procedure4<Round.Mode, Float64Member, Float64VectorMember, Float64VectorMember> round() {
        return this.ROUND;
    }

    @Override
    public Function1<Boolean, Float64VectorMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<HighPrecisionMember, Float64VectorMember, Float64VectorMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, Float64VectorMember, Float64VectorMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, Float64VectorMember, Float64VectorMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, Float64Member, Float64VectorMember, Float64VectorMember> within() {
        return this.WITHIN;
    }
}

