/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class MatrixColumnRModuleBridge<U>
implements RModuleMember<U> {
    private final U zero;
    private final MatrixMember<U> mat;
    private long col;

    public MatrixColumnRModuleBridge(Algebra<?, U> algebra, MatrixMember<U> mat) {
        this.zero = algebra.construct();
        this.mat = mat;
        this.col = 0L;
    }

    public void setCol(long col) {
        if (col < 0L || col >= this.mat.cols()) {
            throw new IllegalArgumentException("specified column outside bounds of matrix");
        }
        this.col = col;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension query");
        }
        if (d == 0) {
            return this.length();
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public long length() {
        return this.mat.rows();
    }

    @Override
    public boolean alloc(long len) {
        if (len == this.mat.rows()) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long len) {
        if (len == this.mat.rows()) {
            for (long i = 0L; i < this.length(); ++i) {
                this.setV(i, this.zero);
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long len) {
        if (len != this.mat.rows()) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long i, U value) {
        this.mat.v(i, this.col, value);
    }

    @Override
    public void setV(long i, U value) {
        this.mat.setV(i, this.col, value);
    }

    @Override
    public StorageConstruction storageType() {
        return this.mat.storageType();
    }
}

