/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class MatrixDiagonalRModuleBridge<U>
implements RModuleMember<U> {
    private final U zero;
    private final MatrixMember<U> mat;
    private Origin origin;
    private long diagNumber;

    public MatrixDiagonalRModuleBridge(Algebra<?, U> algebra, MatrixMember<U> mat) {
        this.zero = algebra.construct();
        this.mat = mat;
        this.origin = Origin.UpperLeft;
        this.diagNumber = 0L;
    }

    public void setDiagonal(Origin origin, long diagNumber) {
        this.origin = origin;
        this.diagNumber = diagNumber;
        if (this.length() <= 0L) {
            throw new IllegalArgumentException("diagonal number is outside allowed range");
        }
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension query");
        }
        if (d == 0) {
            return this.length();
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public long length() {
        return Math.min(this.mat.rows(), this.mat.cols()) - Math.abs(this.diagNumber);
    }

    @Override
    public boolean alloc(long len) {
        if (len == this.length()) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long len) {
        if (len == this.length()) {
            for (long i = 0L; i < len; ++i) {
                this.setV(i, this.zero);
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long len) {
        if (len != this.length()) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long i, U value) {
        if (i < 0L || i >= this.length()) {
            throw new IllegalArgumentException("diagonal indexed out of bounds");
        }
        long r = this.row(i);
        long c = this.col(i);
        this.mat.v(r, c, value);
    }

    @Override
    public void setV(long i, U value) {
        if (i < 0L || i >= this.length()) {
            throw new IllegalArgumentException("diagonal indexed out of bounds");
        }
        long r = this.row(i);
        long c = this.col(i);
        this.mat.setV(r, c, value);
    }

    long row(long i) {
        switch (this.origin) {
            case UpperLeft: {
                if (this.diagNumber < 0L) {
                    return i - this.diagNumber;
                }
                return i;
            }
            case LowerRight: {
                if (this.diagNumber < 0L) {
                    return this.mat.rows() - 1L - i + this.diagNumber;
                }
                return this.mat.rows() - 1L - i;
            }
            case UpperRight: {
                if (this.diagNumber < 0L) {
                    return i;
                }
                return i + this.diagNumber;
            }
        }
        if (this.diagNumber < 0L) {
            return this.mat.rows() - 1L - i;
        }
        return this.mat.rows() - 1L - i - this.diagNumber;
    }

    long col(long i) {
        switch (this.origin) {
            case UpperLeft: {
                if (this.diagNumber < 0L) {
                    return i;
                }
                return i + this.diagNumber;
            }
            case LowerRight: {
                if (this.diagNumber < 0L) {
                    return this.mat.cols() - 1L - i;
                }
                return this.mat.cols() - 1L - i - this.diagNumber;
            }
            case UpperRight: {
                if (this.diagNumber < 0L) {
                    return this.mat.cols() - 1L - i + this.diagNumber;
                }
                return this.mat.cols() - 1L - i;
            }
        }
        if (this.diagNumber < 0L) {
            return i - this.diagNumber;
        }
        return i;
    }

    @Override
    public StorageConstruction storageType() {
        return this.mat.storageType();
    }

    public static enum Origin {
        UpperLeft,
        UpperRight,
        LowerRight,
        LowerLeft;

    }
}

