/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.NumberMember;

public class MatrixElementNumberBridge<U>
implements NumberMember<U> {
    private final MatrixMember<U> mat;
    private long row;
    private long col;

    public MatrixElementNumberBridge(MatrixMember<U> mat) {
        this.mat = mat;
        this.row = 0L;
        this.col = 0L;
    }

    public void setRowCol(long r, long c) {
        if (r < 0L || r >= this.mat.rows() || c < 0L || c >= this.mat.cols()) {
            throw new IllegalArgumentException("number bridge set outside matrix bounds");
        }
        this.row = r;
        this.col = c;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension query");
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(U value) {
        this.mat.v(this.row, this.col, value);
    }

    @Override
    public void setV(U value) {
        this.mat.setV(this.row, this.col, value);
    }
}

