/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class MatrixRowRModuleBridge<U>
implements RModuleMember<U> {
    private final U zero;
    private final MatrixMember<U> mat;
    private long row;

    public MatrixRowRModuleBridge(Algebra<?, U> algebra, MatrixMember<U> mat) {
        this.zero = algebra.construct();
        this.mat = mat;
        this.row = 0L;
    }

    public void setRow(long row) {
        if (row < 0L || row >= this.mat.rows()) {
            throw new IllegalArgumentException("specified row outside bounds of matrix");
        }
        this.row = row;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension query");
        }
        if (d == 0) {
            return this.length();
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public long length() {
        return this.mat.cols();
    }

    @Override
    public boolean alloc(long len) {
        if (len == this.mat.cols()) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long len) {
        if (len == this.mat.cols()) {
            for (long i = 0L; i < this.length(); ++i) {
                this.setV(i, this.zero);
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long len) {
        if (len != this.mat.cols()) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long i, U value) {
        this.mat.v(this.row, i, value);
    }

    @Override
    public void setV(long i, U value) {
        this.mat.setV(this.row, i, value);
    }

    @Override
    public StorageConstruction storageType() {
        return this.mat.storageType();
    }
}

