/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class MatrixTensorBridge<U>
implements TensorMember<U> {
    private final Algebra<?, U> algebra;
    private final U zero;
    private MatrixMember<U> mat;
    private long startRow;
    private long startCol;
    private long size;

    public MatrixTensorBridge(Algebra<?, U> algebra, MatrixMember<U> mat) {
        this.mat = mat;
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.startRow = 0L;
        this.startCol = 0L;
        this.size = Math.min(mat.rows(), mat.cols());
    }

    public void setMat(MatrixMember<U> mat, long startRow, long startCol, long size) {
        if (startRow < 0L || startRow >= mat.rows()) {
            throw new IllegalArgumentException("startRow is of bounds");
        }
        if (startCol < 0L || startCol >= mat.cols()) {
            throw new IllegalArgumentException("startCol is of bounds");
        }
        if (size < 1L) {
            throw new IllegalArgumentException("size must be positive");
        }
        if (startRow + size >= mat.rows() || startCol + size >= mat.cols()) {
            throw new IllegalArgumentException("dimensions out of bounds");
        }
        this.mat = mat;
        this.startRow = startRow;
        this.startCol = startCol;
        this.size = size;
    }

    @Override
    public long dimension(int d) {
        if (d == 0 || d == 1) {
            return this.size;
        }
        throw new IllegalArgumentException("dimension out of bounds exception");
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public boolean alloc(long[] dims) {
        if (this.dimsCompatible(dims)) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long[] dims) {
        if (this.dimsCompatible(dims)) {
            for (long r = this.startRow; r < this.startRow + this.size; ++r) {
                for (long c = this.startCol; c < this.startCol + this.size; ++c) {
                    this.mat.setV(r, c, this.zero);
                }
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long[] dims) {
        if (!this.dimsCompatible(dims)) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(IntegerIndex index, U value) {
        for (int i = 2; i < index.numDimensions(); ++i) {
            if (index.get(i) == 0L) continue;
            this.algebra.assign().call(this.zero, value);
            return;
        }
        long c = index.get(0);
        long r = index.get(1);
        this.mat.v(this.startRow + r, this.startCol + c, value);
    }

    @Override
    public void setV(IntegerIndex index, U value) {
        for (int i = 2; i < index.numDimensions(); ++i) {
            if (index.get(i) == 0L || !this.algebra.isNotEqual().call(this.zero, value).booleanValue()) continue;
            throw new IllegalArgumentException("out of bounds nonzero write");
        }
        long c = index.get(0);
        long r = index.get(1);
        this.mat.setV(this.startRow + r, this.startCol + c, value);
    }

    @Override
    public StorageConstruction storageType() {
        return this.mat.storageType();
    }

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        return 2;
    }

    @Override
    public int upperRank() {
        return 0;
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return true;
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return false;
    }

    @Override
    public long dimension() {
        return this.size;
    }

    private boolean dimsCompatible(long[] newDims) {
        if (newDims.length < 2) {
            return false;
        }
        for (int i = 2; i < newDims.length; ++i) {
            if (newDims[i] == 1L) continue;
            return false;
        }
        if (newDims[0] != this.size) {
            return false;
        }
        return newDims[1] == this.size;
    }
}

