/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class NumberMatrixBridge<U>
implements MatrixMember<U> {
    private final Algebra<?, U> algebra;
    private final U zero;
    private NumberMember<U> num;

    public NumberMatrixBridge(Algebra<?, U> algebra, NumberMember<U> num) {
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.num = num;
    }

    public void setNum(NumberMember<U> num) {
        this.num = num;
    }

    @Override
    public long dimension(int d) {
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public long rows() {
        return 1L;
    }

    @Override
    public long cols() {
        return 1L;
    }

    @Override
    public boolean alloc(long rows, long cols) {
        if (rows == 1L && cols == 1L) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long rows, long cols) {
        if (rows != 1L || cols != 1L) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
        this.num.setV(this.zero);
    }

    @Override
    public void reshape(long rows, long cols) {
        if (rows != 1L || cols != 1L) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long r, long c, U value) {
        if (r == 0L && c == 0L) {
            this.num.v(value);
        } else {
            this.algebra.assign().call(this.zero, value);
        }
    }

    @Override
    public void setV(long r, long c, U value) {
        if (r == 0L && c == 0L) {
            this.num.setV(value);
        } else if (this.algebra.isNotEqual().call(this.zero, value).booleanValue()) {
            throw new IllegalArgumentException("out of bounds nonzero write");
        }
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

