/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class NumberRModuleBridge<U>
implements RModuleMember<U> {
    private final U zero;
    private final Algebra<?, U> algebra;
    private NumberMember<U> num;

    public NumberRModuleBridge(Algebra<?, U> algebra, NumberMember<U> num) {
        this.zero = algebra.construct();
        this.algebra = algebra;
        this.num = num;
    }

    public void setNum(NumberMember<U> num) {
        this.num = num;
    }

    @Override
    public long dimension(int d) {
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public long length() {
        return 1L;
    }

    @Override
    public boolean alloc(long len) {
        if (len == 1L) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long len) {
        if (len != 1L) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
        this.num.setV(this.zero);
    }

    @Override
    public void reshape(long len) {
        if (len != 1L) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long i, U value) {
        if (i == 0L) {
            this.num.v(value);
        } else {
            this.algebra.assign().call(this.zero, value);
        }
    }

    @Override
    public void setV(long i, U value) {
        if (i == 0L) {
            this.num.setV(value);
        } else if (this.algebra.isNotEqual().call(this.zero, value).booleanValue()) {
            throw new IllegalArgumentException("out of bounds nonzero write");
        }
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }
}

