/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class NumberTensorBridge<U>
implements TensorMember<U> {
    private final U zero;
    private final Algebra<?, U> algebra;
    private NumberMember<U> num;

    public NumberTensorBridge(Algebra<?, U> algebra, NumberMember<U> num) {
        this.zero = algebra.construct();
        this.algebra = algebra;
        this.num = num;
    }

    public void setNum(NumberMember<U> num) {
        this.num = num;
    }

    @Override
    public long dimension(int d) {
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public boolean alloc(long[] dims) {
        if (this.dimsCompatible(dims)) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long[] dims) {
        if (!this.dimsCompatible(dims)) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
        this.num.setV(this.zero);
    }

    @Override
    public void reshape(long[] dims) {
        if (!this.dimsCompatible(dims)) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(IntegerIndex index, U value) {
        for (int i = 1; i < index.numDimensions(); ++i) {
            if (index.get(i) == 0L) continue;
            this.algebra.assign().call(this.zero, value);
            return;
        }
        this.num.v(value);
    }

    @Override
    public void setV(IntegerIndex index, U value) {
        for (int i = 1; i < index.numDimensions(); ++i) {
            if (index.get(i) == 0L || !this.algebra.isNotEqual().call(this.zero, value).booleanValue()) continue;
            throw new IllegalArgumentException("out of bounds nonzero write");
        }
        this.num.setV(value);
    }

    @Override
    public StorageConstruction storageType() {
        return StorageConstruction.MEM_ARRAY;
    }

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        return 0;
    }

    @Override
    public int upperRank() {
        return 0;
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return true;
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return false;
    }

    @Override
    public long dimension() {
        return 1L;
    }

    private boolean dimsCompatible(long[] newDims) {
        if (newDims.length < 1) {
            return false;
        }
        for (int i = 0; i < newDims.length; ++i) {
            if (newDims[i] == 1L) continue;
            return false;
        }
        return true;
    }
}

