/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;

public class RModuleElementNumberBridge<U>
implements NumberMember<U> {
    private final RModuleMember<U> rmod;
    private long index;

    public RModuleElementNumberBridge(RModuleMember<U> rmod) {
        this.rmod = rmod;
        this.index = 0L;
    }

    public void setIndex(long i) {
        if (i < 0L || i >= this.rmod.length()) {
            throw new IllegalArgumentException("number bridge set outside rmodule bounds");
        }
        this.index = i;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension query");
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(U value) {
        this.rmod.v(this.index, value);
    }

    @Override
    public void setV(U value) {
        this.rmod.setV(this.index, value);
    }
}

