/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class RModuleMatrixBridge<U>
implements MatrixMember<U> {
    private final Algebra<?, U> algebra;
    private final U zero;
    private final RModuleMember<U> rmod;
    private boolean isColumn;

    public RModuleMatrixBridge(Algebra<?, U> algebra, RModuleMember<U> rmod) {
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.rmod = rmod;
        this.isColumn = true;
    }

    public void setIsColumn(boolean b) {
        this.isColumn = b;
    }

    public boolean isColumn() {
        return this.isColumn;
    }

    public boolean isRow() {
        return !this.isColumn;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension exception");
        }
        if (d == 0) {
            return this.cols();
        }
        if (d == 1) {
            return this.rows();
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public long rows() {
        return this.isColumn ? 1L : this.rmod.length();
    }

    @Override
    public long cols() {
        return this.isColumn ? this.rmod.length() : 1L;
    }

    @Override
    public boolean alloc(long rows, long cols) {
        if (this.isColumn && rows == 1L && cols == this.rmod.length()) {
            return false;
        }
        if (!this.isColumn && rows == this.rmod.length() && cols == 1L) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long rows, long cols) {
        block3: {
            block2: {
                if (!this.isColumn || rows != 1L || cols != this.rmod.length()) break block2;
                for (long i = 0L; i < this.rmod.length(); ++i) {
                    this.rmod.setV(i, this.zero);
                }
                break block3;
            }
            if (this.isColumn || rows != this.rmod.length() || cols != 1L) break block3;
            for (long i = 0L; i < this.rmod.length(); ++i) {
                this.rmod.setV(i, this.zero);
            }
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void reshape(long rows, long cols) {
        if (!(this.isColumn && rows == 1L && cols == this.rmod.length() || !this.isColumn && rows == this.rmod.length() && cols == 1L)) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long r, long c, U value) {
        if (this.isColumn) {
            if (r != 0L) {
                this.algebra.assign().call(this.zero, value);
            } else {
                this.rmod.v(c, value);
            }
        } else if (c != 0L) {
            this.algebra.assign().call(this.zero, value);
        } else {
            this.rmod.v(r, value);
        }
    }

    @Override
    public void setV(long r, long c, U value) {
        if (this.isColumn) {
            if (r != 0L && this.algebra.isNotEqual().call(this.zero, value).booleanValue()) {
                throw new IllegalArgumentException("out of bounds nonzero write");
            }
            this.rmod.setV(c, value);
        } else {
            if (c != 0L && this.algebra.isNotEqual().call(this.zero, value).booleanValue()) {
                throw new IllegalArgumentException("out of bounds nonzero write");
            }
            this.rmod.setV(r, value);
        }
    }

    @Override
    public StorageConstruction storageType() {
        return this.rmod.storageType();
    }
}

