/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class RModuleTensorBridge<U>
implements TensorMember<U> {
    private final Algebra<?, U> algebra;
    private final U zero;
    private final RModuleMember<U> rmod;

    public RModuleTensorBridge(Algebra<?, U> algebra, RModuleMember<U> rmod) {
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.rmod = rmod;
    }

    @Override
    public long dimension(int d) {
        return this.rmod.dimension(d);
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public boolean alloc(long[] dims) {
        if (this.dimsCompatible(dims)) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long[] dims) {
        if (this.dimsCompatible(dims)) {
            for (long i = 0L; i < this.rmod.length(); ++i) {
                this.rmod.setV(i, this.zero);
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long[] dims) {
        if (!this.dimsCompatible(dims)) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(IntegerIndex index, U value) {
        for (int i = 1; i < index.numDimensions(); ++i) {
            if (index.get(i) == 0L) continue;
            this.algebra.assign().call(this.zero, value);
            return;
        }
        long i = index.get(0);
        this.rmod.v(i, value);
    }

    @Override
    public void setV(IntegerIndex index, U value) {
        for (int i = 1; i < index.numDimensions(); ++i) {
            if (index.get(i) == 0L || !this.algebra.isNotEqual().call(this.zero, value).booleanValue()) continue;
            throw new IllegalArgumentException("out of bounds nonzero write");
        }
        long i = index.get(0);
        this.rmod.setV(i, value);
    }

    @Override
    public StorageConstruction storageType() {
        return this.rmod.storageType();
    }

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        return 1;
    }

    @Override
    public int upperRank() {
        return 0;
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return true;
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return false;
    }

    @Override
    public long dimension() {
        return this.rmod.length();
    }

    private boolean dimsCompatible(long[] newDims) {
        if (newDims.length < 1) {
            return false;
        }
        for (int i = 1; i < newDims.length; ++i) {
            if (newDims[i] == 1L) continue;
            return false;
        }
        return newDims[0] == this.rmod.length();
    }
}

