/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class SubMatrixBridge<U>
implements MatrixMember<U> {
    private final U zero;
    private final MatrixMember<U> mat;
    private long startRow;
    private long countRows;
    private long startCol;
    private long countCols;

    public SubMatrixBridge(Algebra<?, U> algebra, MatrixMember<U> mat) {
        this.zero = algebra.construct();
        this.mat = mat;
        this.startRow = 0L;
        this.startCol = 0L;
        this.countRows = mat.rows();
        this.countCols = mat.cols();
    }

    public void setSubrow(long matrixStartRow, long matrixCountRows) {
        if (matrixStartRow < 0L) {
            throw new IllegalArgumentException("negative start row");
        }
        if (matrixCountRows < 1L) {
            throw new IllegalArgumentException("non-positive count rows");
        }
        if (matrixStartRow + matrixCountRows > this.mat.rows()) {
            throw new IllegalArgumentException("subrow beyond end of matrix row");
        }
        this.startRow = matrixStartRow;
        this.countRows = matrixCountRows;
    }

    public void setSubcol(long matrixStartCol, long matrixCountCols) {
        if (matrixStartCol < 0L) {
            throw new IllegalArgumentException("negative start col");
        }
        if (matrixCountCols < 1L) {
            throw new IllegalArgumentException("non-positive count cols");
        }
        if (matrixStartCol + matrixCountCols > this.mat.cols()) {
            throw new IllegalArgumentException("subcol beyond end of matrix row");
        }
        this.startCol = matrixStartCol;
        this.countCols = matrixCountCols;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension exception");
        }
        if (d == 0) {
            return this.countCols;
        }
        if (d == 1) {
            return this.countRows;
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public long rows() {
        return this.countRows;
    }

    @Override
    public long cols() {
        return this.countCols;
    }

    @Override
    public boolean alloc(long rows, long cols) {
        if (rows == this.countRows && cols == this.countCols) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long rows, long cols) {
        if (rows == this.countRows && cols == this.countCols) {
            for (long r = 0L; r < this.countRows; ++r) {
                for (long c = 0L; c < this.countCols; ++c) {
                    this.setV(r, c, this.zero);
                }
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long rows, long cols) {
        if (rows != this.countRows || cols != this.countCols) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long r, long c, U value) {
        this.mat.v(this.startRow + r, this.startCol + c, value);
    }

    @Override
    public void setV(long r, long c, U value) {
        this.mat.setV(this.startRow + r, this.startCol + c, value);
    }

    @Override
    public StorageConstruction storageType() {
        return this.mat.storageType();
    }
}

