/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class SubRModuleBridge<U>
implements RModuleMember<U> {
    private final U zero;
    private final RModuleMember<U> rmod;
    private long startElem;
    private long countElems;

    public SubRModuleBridge(Algebra<?, U> algebra, RModuleMember<U> rmod) {
        this.zero = algebra.construct();
        this.rmod = rmod;
        this.startElem = 0L;
        this.countElems = rmod.length();
    }

    public void setSubrange(long rmodStartElem, long rmodCountElems) {
        if (rmodStartElem < 0L) {
            throw new IllegalArgumentException("negative start elem");
        }
        if (rmodCountElems < 1L) {
            throw new IllegalArgumentException("non-positive count elems");
        }
        if (rmodStartElem + rmodCountElems > this.rmod.length()) {
            throw new IllegalArgumentException("subelement beyond end of rmodule");
        }
        this.startElem = rmodStartElem;
        this.countElems = rmodCountElems;
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension exception");
        }
        if (d == 0) {
            return this.countElems;
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public long length() {
        return this.countElems;
    }

    @Override
    public boolean alloc(long len) {
        if (len == this.countElems) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long len) {
        if (len == this.countElems) {
            for (long i = 0L; i < this.countElems; ++i) {
                this.setV(i, this.zero);
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long len) {
        if (len != this.countElems) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long i, U value) {
        this.rmod.v(this.startElem + i, value);
    }

    @Override
    public void setV(long i, U value) {
        this.rmod.setV(this.startElem + i, value);
    }

    @Override
    public StorageConstruction storageType() {
        return this.rmod.storageType();
    }
}

