/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class SubTensorBridge<U>
implements TensorMember<U> {
    private final Algebra<?, U> algebra;
    private final U zero;
    private final TensorMember<U> tensor;
    private IntegerIndex index;
    private int[] rangingDims;
    private long dim;

    public SubTensorBridge(Algebra<?, U> algebra, TensorMember<U> tensor) {
        if (tensor.numDimensions() < 2) {
            throw new IllegalArgumentException("subtensor can only be constructed on tensor with 2 or more dimensions");
        }
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.tensor = tensor;
        this.index = new IntegerIndex(tensor.numDimensions());
        this.rangingDims = new int[tensor.numDimensions()];
        for (int i = 0; i < tensor.numDimensions(); ++i) {
            this.rangingDims[i] = i;
        }
        this.dim = tensor.dimension(0);
    }

    public void setSubrange(int rank, int dim, int[] rangingDims, long[] fixedDimValues) {
        int i;
        int i2;
        if (rank < 2 || rank > this.tensor.numDimensions()) {
            throw new IllegalArgumentException("rank of subtensor outside legal range");
        }
        if (dim < 1 || (long)dim > this.tensor.dimension(0)) {
            throw new IllegalArgumentException("dimension of subtensor outside legal range");
        }
        if (rank != rangingDims.length) {
            throw new IllegalArgumentException("count of ranging dimensions does not match given rank");
        }
        if (rangingDims.length + fixedDimValues.length != this.tensor.numDimensions()) {
            throw new IllegalArgumentException("combined dims are incompatible with given tensor");
        }
        for (i2 = 0; i2 < rangingDims.length; ++i2) {
            int v = rangingDims[i2];
            if (v < 0 || v >= this.tensor.numDimensions()) {
                throw new IllegalArgumentException("");
            }
            for (int j = i2 + 1; j < rangingDims.length; ++j) {
                if (rangingDims[j] == v) {
                    throw new IllegalArgumentException("repeated ranging dim not allowed");
                }
                if (rangingDims[j] >= v) continue;
                throw new IllegalArgumentException("ranging dims must be specified as increasing values");
            }
        }
        for (i2 = 0; i2 < fixedDimValues.length; ++i2) {
            long v = fixedDimValues[i2];
            if (v >= 0L && v < this.tensor.dimension(0)) continue;
            throw new IllegalArgumentException("fixed dimensions out of range");
        }
        this.rangingDims = (int[])rangingDims.clone();
        this.dim = dim;
        int f = 0;
        for (i = 0; i < rangingDims.length; ++i) {
            int v = rangingDims[i];
            while (f < v) {
                this.index.set(f, fixedDimValues[f]);
                ++f;
            }
            this.index.set(f, 0L);
            ++f;
        }
        for (i = rangingDims[rangingDims.length - 1] + 1; i < this.tensor.numDimensions(); ++i) {
            this.index.set(i, fixedDimValues[f]);
            ++f;
        }
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension exception");
        }
        if (d >= this.rangingDims.length) {
            throw new IllegalArgumentException("dimension out of bounds exception");
        }
        return this.dim;
    }

    @Override
    public int numDimensions() {
        return this.rangingDims.length;
    }

    @Override
    public boolean alloc(long[] dims) {
        if (this.dimsCompatible(dims)) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long[] dims) {
        if (this.dimsCompatible(dims)) {
            IntegerIndex idx = new IntegerIndex(dims.length);
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(new long[dims.length], dims);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            while (iter.hasNext()) {
                iter.next(idx);
                this.setV(idx, this.zero);
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long[] dims) {
        if (!this.dimsCompatible(dims)) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(IntegerIndex index, U value) {
        if (index.numDimensions() != this.rangingDims.length) {
            throw new IllegalArgumentException("mismatched dims exception");
        }
        for (int i = 0; i < this.rangingDims.length; ++i) {
            index.set(this.rangingDims[i], index.get(i));
        }
        if (this.oob()) {
            this.algebra.assign().call(this.zero, value);
        } else {
            this.tensor.v(index, value);
        }
    }

    @Override
    public void setV(IntegerIndex index, U value) {
        if (index.numDimensions() != this.rangingDims.length) {
            throw new IllegalArgumentException("mismatched dims exception");
        }
        for (int i = 0; i < this.rangingDims.length; ++i) {
            index.set(this.rangingDims[i], index.get(i));
        }
        if (this.oob()) {
            if (this.algebra.isNotEqual().call(this.zero, value).booleanValue()) {
                throw new IllegalArgumentException("out of bounds nonzero write");
            }
        } else {
            this.tensor.setV(index, value);
        }
    }

    @Override
    public StorageConstruction storageType() {
        return this.tensor.storageType();
    }

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        throw new IllegalArgumentException("to be impemented");
    }

    @Override
    public int upperRank() {
        throw new IllegalArgumentException("to be impemented");
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        throw new IllegalArgumentException("to be impemented");
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        throw new IllegalArgumentException("to be impemented");
    }

    @Override
    public long dimension() {
        throw new IllegalArgumentException("TODO");
    }

    private boolean dimsCompatible(long[] newDims) {
        if (newDims.length != this.rangingDims.length) {
            return false;
        }
        for (int i = 0; i < this.rangingDims.length; ++i) {
            if (newDims[i] == this.dim) continue;
            return false;
        }
        return true;
    }

    private boolean oob() {
        for (int i = 0; i < this.index.numDimensions(); ++i) {
            long v = this.index.get(i);
            if (v >= 0L && v < this.tensor.dimension(i)) continue;
            return true;
        }
        return false;
    }
}

