/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.NumberMember;
import nom.bdezonia.zorbage.type.algebra.TensorMember;

public class TensorElementNumberBridge<U>
implements NumberMember<U> {
    private final TensorMember<U> tensor;
    private final IntegerIndex index;

    public TensorElementNumberBridge(TensorMember<U> tensor) {
        this.tensor = tensor;
        this.index = new IntegerIndex(tensor.numDimensions());
    }

    public void setIndex(IntegerIndex idx) {
        int i;
        for (i = 0; i < this.index.numDimensions(); ++i) {
            this.index.set(i, 0L);
        }
        for (i = 0; i < idx.numDimensions(); ++i) {
            if (i < this.index.numDimensions()) {
                this.index.set(i, idx.get(i));
                continue;
            }
            if (idx.get(i) <= 0L) continue;
            throw new IllegalArgumentException("out of bounds index");
        }
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension exception");
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    public void v(U value) {
        this.tensor.v(this.index, value);
    }

    @Override
    public void setV(U value) {
        this.tensor.setV(this.index, value);
    }
}

