/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class TensorMatrixBridge<U>
implements MatrixMember<U> {
    private final Algebra<?, U> algebra;
    private final U zero;
    private final TensorMember<U> tensor;
    private final IntegerIndex fixedDims;
    private int rangingDimR;
    private int rangingDimC;

    public TensorMatrixBridge(Algebra<?, U> algebra, TensorMember<U> tensor) {
        if (tensor.numDimensions() < 2) {
            throw new IllegalArgumentException();
        }
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.tensor = tensor;
        this.fixedDims = new IntegerIndex(tensor.numDimensions());
        this.rangingDimC = 0;
        this.rangingDimR = 0;
    }

    public void setMatrix(IntegerIndex idx, int rDim, int cDim) {
        if (idx.numDimensions() != this.fixedDims.numDimensions()) {
            throw new IllegalArgumentException("mismatched dimensions");
        }
        if (rDim < 0 || rDim >= this.fixedDims.numDimensions()) {
            throw new IllegalArgumentException("row dim out of range");
        }
        if (cDim < 0 || cDim >= this.fixedDims.numDimensions()) {
            throw new IllegalArgumentException("col dim out of range");
        }
        if (rDim == cDim) {
            throw new IllegalArgumentException("cannot specify same dim twice");
        }
        this.rangingDimR = rDim;
        this.rangingDimC = cDim;
        for (int i = 0; i < idx.numDimensions(); ++i) {
            this.fixedDims.set(i, idx.get(i));
        }
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension exception");
        }
        if (d == 0) {
            return this.cols();
        }
        if (d == 1) {
            return this.rows();
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 2;
    }

    @Override
    public long rows() {
        return this.tensor.dimension(this.rangingDimR);
    }

    @Override
    public long cols() {
        return this.tensor.dimension(this.rangingDimC);
    }

    @Override
    public boolean alloc(long rows, long cols) {
        if (rows == this.rows() && cols == this.cols()) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long rows, long cols) {
        if (rows == this.rows() && cols == this.cols()) {
            for (long r = 0L; r < rows; ++r) {
                for (long c = 0L; c < cols; ++c) {
                    this.setV(r, c, this.zero);
                }
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long rows, long cols) {
        if (rows != this.rows() && cols != this.cols()) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long r, long c, U value) {
        if (r < 0L || r >= this.rows() || c < 0L || c >= this.cols()) {
            this.algebra.assign().call(this.zero, value);
        } else {
            this.fixedDims.set(this.rangingDimR, r);
            this.fixedDims.set(this.rangingDimC, c);
            this.tensor.v(this.fixedDims, value);
        }
    }

    @Override
    public void setV(long r, long c, U value) {
        if (r < 0L || r >= this.rows() || c < 0L || c >= this.cols()) {
            if (this.algebra.isNotEqual().call(this.zero, value).booleanValue()) {
                throw new IllegalArgumentException("out of bounds nonzero write");
            }
        } else {
            this.fixedDims.set(this.rangingDimR, r);
            this.fixedDims.set(this.rangingDimC, c);
            this.tensor.setV(this.fixedDims, value);
        }
    }

    @Override
    public StorageConstruction storageType() {
        return this.tensor.storageType();
    }
}

