/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.helper;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class TensorRModuleBridge<U>
implements RModuleMember<U> {
    private final Algebra<?, U> algebra;
    private final U zero;
    private final TensorMember<U> tensor;
    private final IntegerIndex fixedDims;
    private int rangingDim;

    public TensorRModuleBridge(Algebra<?, U> algebra, TensorMember<U> tensor) {
        this.algebra = algebra;
        this.zero = algebra.construct();
        this.tensor = tensor;
        this.fixedDims = new IntegerIndex(tensor.numDimensions());
        this.rangingDim = 0;
    }

    public void setRmodule(IntegerIndex idx, int dim) {
        if (idx.numDimensions() != this.fixedDims.numDimensions()) {
            throw new IllegalArgumentException("mismatched dimensions");
        }
        if (dim < 0 || dim >= this.fixedDims.numDimensions()) {
            throw new IllegalArgumentException("dim out of range");
        }
        this.rangingDim = dim;
        for (int i = 0; i < idx.numDimensions(); ++i) {
            this.fixedDims.set(i, idx.get(i));
        }
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("negative dimension exception");
        }
        if (d == 0) {
            return this.length();
        }
        return 1L;
    }

    @Override
    public int numDimensions() {
        return 1;
    }

    @Override
    public long length() {
        return this.tensor.dimension(this.rangingDim);
    }

    @Override
    public boolean alloc(long len) {
        if (len == this.length()) {
            return false;
        }
        throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
    }

    @Override
    public void init(long len) {
        if (len == this.length()) {
            for (long i = 0L; i < len; ++i) {
                this.setV(i, this.zero);
            }
        } else {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void reshape(long len) {
        if (len != this.length()) {
            throw new UnsupportedOperationException("read only wrapper does not allow reallocation of data");
        }
    }

    @Override
    public void v(long i, U value) {
        if (i < 0L || i >= this.length()) {
            this.algebra.assign().call(this.zero, value);
        } else {
            this.fixedDims.set(this.rangingDim, i);
            this.tensor.v(this.fixedDims, value);
        }
    }

    @Override
    public void setV(long i, U value) {
        if (i < 0L || i >= this.length()) {
            if (this.algebra.isNotEqual().call(this.zero, value).booleanValue()) {
                throw new IllegalArgumentException("out of bounds nonzero write");
            }
        } else {
            this.fixedDims.set(this.rangingDim, i);
            this.tensor.setV(this.fixedDims, value);
        }
    }

    @Override
    public StorageConstruction storageType() {
        return this.tensor.storageType();
    }
}

