/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.complex;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.ComplexNumberWithin;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Conjugate;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Field;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.ImaginaryConstants;
import nom.bdezonia.zorbage.type.algebra.InverseHyperbolic;
import nom.bdezonia.zorbage.type.algebra.InverseTrigonometric;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RealUnreal;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.ScaleComponents;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexHighPrecisionAlgebra
implements Field<ComplexHighPrecisionAlgebra, ComplexHighPrecisionMember>,
Norm<ComplexHighPrecisionMember, HighPrecisionMember>,
RealConstants<ComplexHighPrecisionMember>,
ImaginaryConstants<ComplexHighPrecisionMember>,
Exponential<ComplexHighPrecisionMember>,
Trigonometric<ComplexHighPrecisionMember>,
InverseTrigonometric<ComplexHighPrecisionMember>,
Hyperbolic<ComplexHighPrecisionMember>,
InverseHyperbolic<ComplexHighPrecisionMember>,
Roots<ComplexHighPrecisionMember>,
Power<ComplexHighPrecisionMember>,
Conjugate<ComplexHighPrecisionMember>,
RealUnreal<ComplexHighPrecisionMember, HighPrecisionMember>,
Scale<ComplexHighPrecisionMember, ComplexHighPrecisionMember>,
ScaleByHighPrec<ComplexHighPrecisionMember>,
ScaleByRational<ComplexHighPrecisionMember>,
ScaleByDouble<ComplexHighPrecisionMember>,
ScaleComponents<ComplexHighPrecisionMember, HighPrecisionMember>,
Tolerance<HighPrecisionMember, ComplexHighPrecisionMember> {
    private static final ComplexHighPrecisionMember ONE = new ComplexHighPrecisionMember(BigDecimal.ONE, BigDecimal.ZERO);
    private static final ComplexHighPrecisionMember TWO = new ComplexHighPrecisionMember(BigDecimal.valueOf(2L), BigDecimal.ZERO);
    private static final ComplexHighPrecisionMember MINUS_ONE = new ComplexHighPrecisionMember(BigDecimal.valueOf(-1L), BigDecimal.ZERO);
    private static final ComplexHighPrecisionMember I = new ComplexHighPrecisionMember(BigDecimal.ZERO, BigDecimal.ONE);
    private static final ComplexHighPrecisionMember TWO_I = new ComplexHighPrecisionMember(BigDecimal.ZERO, BigDecimal.valueOf(2L));
    private static final ComplexHighPrecisionMember MINUS_I = new ComplexHighPrecisionMember(BigDecimal.ZERO, BigDecimal.valueOf(-1L));
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> MUL = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            BigDecimal r = a.r().multiply(b.r()).subtract(a.i().multiply(b.i()));
            BigDecimal i = a.i().multiply(b.r()).subtract(a.r().multiply(b.i()));
            c.setR(r);
            c.setI(i);
        }
    };
    private final Procedure3<Integer, ComplexHighPrecisionMember, ComplexHighPrecisionMember> POWER = new Procedure3<Integer, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(Integer power, ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            if (power == 0 && ComplexHighPrecisionAlgebra.this.isZero().call(a).booleanValue()) {
                throw new IllegalArgumentException("0^0 is not a number");
            }
            BigDecimal r = ComplexHighPrecisionAlgebra.this.getModulus(a);
            BigDecimal rToTheN = BigDecimalMath.pow((BigDecimal)r, (long)power.intValue(), (MathContext)HighPrecisionAlgebra.getContext());
            BigDecimal nTheta = BigDecimal.valueOf(power.intValue()).multiply(ComplexHighPrecisionAlgebra.this.getArgument(a));
            b.setR(rToTheN.multiply(BigDecimalMath.cos((BigDecimal)nTheta, (MathContext)HighPrecisionAlgebra.getContext())));
            b.setI(rToTheN.multiply(BigDecimalMath.sin((BigDecimal)nTheta, (MathContext)HighPrecisionAlgebra.getContext())));
        }
    };
    private final Procedure1<ComplexHighPrecisionMember> ZER = new Procedure1<ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> NEG = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            b.setR(a.r().negate());
            b.setI(a.i().negate());
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> ADD = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            c.setR(a.r().add(b.r()));
            c.setI(a.i().add(b.i()));
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> SUB = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            c.setR(a.r().subtract(b.r()));
            c.setI(a.i().subtract(b.i()));
        }
    };
    private final Function2<Boolean, ComplexHighPrecisionMember, ComplexHighPrecisionMember> EQ = new Function2<Boolean, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            return a.r().equals(b.r()) && a.i().equals(b.i());
        }
    };
    private final Function2<Boolean, ComplexHighPrecisionMember, ComplexHighPrecisionMember> NEQ = new Function2<Boolean, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            return !a.r().equals(b.r()) || !a.i().equals(b.i());
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ASSIGN = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember from, ComplexHighPrecisionMember to) {
            to.set(from);
        }
    };
    private final Procedure1<ComplexHighPrecisionMember> UNITY = new Procedure1<ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a) {
            ComplexHighPrecisionAlgebra.this.assign().call(ONE, a);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> INV = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionAlgebra.this.divide().call(ONE, a, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> DIVIDE = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            BigDecimal mod2 = ComplexHighPrecisionAlgebra.this.getModulus2(b);
            BigDecimal r = a.r().multiply(b.r()).add(a.i().multiply(b.i())).divide(mod2, HighPrecisionAlgebra.getContext());
            BigDecimal i = a.i().multiply(b.r()).subtract(a.r().multiply(b.i())).divide(mod2, HighPrecisionAlgebra.getContext());
            c.setR(r);
            c.setI(i);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> CONJ = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            b.setR(a.r());
            b.setI(a.i().negate());
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, HighPrecisionMember> NORM = new Procedure2<ComplexHighPrecisionMember, HighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, HighPrecisionMember b) {
            b.setV(ComplexHighPrecisionAlgebra.this.getModulus(a));
        }
    };
    private final Procedure1<ComplexHighPrecisionMember> PI_ = new Procedure1<ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a) {
            HighPrecisionMember pi = G.HP.construct();
            G.HP.PI().call(pi);
            a.setR(pi.v());
            a.setI(BigDecimal.ZERO);
        }
    };
    private final Procedure1<ComplexHighPrecisionMember> E_ = new Procedure1<ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a) {
            HighPrecisionMember e = G.HP.construct();
            G.HP.E().call(e);
            a.setR(e.v());
            a.setI(BigDecimal.ZERO);
        }
    };
    private final Procedure1<ComplexHighPrecisionMember> GAMMA_ = new Procedure1<ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a) {
            HighPrecisionMember gamma = G.HP.construct();
            G.HP.GAMMA().call(gamma);
            a.setR(gamma.v());
            a.setI(BigDecimal.ZERO);
        }
    };
    private final Procedure1<ComplexHighPrecisionMember> PHI_ = new Procedure1<ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a) {
            HighPrecisionMember phi = G.HP.construct();
            G.HP.PHI().call(phi);
            a.setR(phi.v());
            a.setI(BigDecimal.ZERO);
        }
    };
    private final Procedure1<ComplexHighPrecisionMember> I_ = new Procedure1<ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a) {
            ComplexHighPrecisionAlgebra.this.assign().call(I, a);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ASIN = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember ia = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember aSquared = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember miniSum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember root = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember logSum = new ComplexHighPrecisionMember();
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_HALF = new ComplexHighPrecisionMember(one_half, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.multiply().call(I, a, ia);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, a, aSquared);
            ComplexHighPrecisionAlgebra.this.subtract().call(ONE, aSquared, miniSum);
            ComplexHighPrecisionAlgebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexHighPrecisionAlgebra.this.add().call(ia, root, sum);
            ComplexHighPrecisionAlgebra.this.log().call(sum, logSum);
            ComplexHighPrecisionAlgebra.this.multiply().call(MINUS_I, logSum, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ACOS = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember aSquared = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember miniSum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember root = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember logSum = new ComplexHighPrecisionMember();
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_HALF = new ComplexHighPrecisionMember(one_half, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, a, aSquared);
            ComplexHighPrecisionAlgebra.this.subtract().call(aSquared, ONE, miniSum);
            ComplexHighPrecisionAlgebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexHighPrecisionAlgebra.this.add().call(a, root, sum);
            ComplexHighPrecisionAlgebra.this.log().call(sum, logSum);
            ComplexHighPrecisionAlgebra.this.multiply().call(MINUS_I, logSum, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ATAN = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember ia = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember diff = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember quotient = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember log = new ComplexHighPrecisionMember();
            BigDecimal minus_one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(-2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember MINUS_I_OVER_TWO = new ComplexHighPrecisionMember(BigDecimal.ZERO, minus_one_half);
            ComplexHighPrecisionAlgebra.this.multiply().call(I, a, ia);
            ComplexHighPrecisionAlgebra.this.add().call(ONE, ia, sum);
            ComplexHighPrecisionAlgebra.this.subtract().call(ONE, ia, diff);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, diff, quotient);
            ComplexHighPrecisionAlgebra.this.log().call(quotient, log);
            ComplexHighPrecisionAlgebra.this.multiply().call(MINUS_I_OVER_TWO, log, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ACSC = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember recipA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.invert().call(a, recipA);
            ComplexHighPrecisionAlgebra.this.asin().call(recipA, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ASEC = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember recipA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.invert().call(a, recipA);
            ComplexHighPrecisionAlgebra.this.acos().call(recipA, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ACOT = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember ia = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember diff = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember quotient = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember log = new ComplexHighPrecisionMember();
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember I_OVER_TWO = new ComplexHighPrecisionMember(BigDecimal.ZERO, one_half);
            ComplexHighPrecisionAlgebra.this.multiply().call(I, a, ia);
            ComplexHighPrecisionAlgebra.this.add().call(ia, ONE, sum);
            ComplexHighPrecisionAlgebra.this.subtract().call(ia, ONE, diff);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, diff, quotient);
            ComplexHighPrecisionAlgebra.this.log().call(quotient, log);
            ComplexHighPrecisionAlgebra.this.multiply().call(I_OVER_TWO, log, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ASINH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember aSquared = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember miniSum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember root = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_HALF = new ComplexHighPrecisionMember(one_half, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, a, aSquared);
            ComplexHighPrecisionAlgebra.this.add().call(aSquared, ONE, miniSum);
            ComplexHighPrecisionAlgebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexHighPrecisionAlgebra.this.add().call(a, root, sum);
            ComplexHighPrecisionAlgebra.this.log().call(sum, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ACOSH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember aSquared = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember miniSum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember root = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_HALF = new ComplexHighPrecisionMember(one_half, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, a, aSquared);
            ComplexHighPrecisionAlgebra.this.subtract().call(aSquared, ONE, miniSum);
            ComplexHighPrecisionAlgebra.this.pow().call(miniSum, ONE_HALF, root);
            ComplexHighPrecisionAlgebra.this.add().call(a, root, sum);
            ComplexHighPrecisionAlgebra.this.log().call(sum, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ATANH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember diff = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember quotient = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember log = new ComplexHighPrecisionMember();
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_HALF = new ComplexHighPrecisionMember(one_half, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.add().call(ONE, a, sum);
            ComplexHighPrecisionAlgebra.this.subtract().call(ONE, a, diff);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, diff, quotient);
            ComplexHighPrecisionAlgebra.this.log().call(quotient, log);
            ComplexHighPrecisionAlgebra.this.multiply().call(ONE_HALF, log, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ACSCH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember recipA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.invert().call(a, recipA);
            ComplexHighPrecisionAlgebra.this.asinh().call(recipA, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ASECH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember recipA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.invert().call(a, recipA);
            ComplexHighPrecisionAlgebra.this.acosh().call(recipA, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> ACOTH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember diff = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember quotient = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember log = new ComplexHighPrecisionMember();
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_HALF = new ComplexHighPrecisionMember(one_half, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.add().call(a, ONE, sum);
            ComplexHighPrecisionAlgebra.this.subtract().call(a, ONE, diff);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, diff, quotient);
            ComplexHighPrecisionAlgebra.this.log().call(quotient, log);
            ComplexHighPrecisionAlgebra.this.multiply().call(ONE_HALF, log, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SIN = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember IA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember minusIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expMinusIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember diff = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.multiply().call(a, I, IA);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexHighPrecisionAlgebra.this.exp().call(IA, expIA);
            ComplexHighPrecisionAlgebra.this.exp().call(minusIA, expMinusIA);
            ComplexHighPrecisionAlgebra.this.subtract().call(expIA, expMinusIA, diff);
            ComplexHighPrecisionAlgebra.this.divide().call(diff, TWO_I, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> COS = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember IA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember minusIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expMinusIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.multiply().call(a, I, IA);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexHighPrecisionAlgebra.this.exp().call(IA, expIA);
            ComplexHighPrecisionAlgebra.this.exp().call(minusIA, expMinusIA);
            ComplexHighPrecisionAlgebra.this.add().call(expIA, expMinusIA, sum);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, TWO, b);
        }
    };
    private Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> SINCOS = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember s, ComplexHighPrecisionMember c) {
            ComplexHighPrecisionMember IA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember minusIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expMinusIA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember diff = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.multiply().call(a, I, IA);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, MINUS_I, minusIA);
            ComplexHighPrecisionAlgebra.this.exp().call(IA, expIA);
            ComplexHighPrecisionAlgebra.this.exp().call(minusIA, expMinusIA);
            ComplexHighPrecisionAlgebra.this.subtract().call(expIA, expMinusIA, diff);
            ComplexHighPrecisionAlgebra.this.divide().call(diff, TWO_I, s);
            ComplexHighPrecisionAlgebra.this.add().call(expIA, expMinusIA, sum);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> TAN = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember sin = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember cos = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.sinAndCos().call(a, sin, cos);
            ComplexHighPrecisionAlgebra.this.divide().call(sin, cos, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> CSC = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember sin = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.sin().call(a, sin);
            ComplexHighPrecisionAlgebra.this.invert().call(sin, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SEC = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember cos = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.cos().call(a, cos);
            ComplexHighPrecisionAlgebra.this.invert().call(cos, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> COT = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember tan = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.tan().call(a, tan);
            ComplexHighPrecisionAlgebra.this.invert().call(tan, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SINH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember expA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember minusA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expMinusA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember diff = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.exp().call(a, expA);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexHighPrecisionAlgebra.this.exp().call(minusA, expMinusA);
            ComplexHighPrecisionAlgebra.this.subtract().call(expA, expMinusA, diff);
            ComplexHighPrecisionAlgebra.this.divide().call(diff, TWO, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> COSH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember expA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember minusA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expMinusA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.exp().call(a, expA);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexHighPrecisionAlgebra.this.exp().call(minusA, expMinusA);
            ComplexHighPrecisionAlgebra.this.add().call(expA, expMinusA, sum);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, TWO, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> SINHCOSH = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember s, ComplexHighPrecisionMember c) {
            ComplexHighPrecisionMember expA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember minusA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember expMinusA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember sum = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.exp().call(a, expA);
            ComplexHighPrecisionAlgebra.this.multiply().call(a, MINUS_ONE, minusA);
            ComplexHighPrecisionAlgebra.this.exp().call(minusA, expMinusA);
            ComplexHighPrecisionAlgebra.this.subtract().call(expA, expMinusA, sum);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, TWO, s);
            ComplexHighPrecisionAlgebra.this.add().call(expA, expMinusA, sum);
            ComplexHighPrecisionAlgebra.this.divide().call(sum, TWO, c);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> TANH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember sinh = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember cosh = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.sinhAndCosh().call(a, sinh, cosh);
            ComplexHighPrecisionAlgebra.this.divide().call(sinh, cosh, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> CSCH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember sinh = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.sinh().call(a, sinh);
            ComplexHighPrecisionAlgebra.this.invert().call(sinh, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SECH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember cosh = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.cosh().call(a, cosh);
            ComplexHighPrecisionAlgebra.this.invert().call(cosh, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> COTH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember tanh = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.tanh().call(a, tanh);
            ComplexHighPrecisionAlgebra.this.invert().call(tanh, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> EXP = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            BigDecimal constant = BigDecimalMath.exp((BigDecimal)a.r(), (MathContext)HighPrecisionAlgebra.getContext());
            b.setR(constant.multiply(BigDecimalMath.cos((BigDecimal)a.i(), (MathContext)HighPrecisionAlgebra.getContext())));
            b.setI(constant.multiply(BigDecimalMath.sin((BigDecimal)a.i(), (MathContext)HighPrecisionAlgebra.getContext())));
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> EXPM1 = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember tmp = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.exp().call(a, tmp);
            ComplexHighPrecisionAlgebra.this.subtract().call(tmp, ONE, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> LOG = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            BigDecimal modulus = ComplexHighPrecisionAlgebra.this.getModulus(a);
            BigDecimal argument = ComplexHighPrecisionAlgebra.this.getArgument(a);
            b.setR(BigDecimalMath.log((BigDecimal)modulus, (MathContext)HighPrecisionAlgebra.getContext()));
            b.setI(ComplexHighPrecisionAlgebra.this.getPrincipalArgument(argument));
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> LOG1P = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            ComplexHighPrecisionMember tmp = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.add().call(a, ONE, tmp);
            ComplexHighPrecisionAlgebra.this.log().call(tmp, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SQRT = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            BigDecimal one_half = BigDecimal.ONE.divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_HALF = new ComplexHighPrecisionMember(one_half, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.pow().call(a, ONE_HALF, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> CBRT = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            BigDecimal one_third = BigDecimal.ONE.divide(BigDecimal.valueOf(3L), HighPrecisionAlgebra.getContext());
            ComplexHighPrecisionMember ONE_THIRD = new ComplexHighPrecisionMember(one_third, BigDecimal.ZERO);
            ComplexHighPrecisionAlgebra.this.pow().call(a, ONE_THIRD, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> POW = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            ComplexHighPrecisionMember logA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionMember bLogA = new ComplexHighPrecisionMember();
            ComplexHighPrecisionAlgebra.this.log().call(a, logA);
            ComplexHighPrecisionAlgebra.this.multiply().call(b, logA, bLogA);
            ComplexHighPrecisionAlgebra.this.exp().call(bLogA, c);
        }
    };
    private Procedure2<ComplexHighPrecisionMember, HighPrecisionMember> REAL = new Procedure2<ComplexHighPrecisionMember, HighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, HighPrecisionMember b) {
            b.setV(a.r());
        }
    };
    private Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> UNREAL = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            b.setR(BigDecimal.ZERO);
            b.setI(a.i());
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SINCH = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            Sinch.compute(G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SINCHPI = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            Sinchpi.compute(G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SINC = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            Sinc.compute(G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> SINCPI = new Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            Sincpi.compute(G.CHP, a, b);
        }
    };
    private final Function1<Boolean, ComplexHighPrecisionMember> ISZERO = new Function1<Boolean, ComplexHighPrecisionMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionMember a) {
            return a.r().equals(BigDecimal.ZERO) && a.i().equals(BigDecimal.ZERO);
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> SBHP = new Procedure3<HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            BigDecimal tmp = a.v().multiply(b.r());
            c.setR(tmp);
            tmp = a.v().multiply(b.i());
            c.setI(tmp);
        }
    };
    private final Procedure3<RationalMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> SBR = new Procedure3<RationalMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(RationalMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            BigDecimal n = new BigDecimal(a.n());
            BigDecimal d = new BigDecimal(a.d());
            BigDecimal tmp = b.r();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setR(tmp);
            tmp = b.i();
            tmp = tmp.multiply(n);
            tmp = tmp.divide(d, HighPrecisionAlgebra.getContext());
            c.setI(tmp);
        }
    };
    private final Procedure3<Double, ComplexHighPrecisionMember, ComplexHighPrecisionMember> SBD = new Procedure3<Double, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(Double a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            BigDecimal d = BigDecimal.valueOf(a);
            BigDecimal tmp = b.r();
            tmp = tmp.multiply(d);
            c.setR(tmp);
            tmp = b.i();
            tmp = tmp.multiply(d);
            c.setI(tmp);
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> SC = new Procedure3<HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexHighPrecisionMember b, ComplexHighPrecisionMember c) {
            c.setR(a.v().multiply(b.r()));
            c.setI(a.v().multiply(b.i()));
        }
    };
    private final Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> WITHIN = new Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, ComplexHighPrecisionMember a, ComplexHighPrecisionMember b) {
            return ComplexNumberWithin.compute(G.HP, tol, a, b);
        }
    };

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, ComplexHighPrecisionMember, ComplexHighPrecisionMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexHighPrecisionMember, ComplexHighPrecisionMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexHighPrecisionMember, ComplexHighPrecisionMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public ComplexHighPrecisionMember construct() {
        return new ComplexHighPrecisionMember();
    }

    @Override
    public ComplexHighPrecisionMember construct(ComplexHighPrecisionMember other) {
        return new ComplexHighPrecisionMember(other);
    }

    @Override
    public ComplexHighPrecisionMember construct(String s) {
        return new ComplexHighPrecisionMember(s);
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMember> PI() {
        return this.PI_;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMember> E() {
        return this.E_;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMember> GAMMA() {
        return this.GAMMA_;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMember> PHI() {
        return this.PHI_;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMember> I() {
        return this.I_;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> asin() {
        return this.ASIN;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> acos() {
        return this.ACOS;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> atan() {
        return this.ATAN;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> acsc() {
        return this.ACSC;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> asec() {
        return this.ASEC;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> acot() {
        return this.ACOT;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> asinh() {
        return this.ASINH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> acosh() {
        return this.ACOSH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> atanh() {
        return this.ATANH;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> acsch() {
        return this.ACSCH;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> asech() {
        return this.ASECH;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> acoth() {
        return this.ACOTH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> sinAndCos() {
        return this.SINCOS;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> tan() {
        return this.TAN;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> csc() {
        return this.CSC;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sec() {
        return this.SEC;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> cot() {
        return this.COT;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> sinhAndCosh() {
        return this.SINHCOSH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> tanh() {
        return this.TANH;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> csch() {
        return this.CSCH;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sech() {
        return this.SECH;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> coth() {
        return this.COTH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> exp() {
        return this.EXP;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> expm1() {
        return this.EXPM1;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> log() {
        return this.LOG;
    }

    private BigDecimal getModulus2(ComplexHighPrecisionMember a) {
        return a.r().multiply(a.r()).add(a.i().multiply(a.i()));
    }

    private BigDecimal getModulus(ComplexHighPrecisionMember a) {
        return BigDecimalMath.sqrt((BigDecimal)this.getModulus2(a), (MathContext)HighPrecisionAlgebra.getContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal getArgument(ComplexHighPrecisionMember a) {
        HighPrecisionMember pi = G.HP.construct();
        HighPrecisionMember minus_pi = G.HP.construct();
        G.HP.PI().call(pi);
        G.HP.negate().call(pi, minus_pi);
        BigDecimal x = a.r();
        BigDecimal y = a.i();
        if (x.equals(BigDecimal.ZERO)) {
            if (y.compareTo(BigDecimal.ZERO) > 0) {
                return pi.v().divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
            }
            if (y.compareTo(BigDecimal.ZERO) >= 0) throw new IllegalArgumentException("HighPrec can't use NaN value");
            return minus_pi.v().divide(BigDecimal.valueOf(2L), HighPrecisionAlgebra.getContext());
        }
        if (!y.equals(BigDecimal.ZERO)) return BigDecimalMath.atan2((BigDecimal)y, (BigDecimal)x, (MathContext)HighPrecisionAlgebra.getContext());
        if (x.compareTo(BigDecimal.ZERO) <= 0) return pi.v();
        return BigDecimal.ZERO;
    }

    private BigDecimal getPrincipalArgument(BigDecimal angle) {
        HighPrecisionMember pi = G.HP.construct();
        HighPrecisionMember minus_pi = G.HP.construct();
        G.HP.PI().call(pi);
        G.HP.negate().call(pi, minus_pi);
        BigDecimal arg = angle;
        while (arg.compareTo(minus_pi.v()) <= 0) {
            arg = arg.add(pi.v()).add(pi.v());
        }
        while (arg.compareTo(pi.v()) > 0) {
            arg = arg.subtract(pi.v()).subtract(pi.v());
        }
        return arg;
    }

    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> log1p() {
        return this.LOG1P;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sqrt() {
        return this.SQRT;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> cbrt() {
        return this.CBRT;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> pow() {
        return this.POW;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, HighPrecisionMember> real() {
        return this.REAL;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> unreal() {
        return this.UNREAL;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMember, ComplexHighPrecisionMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Function1<Boolean, ComplexHighPrecisionMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> scale() {
        return this.MUL;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexHighPrecisionMember, ComplexHighPrecisionMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> scaleComponents() {
        return this.SC;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionMember, ComplexHighPrecisionMember> within() {
        return this.WITHIN;
    }
}

