/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.Copy;
import nom.bdezonia.zorbage.algorithm.FixedTransform2;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.ShapesMatch;
import nom.bdezonia.zorbage.algorithm.TensorCommaDerivative;
import nom.bdezonia.zorbage.algorithm.TensorContract;
import nom.bdezonia.zorbage.algorithm.TensorNorm;
import nom.bdezonia.zorbage.algorithm.TensorOuterProduct;
import nom.bdezonia.zorbage.algorithm.TensorPower;
import nom.bdezonia.zorbage.algorithm.TensorSemicolonDerivative;
import nom.bdezonia.zorbage.algorithm.TensorShape;
import nom.bdezonia.zorbage.algorithm.TensorUnity;
import nom.bdezonia.zorbage.algorithm.Transform2;
import nom.bdezonia.zorbage.algorithm.Transform3;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.procedure.Procedure4;
import nom.bdezonia.zorbage.procedure.Procedure5;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.Scale;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.TensorProduct;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.ctor.ConstructibleNdLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionCartesianTensorProductMember;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexHighPrecisionCartesianTensorProduct
implements TensorProduct<ComplexHighPrecisionCartesianTensorProduct, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionAlgebra, ComplexHighPrecisionMember>,
ConstructibleNdLong<ComplexHighPrecisionCartesianTensorProductMember>,
Norm<ComplexHighPrecisionCartesianTensorProductMember, HighPrecisionMember>,
Scale<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionMember>,
ScaleByHighPrec<ComplexHighPrecisionCartesianTensorProductMember>,
ScaleByRational<ComplexHighPrecisionCartesianTensorProductMember>,
ScaleByDouble<ComplexHighPrecisionCartesianTensorProductMember>,
Tolerance<HighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember> {
    private final Function2<Boolean, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> EQ = new Function2<Boolean, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CHP, G.HP.construct(), a.rawData(), b.rawData());
        }
    };
    private final Function2<Boolean, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> NEQ = new Function2<Boolean, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            return ComplexHighPrecisionCartesianTensorProduct.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> ASSIGN = new Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember from, ComplexHighPrecisionCartesianTensorProductMember to) {
            TensorShape.compute(from, to);
            Copy.compute(G.CHP, from.rawData(), to.rawData());
        }
    };
    private final Procedure1<ComplexHighPrecisionCartesianTensorProductMember> ZER = new Procedure1<ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> NEG = new Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CHP, G.CHP.negate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> ADDEL = new Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b, ComplexHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor add shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHP, G.CHP.add(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> SUBEL = new Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b, ComplexHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("tensor subtract shape mismatch");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHP, G.CHP.subtract(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure2<ComplexHighPrecisionCartesianTensorProductMember, HighPrecisionMember> NORM = new Procedure2<ComplexHighPrecisionCartesianTensorProductMember, HighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, HighPrecisionMember b) {
            TensorNorm.compute(G.CHP, G.HP, a.rawData(), b);
        }
    };
    private final Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> CONJ = new Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            Transform2.compute(G.CHP, G.CHP.conjugate(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> SCALE = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionMember scalar, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.Scale.compute(G.CHP, scalar, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> ADDSCALAR = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionMember scalar, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            FixedTransform2.compute(G.CHP, scalar, G.CHP.add(), a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> SUBSCALAR = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionMember scalar, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            ComplexHighPrecisionMember tmp = G.CHP.construct();
            G.CHP.negate().call(scalar, tmp);
            ComplexHighPrecisionCartesianTensorProduct.this.addScalar().call(tmp, a, b);
        }
    };
    private Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> MULEL = new Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b, ComplexHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHP, G.CHP.multiply(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> DIVIDEEL = new Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b, ComplexHighPrecisionCartesianTensorProductMember c) {
            if (!ShapesMatch.compute(a, b)) {
                throw new IllegalArgumentException("mismatched shapes");
            }
            TensorShape.compute(a, c);
            Transform3.compute(G.CHP, G.CHP.divide(), a.rawData(), b.rawData(), c.rawData());
        }
    };
    private final Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> MUL = new Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b, ComplexHighPrecisionCartesianTensorProductMember c) {
            ComplexHighPrecisionCartesianTensorProduct.this.outerProduct().call(a, b, c);
        }
    };
    private final Procedure4<Integer, Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> CONTRACT = new Procedure4<Integer, Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer i, Integer j, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorContract.compute(G.CHP, a.rank(), i, j, a, b);
        }
    };
    private final Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> SEMI = new Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorSemicolonDerivative.compute(G.CHP_TEN, G.CHP, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> COMMA = new Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer index, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorCommaDerivative.compute(G.CHP_TEN, G.CHP, index, a, b);
        }
    };
    private final Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> POWER = new Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer power, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorPower.compute(G.CHP_TEN, power, a, b);
        }
    };
    private final Procedure1<ComplexHighPrecisionCartesianTensorProductMember> UNITY = new Procedure1<ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember result) {
            TensorUnity.compute(G.CHP_TEN, G.CHP, result);
        }
    };
    private final Function1<Boolean, ComplexHighPrecisionCartesianTensorProductMember> ISZERO = new Function1<Boolean, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionCartesianTensorProductMember a) {
            return SequenceIsZero.compute(G.CHP, a.rawData());
        }
    };
    private final Procedure3<RationalMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> SBR = new Procedure3<RationalMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(RationalMember factor, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByRational.compute(G.CHP, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<Double, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> SBD = new Procedure3<Double, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Double factor, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByDouble.compute(G.CHP, factor, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<HighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> SBHP = new Procedure3<HighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(HighPrecisionMember factor, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            TensorShape.compute(a, b);
            nom.bdezonia.zorbage.algorithm.ScaleByHighPrec.compute(G.CHP, factor, a.rawData(), b.rawData());
        }
    };
    private final Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> WITHIN = new Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            if (!ShapesMatch.compute(a, b)) {
                return false;
            }
            return SequencesSimilar.compute(G.CHP, tol, a.rawData(), b.rawData());
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> MULBYSCALAR = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionMember factor, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            ComplexHighPrecisionCartesianTensorProduct.this.scale().call(factor, a, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> DIVBYSCALAR = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionMember factor, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            ComplexHighPrecisionMember invFactor = G.CHP.construct();
            G.CHP.invert().call(factor, invFactor);
            ComplexHighPrecisionCartesianTensorProduct.this.scale().call(invFactor, a, b);
        }
    };
    private final Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> RAISE = new Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            throw new IllegalArgumentException("cannot raise index of a cartesian tensor");
        }
    };
    private final Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> LOWER = new Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer idx, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b) {
            if (idx < 0 || idx >= a.rank()) {
                throw new IllegalArgumentException("index outside rank bounds in lowerIndex");
            }
            ComplexHighPrecisionCartesianTensorProduct.this.assign().call(a, b);
        }
    };
    private final Procedure5<Integer, Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> INNER = new Procedure5<Integer, Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(Integer aIndex, Integer bIndex, ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b, ComplexHighPrecisionCartesianTensorProductMember c) {
            if (aIndex < 0 || bIndex < 0) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle negative indices");
            }
            if (aIndex >= a.rank() || bIndex >= b.rank()) {
                throw new IllegalArgumentException("tensor innerProduct() cannot handle out of bounds indices");
            }
            ComplexHighPrecisionCartesianTensorProductMember tmp = ComplexHighPrecisionCartesianTensorProduct.this.construct();
            ComplexHighPrecisionCartesianTensorProduct.this.outerProduct().call(a, b, tmp);
            ComplexHighPrecisionCartesianTensorProduct.this.contract().call(aIndex, a.rank() + bIndex, tmp, c);
        }
    };
    private final Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> OUTER = new Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember>(){

        @Override
        public void call(ComplexHighPrecisionCartesianTensorProductMember a, ComplexHighPrecisionCartesianTensorProductMember b, ComplexHighPrecisionCartesianTensorProductMember c) {
            TensorOuterProduct.compute(G.CHP_TEN, G.CHP, a, b, c);
        }
    };

    @Override
    public ComplexHighPrecisionCartesianTensorProductMember construct() {
        return new ComplexHighPrecisionCartesianTensorProductMember();
    }

    @Override
    public ComplexHighPrecisionCartesianTensorProductMember construct(ComplexHighPrecisionCartesianTensorProductMember other) {
        return new ComplexHighPrecisionCartesianTensorProductMember(other);
    }

    @Override
    public ComplexHighPrecisionCartesianTensorProductMember construct(String s) {
        return new ComplexHighPrecisionCartesianTensorProductMember(s);
    }

    @Override
    public ComplexHighPrecisionCartesianTensorProductMember construct(StorageConstruction s, long[] nd) {
        return new ComplexHighPrecisionCartesianTensorProductMember(s, nd);
    }

    @Override
    public Function2<Boolean, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public Procedure1<ComplexHighPrecisionCartesianTensorProductMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> add() {
        return this.ADDEL;
    }

    @Override
    public Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> subtract() {
        return this.SUBEL;
    }

    @Override
    public Procedure2<ComplexHighPrecisionCartesianTensorProductMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> addScalar() {
        return this.ADDSCALAR;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> subtractScalar() {
        return this.SUBSCALAR;
    }

    @Override
    public Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> multiplyElements() {
        return this.MULEL;
    }

    @Override
    public Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> divideElements() {
        return this.DIVIDEEL;
    }

    @Override
    public Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure4<Integer, Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> contract() {
        return this.CONTRACT;
    }

    @Override
    public Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> semicolonDerivative() {
        return this.SEMI;
    }

    @Override
    public Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> commaDerivative() {
        return this.COMMA;
    }

    @Override
    public Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexHighPrecisionCartesianTensorProductMember> unity() {
        return this.UNITY;
    }

    @Override
    public Function1<Boolean, ComplexHighPrecisionCartesianTensorProductMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure3<RationalMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> within() {
        return this.WITHIN;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> multiplyByScalar() {
        return this.MULBYSCALAR;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> divideByScalar() {
        return this.DIVBYSCALAR;
    }

    @Override
    public Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> raiseIndex() {
        return this.RAISE;
    }

    @Override
    public Procedure3<Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> lowerIndex() {
        return this.LOWER;
    }

    @Override
    public Procedure5<Integer, Integer, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> innerProduct() {
        return this.INNER;
    }

    @Override
    public Procedure3<ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember, ComplexHighPrecisionCartesianTensorProductMember> outerProduct() {
        return this.OUTER;
    }
}

