/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.complex;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import nom.bdezonia.zorbage.misc.BigList;
import nom.bdezonia.zorbage.misc.LongUtils;
import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.sampling.SamplingCartesianIntegerGrid;
import nom.bdezonia.zorbage.sampling.SamplingIterator;
import nom.bdezonia.zorbage.type.algebra.Gettable;
import nom.bdezonia.zorbage.type.algebra.Settable;
import nom.bdezonia.zorbage.type.algebra.TensorMember;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.universal.OctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorOctonionRepresentation;
import nom.bdezonia.zorbage.type.data.universal.TensorStringRepresentation;
import nom.bdezonia.zorbage.type.data.universal.UniversalRepresentation;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.RawData;

public final class ComplexHighPrecisionCartesianTensorProductMember
implements TensorMember<ComplexHighPrecisionMember>,
Gettable<ComplexHighPrecisionCartesianTensorProductMember>,
Settable<ComplexHighPrecisionCartesianTensorProductMember>,
PrimitiveConversion,
UniversalRepresentation,
RawData<ComplexHighPrecisionMember> {
    private static final ComplexHighPrecisionMember ZERO = new ComplexHighPrecisionMember();
    private int rank;
    private long dimCount;
    private IndexedDataSource<ComplexHighPrecisionMember> storage;
    private long[] dims;
    private long[] multipliers;
    private StorageConstruction s;
    private static ThreadLocal<ComplexHighPrecisionMember> tmpComp = new ThreadLocal<ComplexHighPrecisionMember>(){

        @Override
        protected ComplexHighPrecisionMember initialValue() {
            return new ComplexHighPrecisionMember();
        }
    };

    @Override
    public int rank() {
        return this.lowerRank() + this.upperRank();
    }

    @Override
    public int lowerRank() {
        return this.rank;
    }

    @Override
    public int upperRank() {
        return 0;
    }

    @Override
    public boolean indexIsLower(int index) {
        if (index < 0 || index > this.lowerRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return true;
    }

    @Override
    public boolean indexIsUpper(int index) {
        if (index < 0 || index > this.upperRank()) {
            throw new IllegalArgumentException("index of tensor component is outside bounds");
        }
        return false;
    }

    @Override
    public long dimension() {
        return this.dimCount;
    }

    public ComplexHighPrecisionCartesianTensorProductMember() {
        this.rank = 0;
        this.dimCount = 0L;
        this.dims = new long[0];
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, 1L, new ComplexHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
    }

    public ComplexHighPrecisionCartesianTensorProductMember(int rank, long dimCount) {
        if (rank < 0) {
            throw new IllegalArgumentException("bad rank in tensor constructor");
        }
        if (dimCount < 0L) {
            throw new IllegalArgumentException("bad dimensionality in tensor constructor");
        }
        this.rank = rank;
        this.dimCount = dimCount;
        this.dims = new long[rank];
        for (int i = 0; i < rank; ++i) {
            this.dims[i] = dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new ComplexHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
    }

    public ComplexHighPrecisionCartesianTensorProductMember(int rank, long dimCount, BigDecimal[] vals) {
        this(rank, dimCount);
        if ((long)vals.length != this.storage.size() * 2L) {
            throw new IllegalArgumentException("incorrect number of values given in tensor constructor");
        }
        ComplexHighPrecisionMember value = new ComplexHighPrecisionMember();
        for (int i = 0; i < vals.length; i += 2) {
            value.setR(vals[i]);
            value.setI(vals[i + 1]);
            this.storage.set(i, value);
        }
    }

    public ComplexHighPrecisionCartesianTensorProductMember(long[] dims) {
        this.rank = dims.length;
        long max = 0L;
        for (long d : dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new ComplexHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
    }

    public ComplexHighPrecisionCartesianTensorProductMember(long[] dims, BigDecimal[] vals) {
        this(dims);
        long numElems = LongUtils.numElements(dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        if ((long)vals.length != numElems * 2L) {
            throw new IllegalArgumentException("incorrect number of values provided to tensor constructor");
        }
        ComplexHighPrecisionMember value = new ComplexHighPrecisionMember();
        if (numElems == 1L) {
            value.setR(vals[0]);
            value.setI(vals[1]);
            this.storage.set(0L, value);
        } else {
            int i;
            long[] point1 = new long[dims.length];
            long[] point2 = new long[dims.length];
            for (i = 0; i < dims.length; ++i) {
                point2[i] = dims[i] - 1L;
            }
            i = 0;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                value.setR(vals[i]);
                value.setI(vals[i + 1]);
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                i += 2;
            }
        }
    }

    public ComplexHighPrecisionCartesianTensorProductMember(ComplexHighPrecisionCartesianTensorProductMember other) {
        this.set(other);
    }

    public ComplexHighPrecisionCartesianTensorProductMember(String s) {
        TensorStringRepresentation rep = new TensorStringRepresentation(s);
        BigList<OctonionRepresentation> data = rep.values();
        long[] tmpDims = (long[])rep.dimensions().clone();
        this.rank = tmpDims.length;
        long max = 0L;
        for (long d : tmpDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.s = StorageConstruction.MEM_ARRAY;
        this.storage = Storage.allocate(this.s, numElems, new ComplexHighPrecisionMember());
        this.multipliers = this.calcMultipliers();
        ComplexHighPrecisionMember value = new ComplexHighPrecisionMember();
        if (numElems == 1L) {
            OctonionRepresentation val = data.get(0L);
            value.setR(val.r());
            value.setI(val.i());
            this.storage.set(0L, value);
        } else {
            long[] point1 = new long[tmpDims.length];
            long[] point2 = new long[tmpDims.length];
            for (int i = 0; i < tmpDims.length; ++i) {
                point2[i] = tmpDims[i] - 1L;
            }
            long i = 0L;
            SamplingCartesianIntegerGrid sampling = new SamplingCartesianIntegerGrid(point1, point2);
            SamplingIterator<IntegerIndex> iter = sampling.iterator();
            IntegerIndex index = new IntegerIndex(this.dims.length);
            while (iter.hasNext()) {
                iter.next(index);
                OctonionRepresentation val = data.get(i);
                value.setR(val.r());
                value.setI(val.i());
                long idx = this.indexToLong(index);
                this.storage.set(idx, value);
                ++i;
            }
        }
    }

    public ComplexHighPrecisionCartesianTensorProductMember(StorageConstruction s, long[] nd) {
        this.rank = this.dims.length;
        long max = 0L;
        for (long d : this.dims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        this.s = s;
        long numElems = LongUtils.numElements(this.dims);
        if (numElems == 0L) {
            numElems = 1L;
        }
        this.storage = Storage.allocate(s, numElems, new ComplexHighPrecisionMember());
    }

    @Override
    public StorageConstruction storageType() {
        return this.s;
    }

    @Override
    public void set(ComplexHighPrecisionCartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        this.rank = other.rank;
        this.dimCount = other.dimCount;
        this.dims = (long[])other.dims.clone();
        this.multipliers = (long[])other.multipliers.clone();
        this.storage = (IndexedDataSource)other.storage.duplicate();
        this.s = other.s;
    }

    @Override
    public void get(ComplexHighPrecisionCartesianTensorProductMember other) {
        if (this == other) {
            return;
        }
        other.rank = this.rank;
        other.dimCount = this.dimCount;
        other.dims = (long[])this.dims.clone();
        other.multipliers = (long[])this.multipliers.clone();
        other.storage = (IndexedDataSource)this.storage.duplicate();
        other.s = this.s;
    }

    @Override
    public boolean alloc(long[] newDims) {
        boolean theSame = true;
        if (newDims.length != this.dims.length) {
            theSame = false;
        } else {
            for (int i = 0; i < newDims.length; ++i) {
                if (newDims[i] == this.dims[i]) continue;
                theSame = false;
                break;
            }
        }
        if (theSame) {
            return false;
        }
        this.rank = newDims.length;
        long max = 0L;
        for (long d : newDims) {
            if (max >= d) continue;
            max = d;
        }
        this.dimCount = max;
        this.dims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.dims[i] = this.dimCount;
        }
        this.multipliers = this.calcMultipliers();
        long newCount = LongUtils.numElements(this.dims);
        if (newCount == 0L) {
            newCount = 1L;
        }
        if (this.storage == null || newCount != this.storage.size()) {
            this.storage = Storage.allocate(this.s, newCount, new ComplexHighPrecisionMember());
            return true;
        }
        return false;
    }

    @Override
    public void init(long[] newDims) {
        if (!this.alloc(newDims)) {
            long storageSize = this.storage.size();
            for (long i = 0L; i < storageSize; ++i) {
                this.storage.set(i, ZERO);
            }
        }
    }

    public long numElems() {
        return this.storage.size();
    }

    void v(long index, ComplexHighPrecisionMember value) {
        this.storage.get(index, value);
    }

    @Override
    public void v(IntegerIndex index, ComplexHighPrecisionMember value) {
        long idx = this.indexToLong(index);
        this.storage.get(idx, value);
    }

    void setV(long index, ComplexHighPrecisionMember value) {
        this.storage.set(index, value);
    }

    @Override
    public void setV(IntegerIndex index, ComplexHighPrecisionMember value) {
        long idx = this.indexToLong(index);
        this.storage.set(idx, value);
    }

    @Override
    public void toRep(TensorOctonionRepresentation rep) {
        long storageSize = this.storage.size();
        ComplexHighPrecisionMember value = new ComplexHighPrecisionMember();
        BigList<OctonionRepresentation> values = new BigList<OctonionRepresentation>(storageSize);
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, value);
            BigDecimal re = value.r();
            BigDecimal im = value.i();
            OctonionRepresentation o = new OctonionRepresentation(re, im);
            values.set(i, o);
        }
        rep.setTensor(this.dims, values);
    }

    @Override
    public void fromRep(TensorOctonionRepresentation rep) {
        ComplexHighPrecisionMember value = new ComplexHighPrecisionMember();
        BigList<OctonionRepresentation> tensor = rep.getTensor();
        this.init(rep.getTensorDims());
        long tensorSize = tensor.size();
        for (long i = 0L; i < tensorSize; ++i) {
            OctonionRepresentation o = tensor.get(i);
            value.setR(o.r());
            value.setI(o.i());
            this.storage.set(i, value);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        ComplexHighPrecisionMember tmp = new ComplexHighPrecisionMember();
        IntegerIndex index = new IntegerIndex(this.dims.length);
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.get(i, tmp);
            this.longToIntegerIndex(i, index);
            int j = 0;
            while (j < index.numDimensions() && index.get(j++) == 0L) {
                builder.append('[');
            }
            if (index.get(0) != 0L) {
                builder.append(',');
            }
            builder.append('{');
            builder.append(tmp.r());
            builder.append(',');
            builder.append(tmp.i());
            builder.append('}');
            j = 0;
            while (j < index.numDimensions() && index.get(j) == this.dims[j++] - 1L) {
                builder.append(']');
            }
        }
        return builder.toString();
    }

    private long[] calcMultipliers() {
        if (this.dims.length == 0) {
            return new long[0];
        }
        long[] result = new long[this.dims.length - 1];
        long mult = 1L;
        for (int i = 0; i < result.length; ++i) {
            result[i] = mult;
            mult *= this.dims[i];
        }
        return result;
    }

    private long indexToLong(IntegerIndex idx) {
        if (idx.numDimensions() == 0) {
            throw new IllegalArgumentException("null index");
        }
        if (idx.numDimensions() >= this.dims.length && this.indexOob(idx, 0)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        long index = 0L;
        long mult = 1L;
        for (int i = 0; i < this.dims.length; ++i) {
            index += mult * idx.get(i);
            mult *= this.dims[i];
        }
        return index;
    }

    private void longToIntegerIndex(long idx, IntegerIndex result) {
        int i;
        if (idx < 0L) {
            throw new IllegalArgumentException("negative index in tensor addressing");
        }
        if (idx >= this.storage.size()) {
            throw new IllegalArgumentException("index beyond end of tensor storage");
        }
        if (result.numDimensions() < this.dims.length) {
            throw new IllegalArgumentException("mismatched dims in tensor member");
        }
        for (i = this.dims.length; i < result.numDimensions(); ++i) {
            result.set(i, 0L);
        }
        for (i = this.dims.length - 1; i >= 0; --i) {
            result.set(i, idx / this.multipliers[i]);
            idx %= this.multipliers[i];
        }
    }

    private boolean indexOob(IntegerIndex idx, int component) {
        long index;
        int i;
        if (component < 0) {
            throw new IllegalArgumentException("negative component specified in indexOob");
        }
        if (component > 1) {
            return true;
        }
        for (i = 0; i < this.dims.length; ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index < this.dims[i]) continue;
            return true;
        }
        for (i = this.dims.length; i < idx.numDimensions(); ++i) {
            index = idx.get(i);
            if (index < 0L) {
                throw new IllegalArgumentException("negative index in indexOob");
            }
            if (index <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int numDimensions() {
        return this.dims.length;
    }

    @Override
    public void reshape(long[] dims) {
        if (Arrays.equals(this.dims, dims)) {
            return;
        }
        throw new IllegalArgumentException("to implement");
    }

    @Override
    public long dimension(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("can't query negative dimension");
        }
        if (d >= this.dims.length) {
            return 1L;
        }
        return this.dims[d];
    }

    @Override
    public PrimitiveRepresentation preferredRepresentation() {
        return PrimitiveRepresentation.BIGDECIMAL;
    }

    @Override
    public int componentCount() {
        return 2;
    }

    @Override
    public void primComponentSetByte(IntegerIndex index, int component, byte v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(BigDecimal.valueOf(v));
        } else if (component == 1) {
            tmp.setI(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetShort(IntegerIndex index, int component, short v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(BigDecimal.valueOf(v));
        } else if (component == 1) {
            tmp.setI(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetInt(IntegerIndex index, int component, int v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(BigDecimal.valueOf(v));
        } else if (component == 1) {
            tmp.setI(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetLong(IntegerIndex index, int component, long v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(BigDecimal.valueOf(v));
        } else if (component == 1) {
            tmp.setI(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetFloat(IntegerIndex index, int component, float v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(BigDecimal.valueOf(v));
        } else if (component == 1) {
            tmp.setI(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetDouble(IntegerIndex index, int component, double v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(BigDecimal.valueOf(v));
        } else if (component == 1) {
            tmp.setI(BigDecimal.valueOf(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigInteger(IntegerIndex index, int component, BigInteger v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(new BigDecimal(v));
        } else if (component == 1) {
            tmp.setI(new BigDecimal(v));
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetBigDecimal(IntegerIndex index, int component, BigDecimal v) {
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            tmp.setR(v);
        } else if (component == 1) {
            tmp.setI(v);
        }
        this.setV(index, tmp);
    }

    @Override
    public void primComponentSetByteSafe(IntegerIndex index, int component, byte v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else if (component == 1) {
                tmp.setI(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetShortSafe(IntegerIndex index, int component, short v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else if (component == 1) {
                tmp.setI(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetIntSafe(IntegerIndex index, int component, int v) {
        if (this.indexOob(index, component)) {
            if (v != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else if (component == 1) {
                tmp.setI(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetLongSafe(IntegerIndex index, int component, long v) {
        if (this.indexOob(index, component)) {
            if (v != 0L) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else if (component == 1) {
                tmp.setI(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetFloatSafe(IntegerIndex index, int component, float v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0f) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else if (component == 1) {
                tmp.setI(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetDoubleSafe(IntegerIndex index, int component, double v) {
        if (this.indexOob(index, component)) {
            if (v != 0.0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(BigDecimal.valueOf(v));
            } else if (component == 1) {
                tmp.setI(BigDecimal.valueOf(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetBigIntegerSafe(IntegerIndex index, int component, BigInteger v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(new BigDecimal(v));
            } else if (component == 1) {
                tmp.setI(new BigDecimal(v));
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public void primComponentSetBigDecimalSafe(IntegerIndex index, int component, BigDecimal v) {
        if (this.indexOob(index, component)) {
            if (v.signum() != 0) {
                throw new IllegalArgumentException("cannot set nonzero value outside extents");
            }
        } else {
            ComplexHighPrecisionMember tmp = tmpComp.get();
            this.v(index, tmp);
            if (component == 0) {
                tmp.setR(v);
            } else if (component == 1) {
                tmp.setI(v);
            }
            this.setV(index, tmp);
        }
    }

    @Override
    public byte primComponentGetAsByte(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().byteValue();
        }
        if (component == 1) {
            return tmp.i().byteValue();
        }
        return 0;
    }

    @Override
    public short primComponentGetAsShort(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().shortValue();
        }
        if (component == 1) {
            return tmp.i().shortValue();
        }
        return 0;
    }

    @Override
    public int primComponentGetAsInt(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().intValue();
        }
        if (component == 1) {
            return tmp.i().intValue();
        }
        return 0;
    }

    @Override
    public long primComponentGetAsLong(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().longValue();
        }
        if (component == 1) {
            return tmp.i().longValue();
        }
        return 0L;
    }

    @Override
    public float primComponentGetAsFloat(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().floatValue();
        }
        if (component == 1) {
            return tmp.i().floatValue();
        }
        return 0.0f;
    }

    @Override
    public double primComponentGetAsDouble(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().doubleValue();
        }
        if (component == 1) {
            return tmp.i().doubleValue();
        }
        return 0.0;
    }

    @Override
    public BigInteger primComponentGetAsBigInteger(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().toBigInteger();
        }
        if (component == 1) {
            return tmp.i().toBigInteger();
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimal(IntegerIndex index, int component) {
        if (component < 0) {
            throw new IllegalArgumentException("negative component index error");
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r();
        }
        if (component == 1) {
            return tmp.i();
        }
        return BigDecimal.ZERO;
    }

    @Override
    public byte primComponentGetAsByteSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().byteValue();
        }
        return tmp.i().byteValue();
    }

    @Override
    public short primComponentGetAsShortSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().shortValue();
        }
        return tmp.i().shortValue();
    }

    @Override
    public int primComponentGetAsIntSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().intValue();
        }
        return tmp.i().intValue();
    }

    @Override
    public long primComponentGetAsLongSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0L;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().longValue();
        }
        return tmp.i().longValue();
    }

    @Override
    public float primComponentGetAsFloatSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0f;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().floatValue();
        }
        return tmp.i().floatValue();
    }

    @Override
    public double primComponentGetAsDoubleSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return 0.0;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().doubleValue();
        }
        return tmp.i().doubleValue();
    }

    @Override
    public BigInteger primComponentGetAsBigIntegerSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigInteger.ZERO;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r().toBigInteger();
        }
        return tmp.i().toBigInteger();
    }

    @Override
    public BigDecimal primComponentGetAsBigDecimalSafe(IntegerIndex index, int component) {
        if (this.indexOob(index, component)) {
            return BigDecimal.ZERO;
        }
        ComplexHighPrecisionMember tmp = tmpComp.get();
        this.v(index, tmp);
        if (component == 0) {
            return tmp.r();
        }
        return tmp.i();
    }

    @Override
    public void primitiveInit() {
        long storageSize = this.storage.size();
        for (long i = 0L; i < storageSize; ++i) {
            this.storage.set(i, ZERO);
        }
    }

    @Override
    public IndexedDataSource<ComplexHighPrecisionMember> rawData() {
        return this.storage;
    }
}

