/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.type.data.highprec.complex;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.MatrixAddition;
import nom.bdezonia.zorbage.algorithm.MatrixAssign;
import nom.bdezonia.zorbage.algorithm.MatrixConjugate;
import nom.bdezonia.zorbage.algorithm.MatrixConstantDiagonal;
import nom.bdezonia.zorbage.algorithm.MatrixDeterminant;
import nom.bdezonia.zorbage.algorithm.MatrixDirectProduct;
import nom.bdezonia.zorbage.algorithm.MatrixEqual;
import nom.bdezonia.zorbage.algorithm.MatrixInvert;
import nom.bdezonia.zorbage.algorithm.MatrixMultiply;
import nom.bdezonia.zorbage.algorithm.MatrixNegate;
import nom.bdezonia.zorbage.algorithm.MatrixPower;
import nom.bdezonia.zorbage.algorithm.MatrixScale;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByDouble;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByHighPrec;
import nom.bdezonia.zorbage.algorithm.MatrixScaleByRational;
import nom.bdezonia.zorbage.algorithm.MatrixSpectralNorm;
import nom.bdezonia.zorbage.algorithm.MatrixSubtraction;
import nom.bdezonia.zorbage.algorithm.MatrixTranspose;
import nom.bdezonia.zorbage.algorithm.MatrixUnity;
import nom.bdezonia.zorbage.algorithm.SequenceIsZero;
import nom.bdezonia.zorbage.algorithm.SequencesSimilar;
import nom.bdezonia.zorbage.algorithm.Sinc;
import nom.bdezonia.zorbage.algorithm.Sinch;
import nom.bdezonia.zorbage.algorithm.Sinchpi;
import nom.bdezonia.zorbage.algorithm.Sincpi;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCos;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateCosh;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateExp;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateLog;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSin;
import nom.bdezonia.zorbage.algorithm.TaylorEstimateSinh;
import nom.bdezonia.zorbage.function.Function1;
import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.function.Function3;
import nom.bdezonia.zorbage.procedure.Procedure1;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.DirectProduct;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Hyperbolic;
import nom.bdezonia.zorbage.type.algebra.MatrixRing;
import nom.bdezonia.zorbage.type.algebra.Norm;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.RingWithUnity;
import nom.bdezonia.zorbage.type.algebra.ScaleByDouble;
import nom.bdezonia.zorbage.type.algebra.ScaleByHighPrec;
import nom.bdezonia.zorbage.type.algebra.ScaleByRational;
import nom.bdezonia.zorbage.type.algebra.Tolerance;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.ctor.Constructible2dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionAlgebra;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionMatrixMember;
import nom.bdezonia.zorbage.type.data.highprec.complex.ComplexHighPrecisionMember;
import nom.bdezonia.zorbage.type.data.highprec.real.HighPrecisionMember;
import nom.bdezonia.zorbage.type.data.rational.RationalMember;

public class ComplexHighPrecisionMatrix
implements RingWithUnity<ComplexHighPrecisionMatrix, ComplexHighPrecisionMatrixMember>,
MatrixRing<ComplexHighPrecisionMatrix, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionAlgebra, ComplexHighPrecisionMember>,
Constructible2dLong<ComplexHighPrecisionMatrixMember>,
Norm<ComplexHighPrecisionMatrixMember, HighPrecisionMember>,
DirectProduct<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>,
Exponential<ComplexHighPrecisionMatrixMember>,
Trigonometric<ComplexHighPrecisionMatrixMember>,
Hyperbolic<ComplexHighPrecisionMatrixMember>,
RealConstants<ComplexHighPrecisionMatrixMember>,
ScaleByHighPrec<ComplexHighPrecisionMatrixMember>,
ScaleByRational<ComplexHighPrecisionMatrixMember>,
ScaleByDouble<ComplexHighPrecisionMatrixMember>,
Tolerance<HighPrecisionMember, ComplexHighPrecisionMatrixMember> {
    private final Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> MUL = new Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            MatrixMultiply.compute(G.CHP, a, b, c);
        }
    };
    private final Procedure3<Integer, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> POWER = new Procedure3<Integer, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(Integer power, ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            MatrixPower.compute(power, G.CHP, G.CHP_VEC, G.CHP_MAT, a, b);
        }
    };
    private final Procedure1<ComplexHighPrecisionMatrixMember> ZER = new Procedure1<ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a) {
            a.primitiveInit();
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> NEG = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            MatrixNegate.compute(G.CHP, a, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> ADD = new Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            MatrixAddition.compute(G.CHP, a, b, c);
        }
    };
    private final Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SUB = new Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            MatrixSubtraction.compute(G.CHP, a, b, c);
        }
    };
    private final Function2<Boolean, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> EQ = new Function2<Boolean, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            return MatrixEqual.compute(G.CHP, a, b);
        }
    };
    private final Function2<Boolean, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> NEQ = new Function2<Boolean, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            return ComplexHighPrecisionMatrix.this.isEqual().call(a, b) == false;
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> ASSIGN = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember from, ComplexHighPrecisionMatrixMember to) {
            MatrixAssign.compute(G.CHP, from, to);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, HighPrecisionMember> NORM = new Procedure2<ComplexHighPrecisionMatrixMember, HighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, HighPrecisionMember b) {
            MatrixSpectralNorm.compute(G.CHP_MAT, G.HP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> CONJ = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            MatrixConjugate.compute(G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> TRANSP = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            MatrixTranspose.compute(G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> CONJTRANSP = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            ComplexHighPrecisionMatrixMember tmp = new ComplexHighPrecisionMatrixMember();
            ComplexHighPrecisionMatrix.this.conjugate().call(a, tmp);
            ComplexHighPrecisionMatrix.this.transpose().call(tmp, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMember> DET = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMember b) {
            MatrixDeterminant.compute(G.CHP_MAT, G.CHP, a, b);
        }
    };
    private final Procedure1<ComplexHighPrecisionMatrixMember> UNITY = new Procedure1<ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a) {
            MatrixUnity.compute(G.CHP, a);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> INV = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            MatrixInvert.compute(G.CHP, G.CHP_VEC, G.CHP_MAT, a, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> DIVIDE = new Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            ComplexHighPrecisionMatrixMember invB = ComplexHighPrecisionMatrix.this.construct(b.storageType(), b.rows(), b.cols());
            ComplexHighPrecisionMatrix.this.invert().call(b, invB);
            ComplexHighPrecisionMatrix.this.multiply().call(a, invB, c);
        }
    };
    private final Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> DP = new Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember in1, ComplexHighPrecisionMatrixMember in2, ComplexHighPrecisionMatrixMember out) {
            MatrixDirectProduct.compute(G.CHP, in1, in2, out);
        }
    };
    private final Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SCALE = new Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMember a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            MatrixScale.compute(G.CHP, a, b, c);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SINH = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            TaylorEstimateSinh.compute(18, G.CHP_MAT, G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> COSH = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            TaylorEstimateCosh.compute(18, G.CHP_MAT, G.CHP, a, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SINHANDCOSH = new Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember s, ComplexHighPrecisionMatrixMember c) {
            ComplexHighPrecisionMatrix.this.sinh().call(a, s);
            ComplexHighPrecisionMatrix.this.cosh().call(a, c);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> TANH = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            ComplexHighPrecisionMatrixMember s = G.CHP_MAT.construct();
            ComplexHighPrecisionMatrixMember c = G.CHP_MAT.construct();
            ComplexHighPrecisionMatrix.this.sinhAndCosh().call(a, s, c);
            ComplexHighPrecisionMatrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SINCH = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            Sinch.compute(G.CHP_MAT, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SINCHPI = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            Sinchpi.compute(G.CHP_MAT, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SIN = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            TaylorEstimateSin.compute(18, G.CHP_MAT, G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> COS = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            TaylorEstimateCos.compute(18, G.CHP_MAT, G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> TAN = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            ComplexHighPrecisionMatrixMember s = G.CHP_MAT.construct();
            ComplexHighPrecisionMatrixMember c = G.CHP_MAT.construct();
            ComplexHighPrecisionMatrix.this.sinAndCos().call(a, s, c);
            ComplexHighPrecisionMatrix.this.divide().call(s, c, b);
        }
    };
    private final Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SINANDCOS = new Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember s, ComplexHighPrecisionMatrixMember c) {
            ComplexHighPrecisionMatrix.this.sin().call(a, s);
            ComplexHighPrecisionMatrix.this.cos().call(a, c);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SINC = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            Sinc.compute(G.CHP_MAT, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SINCPI = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            Sincpi.compute(G.CHP_MAT, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> EXP = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            TaylorEstimateExp.compute(35, G.CHP_MAT, G.CHP, a, b);
        }
    };
    private final Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> LOG = new Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            TaylorEstimateLog.compute(8, G.CHP_MAT, G.CHP, a, b);
        }
    };
    private final Function1<Boolean, ComplexHighPrecisionMatrixMember> ISZERO = new Function1<Boolean, ComplexHighPrecisionMatrixMember>(){

        @Override
        public Boolean call(ComplexHighPrecisionMatrixMember a) {
            return SequenceIsZero.compute(G.CHP, a.rawData());
        }
    };
    private final Procedure1<ComplexHighPrecisionMatrixMember> PI = new Procedure1<ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a) {
            ComplexHighPrecisionMember pi = G.CHP.construct();
            G.CHP.PI().call(pi);
            MatrixConstantDiagonal.compute(G.CHP, pi, a);
        }
    };
    private final Procedure1<ComplexHighPrecisionMatrixMember> E = new Procedure1<ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a) {
            ComplexHighPrecisionMember e = G.CHP.construct();
            G.CHP.E().call(e);
            MatrixConstantDiagonal.compute(G.CHP, e, a);
        }
    };
    private final Procedure1<ComplexHighPrecisionMatrixMember> PHI = new Procedure1<ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a) {
            ComplexHighPrecisionMember phi = G.CHP.construct();
            G.CHP.PHI().call(phi);
            MatrixConstantDiagonal.compute(G.CHP, phi, a);
        }
    };
    private final Procedure1<ComplexHighPrecisionMatrixMember> GAMMA = new Procedure1<ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(ComplexHighPrecisionMatrixMember a) {
            ComplexHighPrecisionMember gamma = G.CHP.construct();
            G.CHP.GAMMA().call(gamma);
            MatrixConstantDiagonal.compute(G.CHP, gamma, a);
        }
    };
    private Procedure3<HighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SBHP = new Procedure3<HighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(HighPrecisionMember a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            MatrixScaleByHighPrec.compute(G.CHP, a, b, c);
        }
    };
    private Procedure3<RationalMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SBR = new Procedure3<RationalMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(RationalMember a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            MatrixScaleByRational.compute(G.CHP, a, b, c);
        }
    };
    private Procedure3<Double, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> SBD = new Procedure3<Double, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public void call(Double a, ComplexHighPrecisionMatrixMember b, ComplexHighPrecisionMatrixMember c) {
            MatrixScaleByDouble.compute(G.CHP, a, b, c);
        }
    };
    private final Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> WITHIN = new Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember>(){

        @Override
        public Boolean call(HighPrecisionMember tol, ComplexHighPrecisionMatrixMember a, ComplexHighPrecisionMatrixMember b) {
            if (a.rows() != b.rows() || a.cols() != b.cols()) {
                return false;
            }
            return SequencesSimilar.compute(G.CHP, tol, a.rawData(), b.rawData());
        }
    };

    @Override
    public Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> multiply() {
        return this.MUL;
    }

    @Override
    public Procedure3<Integer, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> power() {
        return this.POWER;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMatrixMember> zero() {
        return this.ZER;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> negate() {
        return this.NEG;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> add() {
        return this.ADD;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> subtract() {
        return this.SUB;
    }

    @Override
    public Function2<Boolean, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> isEqual() {
        return this.EQ;
    }

    @Override
    public Function2<Boolean, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> isNotEqual() {
        return this.NEQ;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> assign() {
        return this.ASSIGN;
    }

    @Override
    public ComplexHighPrecisionMatrixMember construct() {
        return new ComplexHighPrecisionMatrixMember();
    }

    @Override
    public ComplexHighPrecisionMatrixMember construct(ComplexHighPrecisionMatrixMember other) {
        return new ComplexHighPrecisionMatrixMember(other);
    }

    @Override
    public ComplexHighPrecisionMatrixMember construct(String s) {
        return new ComplexHighPrecisionMatrixMember(s);
    }

    @Override
    public ComplexHighPrecisionMatrixMember construct(StorageConstruction s, long d1, long d2) {
        return new ComplexHighPrecisionMatrixMember(s, d1, d2);
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, HighPrecisionMember> norm() {
        return this.NORM;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> conjugate() {
        return this.CONJ;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> transpose() {
        return this.TRANSP;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> conjugateTranspose() {
        return this.CONJTRANSP;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMember> det() {
        return this.DET;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMatrixMember> unity() {
        return this.UNITY;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> invert() {
        return this.INV;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> divide() {
        return this.DIVIDE;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> directProduct() {
        return this.DP;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> scale() {
        return this.SCALE;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sinh() {
        return this.SINH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> cosh() {
        return this.COSH;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sinhAndCosh() {
        return this.SINHANDCOSH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> tanh() {
        return this.TANH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sinch() {
        return this.SINCH;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sinchpi() {
        return this.SINCHPI;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sin() {
        return this.SIN;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> cos() {
        return this.COS;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> tan() {
        return this.TAN;
    }

    @Override
    public Procedure3<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sinAndCos() {
        return this.SINANDCOS;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sinc() {
        return this.SINC;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> sincpi() {
        return this.SINCPI;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> exp() {
        return this.EXP;
    }

    @Override
    public Procedure2<ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> log() {
        return this.LOG;
    }

    @Override
    public Function1<Boolean, ComplexHighPrecisionMatrixMember> isZero() {
        return this.ISZERO;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMatrixMember> PI() {
        return this.PI;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMatrixMember> E() {
        return this.E;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMatrixMember> PHI() {
        return this.PHI;
    }

    @Override
    public Procedure1<ComplexHighPrecisionMatrixMember> GAMMA() {
        return this.GAMMA;
    }

    @Override
    public Procedure3<HighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> scaleByHighPrec() {
        return this.SBHP;
    }

    @Override
    public Procedure3<RationalMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> scaleByRational() {
        return this.SBR;
    }

    @Override
    public Procedure3<Double, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> scaleByDouble() {
        return this.SBD;
    }

    @Override
    public Function3<Boolean, HighPrecisionMember, ComplexHighPrecisionMatrixMember, ComplexHighPrecisionMatrixMember> within() {
        return this.WITHIN;
    }
}

